<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\PaymentMethod\DataProvider\GetCollection\Assembler;

use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class RequestAssemblerDecorator implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private RequestStack $requestStack,
    ) {
    }

    public function assemble(string $resourceClass, string $operationName, array $context): RequestInterface
    {
        /** @var \XCart\Logic\Action\Storefront\Cart\PaymentMethod\GetList\DTO\Request $request */
        $request = $this->inner->assemble($resourceClass, $operationName, $context);

        $request->setCart(
            $this->requestStack->getCurrentRequest()->attributes->get('_cart')
        );

        return $request;
    }
}
