<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\API\Endpoint\Storefront\Payment\Action\DataProvider\Item\Assembler\ResponseAssembler;

use Symfony\Component\Security\Core\Security;
use Symfony\Component\Security\Core\User\InMemoryUser;
use Symfony\Component\Security\Core\User\UserInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\ResponseAssemblerInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XCart\Logic\Entity\Storefront\Payment\Action;
use XCart\Logic\Entity\Storefront\Payment\Action\TransactionData;
use XLite\Model\Profile;

class AccessDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
        private Security $security
    ) {
    }

    public function assemble(PayloadOwnerResponseInterface $response): EntityInterface
    {
        if ($this->getCurrentProfile()?->getAccessLevel() !== 100) {
            /** @var Action $action */
            $action = $response->getPayload();

            $action->setData($this->filterTransactionData($action->getData()));
        }

        return $this->inner->assemble($response);
    }

    /**
     * @param TransactionData[] $data
     *
     * @return TransactionData[]
     */
    private function filterTransactionData(array $data): array
    {
        return array_filter($data, static fn ($data) => $data->getAccessLevel() !== 'A');
    }

    private function getCurrentProfile(): ?Profile
    {
        $user = $this->security->getUser();

        return $this->isAnonimous($user)
            ? null
            : $user?->getWrappedProfile();
    }

    private function isAnonimous(?UserInterface $user): bool
    {
        return (
            $user instanceof InMemoryUser
            && $user->getUserIdentifier() === 'read_only'
        );
    }
}
