<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\API\Endpoint\Storefront\Payment\Action\DataPersister;

use ApiPlatform\Exception\RuntimeException;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\Assembler\RequestAssemblerInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\PersisterInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\ResponseAssemblerInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\Entity\EntityInterface;
use XCart\Bundle\CommonBundle\DTO\Id\IdOwnerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;

/**
 * @todo: Temporary class, will be removed after ECOM-2928 fix
 */
class Persister implements PersisterInterface
{
    public function __construct(
        private ?ActionInterface $addAction,
        private ?ActionInterface $updateAction,
        private ?RequestAssemblerInterface $addRequestAssembler,
        private ?RequestAssemblerInterface $updateRequestAssembler,
        private ?ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function persist(IdOwnerInterface $data, array $context): EntityInterface
    {
        /** @var PayloadOwnerResponseInterface $response */
        if ($this->isUpdate($data)) {
            $request  = $this->updateRequestAssembler->assemble($data, $context);
            $response = $this->updateAction->run($request);
        } else {
            $request  = $this->addRequestAssembler->assemble($data, $context);
            $response = $this->addAction->run($request);
        }

        if ($response instanceof DefaultFailedResponse) {
            throw new RuntimeException($response->getTitle());
        }

        return $this->responseAssembler->assemble($response);
    }

    private function isUpdate(IdOwnerInterface $data): bool
    {
        return !empty($data->getId());
    }
}
