<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\API\Endpoint\Storefront\Common\DataProvider\Assembler;

use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class RequestAssemblerWithProfileDecorator implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private RequestStack $requestStack,
    ) {
    }

    public function assemble($id): RequestInterface
    {
        $request = $this->inner->assemble($id);

        $request->setProfile(
            $this->requestStack->getCurrentRequest()->attributes->get('_profile')
        );

        return $request;
    }
}
