<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\API\Endpoint\Storefront\Common\DataPersister\Persister\Assembler;

use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\Assembler\RequestAssemblerInterface;
use XCart\Bundle\CommonBundle\DTO\Id\IdOwnerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class CreatePayloadAssemblerWithProfileDecorator implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private RequestStack $requestStack,
    ) {
    }

    public function assemble(IdOwnerInterface $entity, array $context): RequestInterface
    {
        $request = $this->inner->assemble($entity, $context);

        $request->setProfile(
            $this->requestStack->getCurrentRequest()->attributes->get('_profile')
        );

        return $request;
    }
}
