<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Category\Detailed\GetOneByCleanURL\Assembler;

use ApiPlatform\Exception\ItemNotFoundException;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Factory\Logic\Action\Storefront\Category\GetOne\DTO\RequestInterface as RequestFactory;
use XCart\Logic\Action\Storefront\Category\GetOne\DTO\Request;
use XLite\Model\Category;

class RequestAssembler implements RequestAssemblerInterface
{
    /**
     * @param RequestFactory $requestFactory
     */
    public function __construct(
        private RequestFactory $requestFactory,
        private ReadRepositoryInterface $categoryRepository,
    ) {
    }

    /**
     * @param string $id
     *
     * @return Request
     */
    public function assemble($id): RequestInterface
    {
        /** @var Category $category */
        $category = null;
        $parent = $this->categoryRepository->getRootCategory();
        foreach (explode('/', $id) as $path) {
            $category = $this->categoryRepository->createQueryBuilder('entity')
                ->linkInner('entity.cleanURLs', 'cleanURL')
                ->andWhere('cleanURL.cleanURL = :cleanURL AND entity.parent = :parent')
                ->setParameter('cleanURL', $path)
                ->setParameter('parent', $parent)
                ->getSingleResult();

            if (!$category) {
                throw new ItemNotFoundException("Category with clean_url {$id} not found");
            }

            $parent = $category;
        }

        if (!$category) {
            throw new ItemNotFoundException("Category with clean_url {$id} not found");
        }

        return $this->requestFactory->create()
            ->setId($category->getCategoryId());
    }
}
