<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\CartItem\SubIriConverter;

use Symfony\Component\Routing\RouterInterface;
use XCart\API\Entity\Storefront\Cart\Item as Entity;
use XCart\Framework\ApiPlatform\Core\Bridge\Symfony\Routing\SubIriConverter\SubIriFromItemConverterInterface;
use Xlite\Model\OrderItem as CartItemModel;
use XLite\Model\Repo\OrderItem as CartItemRepository;

class SubIriConverter implements SubIriFromItemConverterInterface
{
    public function __construct(
        private RouterInterface $router,
        private CartItemRepository $cartItemReadRepository,
    ) {
    }

    public function supportIriFromItem(object $item, int $referenceType): bool
    {
        return $item instanceof Entity;
    }

    /**
     * @param Entity $item
     */
    public function getIriFromItem(object $item, int $referenceType): string
    {
        /** @var ?CartItemModel $cartItem */
        $cartItem = $this->cartItemReadRepository->find($item->getId());

        return $this->router->generate(
            'api_cart items_get_item',
            [
                'cart_id' => $cartItem->getOrder()->getPublicId(),
                'id' => $item->getId(),
            ],
            $referenceType
        );
    }
}
