<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\CartItem\DataProvider\Collection\Assembler;

use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\IntegerValue;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\NumberFilterStrategyType;

class RequestAssemblerDecorator implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private RequestStack $requestStack,
    ) {
    }

    public function assemble(string $resourceClass, string $operationName, array $context): RequestInterface
    {
        /** @var \XCart\Logic\Action\Storefront\Cart\Item\GetList\DTO\Request $request */
        $request = $this->inner->assemble($resourceClass, $operationName, $context);

        $request->getFilter()->setOrder(
            (new IntegerValue())->setValue($this->requestStack->getCurrentRequest()->attributes->get('_cart')->getOrderId())
                ->setStrategy(NumberFilterStrategyType::EXACT())
                ->setExclude(false)
        );

        return $request;
    }
}
