<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\CartItem\DataPersister\Persister\Assembler;

use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\Assembler\RequestAssemblerInterface;
use XCart\Bundle\CommonBundle\DTO\Id\IdOwnerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class CreatePayloadAssemblerDecorator implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private RequestStack $requestStack,
    ) {
    }

    public function assemble(IdOwnerInterface $entity, array $context): RequestInterface
    {
        /** @var \XCart\Logic\Action\Storefront\Cart\Item\CreateOne\DTO\Request|\XCart\Logic\Action\Storefront\Cart\Item\UpdateOne\DTO\Request $request */
        $request = $this->inner->assemble($entity, $context);

        $request->getPayload()->setCartId($this->requestStack->getCurrentRequest()->attributes->get('_cart')->getOrderId());

        return $request;
    }
}
