<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\CartEmailChanging\SubIriConverter;

use Symfony\Component\Routing\RouterInterface;
use XCart\API\Entity\Storefront\Cart\EmailChanging as Entity;
use XCart\Framework\ApiPlatform\Core\Bridge\Symfony\Routing\SubIriConverter\SubIriFromItemConverterInterface;

class SubIriConverter implements SubIriFromItemConverterInterface
{
    public function __construct(
        private RouterInterface $router,
    ) {
    }

    public function supportIriFromItem(object $item, int $referenceType): bool
    {
        return $item instanceof Entity;
    }

    /**
     * @param Entity $item
     */
    public function getIriFromItem(object $item, int $referenceType): string
    {
        return $this->router->generate(
            'api_storefront carts_get_item',
            [
                'id' => $item->getId(),
            ],
            $referenceType
        );
    }
}
