<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Cart\DataPersister\Remover\Assembler;

use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Remover\Assembler\RequestAssemblerInterface;
use XCart\Bundle\CommonBundle\DTO\Id\IdOwnerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Factory\Logic\Action\Storefront\Cart\DeleteOne\DTO\RequestInterface as RequestFactory;

class IdBasedAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestFactory $factory,
        private RequestStack $requestStack,
    ) {
    }

    public function assemble(IdOwnerInterface $entity): RequestInterface
    {
        return $this->factory->create()
            ->setId($this->requestStack->getCurrentRequest()->attributes->get('_cart')->getOrderId());
    }
}
