<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Address\Validator\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use XCart\API\Endpoint\Storefront\Address\Validator\Constraint\Operation\AddressFieldsTransformer;
use XLite\Core\Database;
use XLite\Model\State;

class StateIdValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint)
    {
        $addressFields = AddressFieldsTransformer::transform($value);
        $stateId = $addressFields['state_id'] ?? null;

        if ($stateId) {
            $state = Database::getRepo(State::class)->find($stateId);

            if (!$state) {
                $this->context->buildViolation($constraint->message)
                    ->setParameter('{{ value }}', $stateId)
                    ->addViolation();
            }
        }
    }
}
