<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Address\Validator\Constraint\Operation;

use XCart\API\Entity\Storefront\AddressFieldValue;

class AddressFieldsTransformer
{
    public static function transform(array $addressFields): array
    {
        $cache = \XLite\Core\Cache::getInstance()->getDriver();
        $key   = serialize($addressFields);

        if ($cache->contains($key)) {
            return $cache->fetch($key);
        }

        $result = [];

        /** @var AddressFieldValue $addressField */
        foreach ($addressFields as $addressField) {
            $result[$addressField->getServiceName()] = $addressField->getValue();
        }

        $cache->save($key, $result);

        return $result;
    }
}
