<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Address\Validator\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use XCart\API\Endpoint\Storefront\Address\Validator\Constraint\Operation\AddressFieldsTransformer;

class InvalidFieldsValidator extends ConstraintValidator
{
    /**
     * @param \XCart\API\Entity\Storefront\Address $value
     */
    public function validate($value, Constraint $constraint)
    {
        $requestFields  = AddressFieldsTransformer::transform($value->getFields());

        foreach ($requestFields as $requestFieldName => $requestFieldValue) {
            if (!$requestFieldName) {
                $this->context
                    ->buildViolation($constraint->missingServiceNameMessage)
                    ->addViolation();
            }

            if ($requestFieldValue === null) {
                $this->context
                    ->buildViolation($constraint->missingValueMessage)
                    ->addViolation();
            }
        }
    }
}
