<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Address\Validator\Constraint;

use Symfony\Component\Validator\Constraint;

#[\Attribute]
class CountryStateCompatibility extends Constraint
{
    public $nonCompatibleStateMessage = 'state_id {{ state }} is not compatible with country_code {{ country }}';

    public $missingCustomStateMessage = 'custom_state field is required for country_code {{ country }}';

    public function getTargets(): string
    {
        return self::CLASS_CONSTRAINT;
    }
}
