<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Address\Validator\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use XCart\API\Endpoint\Storefront\Address\Validator\Constraint\Operation\AddressFieldsTransformer;
use XLite\Core\Database;
use XLite\Model\Country;

class CountryCodeValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint)
    {
        $addressFields = AddressFieldsTransformer::transform($value);
        $countryCode   = $addressFields['country_code'] ?? null;

        if ($countryCode) {
            $country = Database::getRepo(Country::class)->findOneBy([
                'enabled' => 1,
                'code'    => $countryCode,
            ]);

            if (!$country) {
                $this->context->buildViolation($constraint->message)
                    ->setParameter('{{ value }}', $countryCode)
                    ->addViolation();
            }
        }
    }
}
