<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Address\DataProvider\Item\Assembler;

use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class RequestAssemblerDecorator implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private RequestStack $requestStack,
    ) {
    }

    public function assemble($id): RequestInterface
    {
        /** @var \XCart\Logic\Action\Storefront\Address\GetOne\DTO\Request $request */
        $request = $this->inner->assemble($id);

        $request->setProfile(
            $this->requestStack->getCurrentRequest()->attributes->get('_profile')
        );

        return $request;
    }
}
