<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\API\Endpoint\Storefront\Address\DataProvider\Collection\Assembler;

use ApiPlatform\Exception\InvalidArgumentException;
use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\IntegerValue;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\NumberFilterStrategyType;

class RequestAssemblerDecorator implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private RequestStack $requestStack,
    ) {
    }

    public function assemble(string $resourceClass, string $operationName, array $context): RequestInterface
    {
        /** @var \XCart\Logic\Action\Storefront\Address\GetList\DTO\Request $request */
        $request = $this->inner->assemble($resourceClass, $operationName, $context);

        $profileId = $this->requestStack->getCurrentRequest()->attributes->get('_profile_id');

        if (!$profileId) {
            throw new InvalidArgumentException('This endpoint is allowed only for authorized user');
        }

        $request->getFilter()->setProfile(
            (new IntegerValue())
                ->setValue($profileId)
                ->setStrategy(NumberFilterStrategyType::EXACT())
                ->setExclude(false)
        );

        return $request;
    }
}
