<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\API\DataProvider\Storefront\Item\Assembler;

use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\Factory\Request\RequestFactoryInterface;

/**
 * This class differs from the default
 * \XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler\RequestAssembler class
 * in that the id is not set for the Request
 */
class WithoutIdRequestAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private RequestFactoryInterface $requestFactory,
    ) {
    }

    public function assemble($id): RequestInterface
    {
        if (!$id) {
            return $this->requestFactory->create();
        }

        return $this->inner->assemble($id);
    }
}
