<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\API\DataProvider\Storefront\Collection\Assembler;

use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\StringListValue;
use XCart\Bundle\LogicBundle\DTO\Request\FilterOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Domain\StaticConfigDomain;

class RequestAssemblerDecorator implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $inner,
        private StaticConfigDomain $configDomain
    ) {
    }

    public function assemble(string $resourceClass, string $operationName, array $context): RequestInterface
    {
        $request = $this->inner->assemble($resourceClass, $operationName, $context);

        if ($request instanceof FilterOwnerRequestInterface) {
            /** @var XCart\Logic\Action\Storefront\Config\GetList\DTO\Request\Filter $filter */
            $filter = $request->getFilter();
            $selectedConfigs = $this->configDomain->getOption(['storefront_api', 'configs']);

            $result = [];
            foreach ($selectedConfigs as $condition) {
                $result[] = $condition['category'] . '|' . $condition['name'];
            }

            $filter->setSelected(
                (new StringListValue())->setValue($result)
            );
        }

        return $request;
    }
}
