SET FOREIGN_KEY_CHECKS=0;

--
-- Product date and arrival date corrections.
--
UPDATE
    `%%XC%%_products`
SET
    arrivalDate = UNIX_TIMESTAMP(CONVERT_TZ(CURDATE(), '+00:00', @@session.time_zone)) - arrivalDate,
    date = UNIX_TIMESTAMP(CONVERT_TZ(CURDATE(), '+00:00', @@session.time_zone)) - date;


--
-- Assign "Wheels" and "Tires" categories as default for AutoSync import.
--
INSERT INTO
    `%%XC%%_config` (name, category, type, orderby, value, widgetParameters)
VALUES
    ('wheelCategoryId', 'XC\\AutoSync', 'text', 0, (SELECT id FROM `%%XC%%_category_translations` WHERE name = 'Wheels' LIMIT 1), 'N;'),
    ('tireCategoryId', 'XC\\AutoSync', 'text', 0, (SELECT id FROM `%%XC%%_category_translations` WHERE name = 'Tires' LIMIT 1), 'N;');