SET FOREIGN_KEY_CHECKS=0;

--
-- Product classes
--
INSERT INTO `%%XC%%_product_classes` (`id`, `position`)
VALUES (4, 10), (5, 20), (6, 30), (7, 40), (8, 50), (9, 60), (10, 70), (11, 80), (12, 0), (13, 0), (14, 0);


--
-- Product class translations
--
INSERT INTO `%%XC%%_product_class_translations` (`id`, `name`, `code`)
VALUES
    (4, 'Discos de freno', 'es'),
    (5, 'Pernos', 'es'),
    (6, 'Mangueras trenzadas', 'es'),
    (7, 'Pastillas de freno', 'es'),
    (8, 'Paquete de frenos', 'es'),
    (9, 'Embragues', 'es'),
    (10, 'Almohadillas de carrera', 'es'),
    (11, 'Espaciadores de ruedas', 'es'),
    (12, 'Rueda', 'es'),
    (13, 'Ruedas', 'es'),
    (14, 'Llantas', 'es'),
    (4, 'Brake Discs', 'en'),
    (5, 'Bolts', 'en'),
    (6, 'Braided Hoses', 'en'),
    (7, 'Brake Pads', 'en'),
    (8, 'Brake Package', 'en'),
    (9, 'Clutches', 'en'),
    (10, 'Race Pads', 'en'),
    (11, 'Wheel Spacers', 'en'),
    (12, 'Wheel', 'en'),
    (13, 'Wheels', 'en'),
    (14, 'Tires', 'en');


--
-- Attribute groups
--
INSERT INTO `%%XC%%_attribute_groups` (`id`, `product_class_id`, `position`)
VALUES
    (4, 4, 0),
    (5, 11, 0),
    (6, 13, 0),
    (7, 13, 0),
    (8, 13, 0),
    (9, 13, 0),
    (10, 13, 0),
    (11, 14, 0),
    (12, 14, 0),
    (13, 14, 0);


--
-- Attribute group translations
--
INSERT INTO `%%XC%%_attribute_group_translations` (`id`, `name`, `code`)
VALUES
    (4, 'Dimensiones', 'es'),
    (5, 'Dimensiones', 'es'),
    (6, 'Etiquetas', 'es'),
    (7, 'Tamaño de llanta', 'es'),
    (8, 'Patrón de pernos', 'es'),
    (9, 'Especificaciones', 'es'),
    (10, 'Estilos de ruedas', 'es'),
    (11, 'Etiquetas', 'es'),
    (12, 'Tamaño de llanta', 'es'),
    (13, 'Especificaciones', 'es'),
    (4, 'Dimensions', 'en'),
    (5, 'Dimensions', 'en'),
    (6, 'Tags', 'en'),
    (7, 'Rim Size', 'en'),
    (8, 'Bolt Pattern', 'en'),
    (9, 'Specifications', 'en'),
    (10, 'Wheel Styles', 'en'),
    (11, 'Tags', 'en'),
    (12, 'Tire Size', 'en'),
    (13, 'Specifications', 'en');

--
-- Attributes
--
INSERT INTO
    `%%XC%%_attributes` (
        `id`, `product_class_id`, `attribute_group_id`, `type`, `displayMode`, `position`, `decimals`, `addToNew`
    )
VALUES
    (50, NULL, NULL, 'S', 'S', 0, 0, ''),
    (100, 4, 4, 'T', '', 0, 0, ''),
    (101, 4, 4, 'T', '', 0, 0, ''),
    (102, 4, 4, 'T', '', 0, 0, ''),
    (103, NULL, NULL, 'T', '', 0, 0, ''),
    (104, 4, NULL, 'T', '', 0, 0, ''),
    (105, NULL, NULL, 'T', '', 0, 0, ''),
    (106, NULL, NULL, 'T', '', 0, 0, ''),
    (107, 4, 4, 'T', '', 0, 0, ''),
    (108, 4, 4, 'T', '', 0, 0, ''),
    (109, 4, 4, 'T', '', 0, 0, ''),
    (110, 4, 4, 'T', '', 0, 0, ''),
    (111, 4, 4, 'T', '', 0, 0, ''),
    (112, NULL, NULL, 'T', '', 0, 0, ''),
    (113, 5, NULL, 'T', '', 0, 0, ''),
    (114, 5, NULL, 'T', '', 0, 0, ''),
    (115, 5, NULL, 'T', '', 0, 0, ''),
    (116, 5, NULL, 'T', '', 0, 0, ''),
    (117, 5, NULL, 'T', '', 0, 0, ''),
    (118, 6, NULL, 'T', '', 0, 0, ''),
    (119, 6, NULL, 'T', '', 0, 0, ''),
    (140, NULL, NULL, 'T', '', 0, 0, ''),
    (141, 10, NULL, 'T', '', 0, 0, ''),
    (142, 10, NULL, 'T', '', 0, 0, ''),
    (146, NULL, NULL, 'T', '', 0, 0, ''),
    (153, 11, 5, 'T', '', 0, 0, ''),
    (154, 11, 5, 'T', '', 0, 0, ''),
    (155, 11, 5, 'T', '', 0, 0, ''),
    (156, 11, 5, 'T', '', 0, 0, ''),
    (157, 11, 5, 'T', '', 0, 0, ''),
    (158, NULL, NULL, 'S', 'S', 0, 0, ''),
    (161, NULL, NULL, 'S', 'S', 0, 0, ''),
    (163, NULL, NULL, 'S', 'S', 0, 0, ''),
    (164, NULL, NULL, 'S', 'S', 0, 0, ''),
    (165, NULL, NULL, 'S', 'S', 0, 0, ''),
    (166, NULL, NULL, 'S', 'S', 0, 0, ''),
    (168, NULL, NULL, 'S', 'S', 0, 0, ''),
    (171, NULL, NULL, 'S', 'S', 0, 0, ''),
    (172, NULL, NULL, 'S', 'S', 0, 0, ''),
    (173, 13, 6, 'S', 'P', 0, 0, ''),
    (174, 13, 6, 'S', 'P', 0, 0, ''),
    (175, 13, 7, 'S', 'S', 0, 0, ''),
    (176, 13, 7, 'S', 'S', 0, 0, ''),
    (177, 13, 8, 'S', 'S', 0, 0, ''),
    (178, 13, 8, 'S', 'P', 0, 0, ''),
    (179, 13, 9, 'S', 'S', 0, 0, ''),
    (180, 13, 9, 'S', 'S', 0, 0, ''),
    (181, 13, 9, 'S', 'S', 0, 0, ''),
    (182, 13, 9, 'S', 'S', 0, 0, ''),
    (183, 13, 9, 'S', 'S', 0, 0, ''),
    (184, 13, 9, 'S', 'S', 0, 0, ''),
    (185, 13, 10, 'S', 'S', 0, 0, ''),
    (186, 13, 10, 'S', 'S', 0, 0, ''),
    (187, 13, 10, 'S', 'S', 0, 0, ''),
    (188, 13, 10, 'C', '', 0, 0, ''),
    (189, 13, 10, 'S', 'S', 0, 0, ''),
    (190, 13, 10, 'S', 'S', 0, 0, ''),
    (191, 13, NULL, 'S', 'S', 0, 0, ''),
    (192, 14, 11, 'S', 'P', 0, 0, ''),
    (193, 14, 11, 'S', 'P', 0, 0, ''),
    (194, 14, 12, 'S', 'S', 0, 0, ''),
    (195, 14, 12, 'S', 'S', 0, 0, ''),
    (196, 14, 12, 'S', 'S', 0, 0, ''),
    (197, 14, 13, 'S', 'S', 0, 0, ''),
    (198, 14, 13, 'S', 'S', 0, 0, ''),
    (199, 14, 13, 'S', 'S', 0, 0, ''),
    (200, 14, 13, 'S', 'S', 0, 0, ''),
    (201, 14, 13, 'S', 'S', 0, 0, ''),
    (202, 14, 13, 'S', 'S', 0, 0, ''),
    (203, 14, 13, 'S', 'S', 0, 0, ''),
    (204, 14, NULL, 'S', 'S', 0, 0, ''),
    (205, 14, 13, 'S', 'S', 0, 0, ''),
    (206, 14, 13, 'S', 'S', 0, 0, ''),
    (207, 14, 12, 'S', 'S', 0, 0, ''),
    (208, 14, 12, 'S', 'S', 0, 0, ''),
    (209, NULL, NULL, 'S', 'S', 0, 0, ''),
    (210, NULL, NULL, 'S', 'S', 0, 0, '');

--
-- Match attributes and products
--
UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1)
WHERE
    id = 158;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1)
WHERE
    id = 161;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1)
WHERE
    id = 163;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1)
WHERE
    id = 164;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1)
WHERE
    id = 165;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1)
WHERE
    id = 166;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1)
WHERE
    id = 168;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1)
WHERE
    id = 171;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1)
WHERE
    id = 172;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1)
WHERE
    id = 209;

UPDATE
    `%%XC%%_attributes`
SET
    product_id = (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1)
WHERE
    id = 210;


--
-- Attribute translations
--
INSERT INTO `%%XC%%_attribute_translations` (`id`, `name`, `unit`, `code`)
VALUES
    (50, 'Marca', '', 'es'),
    (100, 'Diámetro', '', 'es'),
    (101, 'Diámetro de la espiga', '', 'es'),
    (102, 'PCD', '', 'es'),
    (103, 'Colocación en el coche', '', 'es'),
    (104, 'Características', '', 'es'),
    (105, 'Fabricante', '', 'es'),
    (106, 'NMP', '', 'es'),
    (107, 'Espesor máx.', '', 'es'),
    (108, 'Espesor mínimo', '', 'es'),
    (109, 'Altura', '', 'es'),
    (110, 'Agujeros para pernos', '', 'es'),
    (111, 'Sólido o ventilado', '', 'es'),
    (112, 'País/Región de Fabricación', '', 'es'),
    (113, 'Finalizar', '', 'es'),
    (114, 'Estilo de cabeza', '', 'es'),
    (115, 'Material', '', 'es'),
    (116, 'Número en paquete', '', 'es'),
    (117, 'Tamaño del hilo', '', 'es'),
    (118, 'Cantidad de manguera:', '', 'es'),
    (119, 'Notas:', '', 'es'),
    (140, 'Características', '', 'es'),
    (141, 'Profundidad radial', '', 'es'),
    (142, 'Diámetro del rotor', '', 'es'),
    (146, 'EAN', '', 'es'),
    (153, 'Diámetro', '', 'es'),
    (154, 'Espesor', '', 'es'),
    (155, 'Diámetro de la espiga', '', 'es'),
    (156, 'Diámetro del orificio del perno prisionero', '', 'es'),
    (157, 'PCD', '', 'es'),
    (158, 'Material', '', 'es'),
    (161, 'Color', '', 'es'),
    (163, 'Color', '', 'es'),
    (164, 'Tamaño de la rueda delantera', '', 'es'),
    (165, 'Color', '', 'es'),
    (166, 'Color', '', 'es'),
    (168, 'Tamaño', '', 'es'),
    (171, 'Color', '', 'es'),
    (172, 'Color', '', 'es'),
    (173, 'tipo de vehiculo', '', 'es'),
    (174, 'Segmento', '', 'es'),
    (175, 'Diámetro [pulgadas]', '', 'es'),
    (176, 'Ancho [pulgadas]', '', 'es'),
    (177, 'Recuento de tuercas', '', 'es'),
    (178, 'Círculo de pernos [mm]', '', 'es'),
    (179, 'Acabado', '', 'es'),
    (180, 'Color', '', 'es'),
    (181, 'Acento', '', 'es'),
    (182, 'Diámetro [mm]', '', 'es'),
    (183, 'Clasificación de carga [libras]', '', 'es'),
    (184, 'Desplazamiento [mm]', '', 'es'),
    (185, 'Material', '', 'es'),
    (186, 'Estructura', '', 'es'),
    (187, 'Tipo de terminal', '', 'es'),
    (188, 'Orejetas expuestas', '', 'es'),
    (189, 'Modelo', '', 'es'),
    (190, 'Submodelo', '', 'es'),
    (191, 'Tamaño de rueda y patrón de pernos', '', 'es'),
    (192, 'tipo de vehiculo', '', 'es'),
    (193, 'Tipo de neumático', '', 'es'),
    (194, 'Ancho de sección [mm]', '', 'es'),
    (195, 'Relación de aspecto', '', 'es'),
    (196, 'Relación de aspecto', '', 'es'),
    (197, 'Modelo', '', 'es'),
    (198, 'Diámetro total [pulgadas]', '', 'es'),
    (199, 'Ancho promedio', '', 'es'),
    (200, 'Profundidad de la banda de rodadura', '', 'es'),
    (201, 'Revoluciones por milla', '', 'es'),
    (202, 'Capacidad de carga', '', 'es'),
    (203, 'Clasificación de velocidad', '', 'es'),
    (204, 'Tamaño de llanta', '', 'es'),
    (205, 'Rango de carga', '', 'es'),
    (206, 'Clasificación de capas', '', 'es'),
    (207, 'Diámetro [pulgadas]', '', 'es'),
    (208, 'Ancho de llanta [pulgadas]', '', 'es'),
    (209, 'Color', '', 'es'),
    (210, 'Color', '', 'es'),
    (50, 'Brand', '', 'en'),
    (100, 'Diameter', '', 'en'),
    (101, 'Spigot Diameter', '', 'en'),
    (102, 'PCD', '', 'en'),
    (103, 'Placement on Car', '', 'en'),
    (104, 'Features', '', 'en'),
    (105, 'Manufacturer', '', 'en'),
    (106, 'MPN', '', 'en'),
    (107, 'Thickness Max', '', 'en'),
    (108, 'Thickness Min', '', 'en'),
    (109, 'Height', '', 'en'),
    (110, 'Stud Holes', '', 'en'),
    (111, 'Solid or Vented', '', 'en'),
    (112, 'Country/Region of Manufacture', '', 'en'),
    (113, 'Finish', '', 'en'),
    (114, 'Head Style', '', 'en'),
    (115, 'Material', '', 'en'),
    (116, 'Number in Pack', '', 'en'),
    (117, 'Thread Size', '', 'en'),
    (118, 'Hose Quantity:', '', 'en'),
    (119, 'Notes:', '', 'en'),
    (140, 'Features', '', 'en'),
    (141, 'Radial Depth', '', 'en'),
    (142, 'Rotor Diameter', '', 'en'),
    (146, 'EAN', '', 'en'),
    (153, 'Diameter', '', 'en'),
    (154, 'Thickness', '', 'en'),
    (155, 'Spigot Diameter', '', 'en'),
    (156, 'Stud Hole Diameter', '', 'en'),
    (157, 'PCD', '', 'en'),
    (158, 'Material', '', 'en'),
    (161, 'Color', '', 'en'),
    (163, 'Color', '', 'en'),
    (164, 'Front Wheel Size', '', 'en'),
    (165, 'Color', '', 'en'),
    (166, 'Color', '', 'en'),
    (168, 'Size', '', 'en'),
    (171, 'Color', '', 'en'),
    (172, 'Color', '', 'en'),
    (173, 'Vehicle Type', '', 'en'),
    (174, 'Segment', '', 'en'),
    (175, 'Diameter [inch]', '', 'en'),
    (176, 'Width [inch]', '', 'en'),
    (177, 'Lug Count', '', 'en'),
    (178, 'Bolt Circle [mm]', '', 'en'),
    (179, 'Finish', '', 'en'),
    (180, 'Color', '', 'en'),
    (181, 'Accent', '', 'en'),
    (182, 'Bore [mm]', '', 'en'),
    (183, 'Load Rating [lbs]', '', 'en'),
    (184, 'Offset [mm]', '', 'en'),
    (185, 'Material', '', 'en'),
    (186, 'Structure', '', 'en'),
    (187, 'Lug Type', '', 'en'),
    (188, 'Exposed Lugs', '', 'en'),
    (189, 'Model', '', 'en'),
    (190, 'Submodel', '', 'en'),
    (191, 'Wheel Size & Bolt Pattern', '', 'en'),
    (192, 'Vehicle Type', '', 'en'),
    (193, 'Tire Type', '', 'en'),
    (194, 'Section Width [mm]', '', 'en'),
    (195, 'Aspect Ratio', '', 'en'),
    (196, 'Rim Diameter [inch]', '', 'en'),
    (197, 'Model', '', 'en'),
    (198, 'Overall Diameter [inch]', '', 'en'),
    (199, 'Overall Width', '', 'en'),
    (200, 'Tread depth', '', 'en'),
    (201, 'Revolutions Per Mile', '', 'en'),
    (202, 'Load rating', '', 'en'),
    (203, 'Speed rating', '', 'en'),
    (204, 'Tire Size', '', 'en'),
    (205, 'Load range', '', 'en'),
    (206, 'Ply rating', '', 'en'),
    (207, 'Diameter [inch]', '', 'en'),
    (208, 'Rim Width [inch]', '', 'en'),
    (209, 'Color', '', 'en'),
    (210, 'Color', '', 'en');


--
-- Attribute options
--
INSERT INTO `%%XC%%_attribute_options` (`id`, `attribute_id`, `position`, `addToNew`)
VALUES
    (245, 98, 0, 0), (246, 98, 0, 0), (247, 98, 0, 0), (248, 98, 0, 0), (482, 50, 0, 0), (485, 50, 0, 0), (494, 50, 0, 0), (497, 158, 0, 0), (498, 158, 0, 0), (499, NULL, 0, 0),
    (500, NULL, 0, 0), (501, NULL, 0, 0), (502, NULL, 0, 0), (503, 161, 0, 0), (504, 161, 0, 0), (505, 50, 0, 0), (506, 50, 0, 0), (507, 50, 0, 0), (508, 50, 0, 0),
    (509, 50, 0, 0), (510, 50, 0, 0), (511, 50, 0, 0), (512, 50, 0, 0), (514, 50, 0, 0), (515, 50, 0, 0), (516, 50, 0, 0), (517, 50, 0, 0), (518, 50, 0, 0), (519, 50, 0, 0),
    (520, 50, 0, 0), (521, 50, 0, 0), (522, 50, 0, 0), (523, 50, 0, 0), (524, 50, 0, 0), (525, 50, 0, 0), (526, 50, 0, 0), (527, 50, 0, 0), (528, 50, 0, 0), (529, 50, 0, 0),
    (530, 50, 0, 0), (531, 50, 0, 0), (532, 50, 0, 0), (533, 50, 0, 0), (534, 50, 0, 0), (535, 50, 0, 0), (536, 50, 0, 0), (537, 50, 0, 0), (538, 50, 0, 0), (539, 50, 0, 0),
    (540, 50, 0, 0), (541, 50, 0, 0), (542, 50, 0, 0), (543, 50, 0, 0), (544, 50, 0, 0), (545, 50, 0, 0), (546, 50, 0, 0), (547, 50, 0, 0), (551, 163, 0, 0), (552, 163, 0, 0),
    (553, 163, 0, 0), (554, 164, 0, 0), (555, 164, 0, 0), (556, 165, 0, 0), (557, 165, 0, 0), (558, 166, 0, 0), (559, 166, 0, 0), (562, 168, 0, 0), (563, 168, 0, 0),
    (564, 168, 0, 0), (565, 168, 0, 0), (566, 168, 0, 0), (567, NULL, 0, 0), (568, NULL, 0, 0), (569, NULL, 0, 0), (570, NULL, 0, 0), (571, NULL, 0, 0), (572, NULL, 0, 0),
    (573, NULL, 0, 0), (574, NULL, 0, 0), (575, 50, 0, 0), (576, 50, 0, 0), (577, 50, 0, 0), (578, 50, 0, 0), (579, 50, 0, 0), (580, 50, 0, 0), (581, 50, 0, 0), (582, 50, 0, 0),
    (583, 50, 0, 0), (584, 50, 0, 0), (585, 50, 0, 0), (586, 50, 0, 0), (587, 50, 0, 0), (588, 50, 0, 0), (589, 50, 0, 0), (590, 50, 0, 0), (591, 50, 0, 0), (592, 50, 0, 0),
    (593, 50, 0, 0), (594, 50, 0, 0), (595, 50, 0, 0), (596, 50, 0, 0), (597, 50, 0, 0), (598, 50, 0, 0), (599, 50, 0, 0), (600, 50, 0, 0), (601, 50, 0, 0), (602, 50, 0, 0),
    (603, 50, 0, 0), (604, 50, 0, 0), (605, 50, 0, 0), (606, 50, 0, 0), (607, 50, 0, 0), (608, 50, 0, 0), (609, 50, 0, 0), (610, 50, 0, 0), (611, 50, 0, 0), (612, 50, 0, 0),
    (613, 50, 0, 0), (614, 50, 0, 0), (615, 50, 0, 0), (616, 50, 0, 0), (617, 50, 0, 0), (618, 50, 0, 0), (619, 50, 0, 0), (620, 50, 0, 0), (621, 50, 0, 0), (622, 50, 0, 0),
    (623, 50, 0, 0), (624, 50, 0, 0), (625, 50, 0, 0), (626, 50, 0, 0), (627, 50, 0, 0), (628, 50, 0, 0), (629, 50, 0, 0), (630, 50, 0, 0), (631, 50, 0, 0), (632, 50, 0, 0),
    (633, 50, 0, 0), (634, 50, 0, 0), (635, 50, 0, 0), (636, 50, 0, 0), (637, 50, 0, 0), (638, 50, 0, 0), (639, 50, 0, 0), (640, 50, 0, 0), (641, 50, 0, 0), (642, 50, 0, 0),
    (643, 50, 0, 0), (644, 50, 0, 0), (645, 50, 0, 0), (646, 50, 0, 0), (647, 50, 0, 0), (648, 50, 0, 0), (649, 50, 0, 0), (650, 50, 0, 0), (651, 50, 0, 0), (652, 50, 0, 0),
    (653, 50, 0, 0), (654, 50, 0, 0), (655, 50, 0, 0), (656, 50, 0, 0), (657, 50, 0, 0), (658, 50, 0, 0), (659, 50, 0, 0), (660, 50, 0, 0), (661, 50, 0, 0), (662, 50, 0, 0),
    (663, 50, 0, 0), (664, 50, 0, 0), (665, 50, 0, 0), (666, 50, 0, 0), (667, 50, 0, 0), (668, 50, 0, 0), (669, 50, 0, 0), (670, 50, 0, 0), (672, 50, 0, 0),
    (673, 50, 0, 0), (674, 50, 0, 0), (676, 50, 0, 0), (677, 50, 0, 0), (678, 50, 0, 0), (679, 50, 0, 0), (680, 50, 0, 0), (681, 50, 0, 0), (682, 50, 0, 0),
    (683, 173, 0, 0), (684, 173, 0, 0), (685, 174, 0, 0), (686, 175, 0, 0), (687, 176, 0, 0), (688, 177, 0, 0), (689, 178, 0, 0), (690, 178, 0, 0), (691, 179, 0, 0),
    (692, 180, 0, 0), (693, 181, 0, 0), (694, 182, 0, 0), (695, 183, 0, 0), (696, 184, 0, 0), (697, 185, 0, 0), (698, 186, 0, 0), (699, 187, 0, 0), (700, 189, 0, 0),
    (701, 190, 0, 0), (702, 191, 0, 0), (703, 177, 0, 0), (704, 178, 0, 0), (705, 182, 0, 0), (706, 191, 0, 0), (707, 175, 0, 0), (708, 191, 0, 0), (709, 175, 0, 0),
    (710, 176, 0, 0), (711, 184, 0, 0), (712, 191, 0, 0), (713, 191, 0, 0), (714, 191, 0, 0), (715, 191, 0, 0), (716, 176, 0, 0), (717, 183, 0, 0), (718, 191, 0, 0),
    (719, 191, 0, 0), (720, 177, 0, 0), (721, 178, 0, 0), (722, 182, 0, 0), (723, 183, 0, 0), (724, 191, 0, 0), (725, 178, 0, 0), (726, 191, 0, 0), (727, 178, 0, 0),
    (728, 191, 0, 0), (729, 184, 0, 0), (730, 191, 0, 0), (731, 184, 0, 0), (732, 191, 0, 0), (733, 189, 0, 0), (734, 191, 0, 0), (735, 182, 0, 0), (736, 191, 0, 0),
    (737, 191, 0, 0), (738, 184, 0, 0), (739, 191, 0, 0), (740, 191, 0, 0), (741, 191, 0, 0), (742, 191, 0, 0), (743, 191, 0, 0), (744, 191, 0, 0), (745, 191, 0, 0),
    (746, 191, 0, 0), (747, 189, 0, 0), (748, 191, 0, 0), (749, 191, 0, 0), (750, 189, 0, 0), (751, 189, 0, 0), (752, 189, 0, 0), (753, 189, 0, 0), (754, 176, 0, 0),
    (755, 179, 0, 0), (756, 181, 0, 0), (757, 184, 0, 0), (758, 189, 0, 0), (759, 190, 0, 0), (760, 191, 0, 0), (761, 183, 0, 0), (762, 191, 0, 0), (763, 191, 0, 0),
    (764, 191, 0, 0), (765, 173, 0, 0), (766, 174, 0, 0), (767, 178, 0, 0), (768, 180, 0, 0), (769, 181, 0, 0), (770, 182, 0, 0), (771, 183, 0, 0), (772, 184, 0, 0),
    (773, 189, 0, 0), (774, 190, 0, 0), (775, 191, 0, 0), (776, 178, 0, 0), (777, 191, 0, 0), (778, 175, 0, 0), (779, 184, 0, 0), (780, 191, 0, 0), (781, 176, 0, 0),
    (782, 191, 0, 0), (783, 176, 0, 0), (784, 191, 0, 0), (785, 176, 0, 0), (786, 178, 0, 0), (787, 184, 0, 0), (788, 191, 0, 0), (789, 176, 0, 0), (790, 184, 0, 0),
    (791, 191, 0, 0), (792, 180, 0, 0), (793, 181, 0, 0), (794, 190, 0, 0), (795, 180, 0, 0), (796, 190, 0, 0), (797, 178, 0, 0), (798, 179, 0, 0), (799, 180, 0, 0),
    (800, 181, 0, 0), (801, 189, 0, 0), (802, 191, 0, 0), (803, 183, 0, 0), (804, 191, 0, 0), (805, 191, 0, 0), (806, 184, 0, 0), (807, 191, 0, 0), (808, 191, 0, 0),
    (809, 191, 0, 0), (810, 184, 0, 0), (811, 191, 0, 0), (812, 191, 0, 0), (813, 191, 0, 0), (814, 191, 0, 0), (815, 190, 0, 0), (816, 180, 0, 0), (817, 190, 0, 0),
    (818, 191, 0, 0), (819, 190, 0, 0), (820, 178, 0, 0), (821, 180, 0, 0), (822, 183, 0, 0), (823, 189, 0, 0), (824, 191, 0, 0), (825, 181, 0, 0), (826, 190, 0, 0),
    (827, 181, 0, 0), (828, 183, 0, 0), (829, 189, 0, 0), (830, 191, 0, 0), (831, 181, 0, 0), (832, 190, 0, 0), (833, 180, 0, 0), (834, 190, 0, 0), (835, 178, 0, 0),
    (836, 189, 0, 0), (837, 191, 0, 0), (838, 191, 0, 0), (839, 191, 0, 0), (840, 191, 0, 0), (841, 191, 0, 0), (842, 191, 0, 0), (843, 180, 0, 0), (844, 192, 0, 0),
    (845, 193, 0, 0), (846, 193, 0, 0), (847, 194, 0, 0), (848, 195, 0, 0), (849, 196, 0, 0), (850, 197, 0, 0), (851, 198, 0, 0), (852, 199, 0, 0), (853, 200, 0, 0),
    (854, 201, 0, 0), (855, 202, 0, 0), (856, 203, 0, 0), (857, 204, 0, 0), (858, 194, 0, 0), (859, 198, 0, 0), (860, 199, 0, 0), (861, 200, 0, 0), (862, 201, 0, 0),
    (863, 202, 0, 0), (864, 204, 0, 0), (865, 194, 0, 0), (866, 195, 0, 0), (867, 198, 0, 0), (868, 199, 0, 0), (869, 205, 0, 0), (870, 200, 0, 0), (871, 201, 0, 0),
    (872, 202, 0, 0), (873, 203, 0, 0), (874, 204, 0, 0), (875, 196, 0, 0), (876, 199, 0, 0), (877, 201, 0, 0), (878, 202, 0, 0), (879, 204, 0, 0), (880, 194, 0, 0),
    (881, 198, 0, 0), (882, 199, 0, 0), (883, 201, 0, 0), (884, 204, 0, 0), (885, 194, 0, 0), (886, 195, 0, 0), (887, 196, 0, 0), (888, 198, 0, 0), (889, 199, 0, 0),
    (890, 201, 0, 0), (891, 202, 0, 0), (892, 204, 0, 0), (893, 194, 0, 0), (894, 198, 0, 0), (895, 199, 0, 0), (896, 201, 0, 0), (897, 202, 0, 0), (898, 204, 0, 0),
    (899, 198, 0, 0), (900, 201, 0, 0), (901, 202, 0, 0), (902, 204, 0, 0), (903, 194, 0, 0), (904, 199, 0, 0), (905, 202, 0, 0), (906, 204, 0, 0), (907, 198, 0, 0),
    (908, 199, 0, 0), (909, 201, 0, 0), (910, 202, 0, 0), (911, 204, 0, 0), (912, 198, 0, 0), (913, 201, 0, 0), (914, 202, 0, 0), (915, 204, 0, 0), (916, 196, 0, 0),
    (917, 198, 0, 0), (918, 201, 0, 0), (919, 202, 0, 0), (920, 204, 0, 0), (921, 198, 0, 0), (922, 199, 0, 0), (923, 201, 0, 0), (924, 204, 0, 0), (925, 201, 0, 0),
    (926, 202, 0, 0), (927, 204, 0, 0), (928, 194, 0, 0), (929, 198, 0, 0), (930, 199, 0, 0), (931, 201, 0, 0), (932, 204, 0, 0), (933, 195, 0, 0), (934, 199, 0, 0),
    (935, 204, 0, 0), (936, 194, 0, 0), (937, 199, 0, 0), (938, 204, 0, 0), (939, 195, 0, 0), (940, 196, 0, 0), (941, 198, 0, 0), (942, 199, 0, 0), (943, 201, 0, 0),
    (944, 204, 0, 0), (945, 201, 0, 0), (946, 204, 0, 0), (947, 198, 0, 0), (948, 201, 0, 0), (949, 204, 0, 0), (950, 198, 0, 0), (951, 201, 0, 0), (952, 204, 0, 0),
    (953, 204, 0, 0), (954, 194, 0, 0), (955, 199, 0, 0), (956, 201, 0, 0), (957, 202, 0, 0), (958, 204, 0, 0), (959, 194, 0, 0), (960, 195, 0, 0), (961, 198, 0, 0),
    (962, 199, 0, 0), (963, 201, 0, 0), (964, 204, 0, 0), (965, 196, 0, 0), (966, 201, 0, 0), (967, 202, 0, 0), (968, 204, 0, 0), (969, 198, 0, 0), (970, 201, 0, 0),
    (971, 204, 0, 0), (972, 198, 0, 0), (973, 199, 0, 0), (974, 201, 0, 0), (975, 204, 0, 0), (976, 198, 0, 0), (977, 199, 0, 0), (978, 201, 0, 0), (979, 204, 0, 0),
    (980, 204, 0, 0), (981, 194, 0, 0), (982, 198, 0, 0), (983, 199, 0, 0), (984, 201, 0, 0), (985, 202, 0, 0), (986, 204, 0, 0), (987, 198, 0, 0), (988, 201, 0, 0),
    (989, 204, 0, 0), (990, 194, 0, 0), (991, 198, 0, 0), (992, 199, 0, 0), (993, 201, 0, 0), (994, 204, 0, 0), (995, 198, 0, 0), (996, 201, 0, 0), (997, 204, 0, 0),
    (998, 204, 0, 0), (999, 204, 0, 0), (1000, 198, 0, 0), (1001, 201, 0, 0), (1002, 204, 0, 0), (1003, 198, 0, 0), (1004, 201, 0, 0), (1005, 204, 0, 0), (1006, 198, 0, 0),
    (1007, 201, 0, 0), (1008, 202, 0, 0), (1009, 204, 0, 0), (1010, 198, 0, 0), (1011, 201, 0, 0), (1012, 204, 0, 0), (1013, 204, 0, 0), (1014, 198, 0, 0), (1015, 204, 0, 0),
    (1016, 198, 0, 0), (1017, 201, 0, 0), (1018, 204, 0, 0), (1019, 201, 0, 0), (1020, 204, 0, 0), (1021, 198, 0, 0), (1022, 201, 0, 0), (1023, 204, 0, 0), (1024, 201, 0, 0),
    (1025, 204, 0, 0), (1026, 200, 0, 0), (1027, 204, 0, 0), (1028, 204, 0, 0), (1029, 204, 0, 0), (1030, 199, 0, 0), (1031, 201, 0, 0), (1032, 202, 0, 0), (1033, 204, 0, 0),
    (1034, 204, 0, 0), (1035, 205, 0, 0), (1036, 204, 0, 0), (1037, 198, 0, 0), (1038, 199, 0, 0), (1039, 204, 0, 0), (1040, 201, 0, 0), (1041, 204, 0, 0), (1042, 204, 0, 0),
    (1043, 204, 0, 0), (1044, 204, 0, 0), (1045, 198, 0, 0), (1046, 202, 0, 0), (1047, 204, 0, 0), (1048, 195, 0, 0), (1049, 204, 0, 0), (1050, 198, 0, 0), (1051, 201, 0, 0),
    (1052, 202, 0, 0), (1053, 204, 0, 0), (1054, 204, 0, 0), (1055, 198, 0, 0), (1056, 201, 0, 0), (1057, 204, 0, 0), (1058, 204, 0, 0), (1059, 204, 0, 0), (1060, 198, 0, 0),
    (1061, 199, 0, 0), (1062, 204, 0, 0), (1063, 198, 0, 0), (1064, 199, 0, 0), (1065, 201, 0, 0), (1066, 198, 0, 0), (1067, 201, 0, 0), (1068, 204, 0, 0), (1069, 194, 0, 0),
    (1070, 198, 0, 0), (1071, 199, 0, 0), (1072, 201, 0, 0), (1073, 202, 0, 0), (1074, 204, 0, 0), (1075, 201, 0, 0), (1076, 204, 0, 0), (1077, 198, 0, 0), (1078, 199, 0, 0),
    (1079, 201, 0, 0), (1080, 204, 0, 0), (1081, 201, 0, 0), (1082, 199, 0, 0), (1083, 204, 0, 0), (1084, 201, 0, 0), (1085, 204, 0, 0), (1086, 204, 0, 0), (1087, 201, 0, 0),
    (1088, 199, 0, 0), (1089, 204, 0, 0), (1090, 198, 0, 0), (1091, 201, 0, 0), (1092, 204, 0, 0), (1093, 201, 0, 0), (1094, 202, 0, 0), (1095, 204, 0, 0), (1096, 201, 0, 0),
    (1097, 203, 0, 0), (1098, 201, 0, 0), (1099, 205, 0, 0), (1100, 204, 0, 0), (1101, 204, 0, 0), (1102, 200, 0, 0), (1103, 198, 0, 0), (1104, 204, 0, 0), (1105, 199, 0, 0),
    (1106, 204, 0, 0), (1107, 204, 0, 0), (1108, 201, 0, 0), (1109, 202, 0, 0), (1110, 204, 0, 0), (1111, 198, 0, 0), (1112, 199, 0, 0), (1113, 199, 0, 0), (1114, 204, 0, 0),
    (1115, 198, 0, 0), (1116, 201, 0, 0), (1117, 204, 0, 0), (1118, 199, 0, 0), (1119, 201, 0, 0), (1120, 204, 0, 0), (1121, 201, 0, 0), (1122, 204, 0, 0), (1123, 201, 0, 0),
    (1124, 201, 0, 0), (1125, 204, 0, 0), (1126, 201, 0, 0), (1127, 204, 0, 0), (1128, 198, 0, 0), (1129, 199, 0, 0), (1130, 201, 0, 0), (1131, 204, 0, 0), (1132, 198, 0, 0),
    (1133, 201, 0, 0), (1134, 204, 0, 0), (1135, 198, 0, 0), (1136, 199, 0, 0), (1137, 201, 0, 0), (1138, 204, 0, 0), (1139, 201, 0, 0), (1140, 204, 0, 0), (1141, 198, 0, 0),
    (1142, 200, 0, 0), (1143, 201, 0, 0), (1144, 198, 0, 0), (1145, 204, 0, 0), (1146, 192, 0, 0), (1147, 193, 0, 0), (1148, 193, 0, 0), (1149, 193, 0, 0), (1150, 195, 0, 0),
    (1151, 196, 0, 0), (1152, 197, 0, 0), (1153, 198, 0, 0), (1154, 199, 0, 0), (1155, 200, 0, 0), (1156, 202, 0, 0), (1157, 203, 0, 0), (1158, 204, 0, 0), (1159, 198, 0, 0),
    (1160, 200, 0, 0), (1161, 201, 0, 0), (1162, 202, 0, 0), (1163, 203, 0, 0), (1164, 204, 0, 0), (1165, 195, 0, 0), (1166, 198, 0, 0), (1167, 199, 0, 0), (1168, 200, 0, 0),
    (1169, 201, 0, 0), (1170, 204, 0, 0), (1171, 196, 0, 0), (1172, 198, 0, 0), (1173, 199, 0, 0), (1174, 201, 0, 0), (1175, 204, 0, 0), (1176, 194, 0, 0), (1177, 203, 0, 0),
    (1178, 204, 0, 0), (1179, 198, 0, 0), (1180, 201, 0, 0), (1181, 202, 0, 0), (1182, 204, 0, 0), (1183, 198, 0, 0), (1184, 201, 0, 0), (1185, 204, 0, 0), (1186, 198, 0, 0),
    (1187, 201, 0, 0), (1188, 206, 0, 0), (1189, 204, 0, 0), (1190, 198, 0, 0), (1191, 199, 0, 0), (1192, 200, 0, 0), (1193, 201, 0, 0), (1194, 202, 0, 0), (1195, 204, 0, 0),
    (1196, 198, 0, 0), (1197, 204, 0, 0), (1198, 198, 0, 0), (1199, 201, 0, 0), (1200, 204, 0, 0), (1201, 204, 0, 0), (1202, 199, 0, 0), (1203, 204, 0, 0), (1204, 198, 0, 0),
    (1205, 199, 0, 0), (1206, 201, 0, 0), (1207, 202, 0, 0), (1208, 204, 0, 0), (1209, 198, 0, 0), (1210, 199, 0, 0), (1211, 201, 0, 0), (1212, 202, 0, 0), (1213, 206, 0, 0),
    (1214, 204, 0, 0), (1215, 202, 0, 0), (1216, 204, 0, 0), (1217, 198, 0, 0), (1218, 201, 0, 0), (1219, 202, 0, 0), (1220, 204, 0, 0), (1221, 201, 0, 0), (1222, 204, 0, 0),
    (1223, 195, 0, 0), (1224, 198, 0, 0), (1225, 200, 0, 0), (1226, 201, 0, 0), (1227, 204, 0, 0), (1228, 198, 0, 0), (1229, 199, 0, 0), (1230, 201, 0, 0), (1231, 204, 0, 0),
    (1232, 198, 0, 0), (1233, 201, 0, 0), (1234, 203, 0, 0), (1235, 204, 0, 0), (1236, 204, 0, 0), (1237, 195, 0, 0), (1238, 198, 0, 0), (1239, 201, 0, 0), (1240, 204, 0, 0),
    (1241, 195, 0, 0), (1242, 198, 0, 0), (1243, 199, 0, 0), (1244, 201, 0, 0), (1245, 204, 0, 0), (1246, 195, 0, 0), (1247, 201, 0, 0), (1248, 204, 0, 0), (1249, 200, 0, 0),
    (1250, 202, 0, 0), (1251, 204, 0, 0), (1252, 202, 0, 0), (1253, 204, 0, 0), (1254, 204, 0, 0), (1255, 198, 0, 0), (1256, 199, 0, 0), (1257, 201, 0, 0), (1258, 204, 0, 0),
    (1259, 201, 0, 0), (1260, 204, 0, 0), (1261, 207, 0, 0), (1262, 208, 0, 0), (1263, 198, 0, 0), (1264, 201, 0, 0), (1265, 204, 0, 0), (1266, 199, 0, 0), (1267, 199, 0, 0),
    (1268, 201, 0, 0), (1269, 204, 0, 0), (1270, 198, 0, 0), (1271, 204, 0, 0), (1272, 198, 0, 0), (1273, 201, 0, 0), (1274, 204, 0, 0), (1275, 207, 0, 0), (1276, 208, 0, 0),
    (1277, 201, 0, 0), (1278, 204, 0, 0), (1279, 204, 0, 0), (1280, 204, 0, 0), (1281, 204, 0, 0), (1282, 201, 0, 0), (1283, 204, 0, 0), (1284, 198, 0, 0), (1285, 204, 0, 0),
    (1286, 194, 0, 0), (1287, 196, 0, 0), (1288, 199, 0, 0), (1289, 204, 0, 0), (1290, 204, 0, 0), (1291, 198, 0, 0), (1292, 204, 0, 0), (1293, 202, 0, 0), (1294, 204, 0, 0),
    (1295, 201, 0, 0), (1296, 204, 0, 0), (1297, 201, 0, 0), (1298, 206, 0, 0), (1299, 204, 0, 0), (1300, 207, 0, 0), (1301, 208, 0, 0), (1302, 198, 0, 0), (1303, 201, 0, 0),
    (1304, 204, 0, 0), (1305, 206, 0, 0), (1306, 197, 0, 0), (1307, 203, 0, 0), (1308, 204, 0, 0), (1309, 199, 0, 0), (1310, 201, 0, 0), (1311, 204, 0, 0), (1312, 204, 0, 0),
    (1313, 201, 0, 0), (1314, 204, 0, 0), (1315, 198, 0, 0), (1316, 199, 0, 0), (1317, 201, 0, 0), (1318, 204, 0, 0), (1319, 198, 0, 0), (1320, 199, 0, 0), (1321, 201, 0, 0),
    (1322, 204, 0, 0), (1323, 198, 0, 0), (1324, 199, 0, 0), (1325, 201, 0, 0), (1326, 204, 0, 0), (1327, 198, 0, 0), (1328, 201, 0, 0), (1329, 204, 0, 0), (1330, 198, 0, 0),
    (1331, 201, 0, 0), (1332, 204, 0, 0), (1333, 201, 0, 0), (1334, 204, 0, 0), (1335, 201, 0, 0), (1336, 204, 0, 0), (1337, 198, 0, 0), (1338, 199, 0, 0), (1339, 201, 0, 0),
    (1340, 204, 0, 0), (1341, 198, 0, 0), (1342, 201, 0, 0), (1343, 204, 0, 0), (1344, 204, 0, 0), (1345, 198, 0, 0), (1346, 199, 0, 0), (1347, 201, 0, 0), (1348, 204, 0, 0),
    (1349, 198, 0, 0), (1350, 201, 0, 0), (1351, 198, 0, 0), (1352, 199, 0, 0), (1353, 201, 0, 0), (1354, 204, 0, 0), (1355, 201, 0, 0), (1356, 204, 0, 0), (1357, 198, 0, 0),
    (1358, 201, 0, 0), (1359, 204, 0, 0), (1360, 201, 0, 0), (1361, 204, 0, 0), (1362, 198, 0, 0), (1363, 201, 0, 0), (1364, 204, 0, 0), (1365, 198, 0, 0), (1366, 199, 0, 0),
    (1367, 200, 0, 0), (1368, 201, 0, 0), (1369, 204, 0, 0), (1370, 198, 0, 0), (1371, 204, 0, 0), (1372, 198, 0, 0), (1373, 201, 0, 0), (1374, 204, 0, 0), (1375, 201, 0, 0),
    (1376, 204, 0, 0), (1377, 201, 0, 0), (1378, 204, 0, 0), (1379, 198, 0, 0), (1380, 201, 0, 0), (1381, 204, 0, 0), (1382, 201, 0, 0), (1383, 204, 0, 0), (1384, 199, 0, 0),
    (1385, 198, 0, 0), (1386, 199, 0, 0), (1387, 201, 0, 0), (1388, 204, 0, 0), (1389, 204, 0, 0), (1390, 201, 0, 0), (1391, 204, 0, 0), (1392, 198, 0, 0), (1393, 201, 0, 0),
    (1394, 204, 0, 0), (1395, 204, 0, 0), (1396, 204, 0, 0), (1397, 201, 0, 0), (1398, 204, 0, 0), (1399, 198, 0, 0), (1400, 204, 0, 0), (1401, 201, 0, 0), (1402, 204, 0, 0),
    (1403, 204, 0, 0), (1404, 198, 0, 0), (1405, 199, 0, 0), (1406, 204, 0, 0), (1407, 201, 0, 0), (1408, 204, 0, 0), (1409, 204, 0, 0), (1410, 198, 0, 0), (1411, 199, 0, 0),
    (1412, 204, 0, 0), (1413, 198, 0, 0), (1414, 202, 0, 0), (1415, 201, 0, 0), (1416, 204, 0, 0), (1417, 198, 0, 0), (1418, 198, 0, 0), (1419, 199, 0, 0), (1420, 201, 0, 0),
    (1421, 198, 0, 0), (1422, 201, 0, 0), (1423, 204, 0, 0), (1424, 198, 0, 0), (1425, 204, 0, 0), (1426, 199, 0, 0), (1427, 199, 0, 0), (1428, 201, 0, 0), (1429, 204, 0, 0),
    (1430, 199, 0, 0), (1431, 201, 0, 0), (1432, 198, 0, 0), (1433, 204, 0, 0), (1434, 204, 0, 0), (1435, 204, 0, 0), (1436, 199, 0, 0), (1437, 201, 0, 0), (1438, 204, 0, 0),
    (1439, 201, 0, 0), (1440, 204, 0, 0), (1441, 198, 0, 0), (1442, 198, 0, 0), (1443, 204, 0, 0), (1444, 201, 0, 0), (1445, 198, 0, 0), (1446, 198, 0, 0), (1447, 204, 0, 0),
    (1448, 204, 0, 0), (1449, 204, 0, 0), (1450, 198, 0, 0), (1451, 204, 0, 0), (1452, 204, 0, 0), (1453, 198, 0, 0), (1454, 197, 0, 0), (1455, 204, 0, 0), (1456, 200, 0, 0),
    (1457, 204, 0, 0), (1458, 204, 0, 0), (1459, 198, 0, 0), (1460, 201, 0, 0), (1461, 204, 0, 0), (1462, 200, 0, 0), (1463, 204, 0, 0), (1464, 204, 0, 0), (1465, 201, 0, 0),
    (1466, 204, 0, 0), (1467, 201, 0, 0), (1468, 204, 0, 0), (1469, 199, 0, 0), (1470, 201, 0, 0), (1471, 204, 0, 0), (1472, 204, 0, 0), (1473, 204, 0, 0), (1474, 204, 0, 0),
    (1475, 198, 0, 0), (1476, 199, 0, 0), (1477, 201, 0, 0), (1478, 198, 0, 0), (1479, 201, 0, 0), (1480, 198, 0, 0), (1481, 194, 0, 0), (1482, 197, 0, 0), (1483, 198, 0, 0),
    (1484, 199, 0, 0), (1485, 201, 0, 0), (1486, 202, 0, 0), (1487, 204, 0, 0), (1488, 199, 0, 0), (1489, 201, 0, 0), (1490, 204, 0, 0), (1491, 204, 0, 0), (1492, 201, 0, 0),
    (1493, 204, 0, 0), (1494, 201, 0, 0), (1495, 204, 0, 0), (1496, 201, 0, 0), (1497, 204, 0, 0), (1498, 204, 0, 0), (1499, 198, 0, 0), (1500, 201, 0, 0), (1501, 204, 0, 0),
    (1502, 198, 0, 0), (1503, 201, 0, 0), (1504, 204, 0, 0), (1505, 204, 0, 0), (1506, 201, 0, 0), (1507, 204, 0, 0), (1508, 204, 0, 0), (1509, 198, 0, 0), (1510, 201, 0, 0),
    (1511, 204, 0, 0), (1512, 204, 0, 0), (1513, 204, 0, 0), (1514, 199, 0, 0), (1515, 200, 0, 0), (1516, 204, 0, 0), (1517, 201, 0, 0), (1518, 204, 0, 0), (1519, 198, 0, 0),
    (1520, 199, 0, 0), (1521, 201, 0, 0), (1522, 202, 0, 0), (1523, 204, 0, 0), (1524, 198, 0, 0), (1525, 201, 0, 0), (1526, 204, 0, 0), (1527, 201, 0, 0), (1528, 202, 0, 0),
    (1529, 204, 0, 0), (1530, 201, 0, 0), (1531, 204, 0, 0), (1532, 197, 0, 0), (1533, 198, 0, 0), (1534, 201, 0, 0), (1535, 204, 0, 0), (1536, 201, 0, 0), (1537, 202, 0, 0),
    (1538, 204, 0, 0), (1539, 198, 0, 0), (1540, 201, 0, 0), (1541, 198, 0, 0), (1542, 201, 0, 0), (1543, 204, 0, 0), (1544, 198, 0, 0), (1545, 201, 0, 0), (1546, 201, 0, 0),
    (1547, 204, 0, 0), (1548, 201, 0, 0), (1549, 204, 0, 0), (1550, 198, 0, 0), (1551, 199, 0, 0), (1552, 201, 0, 0), (1553, 204, 0, 0), (1554, 204, 0, 0), (1555, 199, 0, 0),
    (1556, 201, 0, 0), (1557, 204, 0, 0), (1558, 198, 0, 0), (1559, 201, 0, 0), (1560, 202, 0, 0), (1561, 204, 0, 0), (1562, 198, 0, 0), (1563, 201, 0, 0), (1564, 204, 0, 0),
    (1565, 201, 0, 0), (1566, 204, 0, 0), (1567, 204, 0, 0), (1568, 204, 0, 0), (1569, 201, 0, 0), (1570, 204, 0, 0), (1571, 204, 0, 0), (1572, 204, 0, 0), (1573, 201, 0, 0),
    (1574, 204, 0, 0), (1575, 198, 0, 0), (1576, 201, 0, 0), (1577, 204, 0, 0), (1578, 201, 0, 0), (1579, 198, 0, 0), (1580, 201, 0, 0), (1581, 204, 0, 0), (1582, 197, 0, 0),
    (1583, 204, 0, 0), (1584, 204, 0, 0), (1585, 204, 0, 0), (1586, 204, 0, 0), (1587, 199, 0, 0), (1588, 201, 0, 0), (1589, 200, 0, 0), (1590, 204, 0, 0), (1591, 204, 0, 0),
    (1592, 204, 0, 0), (1593, 204, 0, 0), (1594, 198, 0, 0), (1595, 204, 0, 0), (1596, 193, 0, 0), (1597, 197, 0, 0), (1598, 201, 0, 0), (1599, 204, 0, 0), (1600, 204, 0, 0),
    (1601, 201, 0, 0), (1602, 204, 0, 0), (1603, 204, 0, 0), (1604, 201, 0, 0), (1605, 204, 0, 0), (1606, 204, 0, 0), (1607, 204, 0, 0), (1608, 207, 0, 0), (1609, 208, 0, 0),
    (1610, 196, 0, 0), (1611, 197, 0, 0), (1612, 198, 0, 0), (1613, 200, 0, 0), (1614, 204, 0, 0), (1615, 207, 0, 0), (1616, 204, 0, 0), (1617, 198, 0, 0), (1618, 200, 0, 0),
    (1619, 206, 0, 0), (1620, 204, 0, 0), (1621, 198, 0, 0), (1622, 199, 0, 0), (1623, 204, 0, 0), (1624, 173, 0, 0), (1625, 174, 0, 0), (1626, 175, 0, 0), (1627, 182, 0, 0),
    (1628, 183, 0, 0), (1629, 184, 0, 0), (1630, 185, 0, 0), (1631, 189, 0, 0), (1632, 191, 0, 0), (1633, 184, 0, 0), (1634, 191, 0, 0), (1635, 182, 0, 0), (1636, 183, 0, 0),
    (1637, 184, 0, 0), (1638, 191, 0, 0), (1639, 191, 0, 0), (1640, 191, 0, 0), (1641, 191, 0, 0), (1642, 175, 0, 0), (1643, 182, 0, 0), (1644, 183, 0, 0), (1645, 184, 0, 0),
    (1646, 191, 0, 0), (1647, 176, 0, 0), (1648, 184, 0, 0), (1649, 191, 0, 0), (1650, 178, 0, 0), (1651, 191, 0, 0), (1652, 191, 0, 0), (1653, 191, 0, 0), (1654, 191, 0, 0),
    (1655, 176, 0, 0), (1656, 183, 0, 0), (1657, 184, 0, 0), (1658, 191, 0, 0), (1659, 191, 0, 0), (1660, 191, 0, 0), (1661, 191, 0, 0), (1662, 191, 0, 0), (1663, 183, 0, 0),
    (1664, 191, 0, 0), (1665, 182, 0, 0), (1666, 183, 0, 0), (1667, 191, 0, 0), (1668, 191, 0, 0), (1669, 191, 0, 0), (1670, 191, 0, 0), (1671, 191, 0, 0), (1672, 191, 0, 0),
    (1673, 191, 0, 0), (1674, 191, 0, 0), (1675, 191, 0, 0), (1676, 191, 0, 0), (1677, 175, 0, 0), (1678, 191, 0, 0), (1679, 191, 0, 0), (1680, 191, 0, 0), (1681, 184, 0, 0),
    (1682, 191, 0, 0), (1683, 191, 0, 0), (1684, 191, 0, 0), (1685, 191, 0, 0), (1686, 191, 0, 0), (1687, 191, 0, 0), (1688, 191, 0, 0), (1689, 184, 0, 0), (1690, 191, 0, 0),
    (1691, 179, 0, 0), (1692, 182, 0, 0), (1693, 184, 0, 0), (1694, 189, 0, 0), (1695, 191, 0, 0), (1696, 182, 0, 0), (1697, 191, 0, 0), (1698, 191, 0, 0), (1699, 184, 0, 0),
    (1700, 191, 0, 0), (1701, 184, 0, 0), (1702, 191, 0, 0), (1703, 175, 0, 0), (1704, 191, 0, 0), (1705, 191, 0, 0), (1706, 191, 0, 0), (1707, 182, 0, 0), (1708, 191, 0, 0),
    (1709, 178, 0, 0), (1710, 184, 0, 0), (1711, 191, 0, 0), (1712, 176, 0, 0), (1713, 177, 0, 0), (1714, 191, 0, 0), (1715, 191, 0, 0), (1716, 176, 0, 0), (1717, 178, 0, 0),
    (1718, 183, 0, 0), (1719, 191, 0, 0), (1720, 191, 0, 0), (1721, 191, 0, 0), (1722, 191, 0, 0), (1723, 191, 0, 0), (1724, 191, 0, 0), (1725, 178, 0, 0), (1726, 182, 0, 0),
    (1727, 191, 0, 0), (1728, 191, 0, 0), (1729, 180, 0, 0), (1730, 189, 0, 0), (1731, 191, 0, 0), (1732, 191, 0, 0), (1733, 191, 0, 0), (1734, 191, 0, 0), (1735, 191, 0, 0),
    (1736, 191, 0, 0), (1737, 191, 0, 0), (1738, 191, 0, 0), (1739, 191, 0, 0), (1740, 191, 0, 0), (1741, 191, 0, 0), (1742, 182, 0, 0), (1743, 189, 0, 0), (1744, 191, 0, 0),
    (1745, 184, 0, 0), (1746, 191, 0, 0), (1747, 191, 0, 0), (1748, 184, 0, 0), (1749, 191, 0, 0), (1750, 175, 0, 0), (1751, 191, 0, 0), (1752, 191, 0, 0), (1753, 191, 0, 0),
    (1754, 183, 0, 0), (1755, 189, 0, 0), (1756, 191, 0, 0), (1757, 191, 0, 0), (1758, 182, 0, 0), (1759, 183, 0, 0), (1760, 191, 0, 0), (1761, 191, 0, 0), (1762, 191, 0, 0),
    (1763, 191, 0, 0), (1764, 189, 0, 0), (1765, 191, 0, 0), (1766, 191, 0, 0), (1767, 191, 0, 0), (1768, 182, 0, 0), (1769, 189, 0, 0), (1770, 180, 0, 0), (1771, 189, 0, 0),
    (1772, 189, 0, 0), (1773, 191, 0, 0), (1774, 182, 0, 0), (1775, 191, 0, 0), (1776, 191, 0, 0), (1777, 191, 0, 0), (1778, 191, 0, 0), (1779, 191, 0, 0), (1780, 191, 0, 0),
    (1781, 191, 0, 0), (1782, 191, 0, 0), (1783, 189, 0, 0), (1784, 191, 0, 0), (1785, 191, 0, 0), (1786, 191, 0, 0), (1787, 191, 0, 0), (1788, 191, 0, 0), (1789, 191, 0, 0),
    (1790, 189, 0, 0), (1791, 182, 0, 0), (1792, 189, 0, 0), (1793, 191, 0, 0), (1794, 191, 0, 0), (1795, 184, 0, 0), (1796, 191, 0, 0), (1797, 191, 0, 0), (1798, 191, 0, 0),
    (1799, 191, 0, 0), (1800, 189, 0, 0), (1801, 180, 0, 0), (1802, 182, 0, 0), (1803, 184, 0, 0), (1804, 189, 0, 0), (1805, 191, 0, 0), (1806, 182, 0, 0), (1807, 182, 0, 0),
    (1808, 182, 0, 0), (1809, 182, 0, 0), (1810, 184, 0, 0), (1811, 191, 0, 0), (1812, 184, 0, 0), (1813, 191, 0, 0), (1814, 182, 0, 0), (1815, 191, 0, 0), (1816, 189, 0, 0),
    (1817, 179, 0, 0), (1818, 189, 0, 0), (1819, 191, 0, 0), (1820, 191, 0, 0), (1821, 184, 0, 0), (1822, 191, 0, 0), (1823, 191, 0, 0), (1824, 184, 0, 0), (1825, 191, 0, 0),
    (1826, 184, 0, 0), (1827, 191, 0, 0), (1828, 174, 0, 0), (1829, 182, 0, 0), (1830, 189, 0, 0), (1831, 191, 0, 0), (1832, 191, 0, 0), (1833, 191, 0, 0), (1834, 191, 0, 0),
    (1835, 178, 0, 0), (1836, 191, 0, 0), (1837, 191, 0, 0), (1838, 191, 0, 0), (1839, 191, 0, 0), (1840, 176, 0, 0), (1841, 191, 0, 0), (1842, 191, 0, 0), (1843, 191, 0, 0),
    (1844, 191, 0, 0), (1845, 182, 0, 0), (1846, 183, 0, 0), (1847, 191, 0, 0), (1848, 182, 0, 0), (1849, 191, 0, 0), (1850, 183, 0, 0), (1851, 191, 0, 0), (1852, 191, 0, 0),
    (1853, 191, 0, 0), (1854, 191, 0, 0), (1855, 176, 0, 0), (1856, 182, 0, 0), (1857, 183, 0, 0), (1858, 184, 0, 0), (1859, 191, 0, 0), (1860, 182, 0, 0), (1861, 191, 0, 0),
    (1862, 182, 0, 0), (1863, 184, 0, 0), (1864, 191, 0, 0), (1865, 182, 0, 0), (1866, 184, 0, 0), (1867, 191, 0, 0), (1868, 184, 0, 0), (1869, 191, 0, 0), (1870, 184, 0, 0),
    (1871, 191, 0, 0), (1872, 182, 0, 0), (1873, 184, 0, 0), (1874, 191, 0, 0), (1875, 173, 0, 0), (1876, 180, 0, 0), (1877, 181, 0, 0), (1878, 182, 0, 0), (1879, 189, 0, 0),
    (1880, 191, 0, 0), (1881, 176, 0, 0), (1882, 181, 0, 0), (1883, 184, 0, 0), (1884, 185, 0, 0), (1885, 189, 0, 0), (1886, 190, 0, 0), (1887, 191, 0, 0), (1888, 183, 0, 0),
    (1889, 184, 0, 0), (1890, 189, 0, 0), (1891, 191, 0, 0), (1892, 183, 0, 0), (1893, 184, 0, 0), (1894, 191, 0, 0), (1895, 193, 0, 0), (1896, 193, 0, 0), (1897, 207, 0, 0),
    (1898, 208, 0, 0), (1899, 197, 0, 0), (1900, 198, 0, 0), (1901, 199, 0, 0), (1902, 200, 0, 0), (1903, 202, 0, 0), (1904, 204, 0, 0), (1905, 207, 0, 0), (1906, 198, 0, 0),
    (1907, 199, 0, 0), (1908, 202, 0, 0), (1909, 204, 0, 0), (1910, 202, 0, 0), (1911, 204, 0, 0), (1912, 198, 0, 0), (1913, 199, 0, 0), (1914, 204, 0, 0), (1915, 198, 0, 0),
    (1916, 199, 0, 0), (1917, 204, 0, 0), (1918, 198, 0, 0), (1919, 199, 0, 0), (1920, 204, 0, 0), (1921, 198, 0, 0), (1922, 199, 0, 0), (1923, 204, 0, 0), (1924, 198, 0, 0),
    (1925, 199, 0, 0), (1926, 204, 0, 0), (1927, 198, 0, 0), (1928, 199, 0, 0), (1929, 204, 0, 0), (1930, 199, 0, 0), (1931, 202, 0, 0), (1932, 204, 0, 0), (1933, 198, 0, 0),
    (1934, 199, 0, 0), (1935, 204, 0, 0), (1936, 199, 0, 0), (1937, 204, 0, 0), (1938, 198, 0, 0), (1939, 204, 0, 0), (1940, 198, 0, 0), (1941, 199, 0, 0), (1942, 204, 0, 0),
    (1943, 198, 0, 0), (1944, 199, 0, 0), (1945, 202, 0, 0), (1946, 204, 0, 0), (1947, 207, 0, 0), (1948, 204, 0, 0), (1949, 204, 0, 0), (1950, 193, 0, 0), (1951, 193, 0, 0),
    (1952, 197, 0, 0), (1953, 198, 0, 0), (1954, 203, 0, 0), (1955, 198, 0, 0), (1956, 204, 0, 0), (1957, 198, 0, 0), (1958, 199, 0, 0), (1959, 202, 0, 0), (1960, 204, 0, 0),
    (1961, 199, 0, 0), (1962, 204, 0, 0), (1963, 198, 0, 0), (1964, 199, 0, 0), (1965, 208, 0, 0), (1966, 198, 0, 0), (1967, 199, 0, 0), (1968, 204, 0, 0), (1969, 204, 0, 0),
    (1970, 198, 0, 0), (1971, 199, 0, 0), (1972, 204, 0, 0), (1973, 198, 0, 0), (1974, 199, 0, 0), (1975, 204, 0, 0), (1976, 198, 0, 0), (1977, 198, 0, 0), (1978, 204, 0, 0),
    (1979, 204, 0, 0), (1980, 196, 0, 0), (1981, 200, 0, 0), (1982, 202, 0, 0), (1983, 204, 0, 0), (1984, 204, 0, 0), (1985, 207, 0, 0), (1986, 208, 0, 0), (1987, 198, 0, 0),
    (1988, 199, 0, 0), (1989, 202, 0, 0), (1990, 203, 0, 0), (1991, 204, 0, 0), (1992, 204, 0, 0), (1993, 208, 0, 0), (1994, 199, 0, 0), (1995, 202, 0, 0), (1996, 206, 0, 0),
    (1997, 204, 0, 0), (1998, 198, 0, 0), (1999, 199, 0, 0), (2000, 204, 0, 0), (2001, 196, 0, 0), (2002, 199, 0, 0), (2003, 200, 0, 0), (2004, 204, 0, 0), (2005, 198, 0, 0),
    (2006, 199, 0, 0), (2007, 204, 0, 0), (2008, 198, 0, 0), (2009, 199, 0, 0), (2010, 200, 0, 0), (2011, 204, 0, 0), (2012, 204, 0, 0), (2013, 198, 0, 0), (2014, 204, 0, 0),
    (2015, 207, 0, 0), (2016, 204, 0, 0), (2017, 198, 0, 0), (2018, 204, 0, 0), (2019, 196, 0, 0), (2020, 204, 0, 0), (2021, 197, 0, 0), (2022, 198, 0, 0), (2023, 199, 0, 0),
    (2024, 198, 0, 0), (2025, 198, 0, 0), (2026, 204, 0, 0), (2027, 198, 0, 0), (2028, 202, 0, 0), (2029, 198, 0, 0), (2030, 198, 0, 0), (2031, 204, 0, 0), (2032, 200, 0, 0),
    (2033, 204, 0, 0), (2034, 198, 0, 0), (2035, 204, 0, 0), (2036, 198, 0, 0), (2037, 204, 0, 0), (2038, 204, 0, 0), (2039, 204, 0, 0), (2040, 204, 0, 0), (2041, 198, 0, 0),
    (2042, 199, 0, 0), (2043, 202, 0, 0), (2044, 204, 0, 0), (2045, 198, 0, 0), (2046, 198, 0, 0), (2047, 204, 0, 0), (2048, 200, 0, 0), (2049, 204, 0, 0), (2050, 199, 0, 0),
    (2051, 204, 0, 0), (2052, 197, 0, 0), (2053, 204, 0, 0), (2054, 192, 0, 0), (2055, 194, 0, 0), (2056, 196, 0, 0), (2057, 197, 0, 0), (2058, 198, 0, 0), (2059, 199, 0, 0),
    (2060, 200, 0, 0), (2061, 202, 0, 0), (2062, 203, 0, 0), (2063, 206, 0, 0), (2064, 204, 0, 0), (2065, 192, 0, 0), (2066, 197, 0, 0), (2067, 198, 0, 0), (2068, 202, 0, 0),
    (2069, 206, 0, 0), (2070, 204, 0, 0), (2071, 202, 0, 0), (2072, 203, 0, 0), (2073, 206, 0, 0), (2074, 204, 0, 0), (2075, 202, 0, 0), (2076, 204, 0, 0), (2077, 204, 0, 0),
    (2078, 197, 0, 0), (2079, 198, 0, 0), (2080, 200, 0, 0), (2081, 196, 0, 0), (2082, 197, 0, 0), (2083, 202, 0, 0), (2084, 204, 0, 0), (2085, 204, 0, 0), (2086, 202, 0, 0),
    (2087, 204, 0, 0), (2088, 202, 0, 0), (2089, 204, 0, 0), (2090, 202, 0, 0), (2091, 198, 0, 0), (2092, 202, 0, 0), (2093, 202, 0, 0), (2094, 204, 0, 0), (2095, 202, 0, 0),
    (2096, 204, 0, 0), (2097, 202, 0, 0), (2098, 196, 0, 0), (2099, 204, 0, 0), (2100, 197, 0, 0), (2101, 198, 0, 0), (2102, 200, 0, 0), (2103, 201, 0, 0), (2104, 198, 0, 0),
    (2105, 197, 0, 0), (2106, 203, 0, 0), (2107, 202, 0, 0), (2108, 202, 0, 0), (2109, 201, 0, 0), (2110, 198, 0, 0), (2111, 197, 0, 0), (2112, 198, 0, 0), (2113, 199, 0, 0),
    (2114, 201, 0, 0), (2115, 204, 0, 0), (2116, 199, 0, 0), (2117, 201, 0, 0), (2118, 204, 0, 0), (2119, 198, 0, 0), (2120, 199, 0, 0), (2121, 204, 0, 0), (2122, 198, 0, 0),
    (2123, 199, 0, 0), (2124, 204, 0, 0), (2125, 198, 0, 0), (2126, 199, 0, 0), (2127, 198, 0, 0), (2128, 201, 0, 0), (2129, 202, 0, 0), (2130, 204, 0, 0), (2131, 198, 0, 0),
    (2132, 204, 0, 0), (2133, 204, 0, 0), (2134, 201, 0, 0), (2135, 199, 0, 0), (2136, 204, 0, 0), (2137, 198, 0, 0), (2138, 199, 0, 0), (2139, 204, 0, 0), (2140, 199, 0, 0),
    (2141, 204, 0, 0), (2142, 199, 0, 0), (2143, 202, 0, 0), (2144, 204, 0, 0), (2145, 204, 0, 0), (2146, 199, 0, 0), (2147, 200, 0, 0), (2148, 198, 0, 0), (2149, 199, 0, 0),
    (2150, 200, 0, 0), (2151, 199, 0, 0), (2152, 204, 0, 0), (2153, 193, 0, 0), (2154, 197, 0, 0), (2155, 204, 0, 0), (2156, 199, 0, 0), (2157, 201, 0, 0), (2158, 204, 0, 0),
    (2159, 198, 0, 0), (2160, 199, 0, 0), (2161, 200, 0, 0), (2162, 198, 0, 0), (2163, 201, 0, 0), (2164, 198, 0, 0), (2165, 199, 0, 0), (2166, 201, 0, 0), (2167, 199, 0, 0),
    (2168, 201, 0, 0), (2169, 198, 0, 0), (2170, 204, 0, 0), (2171, 198, 0, 0), (2172, 199, 0, 0), (2173, 201, 0, 0), (2174, 198, 0, 0), (2175, 199, 0, 0), (2176, 204, 0, 0),
    (2177, 201, 0, 0), (2178, 199, 0, 0), (2179, 201, 0, 0), (2180, 200, 0, 0), (2181, 204, 0, 0), (2182, 198, 0, 0), (2183, 199, 0, 0), (2184, 198, 0, 0), (2185, 200, 0, 0),
    (2186, 204, 0, 0), (2187, 198, 0, 0), (2188, 199, 0, 0), (2189, 198, 0, 0), (2190, 201, 0, 0), (2191, 198, 0, 0), (2192, 198, 0, 0), (2193, 204, 0, 0), (2194, 199, 0, 0),
    (2195, 204, 0, 0), (2196, 198, 0, 0), (2197, 197, 0, 0), (2198, 198, 0, 0), (2199, 201, 0, 0), (2200, 202, 0, 0), (2201, 204, 0, 0), (2202, 199, 0, 0), (2203, 201, 0, 0),
    (2204, 198, 0, 0), (2205, 201, 0, 0), (2206, 204, 0, 0), (2207, 198, 0, 0), (2208, 201, 0, 0), (2209, 198, 0, 0), (2210, 199, 0, 0), (2211, 200, 0, 0), (2212, 204, 0, 0),
    (2213, 198, 0, 0), (2214, 198, 0, 0), (2215, 199, 0, 0), (2216, 200, 0, 0), (2217, 198, 0, 0), (2218, 199, 0, 0), (2219, 200, 0, 0), (2220, 201, 0, 0), (2221, 204, 0, 0),
    (2222, 198, 0, 0), (2223, 201, 0, 0), (2224, 199, 0, 0), (2225, 201, 0, 0), (2226, 204, 0, 0), (2227, 198, 0, 0), (2228, 199, 0, 0), (2229, 200, 0, 0), (2230, 199, 0, 0),
    (2231, 204, 0, 0), (2232, 198, 0, 0), (2233, 199, 0, 0), (2234, 204, 0, 0), (2235, 198, 0, 0), (2236, 199, 0, 0), (2237, 200, 0, 0), (2238, 204, 0, 0), (2239, 198, 0, 0),
    (2240, 199, 0, 0), (2241, 194, 0, 0), (2242, 198, 0, 0), (2243, 199, 0, 0), (2244, 201, 0, 0), (2245, 204, 0, 0), (2246, 201, 0, 0), (2247, 201, 0, 0), (2248, 204, 0, 0),
    (2249, 201, 0, 0), (2250, 198, 0, 0), (2251, 199, 0, 0), (2252, 200, 0, 0), (2253, 201, 0, 0), (2254, 199, 0, 0), (2255, 198, 0, 0), (2256, 201, 0, 0), (2257, 204, 0, 0),
    (2258, 199, 0, 0), (2259, 198, 0, 0), (2260, 204, 0, 0), (2261, 199, 0, 0), (2262, 204, 0, 0), (2263, 198, 0, 0), (2264, 201, 0, 0), (2265, 204, 0, 0), (2266, 198, 0, 0),
    (2267, 199, 0, 0), (2268, 198, 0, 0), (2269, 199, 0, 0), (2270, 201, 0, 0), (2271, 198, 0, 0), (2272, 199, 0, 0), (2273, 200, 0, 0), (2274, 198, 0, 0), (2275, 199, 0, 0),
    (2276, 200, 0, 0), (2277, 204, 0, 0), (2278, 198, 0, 0), (2279, 199, 0, 0), (2280, 201, 0, 0), (2281, 204, 0, 0), (2282, 199, 0, 0), (2283, 200, 0, 0), (2284, 204, 0, 0),
    (2285, 198, 0, 0), (2286, 201, 0, 0), (2287, 204, 0, 0), (2288, 199, 0, 0), (2289, 204, 0, 0), (2290, 199, 0, 0), (2291, 204, 0, 0), (2292, 200, 0, 0), (2293, 204, 0, 0),
    (2294, 198, 0, 0), (2295, 199, 0, 0), (2296, 198, 0, 0), (2297, 201, 0, 0), (2298, 198, 0, 0), (2299, 204, 0, 0), (2300, 204, 0, 0), (2301, 199, 0, 0), (2302, 204, 0, 0),
    (2303, 199, 0, 0), (2304, 204, 0, 0), (2305, 204, 0, 0), (2306, 198, 0, 0), (2307, 199, 0, 0), (2308, 199, 0, 0), (2309, 204, 0, 0), (2310, 204, 0, 0), (2311, 197, 0, 0),
    (2312, 199, 0, 0), (2313, 201, 0, 0), (2314, 199, 0, 0), (2315, 201, 0, 0), (2316, 198, 0, 0), (2317, 200, 0, 0), (2318, 201, 0, 0), (2319, 198, 0, 0), (2320, 199, 0, 0),
    (2321, 201, 0, 0), (2322, 198, 0, 0), (2323, 199, 0, 0), (2324, 201, 0, 0), (2325, 198, 0, 0), (2326, 200, 0, 0), (2327, 201, 0, 0), (2328, 204, 0, 0), (2329, 201, 0, 0),
    (2330, 201, 0, 0), (2331, 201, 0, 0), (2332, 204, 0, 0), (2333, 201, 0, 0), (2334, 199, 0, 0), (2335, 198, 0, 0), (2336, 199, 0, 0), (2337, 201, 0, 0), (2338, 201, 0, 0),
    (2339, 198, 0, 0), (2340, 200, 0, 0), (2341, 201, 0, 0), (2342, 198, 0, 0), (2343, 201, 0, 0), (2344, 198, 0, 0), (2345, 201, 0, 0), (2346, 201, 0, 0), (2347, 201, 0, 0),
    (2348, 199, 0, 0), (2349, 200, 0, 0), (2350, 201, 0, 0), (2351, 201, 0, 0), (2352, 201, 0, 0), (2353, 197, 0, 0), (2354, 198, 0, 0), (2355, 199, 0, 0), (2356, 198, 0, 0),
    (2357, 201, 0, 0), (2358, 198, 0, 0), (2359, 199, 0, 0), (2360, 201, 0, 0), (2361, 204, 0, 0), (2362, 198, 0, 0), (2363, 199, 0, 0), (2364, 201, 0, 0), (2365, 204, 0, 0),
    (2366, 198, 0, 0), (2367, 201, 0, 0), (2368, 198, 0, 0), (2369, 200, 0, 0), (2370, 198, 0, 0), (2371, 199, 0, 0), (2372, 204, 0, 0), (2373, 198, 0, 0), (2374, 198, 0, 0),
    (2375, 199, 0, 0), (2376, 200, 0, 0), (2377, 198, 0, 0), (2378, 201, 0, 0), (2379, 204, 0, 0), (2380, 204, 0, 0), (2381, 198, 0, 0), (2382, 201, 0, 0), (2383, 198, 0, 0),
    (2384, 199, 0, 0), (2385, 198, 0, 0), (2386, 200, 0, 0), (2387, 198, 0, 0), (2388, 204, 0, 0), (2389, 198, 0, 0), (2390, 198, 0, 0), (2391, 200, 0, 0), (2392, 198, 0, 0),
    (2393, 199, 0, 0), (2394, 204, 0, 0), (2395, 198, 0, 0), (2396, 199, 0, 0), (2397, 204, 0, 0), (2398, 198, 0, 0), (2399, 199, 0, 0), (2400, 201, 0, 0), (2401, 198, 0, 0),
    (2402, 198, 0, 0), (2403, 201, 0, 0), (2404, 204, 0, 0), (2405, 198, 0, 0), (2406, 199, 0, 0), (2407, 199, 0, 0), (2408, 197, 0, 0), (2409, 198, 0, 0), (2410, 198, 0, 0),
    (2411, 199, 0, 0), (2412, 204, 0, 0), (2413, 199, 0, 0), (2414, 204, 0, 0), (2415, 204, 0, 0), (2416, 198, 0, 0), (2417, 201, 0, 0), (2418, 204, 0, 0), (2419, 198, 0, 0),
    (2420, 204, 0, 0), (2421, 199, 0, 0), (2422, 204, 0, 0), (2423, 204, 0, 0), (2424, 198, 0, 0), (2425, 201, 0, 0), (2426, 198, 0, 0), (2427, 198, 0, 0), (2428, 198, 0, 0),
    (2429, 199, 0, 0), (2430, 198, 0, 0), (2431, 199, 0, 0), (2432, 201, 0, 0), (2433, 198, 0, 0), (2434, 199, 0, 0), (2435, 204, 0, 0), (2436, 204, 0, 0), (2437, 198, 0, 0),
    (2438, 201, 0, 0), (2439, 199, 0, 0), (2440, 204, 0, 0), (2441, 198, 0, 0), (2442, 199, 0, 0), (2443, 198, 0, 0), (2444, 198, 0, 0), (2445, 198, 0, 0), (2446, 199, 0, 0),
    (2447, 204, 0, 0), (2448, 198, 0, 0), (2449, 199, 0, 0), (2450, 204, 0, 0), (2451, 198, 0, 0), (2452, 204, 0, 0), (2453, 198, 0, 0), (2454, 198, 0, 0), (2455, 204, 0, 0),
    (2456, 204, 0, 0), (2457, 198, 0, 0), (2458, 204, 0, 0), (2459, 204, 0, 0), (2460, 199, 0, 0), (2461, 199, 0, 0), (2462, 204, 0, 0), (2463, 198, 0, 0), (2464, 198, 0, 0),
    (2465, 204, 0, 0), (2466, 199, 0, 0), (2467, 200, 0, 0), (2468, 198, 0, 0), (2469, 198, 0, 0), (2470, 198, 0, 0), (2471, 199, 0, 0), (2472, 204, 0, 0), (2473, 199, 0, 0),
    (2474, 204, 0, 0), (2475, 204, 0, 0), (2476, 198, 0, 0), (2477, 198, 0, 0), (2478, 204, 0, 0), (2479, 204, 0, 0), (2480, 198, 0, 0), (2481, 193, 0, 0), (2482, 197, 0, 0),
    (2483, 198, 0, 0), (2484, 200, 0, 0), (2485, 204, 0, 0), (2486, 204, 0, 0), (2487, 204, 0, 0), (2488, 198, 0, 0), (2489, 200, 0, 0), (2490, 204, 0, 0), (2491, 198, 0, 0),
    (2492, 201, 0, 0), (2493, 204, 0, 0), (2494, 204, 0, 0), (2495, 198, 0, 0), (2496, 204, 0, 0), (2497, 204, 0, 0), (2498, 204, 0, 0), (2499, 198, 0, 0), (2500, 204, 0, 0),
    (2501, 204, 0, 0), (2502, 204, 0, 0), (2503, 204, 0, 0), (2504, 198, 0, 0), (2505, 204, 0, 0), (2506, 197, 0, 0), (2507, 198, 0, 0), (2508, 201, 0, 0), (2509, 201, 0, 0),
    (2510, 199, 0, 0), (2511, 201, 0, 0), (2512, 204, 0, 0), (2513, 201, 0, 0), (2514, 204, 0, 0), (2515, 204, 0, 0), (2516, 204, 0, 0), (2517, 201, 0, 0), (2518, 204, 0, 0),
    (2519, 204, 0, 0), (2520, 201, 0, 0), (2521, 204, 0, 0), (2522, 201, 0, 0), (2523, 198, 0, 0), (2524, 201, 0, 0), (2525, 204, 0, 0), (2526, 198, 0, 0), (2527, 201, 0, 0),
    (2528, 204, 0, 0), (2529, 201, 0, 0), (2530, 201, 0, 0), (2531, 204, 0, 0), (2532, 198, 0, 0), (2533, 204, 0, 0), (2534, 198, 0, 0), (2535, 201, 0, 0), (2536, 204, 0, 0),
    (2537, 201, 0, 0), (2538, 204, 0, 0), (2539, 201, 0, 0), (2540, 198, 0, 0), (2541, 201, 0, 0), (2542, 204, 0, 0), (2543, 201, 0, 0), (2544, 204, 0, 0), (2545, 201, 0, 0),
    (2546, 204, 0, 0), (2547, 199, 0, 0), (2548, 201, 0, 0), (2549, 204, 0, 0), (2550, 199, 0, 0), (2551, 201, 0, 0), (2552, 204, 0, 0), (2553, 199, 0, 0), (2554, 201, 0, 0),
    (2555, 197, 0, 0), (2556, 198, 0, 0), (2557, 204, 0, 0), (2558, 198, 0, 0), (2559, 199, 0, 0), (2560, 201, 0, 0), (2561, 204, 0, 0), (2562, 204, 0, 0), (2563, 198, 0, 0),
    (2564, 202, 0, 0), (2565, 198, 0, 0), (2566, 201, 0, 0), (2567, 201, 0, 0), (2568, 198, 0, 0), (2569, 199, 0, 0), (2570, 198, 0, 0), (2571, 198, 0, 0), (2572, 204, 0, 0),
    (2573, 198, 0, 0), (2574, 204, 0, 0), (2575, 198, 0, 0), (2576, 204, 0, 0), (2577, 197, 0, 0), (2578, 200, 0, 0), (2579, 204, 0, 0), (2580, 201, 0, 0), (2581, 198, 0, 0),
    (2582, 199, 0, 0), (2583, 200, 0, 0), (2584, 201, 0, 0), (2585, 201, 0, 0), (2586, 201, 0, 0), (2587, 204, 0, 0), (2588, 198, 0, 0), (2589, 200, 0, 0), (2590, 199, 0, 0),
    (2591, 204, 0, 0), (2592, 200, 0, 0), (2593, 204, 0, 0), (2594, 198, 0, 0), (2595, 201, 0, 0), (2596, 201, 0, 0), (2597, 199, 0, 0), (2598, 198, 0, 0), (2599, 201, 0, 0),
    (2600, 198, 0, 0), (2601, 200, 0, 0), (2602, 201, 0, 0), (2603, 198, 0, 0), (2604, 201, 0, 0), (2605, 198, 0, 0), (2606, 198, 0, 0), (2607, 201, 0, 0), (2608, 198, 0, 0),
    (2609, 201, 0, 0), (2610, 198, 0, 0), (2611, 204, 0, 0), (2612, 201, 0, 0), (2613, 204, 0, 0), (2614, 198, 0, 0), (2615, 200, 0, 0), (2616, 204, 0, 0), (2617, 204, 0, 0),
    (2618, 198, 0, 0), (2619, 199, 0, 0), (2620, 204, 0, 0), (2621, 194, 0, 0), (2622, 198, 0, 0), (2623, 199, 0, 0), (2624, 204, 0, 0), (2625, 204, 0, 0), (2626, 198, 0, 0),
    (2627, 204, 0, 0), (2628, 204, 0, 0), (2629, 198, 0, 0), (2630, 199, 0, 0), (2631, 204, 0, 0), (2632, 207, 0, 0), (2633, 198, 0, 0), (2634, 204, 0, 0), (2635, 198, 0, 0),
    (2636, 204, 0, 0), (2637, 204, 0, 0), (2638, 198, 0, 0), (2639, 199, 0, 0), (2640, 204, 0, 0), (2641, 204, 0, 0), (2642, 201, 0, 0), (2643, 204, 0, 0), (2644, 198, 0, 0),
    (2645, 197, 0, 0), (2646, 198, 0, 0), (2647, 200, 0, 0), (2648, 204, 0, 0), (2649, 199, 0, 0), (2650, 198, 0, 0), (2651, 204, 0, 0), (2652, 204, 0, 0), (2653, 204, 0, 0),
    (2654, 199, 0, 0), (2655, 204, 0, 0), (2656, 198, 0, 0), (2657, 199, 0, 0), (2658, 204, 0, 0), (2659, 204, 0, 0), (2660, 204, 0, 0), (2661, 197, 0, 0), (2662, 198, 0, 0),
    (2663, 199, 0, 0), (2664, 204, 0, 0), (2665, 198, 0, 0), (2666, 199, 0, 0), (2667, 199, 0, 0), (2668, 198, 0, 0), (2669, 199, 0, 0), (2670, 204, 0, 0), (2671, 198, 0, 0),
    (2672, 198, 0, 0), (2673, 204, 0, 0), (2674, 198, 0, 0), (2675, 204, 0, 0), (2676, 198, 0, 0), (2677, 198, 0, 0), (2678, 198, 0, 0), (2679, 204, 0, 0), (2680, 198, 0, 0),
    (2681, 199, 0, 0), (2682, 204, 0, 0), (2683, 198, 0, 0), (2684, 199, 0, 0), (2685, 204, 0, 0), (2686, 204, 0, 0), (2687, 204, 0, 0), (2688, 204, 0, 0), (2689, 204, 0, 0),
    (2690, 198, 0, 0), (2691, 204, 0, 0), (2692, 199, 0, 0), (2693, 204, 0, 0), (2694, 204, 0, 0), (2695, 199, 0, 0), (2696, 204, 0, 0), (2697, 204, 0, 0), (2698, 204, 0, 0),
    (2699, 197, 0, 0), (2700, 198, 0, 0), (2701, 200, 0, 0), (2702, 200, 0, 0), (2703, 201, 0, 0), (2704, 200, 0, 0), (2705, 201, 0, 0), (2706, 200, 0, 0), (2707, 201, 0, 0),
    (2708, 201, 0, 0), (2709, 200, 0, 0), (2710, 201, 0, 0), (2711, 204, 0, 0), (2712, 198, 0, 0), (2713, 204, 0, 0), (2714, 198, 0, 0), (2715, 201, 0, 0), (2716, 201, 0, 0),
    (2717, 201, 0, 0), (2718, 204, 0, 0), (2719, 204, 0, 0), (2720, 201, 0, 0), (2721, 198, 0, 0), (2722, 201, 0, 0), (2723, 198, 0, 0), (2724, 201, 0, 0), (2725, 200, 0, 0),
    (2726, 204, 0, 0), (2727, 200, 0, 0), (2728, 198, 0, 0), (2729, 201, 0, 0), (2730, 204, 0, 0), (2731, 198, 0, 0), (2732, 201, 0, 0), (2733, 204, 0, 0), (2734, 204, 0, 0),
    (2735, 198, 0, 0), (2736, 201, 0, 0), (2737, 198, 0, 0), (2738, 201, 0, 0), (2739, 204, 0, 0), (2740, 204, 0, 0), (2741, 201, 0, 0), (2742, 197, 0, 0), (2743, 198, 0, 0),
    (2744, 200, 0, 0), (2745, 201, 0, 0), (2746, 201, 0, 0), (2747, 201, 0, 0), (2748, 198, 0, 0), (2749, 201, 0, 0), (2750, 201, 0, 0), (2751, 204, 0, 0), (2752, 200, 0, 0),
    (2753, 201, 0, 0), (2754, 204, 0, 0), (2755, 204, 0, 0), (2756, 204, 0, 0), (2757, 204, 0, 0), (2758, 208, 0, 0), (2759, 208, 0, 0), (2760, 202, 0, 0), (2761, 203, 0, 0),
    (2762, 202, 0, 0), (2763, 204, 0, 0), (2764, 177, 0, 0), (2765, 178, 0, 0), (2766, 176, 0, 0), (2767, 175, 0, 0), (2768, 178, 0, 0), (2769, 191, 0, 0), (2770, 176, 0, 0),
    (2771, 191, 0, 0), (2772, 191, 0, 0), (2773, 178, 0, 0), (2774, 191, 0, 0), (2775, 204, 0, 0), (2776, 204, 0, 0), (2777, 191, 0, 0), (2778, 178, 0, 0), (2779, 191, 0, 0),
    (2780, 191, 0, 0), (2781, 191, 0, 0), (2782, 164, 0, 0), (2783, 164, 0, 0), (2784, 191, 0, 0), (2785, 164, 0, 0), (2786, 164, 0, 0), (2787, 164, 0, 0), (2788, 175, 0, 0),
    (2789, 191, 0, 0), (2790, 168, 0, 0), (2791, 191, 0, 0), (2792, 209, 0, 0), (2793, 210, 0, 0);


--
-- Attribute option translations
--
INSERT INTO `%%XC%%_attribute_option_translations` (`id`, `name`, `code`)
VALUES
    (245, 'S', 'es'),
    (246, 'M', 'es'),
    (247, 'L', 'es'),
    (248, 'XL', 'es'),
    (482, 'HALO', 'es'),
    (485, 'EBC', 'es'),
    (494, 'Frenos EBC', 'es'),
    (497, 'Acero', 'es'),
    (498, 'Acero inoxidable', 'es'),
    (499, 'Acero', 'es'),
    (500, 'Acero inoxidable', 'es'),
    (501, 'Acero', 'es'),
    (502, 'Acero inoxidable', 'es'),
    (503, 'Azul-Rojo', 'es'),
    (504, 'Blanco-amarillo', 'es'),
    (505, 'Xprite', 'es'),
    (506, 'Lumen', 'es'),
    (507, 'Morimoto', 'es'),
    (508, 'ACDelco', 'es'),
    (509, 'ACT', 'es'),
    (510, 'aFe', 'es'),
    (511, 'AMS', 'es'),
    (512, 'APR', 'es'),
    (514, 'Borla', 'es'),
    (515, 'BOYO', 'es'),
    (516, 'CalTrend', 'es'),
    (517, 'Centerforce', 'es'),
    (518, 'Rendimiento del CFR', 'es'),
    (519, 'Instrumentos clásicos', 'es'),
    (520, 'Coverking', 'es'),
    (521, 'Dorman', 'es'),
    (522, 'Garmin', 'es'),
    (523, 'Gastokyle', 'es'),
    (524, 'GEKO', 'es'),
    (525, 'GrimmSpeed', 'es'),
    (526, 'Innovate Motorsports', 'es'),
    (527, 'McGard', 'es'),
    (528, 'MagnaFlow', 'es'),
    (529, 'Michelin', 'es'),
    (530, 'Mishimoto', 'es'),
    (531, 'OER', 'es'),
    (532, 'Iluminación Oracle', 'es'),
    (533, 'Piloto', 'es'),
    (534, 'Embragues RAM', 'es'),
    (535, 'Rotiform', 'es'),
    (536, 'Seibon', 'es'),
    (537, 'Spectre', 'es'),
    (538, 'Spyder', 'es'),
    (539, 'Steelcraft', 'es'),
    (540, 'Stillen', 'es'),
    (541, 'Escena callejera', 'es'),
    (542, 'Thinkware', 'es'),
    (543, 'Tyger', 'es'),
    (544, 'Uniden', 'es'),
    (545, 'Wagner Tuning', 'es'),
    (546, 'Whistler', 'es'),
    (547, 'Zerex', 'es'),
    (551, 'Rojo', 'es'),
    (552, 'Plata', 'es'),
    (553, 'Rosa-morado', 'es'),
    (554, '17\" DIÁMETRO (17\" x 7\")', 'es'),
    (555, '18\" DIÁMETRO (18\" x 7.5\")', 'es'),
    (556, 'Azul claro', 'es'),
    (557, 'Azul oscuro', 'es'),
    (558, 'Beige', 'es'),
    (559, 'Café', 'es'),
    (562, '225/45R17', 'es'),
    (563, '225/45R18', 'es'),
    (564, '225/40R19', 'es'),
    (565, '245/35R19', 'es'),
    (566, '255/35R19', 'es'),
    (567, 'Beige', 'es'),
    (568, 'Café', 'es'),
    (569, 'Beige', 'es'),
    (570, 'Café', 'es'),
    (571, 'Beige', 'es'),
    (572, 'Café', 'es'),
    (573, 'Azul-Rojo', 'es'),
    (574, 'Blanco-amarillo', 'es'),
    (575, 'ARTIS FORGED', 'es'),
    (576, 'Niche', 'es'),
    (577, 'Rennen Forged', 'es'),
    (578, 'Vogue Tyres', 'es'),
    (579, 'Yokohama', 'es'),
    (580, 'AMS Performance', 'es'),
    (581, 'Laufenn', 'es'),
    (582, 'Landspider', 'es'),
    (583, 'CCI', 'es'),
    (584, '2 Crave', 'es'),
    (585, '4PLAY', 'es'),
    (586, '720Form', 'es'),
    (587, 'Ace Alloy', 'es'),
    (588, 'Advanti Racing USA', 'es'),
    (589, 'Akuza', 'es'),
    (590, 'Alcoa', 'es'),
    (591, 'Allied', 'es'),
    (592, 'Amani Forged', 'es'),
    (593, 'American Design Factory', 'es'),
    (594, 'American Force', 'es'),
    (595, 'American Legend', 'es'),
    (596, 'American Racing', 'es'),
    (597, 'American Truxx', 'es'),
    (598, 'ART Replica', 'es'),
    (599, 'Asanti Black Label', 'es'),
    (600, 'Asanti Forged', 'es'),
    (601, 'ATX', 'es'),
    (602, 'Avant Garde', 'es'),
    (603, 'Avenue', 'es'),
    (604, 'Axe', 'es'),
    (605, 'Azara', 'es'),
    (606, 'Ballistic', 'es'),
    (607, 'Bavar Racing', 'es'),
    (608, 'Beyern', 'es'),
    (609, 'BG Rod Works', 'es'),
    (610, 'Black Rhino', 'es'),
    (611, 'Black Rock', 'es'),
    (612, 'Blade', 'es'),
    (613, 'Blaque Diamond', 'es'),
    (614, 'Borghini', 'es'),
    (615, 'Boyd Coddington', 'es'),
    (616, 'Braelin', 'es'),
    (617, 'Bravado', 'es'),
    (618, 'Buck Commander', 'es'),
    (619, 'Cali Offroad', 'es'),
    (620, 'Carlisle', 'es'),
    (621, 'Cavallo', 'es'),
    (622, 'CEC', 'es'),
    (623, 'Centerline', 'es'),
    (624, 'Coventry', 'es'),
    (625, 'Cragar', 'es'),
    (626, 'Cratus', 'es'),
    (627, 'Cray', 'es'),
    (628, 'Cruiser Alloys', 'es'),
    (629, 'Curva Concepts', 'es'),
    (630, 'DAI Alloys', 'es'),
    (631, 'Dcenti Racing', 'es'),
    (632, 'DDC', 'es'),
    (633, 'Diablo', 'es'),
    (634, 'Akuret', 'es'),
    (635, 'Amp', 'es'),
    (636, 'Antares', 'es'),
    (637, 'Apollo', 'es'),
    (638, 'Ardent', 'es'),
    (639, 'Arroyo', 'es'),
    (640, 'Atturo', 'es'),
    (641, 'Bfgoodrich', 'es'),
    (642, 'Bridgestone', 'es'),
    (643, 'Camso', 'es'),
    (644, 'Comforser', 'es'),
    (645, 'Continental', 'es'),
    (646, 'Cooper', 'es'),
    (647, 'Dean', 'es'),
    (648, 'Deestone', 'es'),
    (649, 'Delinte', 'es'),
    (650, 'Delta', 'es'),
    (651, 'Dick Cepek', 'es'),
    (652, 'Dunlop', 'es'),
    (653, 'Duraturn', 'es'),
    (654, 'Dynamaxx', 'es'),
    (655, 'Efx', 'es'),
    (656, 'Falken', 'es'),
    (657, 'Firestone', 'es'),
    (658, 'Fuel', 'es'),
    (659, 'Fuzion', 'es'),
    (660, 'Galaxy', 'es'),
    (661, 'Gallant', 'es'),
    (662, 'General', 'es'),
    (663, 'Goodyear', 'es'),
    (664, 'Gt Radial', 'es'),
    (665, 'Hankook', 'es'),
    (666, 'Hercules', 'es'),
    (667, 'Interco', 'es'),
    (668, 'ITP', 'es'),
    (669, 'Kenda', 'es'),
    (670, 'Kumho', 'es'),
    (672, 'Lexani', 'es'),
    (673, 'Mastercraft', 'es'),
    (674, 'Maxxis', 'es'),
    (676, 'Mickey Thompson', 'es'),
    (677, 'Momo', 'es'),
    (678, 'Multi-mile', 'es'),
    (679, 'Nexen', 'es'),
    (680, 'Nitto', 'es'),
    (681, 'Ohtsu', 'es'),
    (682, 'Pirelli', 'es'),
    (683, 'SUV', 'es'),
    (684, 'Truck', 'es'),
    (685, 'Off-Road', 'es'),
    (686, '22', 'es'),
    (687, '12', 'es'),
    (688, '5', 'es'),
    (689, '127', 'es'),
    (690, '139.7', 'es'),
    (691, 'Gloss', 'es'),
    (692, 'Black', 'es'),
    (693, 'Brushed Face-Tinted Clear', 'es'),
    (694, '87.1', 'es'),
    (695, '2900', 'es'),
    (696, '-44', 'es'),
    (697, 'Cast Aluminum', 'es'),
    (698, '1-Piece', 'es'),
    (699, 'Conical', 'es'),
    (700, '4P06', 'es'),
    (701, 'BBT', 'es'),
    (702, '22″х12″/-44mm, 5x127/139.7', 'es'),
    (703, '6', 'es'),
    (704, '135', 'es'),
    (705, '106.1', 'es'),
    (706, '22″х12″/-44mm, 6x135/139.7', 'es'),
    (707, '24', 'es'),
    (708, '24″х12″/-44mm, 6x135/139.7', 'es'),
    (709, '20', 'es'),
    (710, '10', 'es'),
    (711, '-18', 'es'),
    (712, '20″х10″/-18mm, 5x127/139.7', 'es'),
    (713, '20″х10″/-18mm, 6x135/139.7', 'es'),
    (714, '22″х10″/-18mm, 5x127/139.7', 'es'),
    (715, '22″х10″/-18mm, 6x135/139.7', 'es'),
    (716, '9', 'es'),
    (717, '2980', 'es'),
    (718, '20″х9″/0mm, 5x127/139.7', 'es'),
    (719, '20″х9″/0mm, 6x135/139.7', 'es'),
    (720, '8', 'es'),
    (721, '170', 'es'),
    (722, '124.9', 'es'),
    (723, '3900', 'es'),
    (724, '20″х9″/0mm, 8x170', 'es'),
    (725, '180', 'es'),
    (726, '20″х9″/0mm, 8x180', 'es'),
    (727, '165.1', 'es'),
    (728, '20″х9″/0mm, 8x165.1', 'es'),
    (729, '12', 'es'),
    (730, '22″х9″/12mm, 6x135/139.7', 'es'),
    (731, '18', 'es'),
    (732, '24″х10″/18mm, 6x135/139.7', 'es'),
    (733, '4P08', 'es'),
    (734, '22″х12″/-44mm, 8x170', 'es'),
    (735, '124.1', 'es'),
    (736, '22″х12″/-44mm, 8x180', 'es'),
    (737, '22″х12″/-44mm, 8x165.1', 'es'),
    (738, '-24', 'es'),
    (739, '20″х10″/-24mm, 5x127/139.7', 'es'),
    (740, '20″х10″/-24mm, 8x170', 'es'),
    (741, '20″х10″/-24mm, 8x180', 'es'),
    (742, '20″х10″/-24mm, 8x165.1', 'es'),
    (743, '22″х10″/-24mm, 5x127/139.7', 'es'),
    (744, '22″х10″/-24mm, 8x170', 'es'),
    (745, '22″х10″/-24mm, 8x180', 'es'),
    (746, '22″х10″/-24mm, 8x165.1', 'es'),
    (747, '4P55', 'es'),
    (748, '20″х12″/-44mm, 5x127/139.7', 'es'),
    (749, '20″х12″/-44mm, 6x135/139.7', 'es'),
    (750, '4P63', 'es'),
    (751, '4P70', 'es'),
    (752, '4P80R', 'es'),
    (753, '4P83', 'es'),
    (754, '14', 'es'),
    (755, 'Matte', 'es'),
    (756, 'Gloss Black Barrel', 'es'),
    (757, '-76', 'es'),
    (758, '4PF6', 'es'),
    (759, 'B', 'es'),
    (760, '24″х14″/-76mm, 6x135/139.7', 'es'),
    (761, '3700', 'es'),
    (762, '24″х14″/-76mm, 8x170', 'es'),
    (763, '24″х14″/-76mm, 8x180', 'es'),
    (764, '24″х14″/-76mm, 8x165.1', 'es'),
    (765, 'Coche', 'es'),
    (766, 'Lujo', 'es'),
    (767, '112', 'es'),
    (768, 'Gris mica', 'es'),
    (769, 'Cara cepillada', 'es'),
    (770, '72.6', 'es'),
    (771, '1650', 'es'),
    (772, '20', 'es'),
    (773, 'AFF01', 'es'),
    (774, 'GY', 'es'),
    (775, '20″х9″/20mm, 5x112', 'es'),
    (776, '114.3', 'es'),
    (777, '20″х12″/20mm, 5x114.3', 'es'),
    (778, '19', 'es'),
    (779, '25', 'es'),
    (780, '19″х10″/25mm, 5x112', 'es'),
    (781, '10.5', 'es'),
    (782, '20″х10.5″/25mm, 5x112', 'es'),
    (783, '11', 'es'),
    (784, '20″х11″/25mm, 5x112', 'es'),
    (785, '9.5', 'es'),
    (786, '110', 'es'),
    (787, '30', 'es'),
    (788, '19″х9.5″/30mm, 5x110', 'es'),
    (789, '8.5', 'es'),
    (790, '38', 'es'),
    (791, '19″х8.5″/38mm, 5x110', 'es'),
    (792, 'Plata líquida', 'es'),
    (793, 'Cara mecanizada', 'es'),
    (794, 'SL', 'es'),
    (795, 'Negro mate', 'es'),
    (796, 'MB', 'es'),
    (797, '108', 'es'),
    (798, 'Cepillado', 'es'),
    (799, 'Plata', 'es'),
    (800, 'Capa transparente', 'es'),
    (801, 'AFF02', 'es'),
    (802, '19″х10″/20mm, 5x108', 'es'),
    (803, '2010', 'es'),
    (804, '22″х9″/20mm, 5x108', 'es'),
    (805, '20″х11″/30mm, 5x112', 'es'),
    (806, '32', 'es'),
    (807, '19″х8.5″/32mm, 5x108', 'es'),
    (808, '20″х9″/32mm, 5x108', 'es'),
    (809, '20″х10.5″/32mm, 5x108', 'es'),
    (810, '35', 'es'),
    (811, '19″х9.5″/35mm, 5x108', 'es'),
    (812, '20″х9.5″/35mm, 5x112', 'es'),
    (813, '20″х12″/35mm, 5x112', 'es'),
    (814, '22″х10.5″/35mm, 5x108', 'es'),
    (815, 'GB', 'es'),
    (816, 'Negro Cromo', 'es'),
    (817, 'CH', 'es'),
    (818, '20″х10″/25mm, 5x108', 'es'),
    (819, 'BK', 'es'),
    (820, '115', 'es'),
    (821, 'Negro piano', 'es'),
    (822, '2101', 'es'),
    (823, 'AFF03', 'es'),
    (824, '22″х10″/20mm, 5x115', 'es'),
    (825, 'Cara mecanizada en espejo', 'es'),
    (826, 'BKM', 'es'),
    (827, 'Cara mecanizada-Labio negro brillante', 'es'),
    (828, '1550', 'es'),
    (829, 'AFF04', 'es'),
    (830, '20″х10.5″/20mm, 5x112', 'es'),
    (831, 'Labio mecanizado', 'es'),
    (832, 'LSL', 'es'),
    (833, 'Titanio', 'es'),
    (834, 'TSL', 'es'),
    (835, '120', 'es'),
    (836, 'AFF05', 'es'),
    (837, '19″х9.5″/18mm, 5x120', 'es'),
    (838, '19″х8.5″/20mm, 5x112', 'es'),
    (839, '20″х10″/20mm, 5x115', 'es'),
    (840, '20″х10.5″/20mm, 5x114.3', 'es'),
    (841, '20″х11″/20mm, 5x114.3', 'es'),
    (842, '20″х8.5″/25mm, 5x112', 'es'),
    (843, 'Gris espacial', 'es'),
    (844, 'Coche', 'es'),
    (845, 'Rendimiento', 'es'),
    (846, 'Verano', 'es'),
    (847, '275', 'es'),
    (848, '40', 'es'),
    (849, '19', 'es'),
    (850, 'Pilot Sport PS2', 'es'),
    (851, '23.9', 'es'),
    (852, '8.43', 'es'),
    (853, '9.5', 'es'),
    (854, '750', 'es'),
    (855, '101', 'es'),
    (856, 'Y', 'es'),
    (857, '275/40R19', 'es'),
    (858, '255', 'es'),
    (859, '25.32', 'es'),
    (860, '9.3', 'es'),
    (861, '10', 'es'),
    (862, '769', 'es'),
    (863, '96', 'es'),
    (864, '255/40R19', 'es'),
    (865, '225', 'es'),
    (866, '35', 'es'),
    (867, '25.2', 'es'),
    (868, '9.1', 'es'),
    (869, 'XL', 'es'),
    (870, '8.5', 'es'),
    (871, '824', 'es'),
    (872, '88', 'es'),
    (873, '(Y)', 'es'),
    (874, '225/35ZR19', 'es'),
    (875, '18', 'es'),
    (876, '10.2', 'es'),
    (877, '832', 'es'),
    (878, '94', 'es'),
    (879, '255/35ZR18', 'es'),
    (880, '265', 'es'),
    (881, '26.3', 'es'),
    (882, '10.7', 'es'),
    (883, '790', 'es'),
    (884, '265/40ZR18', 'es'),
    (885, '285', 'es'),
    (886, '30', 'es'),
    (887, '21', 'es'),
    (888, '27.8', 'es'),
    (889, '11.4', 'es'),
    (890, '749', 'es'),
    (891, '100', 'es'),
    (892, '285/30ZR21', 'es'),
    (893, '235', 'es'),
    (894, '25.5', 'es'),
    (895, '9.5', 'es'),
    (896, '817', 'es'),
    (897, '87', 'es'),
    (898, '235/35ZR19', 'es'),
    (899, '25.4', 'es'),
    (900, '819', 'es'),
    (901, '91', 'es'),
    (902, '235/40ZR18', 'es'),
    (903, '315', 'es'),
    (904, '12.6', 'es'),
    (905, '98', 'es'),
    (906, '315/30ZR18', 'es'),
    (907, '25.6', 'es'),
    (908, '10.9', 'es'),
    (909, '814', 'es'),
    (910, '95', 'es'),
    (911, '275/35R18', 'es'),
    (912, '26', 'es'),
    (913, '799', 'es'),
    (914, '99', 'es'),
    (915, '255/40ZR18', 'es'),
    (916, '20', 'es'),
    (917, '26.1', 'es'),
    (918, '798', 'es'),
    (919, '92', 'es'),
    (920, '255/30ZR20', 'es'),
    (921, '25.1', 'es'),
    (922, '9.2', 'es'),
    (923, '829', 'es'),
    (924, '225/40ZR18', 'es'),
    (925, '797', 'es'),
    (926, '93', 'es'),
    (927, '225/40ZR19', 'es'),
    (928, '245', 'es'),
    (929, '24.8', 'es'),
    (930, '9.8', 'es'),
    (931, '840', 'es'),
    (932, '245/35ZR18', 'es'),
    (933, '25', 'es'),
    (934, '12.8', 'es'),
    (935, '315/25ZR19', 'es'),
    (936, '295', 'es'),
    (937, '11.9', 'es'),
    (938, '295/30ZR19', 'es'),
    (939, '45', 'es'),
    (940, '17', 'es'),
    (941, '25', 'es'),
    (942, '8.9', 'es'),
    (943, '833', 'es'),
    (944, '225/45ZR17', 'es'),
    (945, '831', 'es'),
    (946, '255/40ZR17', 'es'),
    (947, '26.6', 'es'),
    (948, '783', 'es'),
    (949, '275/40ZR18', 'es'),
    (950, '24.2', 'es'),
    (951, '859', 'es'),
    (952, '225/35ZR18', 'es'),
    (953, '255/35ZR19', 'es'),
    (954, '305', 'es'),
    (955, '12.3', 'es'),
    (956, '788', 'es'),
    (957, '102', 'es'),
    (958, '305/30ZR19', 'es'),
    (959, '205', 'es'),
    (960, '55', 'es'),
    (961, '25.9', 'es'),
    (962, '8.4', 'es'),
    (963, '803', 'es'),
    (964, '205/55ZR17', 'es'),
    (965, '22', 'es'),
    (966, '747', 'es'),
    (967, '97', 'es'),
    (968, '295/25ZR22', 'es'),
    (969, '24.7', 'es'),
    (970, '841', 'es'),
    (971, '245/40ZR17', 'es'),
    (972, '27.7', 'es'),
    (973, '8.2', 'es'),
    (974, '742', 'es'),
    (975, '245/40ZR18', 'es'),
    (976, '25.7', 'es'),
    (977, '9.6', 'es'),
    (978, '809', 'es'),
    (979, '245/45ZR17', 'es'),
    (980, '275/30ZR19', 'es'),
    (981, '335', 'es'),
    (982, '28', 'es'),
    (983, '13.5', 'es'),
    (984, '744', 'es'),
    (985, '104', 'es'),
    (986, '335/30ZR20', 'es'),
    (987, '25.8', 'es'),
    (988, '807', 'es'),
    (989, '245/35ZR19', 'es'),
    (990, '325', 'es'),
    (991, '26.4', 'es'),
    (992, '12.9', 'es'),
    (993, '789', 'es'),
    (994, '325/25ZR20', 'es'),
    (995, '25.3', 'es'),
    (996, '822', 'es'),
    (997, '265/35ZR18', 'es'),
    (998, '245/35ZR21', 'es'),
    (999, '265/35ZR19', 'es'),
    (1000, '26.7', 'es'),
    (1001, '778', 'es'),
    (1002, '245/40ZR19', 'es'),
    (1003, '28.1', 'es'),
    (1004, '741', 'es'),
    (1005, '255/30ZR22', 'es'),
    (1006, '24.4', 'es'),
    (1007, '852', 'es'),
    (1008, '90', 'es'),
    (1009, '235/40ZR17', 'es'),
    (1010, '26.8', 'es'),
    (1011, '776', 'es'),
    (1012, '295/25ZR21', 'es'),
    (1013, '295/35ZR18', 'es'),
    (1014, '27', 'es'),
    (1015, '255/30ZR21', 'es'),
    (1016, '26.9', 'es'),
    (1017, '774', 'es'),
    (1018, '285/30ZR20', 'es'),
    (1019, '777', 'es'),
    (1020, '245/35ZR20', 'es'),
    (1021, '27.1', 'es'),
    (1022, '767', 'es'),
    (1023, '255/35ZR20', 'es'),
    (1024, '805', 'es'),
    (1025, '295/25ZR20', 'es'),
    (1026, '13.5', 'es'),
    (1027, '265/30ZR19', 'es'),
    (1028, '295/30ZR18', 'es'),
    (1029, '275/35ZR19', 'es'),
    (1030, '8.3', 'es'),
    (1031, '851', 'es'),
    (1032, '86', 'es'),
    (1033, '205/40ZR18', 'es'),
    (1034, '285/35ZR19', 'es'),
    (1035, 'SL', 'es'),
    (1036, '265/40ZR17', 'es'),
    (1037, '25.28', 'es'),
    (1038, '8.11', 'es'),
    (1039, '245/30ZR20', 'es'),
    (1040, '821', 'es'),
    (1041, '235/45ZR17', 'es'),
    (1042, '275/40ZR17', 'es'),
    (1043, '285/30ZR19', 'es'),
    (1044, '255/40ZR19', 'es'),
    (1045, '26.2', 'es'),
    (1046, '106', 'es'),
    (1047, '335/35ZR17', 'es'),
    (1048, '50', 'es'),
    (1049, '235/50ZR17', 'es'),
    (1050, '29.8', 'es'),
    (1051, '697', 'es'),
    (1052, '110', 'es'),
    (1053, '275/45R20', 'es'),
    (1054, '245/45ZR18', 'es'),
    (1055, '25.94', 'es'),
    (1056, '800', 'es'),
    (1057, '335/30ZR18', 'es'),
    (1058, '225/45ZR18', 'es'),
    (1059, '275/35ZR18', 'es'),
    (1060, '24', 'es'),
    (1061, '9', 'es'),
    (1062, 'P245/40ZR18', 'es'),
    (1063, '27.68', 'es'),
    (1064, '10.94', 'es'),
    (1065, '751', 'es'),
    (1066, '27.6', 'es'),
    (1067, '755', 'es'),
    (1068, '275/35ZR20', 'es'),
    (1069, '345', 'es'),
    (1070, '27.2', 'es'),
    (1071, '13.8', 'es'),
    (1072, '765', 'es'),
    (1073, '105', 'es'),
    (1074, '345/30ZR19', 'es'),
    (1075, '815', 'es'),
    (1076, '225/45R17', 'es'),
    (1077, '27.3', 'es'),
    (1078, '9.7', 'es'),
    (1079, '762', 'es'),
    (1080, '235/50ZR18', 'es'),
    (1081, '802', 'es'),
    (1082, '9.76', 'es'),
    (1083, '265/35R19', 'es'),
    (1084, '813', 'es'),
    (1085, '235/30ZR20', 'es'),
    (1086, '265/30ZR20', 'es'),
    (1087, '791', 'es'),
    (1088, '11.6', 'es'),
    (1089, '285/25ZR20', 'es'),
    (1090, '28.4', 'es'),
    (1091, '732', 'es'),
    (1092, '305/35ZR20', 'es'),
    (1093, '828', 'es'),
    (1094, '89', 'es'),
    (1095, '205/50ZR17', 'es'),
    (1096, '810', 'es'),
    (1097, 'W', 'es'),
    (1098, '780', 'es'),
    (1099, 'LL', 'es'),
    (1100, 'P275/35ZR18', 'es'),
    (1101, '285/30ZR18', 'es'),
    (1102, '9', 'es'),
    (1103, '26.73', 'es'),
    (1104, '255/35R19', 'es'),
    (1105, '10', 'es'),
    (1106, '255/45R19', 'es'),
    (1107, 'P285/30ZR19', 'es'),
    (1108, '743', 'es'),
    (1109, '103', 'es'),
    (1110, '285/40ZR19', 'es'),
    (1111, '26.61', 'es'),
    (1112, '8.98', 'es'),
    (1113, '13', 'es'),
    (1114, 'P325/30ZR19', 'es'),
    (1115, '26.5', 'es'),
    (1116, '786', 'es'),
    (1117, '235/35ZR20', 'es'),
    (1118, '8.7', 'es'),
    (1119, '794', 'es'),
    (1120, '255/40ZR20', 'es'),
    (1121, '717', 'es'),
    (1122, '295/35ZR20', 'es'),
    (1123, '740', 'es'),
    (1124, '801', 'es'),
    (1125, '305/25ZR20', 'es'),
    (1126, '782', 'es'),
    (1127, 'P335/25ZR20', 'es'),
    (1128, '28.3', 'es'),
    (1129, '50', 'es'),
    (1130, '735', 'es'),
    (1131, '265/35ZR21', 'es'),
    (1132, '28.2', 'es'),
    (1133, '715', 'es'),
    (1134, '305/30ZR21', 'es'),
    (1135, '27.4', 'es'),
    (1136, '11.1', 'es'),
    (1137, '758', 'es'),
    (1138, '275/25ZR22', 'es'),
    (1139, '792', 'es'),
    (1140, '245/40R18', 'es'),
    (1141, '43.43', 'es'),
    (1142, '19', 'es'),
    (1143, '478', 'es'),
    (1144, '27.95', 'es'),
    (1145, '255/45ZR18', 'es'),
    (1146, 'SUV/Camión Ligero', 'es'),
    (1147, 'Toda la temporada', 'es'),
    (1148, 'Comercial', 'es'),
    (1149, 'Terreno de carretera', 'es'),
    (1150, '70', 'es'),
    (1151, '16', 'es'),
    (1152, 'LTX M/S', 'es'),
    (1153, '25.83', 'es'),
    (1154, '8.99', 'es'),
    (1155, '10.5', 'es'),
    (1156, '107', 'es'),
    (1157, 'S', 'es'),
    (1158, '245/70R16', 'es'),
    (1159, '31.3', 'es'),
    (1160, '12', 'es'),
    (1161, '666', 'es'),
    (1162, '114', 'es'),
    (1163, 'H', 'es'),
    (1164, 'P275/70R16', 'es'),
    (1165, '75', 'es'),
    (1166, '31.6', 'es'),
    (1167, '10.5', 'es'),
    (1168, '13', 'es'),
    (1169, '658', 'es'),
    (1170, 'P265/75R16', 'es'),
    (1171, '15', 'es'),
    (1172, '27.9', 'es'),
    (1173, '9.4', 'es'),
    (1174, '746', 'es'),
    (1175, 'P235/70R15', 'es'),
    (1176, '215', 'es'),
    (1177, 'R', 'es'),
    (1178, 'LT215/75R15', 'es'),
    (1179, '30.7', 'es'),
    (1180, '681', 'es'),
    (1181, '111', 'es'),
    (1182, 'P265/70R16', 'es'),
    (1183, '29.6', 'es'),
    (1184, '707', 'es'),
    (1185, 'P245/70R16', 'es'),
    (1186, '28.8', 'es'),
    (1187, '727', 'es'),
    (1188, '6', 'es'),
    (1189, 'LT235/75R15', 'es'),
    (1190, '32.8', 'es'),
    (1191, '11.3', 'es'),
    (1192, '15', 'es'),
    (1193, '634', 'es'),
    (1194, '122', 'es'),
    (1195, 'LT285/75R16/D', 'es'),
    (1196, '29.1', 'es'),
    (1197, 'P235/70R16/XL', 'es'),
    (1198, '29.9', 'es'),
    (1199, '696', 'es'),
    (1200, 'P235/75R16', 'es'),
    (1201, 'P225/75R15', 'es'),
    (1202, '8.1', 'es'),
    (1203, 'P205/75R15', 'es'),
    (1204, '31.8', 'es'),
    (1205, '10.8', 'es'),
    (1206, '656', 'es'),
    (1207, '113', 'es'),
    (1208, 'P265/70R17', 'es'),
    (1209, '29.4', 'es'),
    (1210, '8.8', 'es'),
    (1211, '709', 'es'),
    (1212, '115', 'es'),
    (1213, '10', 'es'),
    (1214, 'LT225/75R16', 'es'),
    (1215, '120', 'es'),
    (1216, 'LT245/75R16/E', 'es'),
    (1217, '30.4', 'es'),
    (1218, '684', 'es'),
    (1219, '109', 'es'),
    (1220, 'P245/75R16', 'es'),
    (1221, '738', 'es'),
    (1222, 'P225/70R16', 'es'),
    (1223, '65', 'es'),
    (1224, '29.7', 'es'),
    (1225, '11', 'es'),
    (1226, '700', 'es'),
    (1227, '245/65R17', 'es'),
    (1228, '29.2', 'es'),
    (1229, '10.1', 'es'),
    (1230, '712', 'es'),
    (1231, 'P255/65R16', 'es'),
    (1232, '31.9', 'es'),
    (1233, '652', 'es'),
    (1234, 'T', 'es'),
    (1235, 'P275/55R20', 'es'),
    (1236, 'P215/70R16', 'es'),
    (1237, '85', 'es'),
    (1238, '30.5', 'es'),
    (1239, '685', 'es'),
    (1240, 'LT215/85R16', 'es'),
    (1241, '60', 'es'),
    (1242, '33', 'es'),
    (1243, '11', 'es'),
    (1244, '630', 'es'),
    (1245, 'P275/60R20', 'es'),
    (1246, '80', 'es'),
    (1247, '654', 'es'),
    (1248, 'LT235/80R17/E', 'es'),
    (1249, '14', 'es'),
    (1250, '123', 'es'),
    (1251, 'LT265/75R16/E', 'es'),
    (1252, '108', 'es'),
    (1253, '235/75R15', 'es'),
    (1254, 'P225/70R15', 'es'),
    (1255, '30.2', 'es'),
    (1256, '10.3', 'es'),
    (1257, '694', 'es'),
    (1258, 'P255/70R16', 'es'),
    (1259, '728', 'es'),
    (1260, 'P235/75R15/XL', 'es'),
    (1261, '31', 'es'),
    (1262, '10.5', 'es'),
    (1263, '30.8', 'es'),
    (1264, '679', 'es'),
    (1265, '31X10.50R15', 'es'),
    (1266, '9.86', 'es'),
    (1267, '8.6', 'es'),
    (1268, '754', 'es'),
    (1269, 'P215/75R15', 'es'),
    (1270, '32', 'es'),
    (1271, 'LT235/85R16/E', 'es'),
    (1272, '31.1', 'es'),
    (1273, '669', 'es'),
    (1274, 'P255/70R17', 'es'),
    (1275, '30', 'es'),
    (1276, '9.5', 'es'),
    (1277, '706', 'es'),
    (1278, '30X9.50R15', 'es'),
    (1279, 'LT245/75R16', 'es'),
    (1280, 'P235/70R16', 'es'),
    (1281, 'P245/65R17', 'es'),
    (1282, '703', 'es'),
    (1283, 'P245/60R18', 'es'),
    (1284, '28.7', 'es'),
    (1285, 'P235/75R15', 'es'),
    (1286, '195', 'es'),
    (1287, '14', 'es'),
    (1288, '7.9', 'es'),
    (1289, 'LT195/75R14/C', 'es'),
    (1290, 'LT215/75R15/C', 'es'),
    (1291, '29.3', 'es'),
    (1292, 'LT225/75R16/D', 'es'),
    (1293, '112', 'es'),
    (1294, 'LT265/75R16/C', 'es'),
    (1295, '820', 'es'),
    (1296, 'P235/75R16/XL', 'es'),
    (1297, '655', 'es'),
    (1298, '8', 'es'),
    (1299, 'LT235/85R16', 'es'),
    (1300, '32', 'es'),
    (1301, '11.5', 'es'),
    (1302, '31.7', 'es'),
    (1303, '662', 'es'),
    (1304, '32X11.50R15', 'es'),
    (1305, '4', 'es'),
    (1306, 'Latitude Tour HP', 'es'),
    (1307, 'V', 'es'),
    (1308, '255/60R17', 'es'),
    (1309, '10.6', 'es'),
    (1310, '711', 'es'),
    (1311, '255/55R18', 'es'),
    (1312, '295/30R22', 'es'),
    (1313, '660', 'es'),
    (1314, '295/40R22', 'es'),
    (1315, '31.5', 'es'),
    (1316, '11.5', 'es'),
    (1317, '657', 'es'),
    (1318, '285/60R18', 'es'),
    (1319, '23.8', 'es'),
    (1320, '6.9', 'es'),
    (1321, '872', 'es'),
    (1322, '275/55R17', 'es'),
    (1323, '22.7', 'es'),
    (1324, '7.7', 'es'),
    (1325, '914', 'es'),
    (1326, '235/65R17', 'es'),
    (1327, '30.1', 'es'),
    (1328, '688', 'es'),
    (1329, '255/50R20', 'es'),
    (1330, '28.6', 'es'),
    (1331, '721', 'es'),
    (1332, '315/35ZR20', 'es'),
    (1333, '714', 'es'),
    (1334, '285/45R19', 'es'),
    (1335, '677', 'es'),
    (1336, '265/50R20', 'es'),
    (1337, '31.83', 'es'),
    (1338, '9.87', 'es'),
    (1339, '720', 'es'),
    (1340, 'P255/55R18', 'es'),
    (1341, '28.66', 'es'),
    (1342, '722', 'es'),
    (1343, '275/40ZR20', 'es'),
    (1344, '255/50R19', 'es'),
    (1345, '29', 'es'),
    (1346, '10.4', 'es'),
    (1347, '682', 'es'),
    (1348, '265/60R18', 'es'),
    (1349, '41.54', 'es'),
    (1350, '699', 'es'),
    (1351, '32.1', 'es'),
    (1352, '12.4', 'es'),
    (1353, '649', 'es'),
    (1354, '305/50R20', 'es'),
    (1355, '768', 'es'),
    (1356, '235/60R16', 'es'),
    (1357, '29.57', 'es'),
    (1358, '723', 'es'),
    (1359, '275/45R19', 'es'),
    (1360, '716', 'es'),
    (1361, '255/65R16', 'es'),
    (1362, '29.85', 'es'),
    (1363, '671', 'es'),
    (1364, 'P275/60R18', 'es'),
    (1365, '31.26', 'es'),
    (1366, '11.69', 'es'),
    (1367, '10.3', 'es'),
    (1368, '665', 'es'),
    (1369, 'P285/50R20', 'es'),
    (1370, '30.6', 'es'),
    (1371, '265/70R16', 'es'),
    (1372, '31.2', 'es'),
    (1373, '667', 'es'),
    (1374, '275/70R16', 'es'),
    (1375, '770', 'es'),
    (1376, '215/65R16', 'es'),
    (1377, '753', 'es'),
    (1378, '225/60R17', 'es'),
    (1379, '30', 'es'),
    (1380, '692', 'es'),
    (1381, '255/55R19', 'es'),
    (1382, '701', 'es'),
    (1383, 'P245/50R20', 'es'),
    (1384, '11.7', 'es'),
    (1385, '58.9', 'es'),
    (1386, '21.1', 'es'),
    (1387, '648', 'es'),
    (1388, 'P275/65R18', 'es'),
    (1389, 'P235/65R18', 'es'),
    (1390, '766', 'es'),
    (1391, '235/55R17', 'es'),
    (1392, '29.5', 'es'),
    (1393, '704', 'es'),
    (1394, '225/60R18', 'es'),
    (1395, '235/60R18', 'es'),
    (1396, 'P265/60R18', 'es'),
    (1397, '661', 'es'),
    (1398, 'P285/60R18', 'es'),
    (1399, '28.31', 'es'),
    (1400, '235/50R19', 'es'),
    (1401, '713', 'es'),
    (1402, '235/55R19', 'es'),
    (1403, 'P235/55R19', 'es'),
    (1404, '29.09', 'es'),
    (1405, '10.43', 'es'),
    (1406, 'P255/50R19', 'es'),
    (1407, '690', 'es'),
    (1408, 'P235/55R20', 'es'),
    (1409, '285/50R20', 'es'),
    (1410, '27.28', 'es'),
    (1411, '9.65', 'es'),
    (1412, '235/50R18', 'es'),
    (1413, '30.47', 'es'),
    (1414, '116', 'es'),
    (1415, '705', 'es'),
    (1416, '265/50R19', 'es'),
    (1417, '30.98', 'es'),
    (1418, '29.76', 'es'),
    (1419, '10.75', 'es'),
    (1420, '726', 'es'),
    (1421, '28.5', 'es'),
    (1422, '730', 'es'),
    (1423, '225/65R17', 'es'),
    (1424, '28.9', 'es'),
    (1425, '245/60R18', 'es'),
    (1426, '11.22', 'es'),
    (1427, '9.9', 'es'),
    (1428, '702', 'es'),
    (1429, '245/55R19', 'es'),
    (1430, '10.91', 'es'),
    (1431, '683', 'es'),
    (1432, '31.46', 'es'),
    (1433, '225/50R19', 'es'),
    (1434, '245/45R19', 'es'),
    (1435, '275/45R21', 'es'),
    (1436, '11.8', 'es'),
    (1437, '710', 'es'),
    (1438, '295/40R20', 'es'),
    (1439, '708', 'es'),
    (1440, '265/45R20', 'es'),
    (1441, '31', 'es'),
    (1442, '29.53', 'es'),
    (1443, '245/45R20', 'es'),
    (1444, '691', 'es'),
    (1445, '31.4', 'es'),
    (1446, '30.3', 'es'),
    (1447, '265/45R21', 'es'),
    (1448, '235/65R18', 'es'),
    (1449, '255/55R20', 'es'),
    (1450, '32.3', 'es'),
    (1451, '255/70R18', 'es'),
    (1452, '255/60R20', 'es'),
    (1453, '32.32', 'es'),
    (1454, '4X4 Diamaris', 'es'),
    (1455, '325/30R21', 'es'),
    (1456, '16', 'es'),
    (1457, '285/35R21', 'es'),
    (1458, '275/45R19/XL', 'es'),
    (1459, '27.5', 'es'),
    (1460, '763', 'es'),
    (1461, '255/50R17', 'es'),
    (1462, '12.5', 'es'),
    (1463, '275/55R19', 'es'),
    (1464, '285/50R18', 'es'),
    (1465, '764', 'es'),
    (1466, '225/55R17', 'es'),
    (1467, '724', 'es'),
    (1468, '275/40R20', 'es'),
    (1469, '12', 'es'),
    (1470, '695', 'es'),
    (1471, '285/35R22', 'es'),
    (1472, '315/35R20', 'es'),
    (1473, '295/30ZR22', 'es'),
    (1474, '275/50R20', 'es'),
    (1475, '30.9', 'es'),
    (1476, '11.2', 'es'),
    (1477, '673', 'es'),
    (1478, '30.87', 'es'),
    (1479, '674', 'es'),
    (1480, '29.02', 'es'),
    (1481, '185', 'es'),
    (1482, 'Piloto Exalto A/S', 'es'),
    (1483, '22.8', 'es'),
    (1484, '7.5', 'es'),
    (1485, '912', 'es'),
    (1486, '82', 'es'),
    (1487, '185/60R14', 'es'),
    (1488, '8.5', 'es'),
    (1489, '869', 'es'),
    (1490, '205/55R15', 'es'),
    (1491, '215/60R16', 'es'),
    (1492, '806', 'es'),
    (1493, '225/55R16', 'es'),
    (1494, '812', 'es'),
    (1495, '225/60R15', 'es'),
    (1496, '839', 'es'),
    (1497, '205/55R16', 'es'),
    (1498, '215/55R16', 'es'),
    (1499, '24.1', 'es'),
    (1500, '862', 'es'),
    (1501, '205/50R16', 'es'),
    (1502, '24.5', 'es'),
    (1503, '850', 'es'),
    (1504, '205/60R15', 'es'),
    (1505, '215/65R15', 'es'),
    (1506, '816', 'es'),
    (1507, '215/50R17', 'es'),
    (1508, '205/50R17', 'es'),
    (1509, '24.9', 'es'),
    (1510, '834', 'es'),
    (1511, '225/50R16', 'es'),
    (1512, '235/45R17', 'es'),
    (1513, '195/65R15', 'es'),
    (1514, '7.91', 'es'),
    (1515, '9.7', 'es'),
    (1516, '205/65R15', 'es'),
    (1517, '867', 'es'),
    (1518, '195/60R15', 'es'),
    (1519, '23.5', 'es'),
    (1520, '8', 'es'),
    (1521, '886', 'es'),
    (1522, '85', 'es'),
    (1523, '195/55R15', 'es'),
    (1524, '23.2', 'es'),
    (1525, '895', 'es'),
    (1526, '195/60R14', 'es'),
    (1527, '873', 'es'),
    (1528, '84', 'es'),
    (1529, '195/50R16', 'es'),
    (1530, '913', 'es'),
    (1531, '195/50R15', 'es'),
    (1532, 'Pilot Exalto PE2', 'es'),
    (1533, '23.1', 'es'),
    (1534, '900', 'es'),
    (1535, '205/50R15', 'es'),
    (1536, '897', 'es'),
    (1537, '83', 'es'),
    (1538, '205/45ZR16', 'es'),
    (1539, '23.4', 'es'),
    (1540, '889', 'es'),
    (1541, '22.9', 'es'),
    (1542, '908', 'es'),
    (1543, '195/45R16', 'es'),
    (1544, '23.7', 'es'),
    (1545, '878', 'es'),
    (1546, '870', 'es'),
    (1547, '225/50ZR15', 'es'),
    (1548, '875', 'es'),
    (1549, '215/40ZR17', 'es'),
    (1550, '23', 'es'),
    (1551, '7.6', 'es'),
    (1552, '904', 'es'),
    (1553, '185/55R15', 'es'),
    (1554, '205/55ZR15', 'es'),
    (1555, '6.4', 'es'),
    (1556, '863', 'es'),
    (1557, '205/50ZR16', 'es'),
    (1558, '21.9', 'es'),
    (1559, '950', 'es'),
    (1560, '78', 'es'),
    (1561, '195/45R15', 'es'),
    (1562, '24.6', 'es'),
    (1563, '846', 'es'),
    (1564, '215/45ZR17', 'es'),
    (1565, '835', 'es'),
    (1566, '225/50ZR16', 'es'),
    (1567, '205/50ZR15', 'es'),
    (1568, '215/40ZR16', 'es'),
    (1569, '885', 'es'),
    (1570, '205/40ZR17', 'es'),
    (1571, '205/55ZR16', 'es'),
    (1572, '225/55ZR16', 'es'),
    (1573, '842', 'es'),
    (1574, '215/55ZR17', 'es'),
    (1575, '24.3', 'es'),
    (1576, '856', 'es'),
    (1577, '205/45ZR17', 'es'),
    (1578, '836', 'es'),
    (1579, '24.25', 'es'),
    (1580, '858', 'es'),
    (1581, '205/45R17', 'es'),
    (1582, 'Energía LX4', 'es'),
    (1583, '235/65R16', 'es'),
    (1584, 'P225/60R17', 'es'),
    (1585, 'P225/60R16', 'es'),
    (1586, 'P215/65R16', 'es'),
    (1587, '7.8', 'es'),
    (1588, '725', 'es'),
    (1589, '12.7', 'es'),
    (1590, 'P235/50R17', 'es'),
    (1591, '245/60R17', 'es'),
    (1592, '235/60R17', 'es'),
    (1593, '235-710R460A', 'es'),
    (1594, '28.58', 'es'),
    (1595, 'PS235-710R460A', 'es'),
    (1596, 'Turismo', 'es'),
    (1597, 'Energía MXV4 S8', 'es'),
    (1598, '793', 'es'),
    (1599, 'P215/60R16', 'es'),
    (1600, 'P215/55R17', 'es'),
    (1601, '736', 'es'),
    (1602, 'P235/55R18', 'es'),
    (1603, 'P205/65R15', 'es'),
    (1604, '830', 'es'),
    (1605, 'P225/50R17', 'es'),
    (1606, 'P205/60R16', 'es'),
    (1607, 'P235/55R17', 'es'),
    (1608, '23', 'es'),
    (1609, '8.5', 'es'),
    (1610, '12', 'es'),
    (1611, 'Skidmaster Premium', 'es'),
    (1612, '22.6', 'es'),
    (1613, '17', 'es'),
    (1614, '23X8.50-12', 'es'),
    (1615, '27', 'es'),
    (1616, '27X10.50-15', 'es'),
    (1617, '36.3', 'es'),
    (1618, '32', 'es'),
    (1619, '14', 'es'),
    (1620, '14-17.5', 'es'),
    (1621, '40.1', 'es'),
    (1622, '15.3', 'es'),
    (1623, '15-19.5', 'es'),
    (1624, 'CUV', 'es'),
    (1625, 'Clásico', 'es'),
    (1626, '15', 'es'),
    (1627, '107.95', 'es'),
    (1628, '1400', 'es'),
    (1629, '-89', 'es'),
    (1630, 'Acero', 'es'),
    (1631, '51 Negro Daytona', 'es'),
    (1632, '15″х14″/-89mm, 6x139.7', 'es'),
    (1633, '-63', 'es'),
    (1634, '15″х12″/-63mm, 6x139.7', 'es'),
    (1635, '83.82', 'es'),
    (1636, '1500', 'es'),
    (1637, '-38', 'es'),
    (1638, '15″х10″/-38mm, 5x114.3', 'es'),
    (1639, '15″х10″/-38mm, 5x127', 'es'),
    (1640, '15″х10″/-38mm, 5x139.7', 'es'),
    (1641, '15″х10″/-38mm, 6x139.7', 'es'),
    (1642, '16', 'es'),
    (1643, '130.81', 'es'),
    (1644, '3500', 'es'),
    (1645, '-25', 'es'),
    (1646, '16″х10″/-25mm, 8x165.1', 'es'),
    (1647, '8', 'es'),
    (1648, '-19', 'es'),
    (1649, '15″х8″/-19mm, 5x114.3', 'es'),
    (1650, '120.65', 'es'),
    (1651, '15″х8″/-19mm, 5x120.65', 'es'),
    (1652, '15″х8″/-19mm, 5x127', 'es'),
    (1653, '15″х8″/-19mm, 5x139.7', 'es'),
    (1654, '15″х8″/-19mm, 6x139.7', 'es'),
    (1655, '7', 'es'),
    (1656, '1600', 'es'),
    (1657, '-6', 'es'),
    (1658, '15″х7″/-6mm, 5x114.3', 'es'),
    (1659, '15″х7″/-6mm, 5x120.65', 'es'),
    (1660, '15″х7″/-6mm, 5x127', 'es'),
    (1661, '15″х7″/-6mm, 5x139.7', 'es'),
    (1662, '15″х7″/-6mm, 6x139.7', 'es'),
    (1663, '1700', 'es'),
    (1664, '16″х7″/0mm, 5x114.3', 'es'),
    (1665, '87.12', 'es'),
    (1666, '2000', 'es'),
    (1667, '16″х7″/0mm, 5x135', 'es'),
    (1668, '16″х7″/0mm, 5x127', 'es'),
    (1669, '16″х7″/0mm, 5x139.7', 'es'),
    (1670, '16″х7″/0mm, 6x139.7', 'es'),
    (1671, '16″х7″/0mm, 8x165.1', 'es'),
    (1672, '16″х8″/0mm, 5x114.3', 'es'),
    (1673, '16″х8″/0mm, 5x127', 'es'),
    (1674, '16″х8″/0mm, 5x139.7', 'es'),
    (1675, '16″х8″/0mm, 6x139.7', 'es'),
    (1676, '16″х8″/0mm, 8x165.1', 'es'),
    (1677, '17', 'es'),
    (1678, '17″х9″/0mm, 5x139.7', 'es'),
    (1679, '17″х9″/0mm, 6x139.7', 'es'),
    (1680, '17″х9″/0mm, 8x165.1', 'es'),
    (1681, '6', 'es'),
    (1682, '15″х8″/6mm, 5x114.3', 'es'),
    (1683, '15″х8″/6mm, 6x139.7', 'es'),
    (1684, '17″х8″/6mm, 5x139.7', 'es'),
    (1685, '17″х8″/6mm, 6x139.7', 'es'),
    (1686, '15″х7″/12mm, 5x114.3', 'es'),
    (1687, '15″х7″/12mm, 6x139.7', 'es'),
    (1688, '17″х8″/12mm, 8x165.1', 'es'),
    (1689, '19', 'es'),
    (1690, '15″х7″/19mm, 6x139.7', 'es'),
    (1691, 'Cromo', 'es'),
    (1692, '108.71', 'es'),
    (1693, '-32', 'es'),
    (1694, 'Batido 60 Cromo', 'es'),
    (1695, '15″х10″/-32mm, 6x139.7', 'es'),
    (1696, '81.03', 'es'),
    (1697, '15″х10″/-32mm, 5x114.3', 'es'),
    (1698, '15″х10″/-32mm, 5x127', 'es'),
    (1699, '-13', 'es'),
    (1700, '16″х10″/-13mm, 5x114.3', 'es'),
    (1701, '-12', 'es'),
    (1702, '15″х8″/-12mm, 6x139.7', 'es'),
    (1703, '14', 'es'),
    (1704, '14″х7″/0mm, 5x114.3', 'es'),
    (1705, '15″х7″/0mm, 6x139.7', 'es'),
    (1706, '15″х7″/0mm, 5x114.3', 'es'),
    (1707, '94.23', 'es'),
    (1708, '15″х7″/0mm, 5x127', 'es'),
    (1709, '107.95', 'es'),
    (1710, '3', 'es'),
    (1711, '15″х7″/3mm, 5x107.95', 'es'),
    (1712, '6', 'es'),
    (1713, '4', 'es'),
    (1714, '14″х6″/6mm, 4x107.95', 'es'),
    (1715, '14″х6″/6mm, 5x114.3', 'es'),
    (1716, '5', 'es'),
    (1717, '130', 'es'),
    (1718, '1200', 'es'),
    (1719, '15″х5″/6mm, 4x130', 'es'),
    (1720, '15″х6″/6mm, 5x114.3', 'es'),
    (1721, '16″х7″/6mm, 5x114.3', 'es'),
    (1722, '16″х6″/19mm, 5x114.3', 'es'),
    (1723, '16″х8″/19mm, 5x114.3', 'es'),
    (1724, '16″х6″/25mm, 5x114.3', 'es'),
    (1725, '100', 'es'),
    (1726, '67.95', 'es'),
    (1727, '16″х7″/35mm, 5x100', 'es'),
    (1728, '16″х7″/38mm, 5x114.3', 'es'),
    (1729, 'Mecanizado en bruto', 'es'),
    (1730, '61 Batido crudo', 'es'),
    (1731, '15″х8″/-6mm, 6x139.7', 'es'),
    (1732, '15″х8″/-6mm, 5x114.3', 'es'),
    (1733, '15″х8″/-6mm, 5x127', 'es'),
    (1734, '15″х7″/3mm, 6x139.7', 'es'),
    (1735, '15″х7″/3mm, 5x114.3', 'es'),
    (1736, '15″х7″/3mm, 5x127', 'es'),
    (1737, '15″х5″/6mm, 6x139.7', 'es'),
    (1738, '15″х5″/6mm, 5x114.3', 'es'),
    (1739, '15″х5″/6mm, 5x127', 'es'),
    (1740, '15″х6″/6mm, 6x139.7', 'es'),
    (1741, '15″х6″/6mm, 5x127', 'es'),
    (1742, '82.55', 'es'),
    (1743, '67 Supremo', 'es'),
    (1744, '15″х10″/-32mm, 5x114.3/127', 'es'),
    (1745, '-22', 'es'),
    (1746, '15″х6″/-22mm, 5x114.3/127', 'es'),
    (1747, '15″х8″/-22mm, 5x114.3/127', 'es'),
    (1748, '-16', 'es'),
    (1749, '14″х6″/-16mm, 5x114.3/127', 'es'),
    (1750, '13', 'es'),
    (1751, '13″х7″/-12mm, 5x114.3/127', 'es'),
    (1752, '14″х7″/-12mm, 5x114.3/127', 'es'),
    (1753, '15″х7″/-12mm, 5x114.3/127', 'es'),
    (1754, '2200', 'es'),
    (1755, '81 Negro Blando 8', 'es'),
    (1756, '16″х10″/-25mm, 5x139.7', 'es'),
    (1757, '16″х10″/-25mm, 6x139.7', 'es'),
    (1758, '86.87', 'es'),
    (1759, '2500', 'es'),
    (1760, '16″х8″/0mm, 5x135', 'es'),
    (1761, '17″х9″/0mm, 5x135', 'es'),
    (1762, '17″х9″/0mm, 5x127', 'es'),
    (1763, '17″х9″/0mm, 8x170', 'es'),
    (1764, '54M Negro mate Daytona', 'es'),
    (1765, '15″х10″/-44mm, 5x114.3', 'es'),
    (1766, '15″х10″/-44mm, 5x139.7', 'es'),
    (1767, '15″х10″/-44mm, 6x139.7', 'es'),
    (1768, '110.36', 'es'),
    (1769, '61B Batido negro', 'es'),
    (1770, 'Rojo', 'es'),
    (1771, '61R Batido rojo', 'es'),
    (1772, '62 Chrome Rallye', 'es'),
    (1773, '15″х10″/-32mm, 5x139.7', 'es'),
    (1774, '74.93', 'es'),
    (1775, '14″х7″/6mm, 4x107.95', 'es'),
    (1776, '14″х7″/6mm, 5x114.3', 'es'),
    (1777, '14″х6″/12mm, 4x107.95', 'es'),
    (1778, '14″х6″/12mm, 5x114.3', 'es'),
    (1779, '15″х6″/12mm, 5x127', 'es'),
    (1780, '15″х6″/12mm, 5x139.7', 'es'),
    (1781, '15″х6″/12mm, 6x139.7', 'es'),
    (1782, '15″х6″/12mm, 5x114.3', 'es'),
    (1783, '63 Rallye de plata', 'es'),
    (1784, '15″х8″/-12mm, 5x127', 'es'),
    (1785, '15″х5″/-6mm, 5x114.3', 'es'),
    (1786, '15″х7″/6mm, 5x127', 'es'),
    (1787, '15″х7″/6mm, 5x139.7', 'es'),
    (1788, '15″х7″/6mm, 6x139.7', 'es'),
    (1789, '15″х7″/6mm, 5x114.3', 'es'),
    (1790, '63 Rallye en bruto', 'es'),
    (1791, '87.88', 'es'),
    (1792, '65B Super Spoke', 'es'),
    (1793, '15″х10″/-32mm, 5x114.3/120.65', 'es'),
    (1794, '15″х8″/-6mm, 5x114.3/120.65', 'es'),
    (1795, '-3', 'es'),
    (1796, '14″х6″/-3mm, 5x114.3/120.65', 'es'),
    (1797, '15″х6″/-3mm, 5x114.3/120.65', 'es'),
    (1798, '14″х7″/3mm, 5x114.3/120.65', 'es'),
    (1799, '15″х7″/3mm, 5x114.3/120.65', 'es'),
    (1800, '65C Super Spoke', 'es'),
    (1801, 'Gris', 'es'),
    (1802, '124.21', 'es'),
    (1803, '5', 'es'),
    (1804, 'Acero para camiones ligeros', 'es'),
    (1805, '16″х6″/5mm, 8x165.1', 'es'),
    (1806, '116.08', 'es'),
    (1807, '124.46', 'es'),
    (1808, '121.16', 'es'),
    (1809, '123.95', 'es'),
    (1810, '5.2', 'es'),
    (1811, '16″х6″/5.2mm, 8x165.1', 'es'),
    (1812, '5.4', 'es'),
    (1813, '16″х6″/5.4mm, 8x165.1', 'es'),
    (1814, '125.22', 'es'),
    (1815, '16″х6″/5.4mm, 8x170', 'es'),
    (1816, '54B Negro Daytona', 'es'),
    (1817, 'Satin', 'es'),
    (1818, '67B Supremo', 'es'),
    (1819, '15″х10″/-76mm, 5x114.3/120.65', 'es'),
    (1820, '15″х8″/-63mm, 5x114.3/120.65', 'es'),
    (1821, '-54', 'es'),
    (1822, '13″х7″/-54mm, 5x114.3/120.65', 'es'),
    (1823, '14″х7″/-54mm, 5x114.3/120.65', 'es'),
    (1824, '-51', 'es'),
    (1825, '15″х7″/-51mm, 5x114.3/120.65', 'es'),
    (1826, '-48', 'es'),
    (1827, '14″х6″/-48mm, 5x114.3/120.65', 'es'),
    (1828, 'Invierno', 'es'),
    (1829, '72', 'es'),
    (1830, '70 Rueda de invierno OEM/Nieve', 'es'),
    (1831, '15″х6″/35mm, 4x108', 'es'),
    (1832, '15″х6″/35mm, 4x100/114.3', 'es'),
    (1833, '15″х6″/35mm, 5x100/115', 'es'),
    (1834, '15″х6″/35mm, 5x108/114.3', 'es'),
    (1835, '105', 'es'),
    (1836, '16″х6″/35mm, 5x105/115', 'es'),
    (1837, '16″х6″/35mm, 5x100/115', 'es'),
    (1838, '16″х6″/35mm, 5x108/114.3', 'es'),
    (1839, '16″х6″/35mm, 5x110/114.3', 'es'),
    (1840, '5.5', 'es'),
    (1841, '14″х5.5″/38mm, 4x108', 'es'),
    (1842, '14″х5.5″/38mm, 4x100/114.3', 'es'),
    (1843, '14″х5.5″/38mm, 5x100/115', 'es'),
    (1844, '14″х5.5″/38mm, 5x108/114.3', 'es'),
    (1845, '57.1', 'es'),
    (1846, '1562', 'es'),
    (1847, '15″х6″/38mm, 5x100', 'es'),
    (1848, '67', 'es'),
    (1849, '17″х7″/38mm, 5x112', 'es'),
    (1850, '1350', 'es'),
    (1851, '17″х7″/38mm, 4x108', 'es'),
    (1852, '17″х7″/38mm, 5x100/115', 'es'),
    (1853, '17″х7″/38mm, 5x108/114.3', 'es'),
    (1854, '17″х7″/38mm, 5x110/120', 'es'),
    (1855, '6.5', 'es'),
    (1856, '71.6', 'es'),
    (1857, '1560', 'es'),
    (1858, '40', 'es'),
    (1859, '16″х6.5″/40mm, 5x127', 'es'),
    (1860, '71.5', 'es'),
    (1861, '17″х6.5″/40mm, 5x114.3', 'es'),
    (1862, '65.1', 'es'),
    (1863, '42', 'es'),
    (1864, '17″х6.5″/42mm, 5x110', 'es'),
    (1865, '56.1', 'es'),
    (1866, '48', 'es'),
    (1867, '16″х6.5″/48mm, 5x100', 'es'),
    (1868, '50', 'es'),
    (1869, '17″х6.5″/50mm, 5x127', 'es'),
    (1870, '51', 'es'),
    (1871, '16″х7″/51mm, 5x127', 'es'),
    (1872, '64.1', 'es'),
    (1873, '54', 'es'),
    (1874, '16″х6.5″/54mm, 5x114.3', 'es'),
    (1875, 'Remolque', 'es'),
    (1876, 'Crudo Macinado', 'es'),
    (1877, 'Capa superior en polvo', 'es'),
    (1878, '120.65', 'es'),
    (1879, 'Remolque de acero Dual', 'es'),
    (1880, '16″х6″/mm, 8x165.1', 'es'),
    (1881, '4.5', 'es'),
    (1882, 'Radios mecanizados', 'es'),
    (1883, '-0.1', 'es'),
    (1884, 'Aluminio', 'es'),
    (1885, 'Brute', 'es'),
    (1886, '850', 'es'),
    (1887, '13″х4.5″/-0.1mm, 5x114.3', 'es'),
    (1888, '3045', 'es'),
    (1889, '0.3', 'es'),
    (1890, 'Ruedas de acero para camiones ligeros (sencillas)', 'es'),
    (1891, '16″х7″/0.3mm, 8x165.1', 'es'),
    (1892, '3750', 'es'),
    (1893, '0.5', 'es'),
    (1894, '16″х6″/0.5mm, 8x165.1', 'es'),
    (1895, 'Todo terreno', 'es'),
    (1896, 'Invierno', 'es'),
    (1897, '35', 'es'),
    (1898, '12.5', 'es'),
    (1899, 'Pinza para terrenos A/T G', 'es'),
    (1900, '35', 'es'),
    (1901, '12.5', 'es'),
    (1902, '15.5', 'es'),
    (1903, '121', 'es'),
    (1904, '35X12.50R20LT', 'es'),
    (1905, '37', 'es'),
    (1906, '36.38', 'es'),
    (1907, '12.64', 'es'),
    (1908, '126', 'es'),
    (1909, '37X12.50R20LT', 'es'),
    (1910, '121/118', 'es'),
    (1911, 'LT265/50R20', 'es'),
    (1912, '31.65', 'es'),
    (1913, '10.71', 'es'),
    (1914, 'LT265/70R17', 'es'),
    (1915, '31.89', 'es'),
    (1916, '11.18', 'es'),
    (1917, 'LT275/55R20', 'es'),
    (1918, '32.28', 'es'),
    (1919, '12.28', 'es'),
    (1920, 'LT285/55R20', 'es'),
    (1921, '32.64', 'es'),
    (1922, '11.61', 'es'),
    (1923, 'LT285/70R17', 'es'),
    (1924, '32.68', 'es'),
    (1925, '11.26', 'es'),
    (1926, 'LT285/75R16', 'es'),
    (1927, '33.15', 'es'),
    (1928, '13.03', 'es'),
    (1929, 'LT305/55R20', 'es'),
    (1930, '12.72', 'es'),
    (1931, '124', 'es'),
    (1932, 'LT305/60R18', 'es'),
    (1933, '32.48', 'es'),
    (1934, '12.52', 'es'),
    (1935, 'LT305/65R17', 'es'),
    (1936, '12.36', 'es'),
    (1937, 'LT305/70R16', 'es'),
    (1938, '34.69', 'es'),
    (1939, 'LT305/70R18', 'es'),
    (1940, '34.2', 'es'),
    (1941, '12.71', 'es'),
    (1942, 'LT315/70R17', 'es'),
    (1943, '34.37', 'es'),
    (1944, '12.32', 'es'),
    (1945, '127', 'es'),
    (1946, 'LT315/75R16', 'es'),
    (1947, '33', 'es'),
    (1948, '33X12.50R22LT', 'es'),
    (1949, '35X12.50R22LT', 'es'),
    (1950, 'Todo tiempo', 'es'),
    (1951, 'Terreno de barro', 'es'),
    (1952, 'Mud Terrain Attack M/T A', 'es'),
    (1953, '32.52', 'es'),
    (1954, 'Q', 'es'),
    (1955, '32.91', 'es'),
    (1956, '35X12.50R16LT', 'es'),
    (1957, '34.8', 'es'),
    (1958, '13.4', 'es'),
    (1959, '125', 'es'),
    (1960, '35X12.50R17LT', 'es'),
    (1961, '13.2', 'es'),
    (1962, '35X12.50R18LT', 'es'),
    (1963, '35.04', 'es'),
    (1964, '13.39', 'es'),
    (1965, '13.5', 'es'),
    (1966, '37', 'es'),
    (1967, '14', 'es'),
    (1968, '37X13.50R20LT', 'es'),
    (1969, '37X13.50R22LT', 'es'),
    (1970, '32.99', 'es'),
    (1971, '10.98', 'es'),
    (1972, 'LT275/60R20', 'es'),
    (1973, '32.83', 'es'),
    (1974, '11.93', 'es'),
    (1975, 'LT285/65R18', 'es'),
    (1976, '32.7', 'es'),
    (1977, '33.39', 'es'),
    (1978, 'LT325/50R22', 'es'),
    (1979, '33X12.50R20LT', 'es'),
    (1980, '24', 'es'),
    (1981, '21', 'es'),
    (1982, '118', 'es'),
    (1983, '35X13.50R24LT', 'es'),
    (1984, '37X13.50R24LT', 'es'),
    (1985, '40', 'es'),
    (1986, '15.5', 'es'),
    (1987, '40', 'es'),
    (1988, '16', 'es'),
    (1989, '128', 'es'),
    (1990, 'P', 'es'),
    (1991, '40X15.50R24LT', 'es'),
    (1992, '37X12.50R17LT', 'es'),
    (1993, '14.5', 'es'),
    (1994, '14.46', 'es'),
    (1995, '117', 'es'),
    (1996, '12', 'es'),
    (1997, '33X14.50R22LT', 'es'),
    (1998, '34.7', 'es'),
    (1999, '15.54', 'es'),
    (2000, '35X15.50R22LT', 'es'),
    (2001, '26', 'es'),
    (2002, '13.6', 'es'),
    (2003, '19.5', 'es'),
    (2004, '37X13.50R26LT', 'es'),
    (2005, '34.61', 'es'),
    (2006, '13.58', 'es'),
    (2007, '35X13.50R26LT', 'es'),
    (2008, '34.76', 'es'),
    (2009, '11.42', 'es'),
    (2010, '19.53', 'es'),
    (2011, '33X13.50R24', 'es'),
    (2012, '35X11.50R20LT', 'es'),
    (2013, '36.76', 'es'),
    (2014, '37X12.50R22LT', 'es'),
    (2015, '38', 'es'),
    (2016, '38X15.50R24LT', 'es'),
    (2017, '37.7', 'es'),
    (2018, '38X15.50R26LT', 'es'),
    (2019, '28', 'es'),
    (2020, '37X13.50R28LT', 'es'),
    (2021, 'Terrain Pro A/T P', 'es'),
    (2022, '34.4', 'es'),
    (2023, '12.7', 'es'),
    (2024, '32.5', 'es'),
    (2025, '34.6', 'es'),
    (2026, 'LT325/65R18', 'es'),
    (2027, '32.9', 'es'),
    (2028, '123/120', 'es'),
    (2029, '33.2', 'es'),
    (2030, '35.3', 'es'),
    (2031, 'LT325/60R20', 'es'),
    (2032, '15.1', 'es'),
    (2033, 'LT265/60R20', 'es'),
    (2034, '34.09', 'es'),
    (2035, 'LT275/65R20', 'es'),
    (2036, '33.46', 'es'),
    (2037, 'LT285/60R20', 'es'),
    (2038, 'LT285/45R22', 'es'),
    (2039, 'LT285/55R22', 'es'),
    (2040, 'LT275/70R18', 'es'),
    (2041, '35.12', 'es'),
    (2042, '11.77', 'es'),
    (2043, '129', 'es'),
    (2044, 'LT295/65R20', 'es'),
    (2045, '34.52', 'es'),
    (2046, '32.4', 'es'),
    (2047, '305/35R24', 'es'),
    (2048, '15.75', 'es'),
    (2049, '33X12.50R24LT', 'es'),
    (2050, '12.45', 'es'),
    (2051, '35X12.50R24LT', 'es'),
    (2052, 'Ataque al terreno A/T A', 'es'),
    (2053, '305/40R22', 'es'),
    (2054, 'Remolque', 'es'),
    (2055, '385', 'es'),
    (2056, '22.5', 'es'),
    (2057, 'Endu Trax Ma HD', 'es'),
    (2058, '42.2', 'es'),
    (2059, '15.04', 'es'),
    (2060, '22', 'es'),
    (2061, '164', 'es'),
    (2062, 'K', 'es'),
    (2063, '22', 'es'),
    (2064, '385/65R22.5', 'es'),
    (2065, 'Camión mediano', 'es'),
    (2066, 'Endu Trax Ma', 'es'),
    (2067, '42.6', 'es'),
    (2068, '157', 'es'),
    (2069, '20', 'es'),
    (2070, '315/80R22.5', 'es'),
    (2071, '146/143', 'es'),
    (2072, 'L', 'es'),
    (2073, '16', 'es'),
    (2074, '11R22.5', 'es'),
    (2075, '149/146', 'es'),
    (2076, '11R24.5', 'es'),
    (2077, '285/65R22.5', 'es'),
    (2078, 'Endu Trax MD', 'es'),
    (2079, '43.1', 'es'),
    (2080, '30', 'es'),
    (2081, '17.5', 'es'),
    (2082, 'Endu Combi RT', 'es'),
    (2083, '143', 'es'),
    (2084, '245/70R17.5', 'es'),
    (2085, '235/75R17.5', 'es'),
    (2086, '135', 'es'),
    (2087, '215/75R17.5', 'es'),
    (2088, '144', 'es'),
    (2089, '295/75R22.5', 'es'),
    (2090, '149', 'es'),
    (2091, '40.9', 'es'),
    (2092, '144/142', 'es'),
    (2093, '148', 'es'),
    (2094, '275/70R22.5', 'es'),
    (2095, '138', 'es'),
    (2096, '255/70R22.5', 'es'),
    (2097, '140', 'es'),
    (2098, '19.5', 'es'),
    (2099, '265/70R19.5', 'es'),
    (2100, 'Endu Combi RD CS', 'es'),
    (2101, '41.4', 'es'),
    (2102, '25', 'es'),
    (2103, '126.6', 'es'),
    (2104, '40.4', 'es'),
    (2105, 'Endu Combi RD Os', 'es'),
    (2106, 'M', 'es'),
    (2107, '132', 'es'),
    (2108, '136', 'es'),
    (2109, '121.8', 'es'),
    (2110, '34.1', 'es'),
    (2111, 'Agarrador de barro', 'es'),
    (2112, '33.07', 'es'),
    (2113, '13.94', 'es'),
    (2114, '628', 'es'),
    (2115, '33X13.50R15LT', 'es'),
    (2116, '14.57', 'es'),
    (2117, '596', 'es'),
    (2118, '35X14.50R15LT', 'es'),
    (2119, '37.64', 'es'),
    (2120, '15.55', 'es'),
    (2121, '38X15.50R15LT', 'es'),
    (2122, '32.95', 'es'),
    (2123, '12.68', 'es'),
    (2124, '33X12.50R17LT', 'es'),
    (2125, '34.84', 'es'),
    (2126, '13.19', 'es'),
    (2127, '37.05', 'es'),
    (2128, '560', 'es'),
    (2129, '131', 'es'),
    (2130, '37X13.50R17LT', 'es'),
    (2131, '39.72', 'es'),
    (2132, '40X13.50R17LT', 'es'),
    (2133, '33X12.50R18LT', 'es'),
    (2134, '592', 'es'),
    (2135, '14.17', 'es'),
    (2136, '37X13.50R18LT', 'es'),
    (2137, '37.72', 'es'),
    (2138, '16.3', 'es'),
    (2139, '38X15.50R18LT', 'es'),
    (2140, '14.13', 'es'),
    (2141, '38X15.50R20LT', 'es'),
    (2142, '15.91', 'es'),
    (2143, '130', 'es'),
    (2144, '40X15.50R20LT', 'es'),
    (2145, '40X15.50R22LT', 'es'),
    (2146, '12.01', 'es'),
    (2147, '19.7', 'es'),
    (2148, '34.96', 'es'),
    (2149, '12.87', 'es'),
    (2150, '20.7', 'es'),
    (2151, '15.35', 'es'),
    (2152, 'LT385/70R16', 'es'),
    (2153, 'Terreno extremo', 'es'),
    (2154, 'Dune Grappler', 'es'),
    (2155, '31X10.50R15LT', 'es'),
    (2156, '12.83', 'es'),
    (2157, '640', 'es'),
    (2158, '33X12.50R15LT', 'es'),
    (2159, '32.76', 'es'),
    (2160, '11.57', 'es'),
    (2161, '16.5', 'es'),
    (2162, '32.72', 'es'),
    (2163, '635', 'es'),
    (2164, '34.57', 'es'),
    (2165, '12.73', 'es'),
    (2166, '601', 'es'),
    (2167, '11.73', 'es'),
    (2168, '637', 'es'),
    (2169, '33.82', 'es'),
    (2170, 'LT305/70R17', 'es'),
    (2171, '34.41', 'es'),
    (2172, '12.76', 'es'),
    (2173, '604', 'es'),
    (2174, '36.5', 'es'),
    (2175, '13.11', 'es'),
    (2176, '37X12.50R18LT', 'es'),
    (2177, '639', 'es'),
    (2178, '11.65', 'es'),
    (2179, '664', 'es'),
    (2180, '14.1', 'es'),
    (2181, '305/60R18', 'es'),
    (2182, '34.92', 'es'),
    (2183, '13.15', 'es'),
    (2184, '33.11', 'es'),
    (2185, '15.6', 'es'),
    (2186, 'LT325/60R18', 'es'),
    (2187, '36.42', 'es'),
    (2188, '11.02', 'es'),
    (2189, '32.36', 'es'),
    (2190, '642', 'es'),
    (2191, '35.08', 'es'),
    (2192, '32.05', 'es'),
    (2193, '285/45R22', 'es'),
    (2194, '12.05', 'es'),
    (2195, '305/45R22', 'es'),
    (2196, '31.76', 'es'),
    (2197, 'Terra Grappler', 'es'),
    (2198, '31.54', 'es'),
    (2199, '659', 'es'),
    (2200, '119', 'es'),
    (2201, 'LT265/75R16', 'es'),
    (2202, '11.34', 'es'),
    (2203, '636', 'es'),
    (2204, '33.27', 'es'),
    (2205, '624', 'es'),
    (2206, 'LT295/75R16', 'es'),
    (2207, '34.49', 'es'),
    (2208, '602', 'es'),
    (2209, '31.69', 'es'),
    (2210, '9.18', 'es'),
    (2211, '15.2', 'es'),
    (2212, 'LT235/80R17', 'es'),
    (2213, '31.61', 'es'),
    (2214, '31.57', 'es'),
    (2215, '10.79', 'es'),
    (2216, '13.6', 'es'),
    (2217, '33.19', 'es'),
    (2218, '12.13', 'es'),
    (2219, '16.4', 'es'),
    (2220, '626', 'es'),
    (2221, 'LT295/70R17', 'es'),
    (2222, '33.98', 'es'),
    (2223, '611', 'es'),
    (2224, '13.12', 'es'),
    (2225, '594', 'es'),
    (2226, 'LT325/70R17', 'es'),
    (2227, '52.1', 'es'),
    (2228, '20.5', 'es'),
    (2229, '34', 'es'),
    (2230, '11.06', 'es'),
    (2231, '275/65R18', 'es'),
    (2232, '32.01', 'es'),
    (2233, '10.83', 'es'),
    (2234, 'LT275/65R18', 'es'),
    (2235, '31.38', 'es'),
    (2236, '11.54', 'es'),
    (2237, '13.1', 'es'),
    (2238, 'LT285/60R18', 'es'),
    (2239, '34.88', 'es'),
    (2240, '12.99', 'es'),
    (2241, '355', 'es'),
    (2242, '36.69', 'es'),
    (2243, '14.02', 'es'),
    (2244, '566', 'es'),
    (2245, 'LT355/65R18', 'es'),
    (2246, '609', 'es'),
    (2247, '653', 'es'),
    (2248, '275/55R20', 'es'),
    (2249, '625', 'es'),
    (2250, '32.09', 'es'),
    (2251, '12.2', 'es'),
    (2252, '13.9', 'es'),
    (2253, '647', 'es'),
    (2254, '12.91', 'es'),
    (2255, '36.77', 'es'),
    (2256, '565', 'es'),
    (2257, 'LT355/60R20', 'es'),
    (2258, '11.81', 'es'),
    (2259, '33.23', 'es'),
    (2260, 'LT285/50R22', 'es'),
    (2261, '12.95', 'es'),
    (2262, '285/40R24', 'es'),
    (2263, '36.54', 'es'),
    (2264, '569', 'es'),
    (2265, 'LT315/50R24', 'es'),
    (2266, '30.67', 'es'),
    (2267, '10.55', 'es'),
    (2268, '36.46', 'es'),
    (2269, '13.43', 'es'),
    (2270, '50', 'es'),
    (2271, '29.45', 'es'),
    (2272, '9.69', 'es'),
    (2273, '12.6', 'es'),
    (2274, '30.31', 'es'),
    (2275, '9.72', 'es'),
    (2276, '12.9', 'es'),
    (2277, 'P245/70R17', 'es'),
    (2278, '30.55', 'es'),
    (2279, '10.63', 'es'),
    (2280, '680', 'es'),
    (2281, 'P265/65R17', 'es'),
    (2282, '11.46', 'es'),
    (2283, '13.4', 'es'),
    (2284, 'P285/70R17', 'es'),
    (2285, '33.86', 'es'),
    (2286, '614', 'es'),
    (2287, 'LT285/75R17', 'es'),
    (2288, '10.28', 'es'),
    (2289, '255/60R18', 'es'),
    (2290, '10.67', 'es'),
    (2291, 'P265/70R18', 'es'),
    (2292, '16.6', 'es'),
    (2293, 'LT295/70R18', 'es'),
    (2294, '32.44', 'es'),
    (2295, '12.24', 'es'),
    (2296, '30.51', 'es'),
    (2297, '643', 'es'),
    (2298, '34.45', 'es'),
    (2299, 'LT295/60R20', 'es'),
    (2300, '305/55R20', 'es'),
    (2301, '11.89', 'es'),
    (2302, 'P305/45R22', 'es'),
    (2303, '12.17', 'es'),
    (2304, 'P305/35R24', 'es'),
    (2305, 'LT245/75R17', 'es'),
    (2306, '31.06', 'es'),
    (2307, '10.16', 'es'),
    (2308, '9.17', 'es'),
    (2309, 'P235/75R17', 'es'),
    (2310, 'LT325/70R16', 'es'),
    (2311, 'Dura Grappler', 'es'),
    (2312, '9.57', 'es'),
    (2313, '407', 'es'),
    (2314, '9.96', 'es'),
    (2315, '424', 'es'),
    (2316, '32.87', 'es'),
    (2317, '16.9', 'es'),
    (2318, '393', 'es'),
    (2319, '32.79', 'es'),
    (2320, '12.56', 'es'),
    (2321, '394', 'es'),
    (2322, '31.77', 'es'),
    (2323, '9.32', 'es'),
    (2324, '406', 'es'),
    (2325, '30.59', 'es'),
    (2326, '15.7', 'es'),
    (2327, '422', 'es'),
    (2328, 'LT245/70R17', 'es'),
    (2329, '438', 'es'),
    (2330, '409', 'es'),
    (2331, '423', 'es'),
    (2332, '265/65R17', 'es'),
    (2333, '382', 'es'),
    (2334, '11.49', 'es'),
    (2335, '32.17', 'es'),
    (2336, '10.08', 'es'),
    (2337, '401', 'es'),
    (2338, '388', 'es'),
    (2339, '35.28', 'es'),
    (2340, '17.3', 'es'),
    (2341, '366', 'es'),
    (2342, '33.03', 'es'),
    (2343, '391', 'es'),
    (2344, '34.05', 'es'),
    (2345, '379', 'es'),
    (2346, '405', 'es'),
    (2347, '390', 'es'),
    (2348, '10.51', 'es'),
    (2349, '16.8', 'es'),
    (2350, '408', 'es'),
    (2351, '410', 'es'),
    (2352, '402', 'es'),
    (2353, 'Neo Gen', 'es'),
    (2354, '23.07', 'es'),
    (2355, '8.39', 'es'),
    (2356, '24.02', 'es'),
    (2357, '865', 'es'),
    (2358, '23.35', 'es'),
    (2359, '8.31', 'es'),
    (2360, '890', 'es'),
    (2361, '205/45R16', 'es'),
    (2362, '22.48', 'es'),
    (2363, '8.58', 'es'),
    (2364, '924', 'es'),
    (2365, '205/40R16', 'es'),
    (2366, '23.54', 'es'),
    (2367, '882', 'es'),
    (2368, '24.76', 'es'),
    (2369, '9.8', 'es'),
    (2370, '25.91', 'es'),
    (2371, '9.06', 'es'),
    (2372, '225/50ZR17', 'es'),
    (2373, '25.08', 'es'),
    (2374, '26.22', 'es'),
    (2375, '9.53', 'es'),
    (2376, '10.1', 'es'),
    (2377, '24.53', 'es'),
    (2378, '847', 'es'),
    (2379, '215/40ZR18', 'es'),
    (2380, '215/35ZR18', 'es'),
    (2381, '25.12', 'es'),
    (2382, '827', 'es'),
    (2383, '25.43', 'es'),
    (2384, '9.49', 'es'),
    (2385, '25.75', 'es'),
    (2386, '10.2', 'es'),
    (2387, '24.88', 'es'),
    (2388, '215/35ZR19', 'es'),
    (2389, '25.79', 'es'),
    (2390, '26.54', 'es'),
    (2391, '10.6', 'es'),
    (2392, '26.42', 'es'),
    (2393, '9.02', 'es'),
    (2394, '225/35ZR20', 'es'),
    (2395, '25.35', 'es'),
    (2396, '8.82', 'es'),
    (2397, '225/30ZR20', 'es'),
    (2398, '25.71', 'es'),
    (2399, '9.45', 'es'),
    (2400, '808', 'es'),
    (2401, '25.98', 'es'),
    (2402, '27.76', 'es'),
    (2403, '748', 'es'),
    (2404, '235/30ZR22', 'es'),
    (2405, '24.33', 'es'),
    (2406, '8.23', 'es'),
    (2407, '8.86', 'es'),
    (2408, 'Invo', 'es'),
    (2409, '24.96', 'es'),
    (2410, '27.05', 'es'),
    (2411, '10.31', 'es'),
    (2412, 'P255/50ZR17', 'es'),
    (2413, '8.94', 'es'),
    (2414, '225/45R18', 'es'),
    (2415, '225/40R18', 'es'),
    (2416, '25.39', 'es'),
    (2417, '818', 'es'),
    (2418, '245/50ZR18', 'es'),
    (2419, '26.69', 'es'),
    (2420, '245/45R18', 'es'),
    (2421, '10.04', 'es'),
    (2422, '255/45R18', 'es'),
    (2423, '255/35R18', 'es'),
    (2424, '26.65', 'es'),
    (2425, '779', 'es'),
    (2426, '25.55', 'es'),
    (2427, '26.02', 'es'),
    (2428, '25.51', 'es'),
    (2429, '9.37', 'es'),
    (2430, '25.47', 'es'),
    (2431, '9.84', 'es'),
    (2432, '796', 'es'),
    (2433, '27.17', 'es'),
    (2434, '13.35', 'es'),
    (2435, '245/45ZR20', 'es'),
    (2436, '245/40ZR20', 'es'),
    (2437, '26.77', 'es'),
    (2438, '804', 'es'),
    (2439, '10.12', 'es'),
    (2440, '255/45ZR20', 'es'),
    (2441, '27.01', 'es'),
    (2442, '9.92', 'es'),
    (2443, '26.14', 'es'),
    (2444, '28.62', 'es'),
    (2445, '28.11', 'es'),
    (2446, '13.66', 'es'),
    (2447, '345/25ZR20', 'es'),
    (2448, '27.83', 'es'),
    (2449, '9.61', 'es'),
    (2450, '245/30ZR22', 'es'),
    (2451, '29.06', 'es'),
    (2452, '255/35ZR22', 'es'),
    (2453, '28.03', 'es'),
    (2454, '28.39', 'es'),
    (2455, '265/30ZR22', 'es'),
    (2456, '275/30ZR22', 'es'),
    (2457, '28.82', 'es'),
    (2458, '285/30ZR22', 'es'),
    (2459, '275/25ZR24', 'es'),
    (2460, '9.33', 'es'),
    (2461, '10.39', 'es'),
    (2462, '265/35R18', 'es'),
    (2463, '26.18', 'es'),
    (2464, '26.97', 'es'),
    (2465, '225/45ZR19', 'es'),
    (2466, '10.24', 'es'),
    (2467, '9.1', 'es'),
    (2468, '25.31', 'es'),
    (2469, '25.59', 'es'),
    (2470, '26.57', 'es'),
    (2471, '12.48', 'es'),
    (2472, '325/30ZR19', 'es'),
    (2473, '9.25', 'es'),
    (2474, '275/25ZR20', 'es'),
    (2475, '275/30ZR20', 'es'),
    (2476, '27.72', 'es'),
    (2477, '24.72', 'es'),
    (2478, '225/35R19', 'es'),
    (2479, '255/30R19', 'es'),
    (2480, '26.06', 'es'),
    (2481, 'Carrera', 'es'),
    (2482, 'NT555R', 'es'),
    (2483, '22.84', 'es'),
    (2484, '6.3', 'es'),
    (2485, '205/55R14', 'es'),
    (2486, 'P275/60R15', 'es'),
    (2487, 'P275/50R15', 'es'),
    (2488, '27.99', 'es'),
    (2489, '5', 'es'),
    (2490, '325/50R15', 'es'),
    (2491, '25.67', 'es'),
    (2492, '811', 'es'),
    (2493, 'P245/50R16', 'es'),
    (2494, 'P245/45R17', 'es'),
    (2495, '25.63', 'es'),
    (2496, 'P275/40R17', 'es'),
    (2497, '315/35R17', 'es'),
    (2498, '285/35ZR18', 'es'),
    (2499, '28.78', 'es'),
    (2500, '305/45R18', 'es'),
    (2501, 'P305/40R18', 'es'),
    (2502, '305/35ZR18', 'es'),
    (2503, '305/35R20', 'es'),
    (2504, '26.89', 'es'),
    (2505, '285/40ZR18', 'es'),
    (2506, 'NT555RII', 'es'),
    (2507, '25.87', 'es'),
    (2508, '499', 'es'),
    (2509, '461', 'es'),
    (2510, '13.23', 'es'),
    (2511, '464', 'es'),
    (2512, 'P325/50R15', 'es'),
    (2513, '503', 'es'),
    (2514, '245/50R16', 'es'),
    (2515, '245/45R17', 'es'),
    (2516, 'P315/35R17', 'es'),
    (2517, '484', 'es'),
    (2518, 'P275/40R18', 'es'),
    (2519, 'P285/40R18', 'es'),
    (2520, '449', 'es'),
    (2521, 'P305/45R18', 'es'),
    (2522, '467', 'es'),
    (2523, '27.44', 'es'),
    (2524, '470', 'es'),
    (2525, '305/35R19', 'es'),
    (2526, '27.56', 'es'),
    (2527, '469', 'es'),
    (2528, '275/35R20', 'es'),
    (2529, '451', 'es'),
    (2530, '482', 'es'),
    (2531, '285/30R20', 'es'),
    (2532, '27.24', 'es'),
    (2533, '305/30R20', 'es'),
    (2534, '28.43', 'es'),
    (2535, '454', 'es'),
    (2536, 'P305/45R17', 'es'),
    (2537, '488', 'es'),
    (2538, '305/35R18', 'es'),
    (2539, '468', 'es'),
    (2540, '27.91', 'es'),
    (2541, '462', 'es'),
    (2542, 'P315/40R18', 'es'),
    (2543, '498', 'es'),
    (2544, 'P335/30R18', 'es'),
    (2545, '480', 'es'),
    (2546, '285/35R19', 'es'),
    (2547, '13.78', 'es'),
    (2548, '475', 'es'),
    (2549, '345/30R19', 'es'),
    (2550, '11.85', 'es'),
    (2551, '459', 'es'),
    (2552, '295/35R20', 'es'),
    (2553, '12.44', 'es'),
    (2554, '403', 'es'),
    (2555, 'NT01', 'es'),
    (2556, '22.76', 'es'),
    (2557, '205/55ZR14', 'es'),
    (2558, '22.95', 'es'),
    (2559, '8.35', 'es'),
    (2560, '905', 'es'),
    (2561, '225/45ZR15', 'es'),
    (2562, '245/50ZR16', 'es'),
    (2563, '23.46', 'es'),
    (2564, '80', 'es'),
    (2565, '24.65', 'es'),
    (2566, '844', 'es'),
    (2567, '838', 'es'),
    (2568, '24.92', 'es'),
    (2569, '10.35', 'es'),
    (2570, '26.26', 'es'),
    (2571, '27.48', 'es'),
    (2572, '315/30ZR20', 'es'),
    (2573, '26.34', 'es'),
    (2574, '315/35ZR17', 'es'),
    (2575, '27.87', 'es'),
    (2576, '285/35ZR20', 'es'),
    (2577, 'Trail Grappler M/T', 'es'),
    (2578, '18.9', 'es'),
    (2579, 'LT285/70R16', 'es'),
    (2580, '370', 'es'),
    (2581, '33.54', 'es'),
    (2582, '11.97', 'es'),
    (2583, '19.4', 'es'),
    (2584, '385', 'es'),
    (2585, '368', 'es'),
    (2586, '373', 'es'),
    (2587, 'LT295/55R20', 'es'),
    (2588, '35.47', 'es'),
    (2589, '20', 'es'),
    (2590, '13.82', 'es'),
    (2591, '38X13.50R24LT', 'es'),
    (2592, '18.3', 'es'),
    (2593, 'LT255/75R17', 'es'),
    (2594, '31.97', 'es'),
    (2595, '404', 'es'),
    (2596, '378', 'es'),
    (2597, '13.27', 'es'),
    (2598, '36.85', 'es'),
    (2599, '350', 'es'),
    (2600, '33.62', 'es'),
    (2601, '19.1', 'es'),
    (2602, '384', 'es'),
    (2603, '34.53', 'es'),
    (2604, '371', 'es'),
    (2605, '37.76', 'es'),
    (2606, '39.76', 'es'),
    (2607, '324', 'es'),
    (2608, '34.33', 'es'),
    (2609, '351', 'es'),
    (2610, '32.6', 'es'),
    (2611, 'LT285/75R18', 'es'),
    (2612, '372', 'es'),
    (2613, '35X11.50R18LT', 'es'),
    (2614, '35.59', 'es'),
    (2615, '20.2', 'es'),
    (2616, '37X11.50R20LT', 'es'),
    (2617, '38X13.50R20LT', 'es'),
    (2618, '33.43', 'es'),
    (2619, '14.41', 'es'),
    (2620, 'LT355/40R22', 'es'),
    (2621, '375', 'es'),
    (2622, '35.55', 'es'),
    (2623, '14.96', 'es'),
    (2624, 'LT375/45R22', 'es'),
    (2625, '38X13.50R22LT', 'es'),
    (2626, '36.06', 'es'),
    (2627, 'LT375/40R24', 'es'),
    (2628, '35X11.50R17LT', 'es'),
    (2629, '39.75', 'es'),
    (2630, '15.5', 'es'),
    (2631, '40X15.50R26LT', 'es'),
    (2632, '42', 'es'),
    (2633, '41.77', 'es'),
    (2634, '42X15.50R26LT', 'es'),
    (2635, '33.7', 'es'),
    (2636, '42X13.50R20LT', 'es'),
    (2637, '42X15.50R22LT', 'es'),
    (2638, '35.43', 'es'),
    (2639, '14.21', 'es'),
    (2640, 'LT355/40R24', 'es'),
    (2641, '42X15.50R24LT', 'es'),
    (2642, '342', 'es'),
    (2643, '38X13.50R17LT', 'es'),
    (2644, '36.8', 'es'),
    (2645, 'NT05', 'es'),
    (2646, '24.45', 'es'),
    (2647, '7.2', 'es'),
    (2648, '235/40R18', 'es'),
    (2649, '10.59', 'es'),
    (2650, '28.46', 'es'),
    (2651, '295/45ZR18', 'es'),
    (2652, '245/35R19', 'es'),
    (2653, '275/30R19', 'es'),
    (2654, '13.31', 'es'),
    (2655, '335/30ZR19', 'es'),
    (2656, '23.11', 'es'),
    (2657, '9.29', 'es'),
    (2658, '305/35ZR19', 'es'),
    (2659, '305/30ZR20', 'es'),
    (2660, '295/40ZR18', 'es'),
    (2661, 'Motivo', 'es'),
    (2662, '25.16', 'es'),
    (2663, '8.46', 'es'),
    (2664, '215/50ZR17', 'es'),
    (2665, '24.61', 'es'),
    (2666, '8.54', 'es'),
    (2667, '9.09', 'es'),
    (2668, '27.36', 'es'),
    (2669, '9.88', 'es'),
    (2670, '235/55ZR17', 'es'),
    (2671, '25.04', 'es'),
    (2672, '26.38', 'es'),
    (2673, '235/45ZR18', 'es'),
    (2674, '28.07', 'es'),
    (2675, '235/55ZR18', 'es'),
    (2676, '28.74', 'es'),
    (2677, '29.29', 'es'),
    (2678, '28.54', 'es'),
    (2679, '245/55ZR18', 'es'),
    (2680, '28.98', 'es'),
    (2681, '10.47', 'es'),
    (2682, '255/55ZR18', 'es'),
    (2683, '27.09', 'es'),
    (2684, '9.21', 'es'),
    (2685, '225/55ZR17', 'es'),
    (2686, '245/50ZR17', 'es'),
    (2687, '225/50ZR18', 'es'),
    (2688, '245/50ZR19', 'es'),
    (2689, '255/50ZR19', 'es'),
    (2690, '29.96', 'es'),
    (2691, '255/55ZR19', 'es'),
    (2692, '10.87', 'es'),
    (2693, '275/45ZR19', 'es'),
    (2694, '275/55ZR19', 'es'),
    (2695, '11.38', 'es'),
    (2696, '245/45ZR19', 'es'),
    (2697, '255/45ZR19', 'es'),
    (2698, '295/30ZR20', 'es'),
    (2699, 'NT421Q', 'es'),
    (2700, '27.64', 'es'),
    (2701, '8.98', 'es'),
    (2702, '12.1', 'es'),
    (2703, '453', 'es'),
    (2704, '12.2', 'es'),
    (2705, '444', 'es'),
    (2706, '12.3', 'es'),
    (2707, '437', 'es'),
    (2708, '447', 'es'),
    (2709, '11.8', 'es'),
    (2710, '465', 'es'),
    (2711, '225/55R18', 'es'),
    (2712, '28.15', 'es'),
    (2713, '235/55R18', 'es'),
    (2714, '30.04', 'es'),
    (2715, '430', 'es'),
    (2716, '445', 'es'),
    (2717, '416', 'es'),
    (2718, '255/65R18', 'es'),
    (2719, '265/65R18', 'es'),
    (2720, '456', 'es'),
    (2721, '29.17', 'es'),
    (2722, '442', 'es'),
    (2723, '29.65', 'es'),
    (2724, '436', 'es'),
    (2725, '10.43', 'es'),
    (2726, '255/60R19', 'es'),
    (2727, '10.91', 'es'),
    (2728, '30.16', 'es'),
    (2729, '428', 'es'),
    (2730, '235/55R20', 'es'),
    (2731, '29.69', 'es'),
    (2732, '435', 'es'),
    (2733, '245/50R20', 'es'),
    (2734, '255/45R20', 'es'),
    (2735, '30.08', 'es'),
    (2736, '429', 'es'),
    (2737, '31.02', 'es'),
    (2738, '434', 'es'),
    (2739, '275/60R20', 'es'),
    (2740, '225/55R19', 'es'),
    (2741, '418', 'es'),
    (2742, 'Exo Grappler Awt', 'es'),
    (2743, '31.73', 'es'),
    (2744, '18.4', 'es'),
    (2745, '400', 'es'),
    (2746, '386', 'es'),
    (2747, '376', 'es'),
    (2748, '32.13', 'es'),
    (2749, '396', 'es'),
    (2750, '383', 'es'),
    (2751, 'LT285/65R20', 'es'),
    (2752, '19.3', 'es'),
    (2753, '380', 'es'),
    (2754, 'LT285/70R18', 'es'),
    (2755, 'LT265/65R18', 'es'),
    (2756, '205/40R18', 'es'),
    (2757, '235/35R19', 'es'),
    (2758, '18', 'es'),
    (2759, '19', 'es'),
    (2760, '1477', 'es'),
    (2761, '168', 'es'),
    (2762, 'V', 'es'),
    (2763, '245/50R18', 'es'),
    (2764, '7', 'es'),
    (2765, '7', 'es'),
    (2766, '17', 'es'),
    (2767, '18', 'es'),
    (2768, '8', 'es'),
    (2769, '18″х8″', 'es'),
    (2770, '7.5', 'es'),
    (2771, '17″х7.5″', 'es'),
    (2772, '17″х7″/-44mm, 5x127/139.7', 'es'),
    (2773, '98', 'es'),
    (2774, '19″х8.5″/-44mm, 5x127/139.7', 'es'),
    (2775, '225/40R19', 'es'),
    (2776, '225/50R17', 'es'),
    (2777, '17″х7.5″/-44mm, 5x127/139.7', 'es'),
    (2778, '114', 'es'),
    (2779, '20″х8.5″', 'es'),
    (2780, '19″х8″', 'es'),
    (2781, '18″х7.5″', 'es'),
    (2782, '18\" DIAMETER (18\" x 8\")', 'es'),
    (2783, '19\" DIAMETER (19\" x 8\")', 'es'),
    (2784, '17″х7″', 'es'),
    (2785, '19\" DIAMETER (19\" x 8.5\")', 'es'),
    (2786, '20\" DIAMETER (20\" x 8.5\")', 'es'),
    (2787, '21\" DIAMETER (21\" x 8.5\")', 'es'),
    (2788, '21', 'es'),
    (2789, '21″х8.5″', 'es'),
    (2790, '205/45R17', 'es'),
    (2791, '19″х8.5″', 'es'),
    (2792, 'Imprimir', 'es'),
    (2793, 'Negro y rojo', 'es'),
    (245, 'S', 'en'),
    (246, 'M', 'en'),
    (247, 'L', 'en'),
    (248, 'XL', 'en'),
    (482, 'HALO', 'en'),
    (485, 'EBC', 'en'),
    (494, 'EBC Brakes', 'en'),
    (497, 'Steel', 'en'),
    (498, 'Stainless Steel', 'en'),
    (499, 'Steel', 'en'),
    (500, 'Stainless Steel', 'en'),
    (501, 'Steel', 'en'),
    (502, 'Stainless Steel', 'en'),
    (503, 'Blue-Red', 'en'),
    (504, 'White-Yellow', 'en'),
    (505, 'Xprite', 'en'),
    (506, 'Lumen', 'en'),
    (507, 'Morimoto', 'en'),
    (508, 'ACDelco', 'en'),
    (509, 'ACT', 'en'),
    (510, 'aFe', 'en'),
    (511, 'AMS', 'en'),
    (512, 'APR', 'en'),
    (514, 'Borla', 'en'),
    (515, 'BOYO', 'en'),
    (516, 'CalTrend', 'en'),
    (517, 'Centerforce', 'en'),
    (518, 'CFR Performance', 'en'),
    (519, 'Classic Instruments', 'en'),
    (520, 'Coverking', 'en'),
    (521, 'Dorman', 'en'),
    (522, 'Garmin', 'en'),
    (523, 'Gastokyle', 'en'),
    (524, 'GEKO', 'en'),
    (525, 'GrimmSpeed', 'en'),
    (526, 'Innovate Motorsports', 'en'),
    (527, 'McGard', 'en'),
    (528, 'MagnaFlow', 'en'),
    (529, 'Michelin', 'en'),
    (530, 'Mishimoto', 'en'),
    (531, 'OER', 'en'),
    (532, 'Oracle Lighting', 'en'),
    (533, 'Pilot', 'en'),
    (534, 'RAM Clutches', 'en'),
    (535, 'Rotiform', 'en'),
    (536, 'Seibon', 'en'),
    (537, 'Spectre', 'en'),
    (538, 'Spyder', 'en'),
    (539, 'Steelcraft', 'en'),
    (540, 'Stillen', 'en'),
    (541, 'Street Scene', 'en'),
    (542, 'Thinkware', 'en'),
    (543, 'Tyger', 'en'),
    (544, 'Uniden', 'en'),
    (545, 'Wagner Tuning', 'en'),
    (546, 'Whistler', 'en'),
    (547, 'Zerex', 'en'),
    (551, 'Red', 'en'),
    (552, 'Silver', 'en'),
    (553, 'Pink-Purple', 'en'),
    (554, '17\" DIAMETER (17\" x 7\")', 'en'),
    (555, '18\" DIAMETER (18\" x 7.5\")', 'en'),
    (556, 'Light blue', 'en'),
    (557, 'Dark blue', 'en'),
    (558, 'Beige', 'en'),
    (559, 'Coffee', 'en'),
    (562, '225/45R17', 'en'),
    (563, '225/45R18', 'en'),
    (564, '225/40R19', 'en'),
    (565, '245/35R19', 'en'),
    (566, '255/35R19', 'en'),
    (567, 'Beige', 'en'),
    (568, 'Coffee', 'en'),
    (569, 'Beige', 'en'),
    (570, 'Coffee', 'en'),
    (571, 'Beige', 'en'),
    (572, 'Coffee', 'en'),
    (573, 'Blue-Red', 'en'),
    (574, 'White-Yellow', 'en'),
    (575, 'ARTIS FORGED', 'en'),
    (576, 'Niche', 'en'),
    (577, 'Rennen Forged', 'en'),
    (578, 'Vogue Tyres', 'en'),
    (579, 'Yokohama', 'en'),
    (580, 'AMS Performance', 'en'),
    (581, 'Laufenn', 'en'),
    (582, 'Landspider', 'en'),
    (583, 'CCI', 'en'),
    (584, '2 Crave', 'en'),
    (585, '4PLAY', 'en'),
    (586, '720Form', 'en'),
    (587, 'Ace Alloy', 'en'),
    (588, 'Advanti Racing USA', 'en'),
    (589, 'Akuza', 'en'),
    (590, 'Alcoa', 'en'),
    (591, 'Allied', 'en'),
    (592, 'Amani Forged', 'en'),
    (593, 'American Design Factory', 'en'),
    (594, 'American Force', 'en'),
    (595, 'American Legend', 'en'),
    (596, 'American Racing', 'en'),
    (597, 'American Truxx', 'en'),
    (598, 'ART Replica', 'en'),
    (599, 'Asanti Black Label', 'en'),
    (600, 'Asanti Forged', 'en'),
    (601, 'ATX', 'en'),
    (602, 'Avant Garde', 'en'),
    (603, 'Avenue', 'en'),
    (604, 'Axe', 'en'),
    (605, 'Azara', 'en'),
    (606, 'Ballistic', 'en'),
    (607, 'Bavar Racing', 'en'),
    (608, 'Beyern', 'en'),
    (609, 'BG Rod Works', 'en'),
    (610, 'Black Rhino', 'en'),
    (611, 'Black Rock', 'en'),
    (612, 'Blade', 'en'),
    (613, 'Blaque Diamond', 'en'),
    (614, 'Borghini', 'en'),
    (615, 'Boyd Coddington', 'en'),
    (616, 'Braelin', 'en'),
    (617, 'Bravado', 'en'),
    (618, 'Buck Commander', 'en'),
    (619, 'Cali Offroad', 'en'),
    (620, 'Carlisle', 'en'),
    (621, 'Cavallo', 'en'),
    (622, 'CEC', 'en'),
    (623, 'Centerline', 'en'),
    (624, 'Coventry', 'en'),
    (625, 'Cragar', 'en'),
    (626, 'Cratus', 'en'),
    (627, 'Cray', 'en'),
    (628, 'Cruiser Alloys', 'en'),
    (629, 'Curva Concepts', 'en'),
    (630, 'DAI Alloys', 'en'),
    (631, 'Dcenti Racing', 'en'),
    (632, 'DDC', 'en'),
    (633, 'Diablo', 'en'),
    (634, 'Akuret', 'en'),
    (635, 'Amp', 'en'),
    (636, 'Antares', 'en'),
    (637, 'Apollo', 'en'),
    (638, 'Ardent', 'en'),
    (639, 'Arroyo', 'en'),
    (640, 'Atturo', 'en'),
    (641, 'Bfgoodrich', 'en'),
    (642, 'Bridgestone', 'en'),
    (643, 'Camso', 'en'),
    (644, 'Comforser', 'en'),
    (645, 'Continental', 'en'),
    (646, 'Cooper', 'en'),
    (647, 'Dean', 'en'),
    (648, 'Deestone', 'en'),
    (649, 'Delinte', 'en'),
    (650, 'Delta', 'en'),
    (651, 'Dick Cepek', 'en'),
    (652, 'Dunlop', 'en'),
    (653, 'Duraturn', 'en'),
    (654, 'Dynamaxx', 'en'),
    (655, 'Efx', 'en'),
    (656, 'Falken', 'en'),
    (657, 'Firestone', 'en'),
    (658, 'Fuel', 'en'),
    (659, 'Fuzion', 'en'),
    (660, 'Galaxy', 'en'),
    (661, 'Gallant', 'en'),
    (662, 'General', 'en'),
    (663, 'Goodyear', 'en'),
    (664, 'Gt Radial', 'en'),
    (665, 'Hankook', 'en'),
    (666, 'Hercules', 'en'),
    (667, 'Interco', 'en'),
    (668, 'ITP', 'en'),
    (669, 'Kenda', 'en'),
    (670, 'Kumho', 'en'),
    (672, 'Lexani', 'en'),
    (673, 'Mastercraft', 'en'),
    (674, 'Maxxis', 'en'),
    (676, 'Mickey Thompson', 'en'),
    (677, 'Momo', 'en'),
    (678, 'Multi-mile', 'en'),
    (679, 'Nexen', 'en'),
    (680, 'Nitto', 'en'),
    (681, 'Ohtsu', 'en'),
    (682, 'Pirelli', 'en'),
    (683, 'SUV', 'en'),
    (684, 'Truck', 'en'),
    (685, 'Off-Road', 'en'),
    (686, '22', 'en'),
    (687, '12', 'en'),
    (688, '5', 'en'),
    (689, '127', 'en'),
    (690, '139.7', 'en'),
    (691, 'Gloss', 'en'),
    (692, 'Black', 'en'),
    (693, 'Brushed Face-Tinted Clear', 'en'),
    (694, '87.1', 'en'),
    (695, '2900', 'en'),
    (696, '-44', 'en'),
    (697, 'Cast Aluminum', 'en'),
    (698, '1-Piece', 'en'),
    (699, 'Conical', 'en'),
    (700, '4P06', 'en'),
    (701, 'BBT', 'en'),
    (702, '22″х12″/-44mm, 5x127/139.7', 'en'),
    (703, '6', 'en'),
    (704, '135', 'en'),
    (705, '106.1', 'en'),
    (706, '22″х12″/-44mm, 6x135/139.7', 'en'),
    (707, '24', 'en'),
    (708, '24″х12″/-44mm, 6x135/139.7', 'en'),
    (709, '20', 'en'),
    (710, '10', 'en'),
    (711, '-18', 'en'),
    (712, '20″х10″/-18mm, 5x127/139.7', 'en'),
    (713, '20″х10″/-18mm, 6x135/139.7', 'en'),
    (714, '22″х10″/-18mm, 5x127/139.7', 'en'),
    (715, '22″х10″/-18mm, 6x135/139.7', 'en'),
    (716, '9', 'en'),
    (717, '2980', 'en'),
    (718, '20″х9″/0mm, 5x127/139.7', 'en'),
    (719, '20″х9″/0mm, 6x135/139.7', 'en'),
    (720, '8', 'en'),
    (721, '170', 'en'),
    (722, '124.9', 'en'),
    (723, '3900', 'en'),
    (724, '20″х9″/0mm, 8x170', 'en'),
    (725, '180', 'en'),
    (726, '20″х9″/0mm, 8x180', 'en'),
    (727, '165.1', 'en'),
    (728, '20″х9″/0mm, 8x165.1', 'en'),
    (729, '12', 'en'),
    (730, '22″х9″/12mm, 6x135/139.7', 'en'),
    (731, '18', 'en'),
    (732, '24″х10″/18mm, 6x135/139.7', 'en'),
    (733, '4P08', 'en'),
    (734, '22″х12″/-44mm, 8x170', 'en'),
    (735, '124.1', 'en'),
    (736, '22″х12″/-44mm, 8x180', 'en'),
    (737, '22″х12″/-44mm, 8x165.1', 'en'),
    (738, '-24', 'en'),
    (739, '20″х10″/-24mm, 5x127/139.7', 'en'),
    (740, '20″х10″/-24mm, 8x170', 'en'),
    (741, '20″х10″/-24mm, 8x180', 'en'),
    (742, '20″х10″/-24mm, 8x165.1', 'en'),
    (743, '22″х10″/-24mm, 5x127/139.7', 'en'),
    (744, '22″х10″/-24mm, 8x170', 'en'),
    (745, '22″х10″/-24mm, 8x180', 'en'),
    (746, '22″х10″/-24mm, 8x165.1', 'en'),
    (747, '4P55', 'en'),
    (748, '20″х12″/-44mm, 5x127/139.7', 'en'),
    (749, '20″х12″/-44mm, 6x135/139.7', 'en'),
    (750, '4P63', 'en'),
    (751, '4P70', 'en'),
    (752, '4P80R', 'en'),
    (753, '4P83', 'en'),
    (754, '14', 'en'),
    (755, 'Matte', 'en'),
    (756, 'Gloss Black Barrel', 'en'),
    (757, '-76', 'en'),
    (758, '4PF6', 'en'),
    (759, 'B', 'en'),
    (760, '24″х14″/-76mm, 6x135/139.7', 'en'),
    (761, '3700', 'en'),
    (762, '24″х14″/-76mm, 8x170', 'en'),
    (763, '24″х14″/-76mm, 8x180', 'en'),
    (764, '24″х14″/-76mm, 8x165.1', 'en'),
    (765, 'Car', 'en'),
    (766, 'Luxury', 'en'),
    (767, '112', 'en'),
    (768, 'Mica Grey', 'en'),
    (769, 'Brushed Face', 'en'),
    (770, '72.6', 'en'),
    (771, '1650', 'en'),
    (772, '20', 'en'),
    (773, 'AFF01', 'en'),
    (774, 'GY', 'en'),
    (775, '20″х9″/20mm, 5x112', 'en'),
    (776, '114.3', 'en'),
    (777, '20″х12″/20mm, 5x114.3', 'en'),
    (778, '19', 'en'),
    (779, '25', 'en'),
    (780, '19″х10″/25mm, 5x112', 'en'),
    (781, '10.5', 'en'),
    (782, '20″х10.5″/25mm, 5x112', 'en'),
    (783, '11', 'en'),
    (784, '20″х11″/25mm, 5x112', 'en'),
    (785, '9.5', 'en'),
    (786, '110', 'en'),
    (787, '30', 'en'),
    (788, '19″х9.5″/30mm, 5x110', 'en'),
    (789, '8.5', 'en'),
    (790, '38', 'en'),
    (791, '19″х8.5″/38mm, 5x110', 'en'),
    (792, 'Liquid Silver', 'en'),
    (793, 'Machined Face', 'en'),
    (794, 'SL', 'en'),
    (795, 'Matte Black', 'en'),
    (796, 'MB', 'en'),
    (797, '108', 'en'),
    (798, 'Brushed', 'en'),
    (799, 'Silver', 'en'),
    (800, 'Clear Coat', 'en'),
    (801, 'AFF02', 'en'),
    (802, '19″х10″/20mm, 5x108', 'en'),
    (803, '2010', 'en'),
    (804, '22″х9″/20mm, 5x108', 'en'),
    (805, '20″х11″/30mm, 5x112', 'en'),
    (806, '32', 'en'),
    (807, '19″х8.5″/32mm, 5x108', 'en'),
    (808, '20″х9″/32mm, 5x108', 'en'),
    (809, '20″х10.5″/32mm, 5x108', 'en'),
    (810, '35', 'en'),
    (811, '19″х9.5″/35mm, 5x108', 'en'),
    (812, '20″х9.5″/35mm, 5x112', 'en'),
    (813, '20″х12″/35mm, 5x112', 'en'),
    (814, '22″х10.5″/35mm, 5x108', 'en'),
    (815, 'GB', 'en'),
    (816, 'Black Chrome', 'en'),
    (817, 'CH', 'en'),
    (818, '20″х10″/25mm, 5x108', 'en'),
    (819, 'BK', 'en'),
    (820, '115', 'en'),
    (821, 'Piano Black', 'en'),
    (822, '2101', 'en'),
    (823, 'AFF03', 'en'),
    (824, '22″х10″/20mm, 5x115', 'en'),
    (825, 'Mirror Machined Face', 'en'),
    (826, 'BKM', 'en'),
    (827, 'Machined Face-Gloss Black Lip', 'en'),
    (828, '1550', 'en'),
    (829, 'AFF04', 'en'),
    (830, '20″х10.5″/20mm, 5x112', 'en'),
    (831, 'Machined Lip', 'en'),
    (832, 'LSL', 'en'),
    (833, 'Titanium', 'en'),
    (834, 'TSL', 'en'),
    (835, '120', 'en'),
    (836, 'AFF05', 'en'),
    (837, '19″х9.5″/18mm, 5x120', 'en'),
    (838, '19″х8.5″/20mm, 5x112', 'en'),
    (839, '20″х10″/20mm, 5x115', 'en'),
    (840, '20″х10.5″/20mm, 5x114.3', 'en'),
    (841, '20″х11″/20mm, 5x114.3', 'en'),
    (842, '20″х8.5″/25mm, 5x112', 'en'),
    (843, 'Space Grey', 'en'),
    (844, 'Car', 'en'),
    (845, 'Performance', 'en'),
    (846, 'Summer', 'en'),
    (847, '275', 'en'),
    (848, '40', 'en'),
    (849, '19', 'en'),
    (850, 'Pilot Sport PS2', 'en'),
    (851, '23.9', 'en'),
    (852, '8.43', 'en'),
    (853, '9.5', 'en'),
    (854, '750', 'en'),
    (855, '101', 'en'),
    (856, 'Y', 'en'),
    (857, '275/40R19', 'en'),
    (858, '255', 'en'),
    (859, '25.32', 'en'),
    (860, '9.3', 'en'),
    (861, '10', 'en'),
    (862, '769', 'en'),
    (863, '96', 'en'),
    (864, '255/40R19', 'en'),
    (865, '225', 'en'),
    (866, '35', 'en'),
    (867, '25.2', 'en'),
    (868, '9.1', 'en'),
    (869, 'XL', 'en'),
    (870, '8.5', 'en'),
    (871, '824', 'en'),
    (872, '88', 'en'),
    (873, '(Y)', 'en'),
    (874, '225/35ZR19', 'en'),
    (875, '18', 'en'),
    (876, '10.2', 'en'),
    (877, '832', 'en'),
    (878, '94', 'en'),
    (879, '255/35ZR18', 'en'),
    (880, '265', 'en'),
    (881, '26.3', 'en'),
    (882, '10.7', 'en'),
    (883, '790', 'en'),
    (884, '265/40ZR18', 'en'),
    (885, '285', 'en'),
    (886, '30', 'en'),
    (887, '21', 'en'),
    (888, '27.8', 'en'),
    (889, '11.4', 'en'),
    (890, '749', 'en'),
    (891, '100', 'en'),
    (892, '285/30ZR21', 'en'),
    (893, '235', 'en'),
    (894, '25.5', 'en'),
    (895, '9.5', 'en'),
    (896, '817', 'en'),
    (897, '87', 'en'),
    (898, '235/35ZR19', 'en'),
    (899, '25.4', 'en'),
    (900, '819', 'en'),
    (901, '91', 'en'),
    (902, '235/40ZR18', 'en'),
    (903, '315', 'en'),
    (904, '12.6', 'en'),
    (905, '98', 'en'),
    (906, '315/30ZR18', 'en'),
    (907, '25.6', 'en'),
    (908, '10.9', 'en'),
    (909, '814', 'en'),
    (910, '95', 'en'),
    (911, '275/35R18', 'en'),
    (912, '26', 'en'),
    (913, '799', 'en'),
    (914, '99', 'en'),
    (915, '255/40ZR18', 'en'),
    (916, '20', 'en'),
    (917, '26.1', 'en'),
    (918, '798', 'en'),
    (919, '92', 'en'),
    (920, '255/30ZR20', 'en'),
    (921, '25.1', 'en'),
    (922, '9.2', 'en'),
    (923, '829', 'en'),
    (924, '225/40ZR18', 'en'),
    (925, '797', 'en'),
    (926, '93', 'en'),
    (927, '225/40ZR19', 'en'),
    (928, '245', 'en'),
    (929, '24.8', 'en'),
    (930, '9.8', 'en'),
    (931, '840', 'en'),
    (932, '245/35ZR18', 'en'),
    (933, '25', 'en'),
    (934, '12.8', 'en'),
    (935, '315/25ZR19', 'en'),
    (936, '295', 'en'),
    (937, '11.9', 'en'),
    (938, '295/30ZR19', 'en'),
    (939, '45', 'en'),
    (940, '17', 'en'),
    (941, '25', 'en'),
    (942, '8.9', 'en'),
    (943, '833', 'en'),
    (944, '225/45ZR17', 'en'),
    (945, '831', 'en'),
    (946, '255/40ZR17', 'en'),
    (947, '26.6', 'en'),
    (948, '783', 'en'),
    (949, '275/40ZR18', 'en'),
    (950, '24.2', 'en'),
    (951, '859', 'en'),
    (952, '225/35ZR18', 'en'),
    (953, '255/35ZR19', 'en'),
    (954, '305', 'en'),
    (955, '12.3', 'en'),
    (956, '788', 'en'),
    (957, '102', 'en'),
    (958, '305/30ZR19', 'en'),
    (959, '205', 'en'),
    (960, '55', 'en'),
    (961, '25.9', 'en'),
    (962, '8.4', 'en'),
    (963, '803', 'en'),
    (964, '205/55ZR17', 'en'),
    (965, '22', 'en'),
    (966, '747', 'en'),
    (967, '97', 'en'),
    (968, '295/25ZR22', 'en'),
    (969, '24.7', 'en'),
    (970, '841', 'en'),
    (971, '245/40ZR17', 'en'),
    (972, '27.7', 'en'),
    (973, '8.2', 'en'),
    (974, '742', 'en'),
    (975, '245/40ZR18', 'en'),
    (976, '25.7', 'en'),
    (977, '9.6', 'en'),
    (978, '809', 'en'),
    (979, '245/45ZR17', 'en'),
    (980, '275/30ZR19', 'en'),
    (981, '335', 'en'),
    (982, '28', 'en'),
    (983, '13.5', 'en'),
    (984, '744', 'en'),
    (985, '104', 'en'),
    (986, '335/30ZR20', 'en'),
    (987, '25.8', 'en'),
    (988, '807', 'en'),
    (989, '245/35ZR19', 'en'),
    (990, '325', 'en'),
    (991, '26.4', 'en'),
    (992, '12.9', 'en'),
    (993, '789', 'en'),
    (994, '325/25ZR20', 'en'),
    (995, '25.3', 'en'),
    (996, '822', 'en'),
    (997, '265/35ZR18', 'en'),
    (998, '245/35ZR21', 'en'),
    (999, '265/35ZR19', 'en'),
    (1000, '26.7', 'en'),
    (1001, '778', 'en'),
    (1002, '245/40ZR19', 'en'),
    (1003, '28.1', 'en'),
    (1004, '741', 'en'),
    (1005, '255/30ZR22', 'en'),
    (1006, '24.4', 'en'),
    (1007, '852', 'en'),
    (1008, '90', 'en'),
    (1009, '235/40ZR17', 'en'),
    (1010, '26.8', 'en'),
    (1011, '776', 'en'),
    (1012, '295/25ZR21', 'en'),
    (1013, '295/35ZR18', 'en'),
    (1014, '27', 'en'),
    (1015, '255/30ZR21', 'en'),
    (1016, '26.9', 'en'),
    (1017, '774', 'en'),
    (1018, '285/30ZR20', 'en'),
    (1019, '777', 'en'),
    (1020, '245/35ZR20', 'en'),
    (1021, '27.1', 'en'),
    (1022, '767', 'en'),
    (1023, '255/35ZR20', 'en'),
    (1024, '805', 'en'),
    (1025, '295/25ZR20', 'en'),
    (1026, '13.5', 'en'),
    (1027, '265/30ZR19', 'en'),
    (1028, '295/30ZR18', 'en'),
    (1029, '275/35ZR19', 'en'),
    (1030, '8.3', 'en'),
    (1031, '851', 'en'),
    (1032, '86', 'en'),
    (1033, '205/40ZR18', 'en'),
    (1034, '285/35ZR19', 'en'),
    (1035, 'SL', 'en'),
    (1036, '265/40ZR17', 'en'),
    (1037, '25.28', 'en'),
    (1038, '8.11', 'en'),
    (1039, '245/30ZR20', 'en'),
    (1040, '821', 'en'),
    (1041, '235/45ZR17', 'en'),
    (1042, '275/40ZR17', 'en'),
    (1043, '285/30ZR19', 'en'),
    (1044, '255/40ZR19', 'en'),
    (1045, '26.2', 'en'),
    (1046, '106', 'en'),
    (1047, '335/35ZR17', 'en'),
    (1048, '50', 'en'),
    (1049, '235/50ZR17', 'en'),
    (1050, '29.8', 'en'),
    (1051, '697', 'en'),
    (1052, '110', 'en'),
    (1053, '275/45R20', 'en'),
    (1054, '245/45ZR18', 'en'),
    (1055, '25.94', 'en'),
    (1056, '800', 'en'),
    (1057, '335/30ZR18', 'en'),
    (1058, '225/45ZR18', 'en'),
    (1059, '275/35ZR18', 'en'),
    (1060, '24', 'en'),
    (1061, '9', 'en'),
    (1062, 'P245/40ZR18', 'en'),
    (1063, '27.68', 'en'),
    (1064, '10.94', 'en'),
    (1065, '751', 'en'),
    (1066, '27.6', 'en'),
    (1067, '755', 'en'),
    (1068, '275/35ZR20', 'en'),
    (1069, '345', 'en'),
    (1070, '27.2', 'en'),
    (1071, '13.8', 'en'),
    (1072, '765', 'en'),
    (1073, '105', 'en'),
    (1074, '345/30ZR19', 'en'),
    (1075, '815', 'en'),
    (1076, '225/45R17', 'en'),
    (1077, '27.3', 'en'),
    (1078, '9.7', 'en'),
    (1079, '762', 'en'),
    (1080, '235/50ZR18', 'en'),
    (1081, '802', 'en'),
    (1082, '9.76', 'en'),
    (1083, '265/35R19', 'en'),
    (1084, '813', 'en'),
    (1085, '235/30ZR20', 'en'),
    (1086, '265/30ZR20', 'en'),
    (1087, '791', 'en'),
    (1088, '11.6', 'en'),
    (1089, '285/25ZR20', 'en'),
    (1090, '28.4', 'en'),
    (1091, '732', 'en'),
    (1092, '305/35ZR20', 'en'),
    (1093, '828', 'en'),
    (1094, '89', 'en'),
    (1095, '205/50ZR17', 'en'),
    (1096, '810', 'en'),
    (1097, 'W', 'en'),
    (1098, '780', 'en'),
    (1099, 'LL', 'en'),
    (1100, 'P275/35ZR18', 'en'),
    (1101, '285/30ZR18', 'en'),
    (1102, '9', 'en'),
    (1103, '26.73', 'en'),
    (1104, '255/35R19', 'en'),
    (1105, '10', 'en'),
    (1106, '255/45R19', 'en'),
    (1107, 'P285/30ZR19', 'en'),
    (1108, '743', 'en'),
    (1109, '103', 'en'),
    (1110, '285/40ZR19', 'en'),
    (1111, '26.61', 'en'),
    (1112, '8.98', 'en'),
    (1113, '13', 'en'),
    (1114, 'P325/30ZR19', 'en'),
    (1115, '26.5', 'en'),
    (1116, '786', 'en'),
    (1117, '235/35ZR20', 'en'),
    (1118, '8.7', 'en'),
    (1119, '794', 'en'),
    (1120, '255/40ZR20', 'en'),
    (1121, '717', 'en'),
    (1122, '295/35ZR20', 'en'),
    (1123, '740', 'en'),
    (1124, '801', 'en'),
    (1125, '305/25ZR20', 'en'),
    (1126, '782', 'en'),
    (1127, 'P335/25ZR20', 'en'),
    (1128, '28.3', 'en'),
    (1129, '50', 'en'),
    (1130, '735', 'en'),
    (1131, '265/35ZR21', 'en'),
    (1132, '28.2', 'en'),
    (1133, '715', 'en'),
    (1134, '305/30ZR21', 'en'),
    (1135, '27.4', 'en'),
    (1136, '11.1', 'en'),
    (1137, '758', 'en'),
    (1138, '275/25ZR22', 'en'),
    (1139, '792', 'en'),
    (1140, '245/40R18', 'en'),
    (1141, '43.43', 'en'),
    (1142, '19', 'en'),
    (1143, '478', 'en'),
    (1144, '27.95', 'en'),
    (1145, '255/45ZR18', 'en'),
    (1146, 'SUV/Light Truck', 'en'),
    (1147, 'All Season', 'en'),
    (1148, 'Commercial', 'en'),
    (1149, 'Highway Terrain', 'en'),
    (1150, '70', 'en'),
    (1151, '16', 'en'),
    (1152, 'LTX M/S', 'en'),
    (1153, '25.83', 'en'),
    (1154, '8.99', 'en'),
    (1155, '10.5', 'en'),
    (1156, '107', 'en'),
    (1157, 'S', 'en'),
    (1158, '245/70R16', 'en'),
    (1159, '31.3', 'en'),
    (1160, '12', 'en'),
    (1161, '666', 'en'),
    (1162, '114', 'en'),
    (1163, 'H', 'en'),
    (1164, 'P275/70R16', 'en'),
    (1165, '75', 'en'),
    (1166, '31.6', 'en'),
    (1167, '10.5', 'en'),
    (1168, '13', 'en'),
    (1169, '658', 'en'),
    (1170, 'P265/75R16', 'en'),
    (1171, '15', 'en'),
    (1172, '27.9', 'en'),
    (1173, '9.4', 'en'),
    (1174, '746', 'en'),
    (1175, 'P235/70R15', 'en'),
    (1176, '215', 'en'),
    (1177, 'R', 'en'),
    (1178, 'LT215/75R15', 'en'),
    (1179, '30.7', 'en'),
    (1180, '681', 'en'),
    (1181, '111', 'en'),
    (1182, 'P265/70R16', 'en'),
    (1183, '29.6', 'en'),
    (1184, '707', 'en'),
    (1185, 'P245/70R16', 'en'),
    (1186, '28.8', 'en'),
    (1187, '727', 'en'),
    (1188, '6', 'en'),
    (1189, 'LT235/75R15', 'en'),
    (1190, '32.8', 'en'),
    (1191, '11.3', 'en'),
    (1192, '15', 'en'),
    (1193, '634', 'en'),
    (1194, '122', 'en'),
    (1195, 'LT285/75R16/D', 'en'),
    (1196, '29.1', 'en'),
    (1197, 'P235/70R16/XL', 'en'),
    (1198, '29.9', 'en'),
    (1199, '696', 'en'),
    (1200, 'P235/75R16', 'en'),
    (1201, 'P225/75R15', 'en'),
    (1202, '8.1', 'en'),
    (1203, 'P205/75R15', 'en'),
    (1204, '31.8', 'en'),
    (1205, '10.8', 'en'),
    (1206, '656', 'en'),
    (1207, '113', 'en'),
    (1208, 'P265/70R17', 'en'),
    (1209, '29.4', 'en'),
    (1210, '8.8', 'en'),
    (1211, '709', 'en'),
    (1212, '115', 'en'),
    (1213, '10', 'en'),
    (1214, 'LT225/75R16', 'en'),
    (1215, '120', 'en'),
    (1216, 'LT245/75R16/E', 'en'),
    (1217, '30.4', 'en'),
    (1218, '684', 'en'),
    (1219, '109', 'en'),
    (1220, 'P245/75R16', 'en'),
    (1221, '738', 'en'),
    (1222, 'P225/70R16', 'en'),
    (1223, '65', 'en'),
    (1224, '29.7', 'en'),
    (1225, '11', 'en'),
    (1226, '700', 'en'),
    (1227, '245/65R17', 'en'),
    (1228, '29.2', 'en'),
    (1229, '10.1', 'en'),
    (1230, '712', 'en'),
    (1231, 'P255/65R16', 'en'),
    (1232, '31.9', 'en'),
    (1233, '652', 'en'),
    (1234, 'T', 'en'),
    (1235, 'P275/55R20', 'en'),
    (1236, 'P215/70R16', 'en'),
    (1237, '85', 'en'),
    (1238, '30.5', 'en'),
    (1239, '685', 'en'),
    (1240, 'LT215/85R16', 'en'),
    (1241, '60', 'en'),
    (1242, '33', 'en'),
    (1243, '11', 'en'),
    (1244, '630', 'en'),
    (1245, 'P275/60R20', 'en'),
    (1246, '80', 'en'),
    (1247, '654', 'en'),
    (1248, 'LT235/80R17/E', 'en'),
    (1249, '14', 'en'),
    (1250, '123', 'en'),
    (1251, 'LT265/75R16/E', 'en'),
    (1252, '108', 'en'),
    (1253, '235/75R15', 'en'),
    (1254, 'P225/70R15', 'en'),
    (1255, '30.2', 'en'),
    (1256, '10.3', 'en'),
    (1257, '694', 'en'),
    (1258, 'P255/70R16', 'en'),
    (1259, '728', 'en'),
    (1260, 'P235/75R15/XL', 'en'),
    (1261, '31', 'en'),
    (1262, '10.5', 'en'),
    (1263, '30.8', 'en'),
    (1264, '679', 'en'),
    (1265, '31X10.50R15', 'en'),
    (1266, '9.86', 'en'),
    (1267, '8.6', 'en'),
    (1268, '754', 'en'),
    (1269, 'P215/75R15', 'en'),
    (1270, '32', 'en'),
    (1271, 'LT235/85R16/E', 'en'),
    (1272, '31.1', 'en'),
    (1273, '669', 'en'),
    (1274, 'P255/70R17', 'en'),
    (1275, '30', 'en'),
    (1276, '9.5', 'en'),
    (1277, '706', 'en'),
    (1278, '30X9.50R15', 'en'),
    (1279, 'LT245/75R16', 'en'),
    (1280, 'P235/70R16', 'en'),
    (1281, 'P245/65R17', 'en'),
    (1282, '703', 'en'),
    (1283, 'P245/60R18', 'en'),
    (1284, '28.7', 'en'),
    (1285, 'P235/75R15', 'en'),
    (1286, '195', 'en'),
    (1287, '14', 'en'),
    (1288, '7.9', 'en'),
    (1289, 'LT195/75R14/C', 'en'),
    (1290, 'LT215/75R15/C', 'en'),
    (1291, '29.3', 'en'),
    (1292, 'LT225/75R16/D', 'en'),
    (1293, '112', 'en'),
    (1294, 'LT265/75R16/C', 'en'),
    (1295, '820', 'en'),
    (1296, 'P235/75R16/XL', 'en'),
    (1297, '655', 'en'),
    (1298, '8', 'en'),
    (1299, 'LT235/85R16', 'en'),
    (1300, '32', 'en'),
    (1301, '11.5', 'en'),
    (1302, '31.7', 'en'),
    (1303, '662', 'en'),
    (1304, '32X11.50R15', 'en'),
    (1305, '4', 'en'),
    (1306, 'Latitude Tour HP', 'en'),
    (1307, 'V', 'en'),
    (1308, '255/60R17', 'en'),
    (1309, '10.6', 'en'),
    (1310, '711', 'en'),
    (1311, '255/55R18', 'en'),
    (1312, '295/30R22', 'en'),
    (1313, '660', 'en'),
    (1314, '295/40R22', 'en'),
    (1315, '31.5', 'en'),
    (1316, '11.5', 'en'),
    (1317, '657', 'en'),
    (1318, '285/60R18', 'en'),
    (1319, '23.8', 'en'),
    (1320, '6.9', 'en'),
    (1321, '872', 'en'),
    (1322, '275/55R17', 'en'),
    (1323, '22.7', 'en'),
    (1324, '7.7', 'en'),
    (1325, '914', 'en'),
    (1326, '235/65R17', 'en'),
    (1327, '30.1', 'en'),
    (1328, '688', 'en'),
    (1329, '255/50R20', 'en'),
    (1330, '28.6', 'en'),
    (1331, '721', 'en'),
    (1332, '315/35ZR20', 'en'),
    (1333, '714', 'en'),
    (1334, '285/45R19', 'en'),
    (1335, '677', 'en'),
    (1336, '265/50R20', 'en'),
    (1337, '31.83', 'en'),
    (1338, '9.87', 'en'),
    (1339, '720', 'en'),
    (1340, 'P255/55R18', 'en'),
    (1341, '28.66', 'en'),
    (1342, '722', 'en'),
    (1343, '275/40ZR20', 'en'),
    (1344, '255/50R19', 'en'),
    (1345, '29', 'en'),
    (1346, '10.4', 'en'),
    (1347, '682', 'en'),
    (1348, '265/60R18', 'en'),
    (1349, '41.54', 'en'),
    (1350, '699', 'en'),
    (1351, '32.1', 'en'),
    (1352, '12.4', 'en'),
    (1353, '649', 'en'),
    (1354, '305/50R20', 'en'),
    (1355, '768', 'en'),
    (1356, '235/60R16', 'en'),
    (1357, '29.57', 'en'),
    (1358, '723', 'en'),
    (1359, '275/45R19', 'en'),
    (1360, '716', 'en'),
    (1361, '255/65R16', 'en'),
    (1362, '29.85', 'en'),
    (1363, '671', 'en'),
    (1364, 'P275/60R18', 'en'),
    (1365, '31.26', 'en'),
    (1366, '11.69', 'en'),
    (1367, '10.3', 'en'),
    (1368, '665', 'en'),
    (1369, 'P285/50R20', 'en'),
    (1370, '30.6', 'en'),
    (1371, '265/70R16', 'en'),
    (1372, '31.2', 'en'),
    (1373, '667', 'en'),
    (1374, '275/70R16', 'en'),
    (1375, '770', 'en'),
    (1376, '215/65R16', 'en'),
    (1377, '753', 'en'),
    (1378, '225/60R17', 'en'),
    (1379, '30', 'en'),
    (1380, '692', 'en'),
    (1381, '255/55R19', 'en'),
    (1382, '701', 'en'),
    (1383, 'P245/50R20', 'en'),
    (1384, '11.7', 'en'),
    (1385, '58.9', 'en'),
    (1386, '21.1', 'en'),
    (1387, '648', 'en'),
    (1388, 'P275/65R18', 'en'),
    (1389, 'P235/65R18', 'en'),
    (1390, '766', 'en'),
    (1391, '235/55R17', 'en'),
    (1392, '29.5', 'en'),
    (1393, '704', 'en'),
    (1394, '225/60R18', 'en'),
    (1395, '235/60R18', 'en'),
    (1396, 'P265/60R18', 'en'),
    (1397, '661', 'en'),
    (1398, 'P285/60R18', 'en'),
    (1399, '28.31', 'en'),
    (1400, '235/50R19', 'en'),
    (1401, '713', 'en'),
    (1402, '235/55R19', 'en'),
    (1403, 'P235/55R19', 'en'),
    (1404, '29.09', 'en'),
    (1405, '10.43', 'en'),
    (1406, 'P255/50R19', 'en'),
    (1407, '690', 'en'),
    (1408, 'P235/55R20', 'en'),
    (1409, '285/50R20', 'en'),
    (1410, '27.28', 'en'),
    (1411, '9.65', 'en'),
    (1412, '235/50R18', 'en'),
    (1413, '30.47', 'en'),
    (1414, '116', 'en'),
    (1415, '705', 'en'),
    (1416, '265/50R19', 'en'),
    (1417, '30.98', 'en'),
    (1418, '29.76', 'en'),
    (1419, '10.75', 'en'),
    (1420, '726', 'en'),
    (1421, '28.5', 'en'),
    (1422, '730', 'en'),
    (1423, '225/65R17', 'en'),
    (1424, '28.9', 'en'),
    (1425, '245/60R18', 'en'),
    (1426, '11.22', 'en'),
    (1427, '9.9', 'en'),
    (1428, '702', 'en'),
    (1429, '245/55R19', 'en'),
    (1430, '10.91', 'en'),
    (1431, '683', 'en'),
    (1432, '31.46', 'en'),
    (1433, '225/50R19', 'en'),
    (1434, '245/45R19', 'en'),
    (1435, '275/45R21', 'en'),
    (1436, '11.8', 'en'),
    (1437, '710', 'en'),
    (1438, '295/40R20', 'en'),
    (1439, '708', 'en'),
    (1440, '265/45R20', 'en'),
    (1441, '31', 'en'),
    (1442, '29.53', 'en'),
    (1443, '245/45R20', 'en'),
    (1444, '691', 'en'),
    (1445, '31.4', 'en'),
    (1446, '30.3', 'en'),
    (1447, '265/45R21', 'en'),
    (1448, '235/65R18', 'en'),
    (1449, '255/55R20', 'en'),
    (1450, '32.3', 'en'),
    (1451, '255/70R18', 'en'),
    (1452, '255/60R20', 'en'),
    (1453, '32.32', 'en'),
    (1454, '4X4 Diamaris', 'en'),
    (1455, '325/30R21', 'en'),
    (1456, '16', 'en'),
    (1457, '285/35R21', 'en'),
    (1458, '275/45R19/XL', 'en'),
    (1459, '27.5', 'en'),
    (1460, '763', 'en'),
    (1461, '255/50R17', 'en'),
    (1462, '12.5', 'en'),
    (1463, '275/55R19', 'en'),
    (1464, '285/50R18', 'en'),
    (1465, '764', 'en'),
    (1466, '225/55R17', 'en'),
    (1467, '724', 'en'),
    (1468, '275/40R20', 'en'),
    (1469, '12', 'en'),
    (1470, '695', 'en'),
    (1471, '285/35R22', 'en'),
    (1472, '315/35R20', 'en'),
    (1473, '295/30ZR22', 'en'),
    (1474, '275/50R20', 'en'),
    (1475, '30.9', 'en'),
    (1476, '11.2', 'en'),
    (1477, '673', 'en'),
    (1478, '30.87', 'en'),
    (1479, '674', 'en'),
    (1480, '29.02', 'en'),
    (1481, '185', 'en'),
    (1482, 'Pilot Exalto A/S', 'en'),
    (1483, '22.8', 'en'),
    (1484, '7.5', 'en'),
    (1485, '912', 'en'),
    (1486, '82', 'en'),
    (1487, '185/60R14', 'en'),
    (1488, '8.5', 'en'),
    (1489, '869', 'en'),
    (1490, '205/55R15', 'en'),
    (1491, '215/60R16', 'en'),
    (1492, '806', 'en'),
    (1493, '225/55R16', 'en'),
    (1494, '812', 'en'),
    (1495, '225/60R15', 'en'),
    (1496, '839', 'en'),
    (1497, '205/55R16', 'en'),
    (1498, '215/55R16', 'en'),
    (1499, '24.1', 'en'),
    (1500, '862', 'en'),
    (1501, '205/50R16', 'en'),
    (1502, '24.5', 'en'),
    (1503, '850', 'en'),
    (1504, '205/60R15', 'en'),
    (1505, '215/65R15', 'en'),
    (1506, '816', 'en'),
    (1507, '215/50R17', 'en'),
    (1508, '205/50R17', 'en'),
    (1509, '24.9', 'en'),
    (1510, '834', 'en'),
    (1511, '225/50R16', 'en'),
    (1512, '235/45R17', 'en'),
    (1513, '195/65R15', 'en'),
    (1514, '7.91', 'en'),
    (1515, '9.7', 'en'),
    (1516, '205/65R15', 'en'),
    (1517, '867', 'en'),
    (1518, '195/60R15', 'en'),
    (1519, '23.5', 'en'),
    (1520, '8', 'en'),
    (1521, '886', 'en'),
    (1522, '85', 'en'),
    (1523, '195/55R15', 'en'),
    (1524, '23.2', 'en'),
    (1525, '895', 'en'),
    (1526, '195/60R14', 'en'),
    (1527, '873', 'en'),
    (1528, '84', 'en'),
    (1529, '195/50R16', 'en'),
    (1530, '913', 'en'),
    (1531, '195/50R15', 'en'),
    (1532, 'Pilot Exalto PE2', 'en'),
    (1533, '23.1', 'en'),
    (1534, '900', 'en'),
    (1535, '205/50R15', 'en'),
    (1536, '897', 'en'),
    (1537, '83', 'en'),
    (1538, '205/45ZR16', 'en'),
    (1539, '23.4', 'en'),
    (1540, '889', 'en'),
    (1541, '22.9', 'en'),
    (1542, '908', 'en'),
    (1543, '195/45R16', 'en'),
    (1544, '23.7', 'en'),
    (1545, '878', 'en'),
    (1546, '870', 'en'),
    (1547, '225/50ZR15', 'en'),
    (1548, '875', 'en'),
    (1549, '215/40ZR17', 'en'),
    (1550, '23', 'en'),
    (1551, '7.6', 'en'),
    (1552, '904', 'en'),
    (1553, '185/55R15', 'en'),
    (1554, '205/55ZR15', 'en'),
    (1555, '6.4', 'en'),
    (1556, '863', 'en'),
    (1557, '205/50ZR16', 'en'),
    (1558, '21.9', 'en'),
    (1559, '950', 'en'),
    (1560, '78', 'en'),
    (1561, '195/45R15', 'en'),
    (1562, '24.6', 'en'),
    (1563, '846', 'en'),
    (1564, '215/45ZR17', 'en'),
    (1565, '835', 'en'),
    (1566, '225/50ZR16', 'en'),
    (1567, '205/50ZR15', 'en'),
    (1568, '215/40ZR16', 'en'),
    (1569, '885', 'en'),
    (1570, '205/40ZR17', 'en'),
    (1571, '205/55ZR16', 'en'),
    (1572, '225/55ZR16', 'en'),
    (1573, '842', 'en'),
    (1574, '215/55ZR17', 'en'),
    (1575, '24.3', 'en'),
    (1576, '856', 'en'),
    (1577, '205/45ZR17', 'en'),
    (1578, '836', 'en'),
    (1579, '24.25', 'en'),
    (1580, '858', 'en'),
    (1581, '205/45R17', 'en'),
    (1582, 'Energy LX4', 'en'),
    (1583, '235/65R16', 'en'),
    (1584, 'P225/60R17', 'en'),
    (1585, 'P225/60R16', 'en'),
    (1586, 'P215/65R16', 'en'),
    (1587, '7.8', 'en'),
    (1588, '725', 'en'),
    (1589, '12.7', 'en'),
    (1590, 'P235/50R17', 'en'),
    (1591, '245/60R17', 'en'),
    (1592, '235/60R17', 'en'),
    (1593, '235-710R460A', 'en'),
    (1594, '28.58', 'en'),
    (1595, 'PS235-710R460A', 'en'),
    (1596, 'Touring', 'en'),
    (1597, 'Energy MXV4 S8', 'en'),
    (1598, '793', 'en'),
    (1599, 'P215/60R16', 'en'),
    (1600, 'P215/55R17', 'en'),
    (1601, '736', 'en'),
    (1602, 'P235/55R18', 'en'),
    (1603, 'P205/65R15', 'en'),
    (1604, '830', 'en'),
    (1605, 'P225/50R17', 'en'),
    (1606, 'P205/60R16', 'en'),
    (1607, 'P235/55R17', 'en'),
    (1608, '23', 'en'),
    (1609, '8.5', 'en'),
    (1610, '12', 'en'),
    (1611, 'Skidmaster Premium', 'en'),
    (1612, '22.6', 'en'),
    (1613, '17', 'en'),
    (1614, '23X8.50-12', 'en'),
    (1615, '27', 'en'),
    (1616, '27X10.50-15', 'en'),
    (1617, '36.3', 'en'),
    (1618, '32', 'en'),
    (1619, '14', 'en'),
    (1620, '14-17.5', 'en'),
    (1621, '40.1', 'en'),
    (1622, '15.3', 'en'),
    (1623, '15-19.5', 'en'),
    (1624, 'CUV', 'en'),
    (1625, 'Classic', 'en'),
    (1626, '15', 'en'),
    (1627, '107.95', 'en'),
    (1628, '1400', 'en'),
    (1629, '-89', 'en'),
    (1630, 'Steel', 'en'),
    (1631, '51 Black Daytona', 'en'),
    (1632, '15″х14″/-89mm, 6x139.7', 'en'),
    (1633, '-63', 'en'),
    (1634, '15″х12″/-63mm, 6x139.7', 'en'),
    (1635, '83.82', 'en'),
    (1636, '1500', 'en'),
    (1637, '-38', 'en'),
    (1638, '15″х10″/-38mm, 5x114.3', 'en'),
    (1639, '15″х10″/-38mm, 5x127', 'en'),
    (1640, '15″х10″/-38mm, 5x139.7', 'en'),
    (1641, '15″х10″/-38mm, 6x139.7', 'en'),
    (1642, '16', 'en'),
    (1643, '130.81', 'en'),
    (1644, '3500', 'en'),
    (1645, '-25', 'en'),
    (1646, '16″х10″/-25mm, 8x165.1', 'en'),
    (1647, '8', 'en'),
    (1648, '-19', 'en'),
    (1649, '15″х8″/-19mm, 5x114.3', 'en'),
    (1650, '120.65', 'en'),
    (1651, '15″х8″/-19mm, 5x120.65', 'en'),
    (1652, '15″х8″/-19mm, 5x127', 'en'),
    (1653, '15″х8″/-19mm, 5x139.7', 'en'),
    (1654, '15″х8″/-19mm, 6x139.7', 'en'),
    (1655, '7', 'en'),
    (1656, '1600', 'en'),
    (1657, '-6', 'en'),
    (1658, '15″х7″/-6mm, 5x114.3', 'en'),
    (1659, '15″х7″/-6mm, 5x120.65', 'en'),
    (1660, '15″х7″/-6mm, 5x127', 'en'),
    (1661, '15″х7″/-6mm, 5x139.7', 'en'),
    (1662, '15″х7″/-6mm, 6x139.7', 'en'),
    (1663, '1700', 'en'),
    (1664, '16″х7″/0mm, 5x114.3', 'en'),
    (1665, '87.12', 'en'),
    (1666, '2000', 'en'),
    (1667, '16″х7″/0mm, 5x135', 'en'),
    (1668, '16″х7″/0mm, 5x127', 'en'),
    (1669, '16″х7″/0mm, 5x139.7', 'en'),
    (1670, '16″х7″/0mm, 6x139.7', 'en'),
    (1671, '16″х7″/0mm, 8x165.1', 'en'),
    (1672, '16″х8″/0mm, 5x114.3', 'en'),
    (1673, '16″х8″/0mm, 5x127', 'en'),
    (1674, '16″х8″/0mm, 5x139.7', 'en'),
    (1675, '16″х8″/0mm, 6x139.7', 'en'),
    (1676, '16″х8″/0mm, 8x165.1', 'en'),
    (1677, '17', 'en'),
    (1678, '17″х9″/0mm, 5x139.7', 'en'),
    (1679, '17″х9″/0mm, 6x139.7', 'en'),
    (1680, '17″х9″/0mm, 8x165.1', 'en'),
    (1681, '6', 'en'),
    (1682, '15″х8″/6mm, 5x114.3', 'en'),
    (1683, '15″х8″/6mm, 6x139.7', 'en'),
    (1684, '17″х8″/6mm, 5x139.7', 'en'),
    (1685, '17″х8″/6mm, 6x139.7', 'en'),
    (1686, '15″х7″/12mm, 5x114.3', 'en'),
    (1687, '15″х7″/12mm, 6x139.7', 'en'),
    (1688, '17″х8″/12mm, 8x165.1', 'en'),
    (1689, '19', 'en'),
    (1690, '15″х7″/19mm, 6x139.7', 'en'),
    (1691, 'Chrome', 'en'),
    (1692, '108.71', 'en'),
    (1693, '-32', 'en'),
    (1694, '60 Chrome Smoothie', 'en'),
    (1695, '15″х10″/-32mm, 6x139.7', 'en'),
    (1696, '81.03', 'en'),
    (1697, '15″х10″/-32mm, 5x114.3', 'en'),
    (1698, '15″х10″/-32mm, 5x127', 'en'),
    (1699, '-13', 'en'),
    (1700, '16″х10″/-13mm, 5x114.3', 'en'),
    (1701, '-12', 'en'),
    (1702, '15″х8″/-12mm, 6x139.7', 'en'),
    (1703, '14', 'en'),
    (1704, '14″х7″/0mm, 5x114.3', 'en'),
    (1705, '15″х7″/0mm, 6x139.7', 'en'),
    (1706, '15″х7″/0mm, 5x114.3', 'en'),
    (1707, '94.23', 'en'),
    (1708, '15″х7″/0mm, 5x127', 'en'),
    (1709, '107.95', 'en'),
    (1710, '3', 'en'),
    (1711, '15″х7″/3mm, 5x107.95', 'en'),
    (1712, '6', 'en'),
    (1713, '4', 'en'),
    (1714, '14″х6″/6mm, 4x107.95', 'en'),
    (1715, '14″х6″/6mm, 5x114.3', 'en'),
    (1716, '5', 'en'),
    (1717, '130', 'en'),
    (1718, '1200', 'en'),
    (1719, '15″х5″/6mm, 4x130', 'en'),
    (1720, '15″х6″/6mm, 5x114.3', 'en'),
    (1721, '16″х7″/6mm, 5x114.3', 'en'),
    (1722, '16″х6″/19mm, 5x114.3', 'en'),
    (1723, '16″х8″/19mm, 5x114.3', 'en'),
    (1724, '16″х6″/25mm, 5x114.3', 'en'),
    (1725, '100', 'en'),
    (1726, '67.95', 'en'),
    (1727, '16″х7″/35mm, 5x100', 'en'),
    (1728, '16″х7″/38mm, 5x114.3', 'en'),
    (1729, 'Raw Machined', 'en'),
    (1730, '61 Raw Smoothie', 'en'),
    (1731, '15″х8″/-6mm, 6x139.7', 'en'),
    (1732, '15″х8″/-6mm, 5x114.3', 'en'),
    (1733, '15″х8″/-6mm, 5x127', 'en'),
    (1734, '15″х7″/3mm, 6x139.7', 'en'),
    (1735, '15″х7″/3mm, 5x114.3', 'en'),
    (1736, '15″х7″/3mm, 5x127', 'en'),
    (1737, '15″х5″/6mm, 6x139.7', 'en'),
    (1738, '15″х5″/6mm, 5x114.3', 'en'),
    (1739, '15″х5″/6mm, 5x127', 'en'),
    (1740, '15″х6″/6mm, 6x139.7', 'en'),
    (1741, '15″х6″/6mm, 5x127', 'en'),
    (1742, '82.55', 'en'),
    (1743, '67 Supreme', 'en'),
    (1744, '15″х10″/-32mm, 5x114.3/127', 'en'),
    (1745, '-22', 'en'),
    (1746, '15″х6″/-22mm, 5x114.3/127', 'en'),
    (1747, '15″х8″/-22mm, 5x114.3/127', 'en'),
    (1748, '-16', 'en'),
    (1749, '14″х6″/-16mm, 5x114.3/127', 'en'),
    (1750, '13', 'en'),
    (1751, '13″х7″/-12mm, 5x114.3/127', 'en'),
    (1752, '14″х7″/-12mm, 5x114.3/127', 'en'),
    (1753, '15″х7″/-12mm, 5x114.3/127', 'en'),
    (1754, '2200', 'en'),
    (1755, '81 Black Soft 8', 'en'),
    (1756, '16″х10″/-25mm, 5x139.7', 'en'),
    (1757, '16″х10″/-25mm, 6x139.7', 'en'),
    (1758, '86.87', 'en'),
    (1759, '2500', 'en'),
    (1760, '16″х8″/0mm, 5x135', 'en'),
    (1761, '17″х9″/0mm, 5x135', 'en'),
    (1762, '17″х9″/0mm, 5x127', 'en'),
    (1763, '17″х9″/0mm, 8x170', 'en'),
    (1764, '54M Matte Black Daytona', 'en'),
    (1765, '15″х10″/-44mm, 5x114.3', 'en'),
    (1766, '15″х10″/-44mm, 5x139.7', 'en'),
    (1767, '15″х10″/-44mm, 6x139.7', 'en'),
    (1768, '110.36', 'en'),
    (1769, '61B Black Smoothie', 'en'),
    (1770, 'Red', 'en'),
    (1771, '61R Red Smoothie', 'en'),
    (1772, '62 Chrome Rallye', 'en'),
    (1773, '15″х10″/-32mm, 5x139.7', 'en'),
    (1774, '74.93', 'en'),
    (1775, '14″х7″/6mm, 4x107.95', 'en'),
    (1776, '14″х7″/6mm, 5x114.3', 'en'),
    (1777, '14″х6″/12mm, 4x107.95', 'en'),
    (1778, '14″х6″/12mm, 5x114.3', 'en'),
    (1779, '15″х6″/12mm, 5x127', 'en'),
    (1780, '15″х6″/12mm, 5x139.7', 'en'),
    (1781, '15″х6″/12mm, 6x139.7', 'en'),
    (1782, '15″х6″/12mm, 5x114.3', 'en'),
    (1783, '63 Silver Rallye', 'en'),
    (1784, '15″х8″/-12mm, 5x127', 'en'),
    (1785, '15″х5″/-6mm, 5x114.3', 'en'),
    (1786, '15″х7″/6mm, 5x127', 'en'),
    (1787, '15″х7″/6mm, 5x139.7', 'en'),
    (1788, '15″х7″/6mm, 6x139.7', 'en'),
    (1789, '15″х7″/6mm, 5x114.3', 'en'),
    (1790, '63 Raw Rallye', 'en'),
    (1791, '87.88', 'en'),
    (1792, '65B Super Spoke', 'en'),
    (1793, '15″х10″/-32mm, 5x114.3/120.65', 'en'),
    (1794, '15″х8″/-6mm, 5x114.3/120.65', 'en'),
    (1795, '-3', 'en'),
    (1796, '14″х6″/-3mm, 5x114.3/120.65', 'en'),
    (1797, '15″х6″/-3mm, 5x114.3/120.65', 'en'),
    (1798, '14″х7″/3mm, 5x114.3/120.65', 'en'),
    (1799, '15″х7″/3mm, 5x114.3/120.65', 'en'),
    (1800, '65C Super Spoke', 'en'),
    (1801, 'Gray', 'en'),
    (1802, '124.21', 'en'),
    (1803, '5', 'en'),
    (1804, 'Light Truck Steel', 'en'),
    (1805, '16″х6″/5mm, 8x165.1', 'en'),
    (1806, '116.08', 'en'),
    (1807, '124.46', 'en'),
    (1808, '121.16', 'en'),
    (1809, '123.95', 'en'),
    (1810, '5.2', 'en'),
    (1811, '16″х6″/5.2mm, 8x165.1', 'en'),
    (1812, '5.4', 'en'),
    (1813, '16″х6″/5.4mm, 8x165.1', 'en'),
    (1814, '125.22', 'en'),
    (1815, '16″х6″/5.4mm, 8x170', 'en'),
    (1816, '54B Black Daytona', 'en'),
    (1817, 'Satin', 'en'),
    (1818, '67B Supreme', 'en'),
    (1819, '15″х10″/-76mm, 5x114.3/120.65', 'en'),
    (1820, '15″х8″/-63mm, 5x114.3/120.65', 'en'),
    (1821, '-54', 'en'),
    (1822, '13″х7″/-54mm, 5x114.3/120.65', 'en'),
    (1823, '14″х7″/-54mm, 5x114.3/120.65', 'en'),
    (1824, '-51', 'en'),
    (1825, '15″х7″/-51mm, 5x114.3/120.65', 'en'),
    (1826, '-48', 'en'),
    (1827, '14″х6″/-48mm, 5x114.3/120.65', 'en'),
    (1828, 'Winter', 'en'),
    (1829, '72', 'en'),
    (1830, '70 Winter Wheel OEM/Snow', 'en'),
    (1831, '15″х6″/35mm, 4x108', 'en'),
    (1832, '15″х6″/35mm, 4x100/114.3', 'en'),
    (1833, '15″х6″/35mm, 5x100/115', 'en'),
    (1834, '15″х6″/35mm, 5x108/114.3', 'en'),
    (1835, '105', 'en'),
    (1836, '16″х6″/35mm, 5x105/115', 'en'),
    (1837, '16″х6″/35mm, 5x100/115', 'en'),
    (1838, '16″х6″/35mm, 5x108/114.3', 'en'),
    (1839, '16″х6″/35mm, 5x110/114.3', 'en'),
    (1840, '5.5', 'en'),
    (1841, '14″х5.5″/38mm, 4x108', 'en'),
    (1842, '14″х5.5″/38mm, 4x100/114.3', 'en'),
    (1843, '14″х5.5″/38mm, 5x100/115', 'en'),
    (1844, '14″х5.5″/38mm, 5x108/114.3', 'en'),
    (1845, '57.1', 'en'),
    (1846, '1562', 'en'),
    (1847, '15″х6″/38mm, 5x100', 'en'),
    (1848, '67', 'en'),
    (1849, '17″х7″/38mm, 5x112', 'en'),
    (1850, '1350', 'en'),
    (1851, '17″х7″/38mm, 4x108', 'en'),
    (1852, '17″х7″/38mm, 5x100/115', 'en'),
    (1853, '17″х7″/38mm, 5x108/114.3', 'en'),
    (1854, '17″х7″/38mm, 5x110/120', 'en'),
    (1855, '6.5', 'en'),
    (1856, '71.6', 'en'),
    (1857, '1560', 'en'),
    (1858, '40', 'en'),
    (1859, '16″х6.5″/40mm, 5x127', 'en'),
    (1860, '71.5', 'en'),
    (1861, '17″х6.5″/40mm, 5x114.3', 'en'),
    (1862, '65.1', 'en'),
    (1863, '42', 'en'),
    (1864, '17″х6.5″/42mm, 5x110', 'en'),
    (1865, '56.1', 'en'),
    (1866, '48', 'en'),
    (1867, '16″х6.5″/48mm, 5x100', 'en'),
    (1868, '50', 'en'),
    (1869, '17″х6.5″/50mm, 5x127', 'en'),
    (1870, '51', 'en'),
    (1871, '16″х7″/51mm, 5x127', 'en'),
    (1872, '64.1', 'en'),
    (1873, '54', 'en'),
    (1874, '16″х6.5″/54mm, 5x114.3', 'en'),
    (1875, 'Trailer', 'en'),
    (1876, 'Raw Macined', 'en'),
    (1877, 'Powder Top Coat', 'en'),
    (1878, '120.65', 'en'),
    (1879, 'Steel Trailer Dual', 'en'),
    (1880, '16″х6″/mm, 8x165.1', 'en'),
    (1881, '4.5', 'en'),
    (1882, 'Machined Spokes', 'en'),
    (1883, '-0.1', 'en'),
    (1884, 'Aluminum', 'en'),
    (1885, 'Brute', 'en'),
    (1886, '850', 'en'),
    (1887, '13″х4.5″/-0.1mm, 5x114.3', 'en'),
    (1888, '3045', 'en'),
    (1889, '0.3', 'en'),
    (1890, 'Light Truck Steel Wheels (Single)', 'en'),
    (1891, '16″х7″/0.3mm, 8x165.1', 'en'),
    (1892, '3750', 'en'),
    (1893, '0.5', 'en'),
    (1894, '16″х6″/0.5mm, 8x165.1', 'en'),
    (1895, 'All Terrain', 'en'),
    (1896, 'Winter', 'en'),
    (1897, '35', 'en'),
    (1898, '12.5', 'en'),
    (1899, 'Terrain Gripper A/T G', 'en'),
    (1900, '35', 'en'),
    (1901, '12.5', 'en'),
    (1902, '15.5', 'en'),
    (1903, '121', 'en'),
    (1904, '35X12.50R20LT', 'en'),
    (1905, '37', 'en'),
    (1906, '36.38', 'en'),
    (1907, '12.64', 'en'),
    (1908, '126', 'en'),
    (1909, '37X12.50R20LT', 'en'),
    (1910, '121/118', 'en'),
    (1911, 'LT265/50R20', 'en'),
    (1912, '31.65', 'en'),
    (1913, '10.71', 'en'),
    (1914, 'LT265/70R17', 'en'),
    (1915, '31.89', 'en'),
    (1916, '11.18', 'en'),
    (1917, 'LT275/55R20', 'en'),
    (1918, '32.28', 'en'),
    (1919, '12.28', 'en'),
    (1920, 'LT285/55R20', 'en'),
    (1921, '32.64', 'en'),
    (1922, '11.61', 'en'),
    (1923, 'LT285/70R17', 'en'),
    (1924, '32.68', 'en'),
    (1925, '11.26', 'en'),
    (1926, 'LT285/75R16', 'en'),
    (1927, '33.15', 'en'),
    (1928, '13.03', 'en'),
    (1929, 'LT305/55R20', 'en'),
    (1930, '12.72', 'en'),
    (1931, '124', 'en'),
    (1932, 'LT305/60R18', 'en'),
    (1933, '32.48', 'en'),
    (1934, '12.52', 'en'),
    (1935, 'LT305/65R17', 'en'),
    (1936, '12.36', 'en'),
    (1937, 'LT305/70R16', 'en'),
    (1938, '34.69', 'en'),
    (1939, 'LT305/70R18', 'en'),
    (1940, '34.2', 'en'),
    (1941, '12.71', 'en'),
    (1942, 'LT315/70R17', 'en'),
    (1943, '34.37', 'en'),
    (1944, '12.32', 'en'),
    (1945, '127', 'en'),
    (1946, 'LT315/75R16', 'en'),
    (1947, '33', 'en'),
    (1948, '33X12.50R22LT', 'en'),
    (1949, '35X12.50R22LT', 'en'),
    (1950, 'All Weather', 'en'),
    (1951, 'Mud Terrain', 'en'),
    (1952, 'Mud Terrain Attack M/T A', 'en'),
    (1953, '32.52', 'en'),
    (1954, 'Q', 'en'),
    (1955, '32.91', 'en'),
    (1956, '35X12.50R16LT', 'en'),
    (1957, '34.8', 'en'),
    (1958, '13.4', 'en'),
    (1959, '125', 'en'),
    (1960, '35X12.50R17LT', 'en'),
    (1961, '13.2', 'en'),
    (1962, '35X12.50R18LT', 'en'),
    (1963, '35.04', 'en'),
    (1964, '13.39', 'en'),
    (1965, '13.5', 'en'),
    (1966, '37', 'en'),
    (1967, '14', 'en'),
    (1968, '37X13.50R20LT', 'en'),
    (1969, '37X13.50R22LT', 'en'),
    (1970, '32.99', 'en'),
    (1971, '10.98', 'en'),
    (1972, 'LT275/60R20', 'en'),
    (1973, '32.83', 'en'),
    (1974, '11.93', 'en'),
    (1975, 'LT285/65R18', 'en'),
    (1976, '32.7', 'en'),
    (1977, '33.39', 'en'),
    (1978, 'LT325/50R22', 'en'),
    (1979, '33X12.50R20LT', 'en'),
    (1980, '24', 'en'),
    (1981, '21', 'en'),
    (1982, '118', 'en'),
    (1983, '35X13.50R24LT', 'en'),
    (1984, '37X13.50R24LT', 'en'),
    (1985, '40', 'en'),
    (1986, '15.5', 'en'),
    (1987, '40', 'en'),
    (1988, '16', 'en'),
    (1989, '128', 'en'),
    (1990, 'P', 'en'),
    (1991, '40X15.50R24LT', 'en'),
    (1992, '37X12.50R17LT', 'en'),
    (1993, '14.5', 'en'),
    (1994, '14.46', 'en'),
    (1995, '117', 'en'),
    (1996, '12', 'en'),
    (1997, '33X14.50R22LT', 'en'),
    (1998, '34.7', 'en'),
    (1999, '15.54', 'en'),
    (2000, '35X15.50R22LT', 'en'),
    (2001, '26', 'en'),
    (2002, '13.6', 'en'),
    (2003, '19.5', 'en'),
    (2004, '37X13.50R26LT', 'en'),
    (2005, '34.61', 'en'),
    (2006, '13.58', 'en'),
    (2007, '35X13.50R26LT', 'en'),
    (2008, '34.76', 'en'),
    (2009, '11.42', 'en'),
    (2010, '19.53', 'en'),
    (2011, '33X13.50R24', 'en'),
    (2012, '35X11.50R20LT', 'en'),
    (2013, '36.76', 'en'),
    (2014, '37X12.50R22LT', 'en'),
    (2015, '38', 'en'),
    (2016, '38X15.50R24LT', 'en'),
    (2017, '37.7', 'en'),
    (2018, '38X15.50R26LT', 'en'),
    (2019, '28', 'en'),
    (2020, '37X13.50R28LT', 'en'),
    (2021, 'Terrain Pro A/T P', 'en'),
    (2022, '34.4', 'en'),
    (2023, '12.7', 'en'),
    (2024, '32.5', 'en'),
    (2025, '34.6', 'en'),
    (2026, 'LT325/65R18', 'en'),
    (2027, '32.9', 'en'),
    (2028, '123/120', 'en'),
    (2029, '33.2', 'en'),
    (2030, '35.3', 'en'),
    (2031, 'LT325/60R20', 'en'),
    (2032, '15.1', 'en'),
    (2033, 'LT265/60R20', 'en'),
    (2034, '34.09', 'en'),
    (2035, 'LT275/65R20', 'en'),
    (2036, '33.46', 'en'),
    (2037, 'LT285/60R20', 'en'),
    (2038, 'LT285/45R22', 'en'),
    (2039, 'LT285/55R22', 'en'),
    (2040, 'LT275/70R18', 'en'),
    (2041, '35.12', 'en'),
    (2042, '11.77', 'en'),
    (2043, '129', 'en'),
    (2044, 'LT295/65R20', 'en'),
    (2045, '34.52', 'en'),
    (2046, '32.4', 'en'),
    (2047, '305/35R24', 'en'),
    (2048, '15.75', 'en'),
    (2049, '33X12.50R24LT', 'en'),
    (2050, '12.45', 'en'),
    (2051, '35X12.50R24LT', 'en'),
    (2052, 'Terrain Attack A/T A', 'en'),
    (2053, '305/40R22', 'en'),
    (2054, 'Trailer', 'en'),
    (2055, '385', 'en'),
    (2056, '22.5', 'en'),
    (2057, 'Endu Trax Ma HD', 'en'),
    (2058, '42.2', 'en'),
    (2059, '15.04', 'en'),
    (2060, '22', 'en'),
    (2061, '164', 'en'),
    (2062, 'K', 'en'),
    (2063, '22', 'en'),
    (2064, '385/65R22.5', 'en'),
    (2065, 'Medium Truck', 'en'),
    (2066, 'Endu Trax Ma', 'en'),
    (2067, '42.6', 'en'),
    (2068, '157', 'en'),
    (2069, '20', 'en'),
    (2070, '315/80R22.5', 'en'),
    (2071, '146/143', 'en'),
    (2072, 'L', 'en'),
    (2073, '16', 'en'),
    (2074, '11R22.5', 'en'),
    (2075, '149/146', 'en'),
    (2076, '11R24.5', 'en'),
    (2077, '285/65R22.5', 'en'),
    (2078, 'Endu Trax MD', 'en'),
    (2079, '43.1', 'en'),
    (2080, '30', 'en'),
    (2081, '17.5', 'en'),
    (2082, 'Endu Combi RT', 'en'),
    (2083, '143', 'en'),
    (2084, '245/70R17.5', 'en'),
    (2085, '235/75R17.5', 'en'),
    (2086, '135', 'en'),
    (2087, '215/75R17.5', 'en'),
    (2088, '144', 'en'),
    (2089, '295/75R22.5', 'en'),
    (2090, '149', 'en'),
    (2091, '40.9', 'en'),
    (2092, '144/142', 'en'),
    (2093, '148', 'en'),
    (2094, '275/70R22.5', 'en'),
    (2095, '138', 'en'),
    (2096, '255/70R22.5', 'en'),
    (2097, '140', 'en'),
    (2098, '19.5', 'en'),
    (2099, '265/70R19.5', 'en'),
    (2100, 'Endu Combi RD CS', 'en'),
    (2101, '41.4', 'en'),
    (2102, '25', 'en'),
    (2103, '126.6', 'en'),
    (2104, '40.4', 'en'),
    (2105, 'Endu Combi RD Os', 'en'),
    (2106, 'M', 'en'),
    (2107, '132', 'en'),
    (2108, '136', 'en'),
    (2109, '121.8', 'en'),
    (2110, '34.1', 'en'),
    (2111, 'Mud Grappler', 'en'),
    (2112, '33.07', 'en'),
    (2113, '13.94', 'en'),
    (2114, '628', 'en'),
    (2115, '33X13.50R15LT', 'en'),
    (2116, '14.57', 'en'),
    (2117, '596', 'en'),
    (2118, '35X14.50R15LT', 'en'),
    (2119, '37.64', 'en'),
    (2120, '15.55', 'en'),
    (2121, '38X15.50R15LT', 'en'),
    (2122, '32.95', 'en'),
    (2123, '12.68', 'en'),
    (2124, '33X12.50R17LT', 'en'),
    (2125, '34.84', 'en'),
    (2126, '13.19', 'en'),
    (2127, '37.05', 'en'),
    (2128, '560', 'en'),
    (2129, '131', 'en'),
    (2130, '37X13.50R17LT', 'en'),
    (2131, '39.72', 'en'),
    (2132, '40X13.50R17LT', 'en'),
    (2133, '33X12.50R18LT', 'en'),
    (2134, '592', 'en'),
    (2135, '14.17', 'en'),
    (2136, '37X13.50R18LT', 'en'),
    (2137, '37.72', 'en'),
    (2138, '16.3', 'en'),
    (2139, '38X15.50R18LT', 'en'),
    (2140, '14.13', 'en'),
    (2141, '38X15.50R20LT', 'en'),
    (2142, '15.91', 'en'),
    (2143, '130', 'en'),
    (2144, '40X15.50R20LT', 'en'),
    (2145, '40X15.50R22LT', 'en'),
    (2146, '12.01', 'en'),
    (2147, '19.7', 'en'),
    (2148, '34.96', 'en'),
    (2149, '12.87', 'en'),
    (2150, '20.7', 'en'),
    (2151, '15.35', 'en'),
    (2152, 'LT385/70R16', 'en'),
    (2153, 'Extreme Terrain', 'en'),
    (2154, 'Dune Grappler', 'en'),
    (2155, '31X10.50R15LT', 'en'),
    (2156, '12.83', 'en'),
    (2157, '640', 'en'),
    (2158, '33X12.50R15LT', 'en'),
    (2159, '32.76', 'en'),
    (2160, '11.57', 'en'),
    (2161, '16.5', 'en'),
    (2162, '32.72', 'en'),
    (2163, '635', 'en'),
    (2164, '34.57', 'en'),
    (2165, '12.73', 'en'),
    (2166, '601', 'en'),
    (2167, '11.73', 'en'),
    (2168, '637', 'en'),
    (2169, '33.82', 'en'),
    (2170, 'LT305/70R17', 'en'),
    (2171, '34.41', 'en'),
    (2172, '12.76', 'en'),
    (2173, '604', 'en'),
    (2174, '36.5', 'en'),
    (2175, '13.11', 'en'),
    (2176, '37X12.50R18LT', 'en'),
    (2177, '639', 'en'),
    (2178, '11.65', 'en'),
    (2179, '664', 'en'),
    (2180, '14.1', 'en'),
    (2181, '305/60R18', 'en'),
    (2182, '34.92', 'en'),
    (2183, '13.15', 'en'),
    (2184, '33.11', 'en'),
    (2185, '15.6', 'en'),
    (2186, 'LT325/60R18', 'en'),
    (2187, '36.42', 'en'),
    (2188, '11.02', 'en'),
    (2189, '32.36', 'en'),
    (2190, '642', 'en'),
    (2191, '35.08', 'en'),
    (2192, '32.05', 'en'),
    (2193, '285/45R22', 'en'),
    (2194, '12.05', 'en'),
    (2195, '305/45R22', 'en'),
    (2196, '31.76', 'en'),
    (2197, 'Terra Grappler', 'en'),
    (2198, '31.54', 'en'),
    (2199, '659', 'en'),
    (2200, '119', 'en'),
    (2201, 'LT265/75R16', 'en'),
    (2202, '11.34', 'en'),
    (2203, '636', 'en'),
    (2204, '33.27', 'en'),
    (2205, '624', 'en'),
    (2206, 'LT295/75R16', 'en'),
    (2207, '34.49', 'en'),
    (2208, '602', 'en'),
    (2209, '31.69', 'en'),
    (2210, '9.18', 'en'),
    (2211, '15.2', 'en'),
    (2212, 'LT235/80R17', 'en'),
    (2213, '31.61', 'en'),
    (2214, '31.57', 'en'),
    (2215, '10.79', 'en'),
    (2216, '13.6', 'en'),
    (2217, '33.19', 'en'),
    (2218, '12.13', 'en'),
    (2219, '16.4', 'en'),
    (2220, '626', 'en'),
    (2221, 'LT295/70R17', 'en'),
    (2222, '33.98', 'en'),
    (2223, '611', 'en'),
    (2224, '13.12', 'en'),
    (2225, '594', 'en'),
    (2226, 'LT325/70R17', 'en'),
    (2227, '52.1', 'en'),
    (2228, '20.5', 'en'),
    (2229, '34', 'en'),
    (2230, '11.06', 'en'),
    (2231, '275/65R18', 'en'),
    (2232, '32.01', 'en'),
    (2233, '10.83', 'en'),
    (2234, 'LT275/65R18', 'en'),
    (2235, '31.38', 'en'),
    (2236, '11.54', 'en'),
    (2237, '13.1', 'en'),
    (2238, 'LT285/60R18', 'en'),
    (2239, '34.88', 'en'),
    (2240, '12.99', 'en'),
    (2241, '355', 'en'),
    (2242, '36.69', 'en'),
    (2243, '14.02', 'en'),
    (2244, '566', 'en'),
    (2245, 'LT355/65R18', 'en'),
    (2246, '609', 'en'),
    (2247, '653', 'en'),
    (2248, '275/55R20', 'en'),
    (2249, '625', 'en'),
    (2250, '32.09', 'en'),
    (2251, '12.2', 'en'),
    (2252, '13.9', 'en'),
    (2253, '647', 'en'),
    (2254, '12.91', 'en'),
    (2255, '36.77', 'en'),
    (2256, '565', 'en'),
    (2257, 'LT355/60R20', 'en'),
    (2258, '11.81', 'en'),
    (2259, '33.23', 'en'),
    (2260, 'LT285/50R22', 'en'),
    (2261, '12.95', 'en'),
    (2262, '285/40R24', 'en'),
    (2263, '36.54', 'en'),
    (2264, '569', 'en'),
    (2265, 'LT315/50R24', 'en'),
    (2266, '30.67', 'en'),
    (2267, '10.55', 'en'),
    (2268, '36.46', 'en'),
    (2269, '13.43', 'en'),
    (2270, '50', 'en'),
    (2271, '29.45', 'en'),
    (2272, '9.69', 'en'),
    (2273, '12.6', 'en'),
    (2274, '30.31', 'en'),
    (2275, '9.72', 'en'),
    (2276, '12.9', 'en'),
    (2277, 'P245/70R17', 'en'),
    (2278, '30.55', 'en'),
    (2279, '10.63', 'en'),
    (2280, '680', 'en'),
    (2281, 'P265/65R17', 'en'),
    (2282, '11.46', 'en'),
    (2283, '13.4', 'en'),
    (2284, 'P285/70R17', 'en'),
    (2285, '33.86', 'en'),
    (2286, '614', 'en'),
    (2287, 'LT285/75R17', 'en'),
    (2288, '10.28', 'en'),
    (2289, '255/60R18', 'en'),
    (2290, '10.67', 'en'),
    (2291, 'P265/70R18', 'en'),
    (2292, '16.6', 'en'),
    (2293, 'LT295/70R18', 'en'),
    (2294, '32.44', 'en'),
    (2295, '12.24', 'en'),
    (2296, '30.51', 'en'),
    (2297, '643', 'en'),
    (2298, '34.45', 'en'),
    (2299, 'LT295/60R20', 'en'),
    (2300, '305/55R20', 'en'),
    (2301, '11.89', 'en'),
    (2302, 'P305/45R22', 'en'),
    (2303, '12.17', 'en'),
    (2304, 'P305/35R24', 'en'),
    (2305, 'LT245/75R17', 'en'),
    (2306, '31.06', 'en'),
    (2307, '10.16', 'en'),
    (2308, '9.17', 'en'),
    (2309, 'P235/75R17', 'en'),
    (2310, 'LT325/70R16', 'en'),
    (2311, 'Dura Grappler', 'en'),
    (2312, '9.57', 'en'),
    (2313, '407', 'en'),
    (2314, '9.96', 'en'),
    (2315, '424', 'en'),
    (2316, '32.87', 'en'),
    (2317, '16.9', 'en'),
    (2318, '393', 'en'),
    (2319, '32.79', 'en'),
    (2320, '12.56', 'en'),
    (2321, '394', 'en'),
    (2322, '31.77', 'en'),
    (2323, '9.32', 'en'),
    (2324, '406', 'en'),
    (2325, '30.59', 'en'),
    (2326, '15.7', 'en'),
    (2327, '422', 'en'),
    (2328, 'LT245/70R17', 'en'),
    (2329, '438', 'en'),
    (2330, '409', 'en'),
    (2331, '423', 'en'),
    (2332, '265/65R17', 'en'),
    (2333, '382', 'en'),
    (2334, '11.49', 'en'),
    (2335, '32.17', 'en'),
    (2336, '10.08', 'en'),
    (2337, '401', 'en'),
    (2338, '388', 'en'),
    (2339, '35.28', 'en'),
    (2340, '17.3', 'en'),
    (2341, '366', 'en'),
    (2342, '33.03', 'en'),
    (2343, '391', 'en'),
    (2344, '34.05', 'en'),
    (2345, '379', 'en'),
    (2346, '405', 'en'),
    (2347, '390', 'en'),
    (2348, '10.51', 'en'),
    (2349, '16.8', 'en'),
    (2350, '408', 'en'),
    (2351, '410', 'en'),
    (2352, '402', 'en'),
    (2353, 'Neo Gen', 'en'),
    (2354, '23.07', 'en'),
    (2355, '8.39', 'en'),
    (2356, '24.02', 'en'),
    (2357, '865', 'en'),
    (2358, '23.35', 'en'),
    (2359, '8.31', 'en'),
    (2360, '890', 'en'),
    (2361, '205/45R16', 'en'),
    (2362, '22.48', 'en'),
    (2363, '8.58', 'en'),
    (2364, '924', 'en'),
    (2365, '205/40R16', 'en'),
    (2366, '23.54', 'en'),
    (2367, '882', 'en'),
    (2368, '24.76', 'en'),
    (2369, '9.8', 'en'),
    (2370, '25.91', 'en'),
    (2371, '9.06', 'en'),
    (2372, '225/50ZR17', 'en'),
    (2373, '25.08', 'en'),
    (2374, '26.22', 'en'),
    (2375, '9.53', 'en'),
    (2376, '10.1', 'en'),
    (2377, '24.53', 'en'),
    (2378, '847', 'en'),
    (2379, '215/40ZR18', 'en'),
    (2380, '215/35ZR18', 'en'),
    (2381, '25.12', 'en'),
    (2382, '827', 'en'),
    (2383, '25.43', 'en'),
    (2384, '9.49', 'en'),
    (2385, '25.75', 'en'),
    (2386, '10.2', 'en'),
    (2387, '24.88', 'en'),
    (2388, '215/35ZR19', 'en'),
    (2389, '25.79', 'en'),
    (2390, '26.54', 'en'),
    (2391, '10.6', 'en'),
    (2392, '26.42', 'en'),
    (2393, '9.02', 'en'),
    (2394, '225/35ZR20', 'en'),
    (2395, '25.35', 'en'),
    (2396, '8.82', 'en'),
    (2397, '225/30ZR20', 'en'),
    (2398, '25.71', 'en'),
    (2399, '9.45', 'en'),
    (2400, '808', 'en'),
    (2401, '25.98', 'en'),
    (2402, '27.76', 'en'),
    (2403, '748', 'en'),
    (2404, '235/30ZR22', 'en'),
    (2405, '24.33', 'en'),
    (2406, '8.23', 'en'),
    (2407, '8.86', 'en'),
    (2408, 'Invo', 'en'),
    (2409, '24.96', 'en'),
    (2410, '27.05', 'en'),
    (2411, '10.31', 'en'),
    (2412, 'P255/50ZR17', 'en'),
    (2413, '8.94', 'en'),
    (2414, '225/45R18', 'en'),
    (2415, '225/40R18', 'en'),
    (2416, '25.39', 'en'),
    (2417, '818', 'en'),
    (2418, '245/50ZR18', 'en'),
    (2419, '26.69', 'en'),
    (2420, '245/45R18', 'en'),
    (2421, '10.04', 'en'),
    (2422, '255/45R18', 'en'),
    (2423, '255/35R18', 'en'),
    (2424, '26.65', 'en'),
    (2425, '779', 'en'),
    (2426, '25.55', 'en'),
    (2427, '26.02', 'en'),
    (2428, '25.51', 'en'),
    (2429, '9.37', 'en'),
    (2430, '25.47', 'en'),
    (2431, '9.84', 'en'),
    (2432, '796', 'en'),
    (2433, '27.17', 'en'),
    (2434, '13.35', 'en'),
    (2435, '245/45ZR20', 'en'),
    (2436, '245/40ZR20', 'en'),
    (2437, '26.77', 'en'),
    (2438, '804', 'en'),
    (2439, '10.12', 'en'),
    (2440, '255/45ZR20', 'en'),
    (2441, '27.01', 'en'),
    (2442, '9.92', 'en'),
    (2443, '26.14', 'en'),
    (2444, '28.62', 'en'),
    (2445, '28.11', 'en'),
    (2446, '13.66', 'en'),
    (2447, '345/25ZR20', 'en'),
    (2448, '27.83', 'en'),
    (2449, '9.61', 'en'),
    (2450, '245/30ZR22', 'en'),
    (2451, '29.06', 'en'),
    (2452, '255/35ZR22', 'en'),
    (2453, '28.03', 'en'),
    (2454, '28.39', 'en'),
    (2455, '265/30ZR22', 'en'),
    (2456, '275/30ZR22', 'en'),
    (2457, '28.82', 'en'),
    (2458, '285/30ZR22', 'en'),
    (2459, '275/25ZR24', 'en'),
    (2460, '9.33', 'en'),
    (2461, '10.39', 'en'),
    (2462, '265/35R18', 'en'),
    (2463, '26.18', 'en'),
    (2464, '26.97', 'en'),
    (2465, '225/45ZR19', 'en'),
    (2466, '10.24', 'en'),
    (2467, '9.1', 'en'),
    (2468, '25.31', 'en'),
    (2469, '25.59', 'en'),
    (2470, '26.57', 'en'),
    (2471, '12.48', 'en'),
    (2472, '325/30ZR19', 'en'),
    (2473, '9.25', 'en'),
    (2474, '275/25ZR20', 'en'),
    (2475, '275/30ZR20', 'en'),
    (2476, '27.72', 'en'),
    (2477, '24.72', 'en'),
    (2478, '225/35R19', 'en'),
    (2479, '255/30R19', 'en'),
    (2480, '26.06', 'en'),
    (2481, 'Race', 'en'),
    (2482, 'NT555R', 'en'),
    (2483, '22.84', 'en'),
    (2484, '6.3', 'en'),
    (2485, '205/55R14', 'en'),
    (2486, 'P275/60R15', 'en'),
    (2487, 'P275/50R15', 'en'),
    (2488, '27.99', 'en'),
    (2489, '5', 'en'),
    (2490, '325/50R15', 'en'),
    (2491, '25.67', 'en'),
    (2492, '811', 'en'),
    (2493, 'P245/50R16', 'en'),
    (2494, 'P245/45R17', 'en'),
    (2495, '25.63', 'en'),
    (2496, 'P275/40R17', 'en'),
    (2497, '315/35R17', 'en'),
    (2498, '285/35ZR18', 'en'),
    (2499, '28.78', 'en'),
    (2500, '305/45R18', 'en'),
    (2501, 'P305/40R18', 'en'),
    (2502, '305/35ZR18', 'en'),
    (2503, '305/35R20', 'en'),
    (2504, '26.89', 'en'),
    (2505, '285/40ZR18', 'en'),
    (2506, 'NT555RII', 'en'),
    (2507, '25.87', 'en'),
    (2508, '499', 'en'),
    (2509, '461', 'en'),
    (2510, '13.23', 'en'),
    (2511, '464', 'en'),
    (2512, 'P325/50R15', 'en'),
    (2513, '503', 'en'),
    (2514, '245/50R16', 'en'),
    (2515, '245/45R17', 'en'),
    (2516, 'P315/35R17', 'en'),
    (2517, '484', 'en'),
    (2518, 'P275/40R18', 'en'),
    (2519, 'P285/40R18', 'en'),
    (2520, '449', 'en'),
    (2521, 'P305/45R18', 'en'),
    (2522, '467', 'en'),
    (2523, '27.44', 'en'),
    (2524, '470', 'en'),
    (2525, '305/35R19', 'en'),
    (2526, '27.56', 'en'),
    (2527, '469', 'en'),
    (2528, '275/35R20', 'en'),
    (2529, '451', 'en'),
    (2530, '482', 'en'),
    (2531, '285/30R20', 'en'),
    (2532, '27.24', 'en'),
    (2533, '305/30R20', 'en'),
    (2534, '28.43', 'en'),
    (2535, '454', 'en'),
    (2536, 'P305/45R17', 'en'),
    (2537, '488', 'en'),
    (2538, '305/35R18', 'en'),
    (2539, '468', 'en'),
    (2540, '27.91', 'en'),
    (2541, '462', 'en'),
    (2542, 'P315/40R18', 'en'),
    (2543, '498', 'en'),
    (2544, 'P335/30R18', 'en'),
    (2545, '480', 'en'),
    (2546, '285/35R19', 'en'),
    (2547, '13.78', 'en'),
    (2548, '475', 'en'),
    (2549, '345/30R19', 'en'),
    (2550, '11.85', 'en'),
    (2551, '459', 'en'),
    (2552, '295/35R20', 'en'),
    (2553, '12.44', 'en'),
    (2554, '403', 'en'),
    (2555, 'NT01', 'en'),
    (2556, '22.76', 'en'),
    (2557, '205/55ZR14', 'en'),
    (2558, '22.95', 'en'),
    (2559, '8.35', 'en'),
    (2560, '905', 'en'),
    (2561, '225/45ZR15', 'en'),
    (2562, '245/50ZR16', 'en'),
    (2563, '23.46', 'en'),
    (2564, '80', 'en'),
    (2565, '24.65', 'en'),
    (2566, '844', 'en'),
    (2567, '838', 'en'),
    (2568, '24.92', 'en'),
    (2569, '10.35', 'en'),
    (2570, '26.26', 'en'),
    (2571, '27.48', 'en'),
    (2572, '315/30ZR20', 'en'),
    (2573, '26.34', 'en'),
    (2574, '315/35ZR17', 'en'),
    (2575, '27.87', 'en'),
    (2576, '285/35ZR20', 'en'),
    (2577, 'Trail Grappler M/T', 'en'),
    (2578, '18.9', 'en'),
    (2579, 'LT285/70R16', 'en'),
    (2580, '370', 'en'),
    (2581, '33.54', 'en'),
    (2582, '11.97', 'en'),
    (2583, '19.4', 'en'),
    (2584, '385', 'en'),
    (2585, '368', 'en'),
    (2586, '373', 'en'),
    (2587, 'LT295/55R20', 'en'),
    (2588, '35.47', 'en'),
    (2589, '20', 'en'),
    (2590, '13.82', 'en'),
    (2591, '38X13.50R24LT', 'en'),
    (2592, '18.3', 'en'),
    (2593, 'LT255/75R17', 'en'),
    (2594, '31.97', 'en'),
    (2595, '404', 'en'),
    (2596, '378', 'en'),
    (2597, '13.27', 'en'),
    (2598, '36.85', 'en'),
    (2599, '350', 'en'),
    (2600, '33.62', 'en'),
    (2601, '19.1', 'en'),
    (2602, '384', 'en'),
    (2603, '34.53', 'en'),
    (2604, '371', 'en'),
    (2605, '37.76', 'en'),
    (2606, '39.76', 'en'),
    (2607, '324', 'en'),
    (2608, '34.33', 'en'),
    (2609, '351', 'en'),
    (2610, '32.6', 'en'),
    (2611, 'LT285/75R18', 'en'),
    (2612, '372', 'en'),
    (2613, '35X11.50R18LT', 'en'),
    (2614, '35.59', 'en'),
    (2615, '20.2', 'en'),
    (2616, '37X11.50R20LT', 'en'),
    (2617, '38X13.50R20LT', 'en'),
    (2618, '33.43', 'en'),
    (2619, '14.41', 'en'),
    (2620, 'LT355/40R22', 'en'),
    (2621, '375', 'en'),
    (2622, '35.55', 'en'),
    (2623, '14.96', 'en'),
    (2624, 'LT375/45R22', 'en'),
    (2625, '38X13.50R22LT', 'en'),
    (2626, '36.06', 'en'),
    (2627, 'LT375/40R24', 'en'),
    (2628, '35X11.50R17LT', 'en'),
    (2629, '39.75', 'en'),
    (2630, '15.5', 'en'),
    (2631, '40X15.50R26LT', 'en'),
    (2632, '42', 'en'),
    (2633, '41.77', 'en'),
    (2634, '42X15.50R26LT', 'en'),
    (2635, '33.7', 'en'),
    (2636, '42X13.50R20LT', 'en'),
    (2637, '42X15.50R22LT', 'en'),
    (2638, '35.43', 'en'),
    (2639, '14.21', 'en'),
    (2640, 'LT355/40R24', 'en'),
    (2641, '42X15.50R24LT', 'en'),
    (2642, '342', 'en'),
    (2643, '38X13.50R17LT', 'en'),
    (2644, '36.8', 'en'),
    (2645, 'NT05', 'en'),
    (2646, '24.45', 'en'),
    (2647, '7.2', 'en'),
    (2648, '235/40R18', 'en'),
    (2649, '10.59', 'en'),
    (2650, '28.46', 'en'),
    (2651, '295/45ZR18', 'en'),
    (2652, '245/35R19', 'en'),
    (2653, '275/30R19', 'en'),
    (2654, '13.31', 'en'),
    (2655, '335/30ZR19', 'en'),
    (2656, '23.11', 'en'),
    (2657, '9.29', 'en'),
    (2658, '305/35ZR19', 'en'),
    (2659, '305/30ZR20', 'en'),
    (2660, '295/40ZR18', 'en'),
    (2661, 'Motivo', 'en'),
    (2662, '25.16', 'en'),
    (2663, '8.46', 'en'),
    (2664, '215/50ZR17', 'en'),
    (2665, '24.61', 'en'),
    (2666, '8.54', 'en'),
    (2667, '9.09', 'en'),
    (2668, '27.36', 'en'),
    (2669, '9.88', 'en'),
    (2670, '235/55ZR17', 'en'),
    (2671, '25.04', 'en'),
    (2672, '26.38', 'en'),
    (2673, '235/45ZR18', 'en'),
    (2674, '28.07', 'en'),
    (2675, '235/55ZR18', 'en'),
    (2676, '28.74', 'en'),
    (2677, '29.29', 'en'),
    (2678, '28.54', 'en'),
    (2679, '245/55ZR18', 'en'),
    (2680, '28.98', 'en'),
    (2681, '10.47', 'en'),
    (2682, '255/55ZR18', 'en'),
    (2683, '27.09', 'en'),
    (2684, '9.21', 'en'),
    (2685, '225/55ZR17', 'en'),
    (2686, '245/50ZR17', 'en'),
    (2687, '225/50ZR18', 'en'),
    (2688, '245/50ZR19', 'en'),
    (2689, '255/50ZR19', 'en'),
    (2690, '29.96', 'en'),
    (2691, '255/55ZR19', 'en'),
    (2692, '10.87', 'en'),
    (2693, '275/45ZR19', 'en'),
    (2694, '275/55ZR19', 'en'),
    (2695, '11.38', 'en'),
    (2696, '245/45ZR19', 'en'),
    (2697, '255/45ZR19', 'en'),
    (2698, '295/30ZR20', 'en'),
    (2699, 'NT421Q', 'en'),
    (2700, '27.64', 'en'),
    (2701, '8.98', 'en'),
    (2702, '12.1', 'en'),
    (2703, '453', 'en'),
    (2704, '12.2', 'en'),
    (2705, '444', 'en'),
    (2706, '12.3', 'en'),
    (2707, '437', 'en'),
    (2708, '447', 'en'),
    (2709, '11.8', 'en'),
    (2710, '465', 'en'),
    (2711, '225/55R18', 'en'),
    (2712, '28.15', 'en'),
    (2713, '235/55R18', 'en'),
    (2714, '30.04', 'en'),
    (2715, '430', 'en'),
    (2716, '445', 'en'),
    (2717, '416', 'en'),
    (2718, '255/65R18', 'en'),
    (2719, '265/65R18', 'en'),
    (2720, '456', 'en'),
    (2721, '29.17', 'en'),
    (2722, '442', 'en'),
    (2723, '29.65', 'en'),
    (2724, '436', 'en'),
    (2725, '10.43', 'en'),
    (2726, '255/60R19', 'en'),
    (2727, '10.91', 'en'),
    (2728, '30.16', 'en'),
    (2729, '428', 'en'),
    (2730, '235/55R20', 'en'),
    (2731, '29.69', 'en'),
    (2732, '435', 'en'),
    (2733, '245/50R20', 'en'),
    (2734, '255/45R20', 'en'),
    (2735, '30.08', 'en'),
    (2736, '429', 'en'),
    (2737, '31.02', 'en'),
    (2738, '434', 'en'),
    (2739, '275/60R20', 'en'),
    (2740, '225/55R19', 'en'),
    (2741, '418', 'en'),
    (2742, 'Exo Grappler Awt', 'en'),
    (2743, '31.73', 'en'),
    (2744, '18.4', 'en'),
    (2745, '400', 'en'),
    (2746, '386', 'en'),
    (2747, '376', 'en'),
    (2748, '32.13', 'en'),
    (2749, '396', 'en'),
    (2750, '383', 'en'),
    (2751, 'LT285/65R20', 'en'),
    (2752, '19.3', 'en'),
    (2753, '380', 'en'),
    (2754, 'LT285/70R18', 'en'),
    (2755, 'LT265/65R18', 'en'),
    (2756, '205/40R18', 'en'),
    (2757, '235/35R19', 'en'),
    (2758, '18', 'en'),
    (2759, '19', 'en'),
    (2760, '1477', 'en'),
    (2761, '168', 'en'),
    (2762, 'V', 'en'),
    (2763, '245/50R18', 'en'),
    (2764, '7', 'en'),
    (2765, '7', 'en'),
    (2766, '17', 'en'),
    (2767, '18', 'en'),
    (2768, '8', 'en'),
    (2769, '18″х8″', 'en'),
    (2770, '7.5', 'en'),
    (2771, '17″х7.5″', 'en'),
    (2772, '17″х7″/-44mm, 5x127/139.7', 'en'),
    (2773, '98', 'en'),
    (2774, '19″х8.5″/-44mm, 5x127/139.7', 'en'),
    (2775, '225/40R19', 'en'),
    (2776, '225/50R17', 'en'),
    (2777, '17″х7.5″/-44mm, 5x127/139.7', 'en'),
    (2778, '114', 'en'),
    (2779, '20″х8.5″', 'en'),
    (2780, '19″х8″', 'en'),
    (2781, '18″х7.5″', 'en'),
    (2782, '18\" DIAMETER (18\" x 8\")', 'en'),
    (2783, '19\" DIAMETER (19\" x 8\")', 'en'),
    (2784, '17″х7″', 'en'),
    (2785, '19\" DIAMETER (19\" x 8.5\")', 'en'),
    (2786, '20\" DIAMETER (20\" x 8.5\")', 'en'),
    (2787, '21\" DIAMETER (21\" x 8.5\")', 'en'),
    (2788, '21', 'en'),
    (2789, '21″х8.5″', 'en'),
    (2790, '205/45R17', 'en'),
    (2791, '19″х8.5″', 'en'),
    (2792, 'Print', 'en'),
    (2793, 'Black and Red', 'en');


--
-- Attribute properties
--
INSERT INTO `%%XC%%_attribute_properties` (`id`, `product_id`, `attribute_id`, `position`, `displayMode`)
VALUES
    (288, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 50, 0, 'S'),
	(289, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 103, 0, ''),
	(290, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 105, 0, ''),
	(291, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 106, 0, ''),
	(292, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 112, 0, ''),
	(293, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 140, 0, ''),
	(294, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 146, 0, ''),
	(338, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 50, 0, 'S'),
	(339, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 103, 0, ''),
	(340, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 105, 0, ''),
	(341, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 106, 0, ''),
	(342, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 112, 0, ''),
	(343, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 140, 0, ''),
	(344, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 146, 0, ''),
	(345, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 50, 0, 'S'),
	(346, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 103, 0, ''),
	(347, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 105, 0, ''),
	(348, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 106, 0, ''),
	(349, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 112, 0, ''),
	(350, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 140, 0, ''),
	(351, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 146, 0, ''),
	(352, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 50, 0, 'S'),
	(353, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 103, 0, ''),
	(354, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 105, 0, ''),
	(355, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 106, 0, ''),
	(356, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 112, 0, ''),
	(357, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 140, 0, ''),
	(358, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 146, 0, ''),
	(359, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 50, 0, 'S'),
	(360, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 103, 0, ''),
	(361, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 105, 0, ''),
	(362, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 106, 0, ''),
	(363, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 112, 0, ''),
	(364, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 140, 0, ''),
	(365, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 146, 0, ''),
	(366, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 103, 0, ''),
	(367, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 105, 0, ''),
	(368, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 106, 0, ''),
	(369, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 112, 0, ''),
	(370, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 140, 0, ''),
	(371, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 146, 0, ''),
	(372, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 50, 0, 'S'),
	(373, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 103, 0, ''),
	(374, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 105, 0, ''),
	(375, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 106, 0, ''),
	(376, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 112, 0, ''),
	(377, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 140, 0, ''),
	(378, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 146, 0, ''),
	(379, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 50, 0, 'S'),
	(380, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 103, 0, ''),
	(381, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 105, 0, ''),
	(382, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 106, 0, ''),
	(383, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 112, 0, ''),
	(384, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 140, 0, ''),
	(385, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 146, 0, ''),
	(386, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 103, 0, ''),
	(387, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 105, 0, ''),
	(388, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 106, 0, ''),
	(389, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 112, 0, ''),
	(390, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 140, 0, ''),
	(391, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 146, 0, ''),
	(412, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 50, 0, 'S'),
	(413, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 103, 0, ''),
	(414, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 105, 0, ''),
	(415, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 106, 0, ''),
	(416, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 112, 0, ''),
	(417, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 140, 0, ''),
	(418, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 146, 0, ''),
	(419, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 50, 0, 'S'),
	(420, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 103, 0, ''),
	(421, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 105, 0, ''),
	(422, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 106, 0, ''),
	(423, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 112, 0, ''),
	(424, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 140, 0, ''),
	(425, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 146, 0, ''),
	(426, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 158, 1, 'S'),
	(452, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 103, 0, ''),
	(453, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 105, 0, ''),
	(454, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 106, 0, ''),
	(455, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 112, 0, ''),
	(456, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 140, 0, ''),
	(457, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 146, 0, ''),
	(458, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 103, 0, ''),
	(459, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 105, 0, ''),
	(460, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 106, 0, ''),
	(461, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 112, 0, ''),
	(462, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 140, 0, ''),
	(463, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 146, 0, ''),
	(464, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 161, 1, 'S'),
	(472, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 50, 0, ''),
	(473, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 50, 0, 'S'),
	(474, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 103, 0, ''),
	(475, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 105, 0, ''),
	(476, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 106, 0, ''),
	(477, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 112, 0, ''),
	(478, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 140, 0, ''),
	(479, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 146, 0, ''),
	(480, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 50, 0, ''),
	(481, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 50, 0, 'S'),
	(505, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 50, 0, 'S'),
	(506, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 103, 0, ''),
	(507, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 105, 0, ''),
	(508, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 106, 0, ''),
	(509, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 112, 0, ''),
	(510, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 140, 0, ''),
	(511, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 146, 0, ''),
	(512, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 50, 0, 'S'),
	(513, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 103, 0, ''),
	(514, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 105, 0, ''),
	(515, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 106, 0, ''),
	(516, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 112, 0, ''),
	(517, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 140, 0, ''),
	(518, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 146, 0, ''),
	(519, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 50, 0, 'S'),
	(520, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 103, 0, ''),
	(521, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 105, 0, ''),
	(522, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 106, 0, ''),
	(523, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 112, 0, ''),
	(524, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 140, 0, ''),
	(525, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 146, 0, ''),
	(526, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 50, 0, 'S'),
	(527, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 103, 0, ''),
	(528, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 105, 0, ''),
	(529, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 106, 0, ''),
	(530, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 112, 0, ''),
	(531, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 140, 0, ''),
	(532, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 146, 0, ''),
	(533, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 50, 0, 'S'),
	(534, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 103, 0, ''),
	(535, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 105, 0, ''),
	(536, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 106, 0, ''),
	(537, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 112, 0, ''),
	(538, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 140, 0, ''),
	(539, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 146, 0, ''),
	(540, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 50, 0, 'S'),
	(541, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 103, 0, ''),
	(542, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 105, 0, ''),
	(543, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 106, 0, ''),
	(544, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 112, 0, ''),
	(545, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 140, 0, ''),
	(546, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 146, 0, ''),
	(547, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 50, 0, 'S'),
	(548, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 103, 0, ''),
	(549, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 105, 0, ''),
	(550, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 106, 0, ''),
	(551, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 112, 0, ''),
	(552, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 140, 0, ''),
	(553, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 146, 0, ''),
	(554, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 50, 0, 'S'),
	(555, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 103, 0, ''),
	(556, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 105, 0, ''),
	(557, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 106, 0, ''),
	(558, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 112, 0, ''),
	(559, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 140, 0, ''),
	(560, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 146, 0, ''),
	(561, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 50, 0, 'S'),
	(562, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 103, 0, ''),
	(563, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 105, 0, ''),
	(564, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 106, 0, ''),
	(565, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 112, 0, ''),
	(566, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 140, 0, ''),
	(567, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 146, 0, ''),
	(568, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 50, 0, 'S'),
	(569, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 103, 0, ''),
	(570, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 105, 0, ''),
	(571, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 106, 0, ''),
	(572, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 112, 0, ''),
	(573, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 140, 0, ''),
	(574, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 146, 0, ''),
	(575, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 50, 0, 'S'),
	(576, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 103, 0, ''),
	(577, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 105, 0, ''),
	(578, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 106, 0, ''),
	(579, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 112, 0, ''),
	(580, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 140, 0, ''),
	(581, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 146, 0, ''),
	(582, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 50, 0, 'S'),
	(583, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 103, 0, ''),
	(584, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 105, 0, ''),
	(585, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 106, 0, ''),
	(586, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 112, 0, ''),
	(587, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 140, 0, ''),
	(588, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 146, 0, ''),
	(589, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 50, 0, 'S'),
	(590, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 103, 0, ''),
	(591, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 105, 0, ''),
	(592, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 106, 0, ''),
	(593, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 112, 0, ''),
	(594, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 140, 0, ''),
	(595, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 146, 0, ''),
	(596, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 50, 0, ''),
	(597, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 103, 0, ''),
	(598, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 105, 0, ''),
	(599, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 106, 0, ''),
	(600, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 112, 0, ''),
	(601, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 140, 0, ''),
	(602, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 146, 0, ''),
	(603, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 50, 0, 'S'),
	(604, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 103, 0, ''),
	(605, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 105, 0, ''),
	(606, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 106, 0, ''),
	(607, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 112, 0, ''),
	(608, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 140, 0, ''),
	(609, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 146, 0, ''),
	(612, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 50, 0, ''),
	(613, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 103, 0, ''),
	(614, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 103, 0, ''),
	(615, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 105, 0, ''),
	(616, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 105, 0, ''),
	(617, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 106, 0, ''),
	(618, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 106, 0, ''),
	(619, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 112, 0, ''),
	(620, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 50, 0, ''),
	(621, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 103, 0, ''),
	(622, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 105, 0, ''),
	(623, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 106, 0, ''),
	(624, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 112, 0, ''),
	(625, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 50, 0, 'S'),
	(626, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 103, 0, ''),
	(627, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 105, 0, ''),
	(628, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 106, 0, ''),
	(629, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 112, 0, ''),
	(630, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 140, 0, ''),
	(631, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 146, 0, ''),
	(632, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 50, 0, 'S'),
	(633, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 103, 0, ''),
	(634, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 105, 0, ''),
	(635, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 106, 0, ''),
	(636, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 112, 0, ''),
	(637, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 140, 0, ''),
	(638, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 146, 0, ''),
	(646, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 50, 0, 'S'),
	(647, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 103, 0, ''),
	(648, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 105, 0, ''),
	(649, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 106, 0, ''),
	(650, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 112, 0, ''),
	(651, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 140, 0, ''),
	(652, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 146, 0, ''),
	(653, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 50, 0, ''),
	(654, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 103, 0, ''),
	(655, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 105, 0, ''),
	(656, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 106, 0, ''),
	(657, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 112, 0, ''),
	(658, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 140, 0, ''),
	(659, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 146, 0, ''),
	(660, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 50, 0, ''),
	(661, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 103, 0, ''),
	(662, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 103, 0, ''),
	(663, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 105, 0, ''),
	(664, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 105, 0, ''),
	(665, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 106, 0, ''),
	(666, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 106, 0, ''),
	(667, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 112, 0, ''),
	(668, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 50, 0, ''),
	(669, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 103, 0, ''),
	(670, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 105, 0, ''),
	(671, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 106, 0, ''),
	(672, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 112, 0, ''),
	(673, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 50, 0, 'S'),
	(674, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 103, 0, ''),
	(675, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 105, 0, ''),
	(676, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 106, 0, ''),
	(677, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 112, 0, ''),
	(678, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 140, 0, ''),
	(679, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 146, 0, ''),
	(680, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 50, 0, ''),
	(681, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 103, 0, ''),
	(682, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 105, 0, ''),
	(683, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 106, 0, ''),
	(684, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 112, 0, ''),
	(685, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 140, 0, ''),
	(686, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 146, 0, ''),
	(687, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 50, 0, 'S'),
	(688, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 103, 0, ''),
	(689, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 105, 0, ''),
	(690, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 106, 0, ''),
	(691, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 112, 0, ''),
	(692, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 140, 0, ''),
	(693, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 146, 0, ''),
	(694, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 50, 0, ''),
	(695, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 103, 0, ''),
	(696, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 105, 0, ''),
	(697, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 106, 0, ''),
	(698, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 112, 0, ''),
	(699, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 140, 0, ''),
	(700, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 146, 0, ''),
	(701, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 50, 0, ''),
	(702, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 103, 0, ''),
	(703, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 105, 0, ''),
	(704, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 106, 0, ''),
	(705, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 112, 0, ''),
	(706, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 140, 0, ''),
	(707, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 146, 0, ''),
	(708, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 50, 0, ''),
	(709, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 103, 0, ''),
	(710, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 105, 0, ''),
	(711, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 106, 0, ''),
	(712, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 112, 0, ''),
	(713, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 140, 0, ''),
	(714, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 146, 0, ''),
	(715, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 50, 0, 'S'),
	(716, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 103, 0, ''),
	(717, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 105, 0, ''),
	(718, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 106, 0, ''),
	(719, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 112, 0, ''),
	(720, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 140, 0, ''),
	(721, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 146, 0, ''),
	(722, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 50, 0, 'S'),
	(723, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 103, 0, ''),
	(724, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 105, 0, ''),
	(725, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 106, 0, ''),
	(726, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 112, 0, ''),
	(727, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 140, 0, ''),
	(728, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 146, 0, ''),
	(729, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 103, 0, ''),
	(730, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 105, 0, ''),
	(731, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 106, 0, ''),
	(732, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 112, 0, ''),
	(733, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 140, 0, ''),
	(734, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 146, 0, ''),
	(735, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 50, 0, 'S'),
	(736, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 103, 0, ''),
	(737, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 105, 0, ''),
	(738, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 106, 0, ''),
	(739, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 112, 0, ''),
	(740, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 140, 0, ''),
	(741, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 146, 0, ''),
	(742, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 103, 0, ''),
	(743, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 105, 0, ''),
	(744, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 106, 0, ''),
	(745, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 112, 0, ''),
	(746, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 140, 0, ''),
	(747, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 146, 0, ''),
	(748, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 103, 0, ''),
	(749, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 105, 0, ''),
	(750, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 106, 0, ''),
	(751, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 112, 0, ''),
	(752, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 140, 0, ''),
	(753, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 146, 0, ''),
	(754, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 103, 0, ''),
	(755, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 105, 0, ''),
	(756, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 106, 0, ''),
	(757, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 112, 0, ''),
	(758, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 140, 0, ''),
	(759, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 146, 0, ''),
	(766, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 103, 0, ''),
	(767, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 105, 0, ''),
	(768, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 106, 0, ''),
	(769, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 112, 0, ''),
	(770, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 140, 0, ''),
	(771, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 146, 0, ''),
	(784, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 103, 0, ''),
	(785, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 105, 0, ''),
	(786, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 106, 0, ''),
	(787, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 112, 0, ''),
	(788, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 140, 0, ''),
	(789, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 146, 0, ''),
	(790, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 103, 0, ''),
	(791, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 105, 0, ''),
	(792, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 106, 0, ''),
	(793, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 112, 0, ''),
	(794, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 140, 0, ''),
	(795, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 146, 0, ''),
	(796, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 50, 0, ''),
	(797, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 103, 0, ''),
	(798, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 103, 0, ''),
	(799, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 105, 0, ''),
	(800, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 105, 0, ''),
	(801, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 106, 0, ''),
	(802, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 106, 0, ''),
	(803, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 112, 0, ''),
	(804, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 50, 0, ''),
	(805, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 103, 0, ''),
	(806, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 105, 0, ''),
	(807, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 106, 0, ''),
	(808, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 112, 0, ''),
	(809, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 50, 0, ''),
	(810, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 103, 0, ''),
	(811, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 103, 0, ''),
	(812, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 105, 0, ''),
	(813, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 105, 0, ''),
	(814, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 106, 0, ''),
	(815, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 106, 0, ''),
	(816, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 112, 0, ''),
	(817, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 50, 0, ''),
	(818, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 103, 0, ''),
	(819, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 105, 0, ''),
	(820, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 106, 0, ''),
	(821, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 112, 0, ''),
	(829, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 50, 0, ''),
	(830, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 103, 0, ''),
	(831, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 103, 0, ''),
	(832, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 105, 0, ''),
	(833, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 105, 0, ''),
	(834, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 106, 0, ''),
	(835, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 106, 0, ''),
	(836, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 118, 0, ''),
	(837, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 50, 0, ''),
	(838, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 103, 0, ''),
	(839, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 105, 0, ''),
	(840, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 106, 0, ''),
	(841, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 118, 0, ''),
	(842, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 50, 0, ''),
	(843, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 103, 0, ''),
	(844, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 103, 0, ''),
	(845, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 105, 0, ''),
	(846, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 105, 0, ''),
	(847, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 106, 0, ''),
	(848, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 106, 0, ''),
	(849, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 118, 0, ''),
	(850, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 50, 0, ''),
	(851, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 103, 0, ''),
	(852, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 105, 0, ''),
	(853, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 106, 0, ''),
	(854, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 118, 0, ''),
	(855, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 50, 0, ''),
	(856, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 103, 0, ''),
	(857, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 103, 0, ''),
	(858, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 105, 0, ''),
	(859, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 105, 0, ''),
	(860, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 106, 0, ''),
	(861, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 106, 0, ''),
	(862, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 112, 0, ''),
	(863, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 112, 0, ''),
	(864, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 118, 0, ''),
	(865, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 118, 0, ''),
	(866, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 119, 0, ''),
	(867, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 50, 0, ''),
	(868, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 103, 0, ''),
	(869, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 105, 0, ''),
	(870, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 106, 0, ''),
	(871, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 112, 0, ''),
	(872, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 118, 0, ''),
	(873, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 119, 0, ''),
	(874, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 50, 0, ''),
	(875, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 50, 0, 'S'),
	(876, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 50, 0, ''),
	(877, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 50, 0, 'S'),
	(878, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 103, 0, ''),
	(879, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 105, 0, ''),
	(880, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 106, 0, ''),
	(881, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 112, 0, ''),
	(882, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 140, 0, ''),
	(883, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 146, 0, ''),
	(884, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 50, 0, ''),
	(885, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 50, 0, 'S'),
	(886, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 50, 0, ''),
	(887, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 50, 0, 'S'),
	(888, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 50, 0, ''),
	(889, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 50, 0, 'S'),
	(890, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 103, 0, ''),
	(891, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 105, 0, ''),
	(892, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 106, 0, ''),
	(893, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 112, 0, ''),
	(894, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 140, 0, ''),
	(895, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 146, 0, ''),
	(896, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 50, 0, ''),
	(897, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 50, 0, 'S'),
	(898, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 103, 0, ''),
	(899, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 105, 0, ''),
	(900, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 106, 0, ''),
	(901, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 112, 0, ''),
	(902, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 140, 0, ''),
	(903, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 146, 0, ''),
	(912, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 50, 0, 'S'),
	(913, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 50, 0, 'S'),
	(914, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 50, 0, 'S'),
	(915, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 50, 0, 'S'),
	(916, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 50, 0, 'S'),
	(917, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 50, 0, 'S'),
	(918, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 103, 0, ''),
	(919, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 105, 0, ''),
	(920, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 106, 0, ''),
	(921, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 112, 0, ''),
	(922, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 140, 0, ''),
	(923, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 146, 0, ''),
	(924, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 50, 0, ''),
	(925, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 50, 0, 'S'),
	(926, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 103, 0, ''),
	(927, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 105, 0, ''),
	(928, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 106, 0, ''),
	(929, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 112, 0, ''),
	(930, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 140, 0, ''),
	(931, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 146, 0, ''),
	(942, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 50, 0, ''),
	(943, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 50, 0, 'S'),
	(944, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 50, 0, 'S'),
	(945, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 50, 0, 'S'),
	(946, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 50, 0, 'S'),
	(947, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 50, 0, 'S'),
	(948, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 103, 0, ''),
	(949, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 105, 0, ''),
	(950, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 106, 0, ''),
	(951, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 112, 0, ''),
	(952, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 140, 0, ''),
	(953, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 146, 0, ''),
	(954, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 50, 0, ''),
	(955, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 50, 0, 'S'),
	(958, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 50, 0, ''),
	(959, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 50, 0, 'S'),
	(960, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 103, 0, ''),
	(961, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 105, 0, ''),
	(962, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 106, 0, ''),
	(963, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 112, 0, ''),
	(964, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 140, 0, ''),
	(965, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 146, 0, ''),
	(968, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 50, 0, ''),
	(969, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 50, 0, 'S'),
	(970, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 103, 0, ''),
	(971, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 105, 0, ''),
	(972, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 106, 0, ''),
	(973, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 112, 0, ''),
	(974, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 140, 0, ''),
	(975, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 146, 0, ''),
	(984, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 50, 0, ''),
	(985, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 50, 0, 'S'),
	(993, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 50, 0, ''),
	(994, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 103, 0, ''),
	(995, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 103, 0, ''),
	(996, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 105, 0, ''),
	(997, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 105, 0, ''),
	(998, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 106, 0, ''),
	(999, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 50, 0, ''),
	(1000, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 103, 0, ''),
	(1001, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 105, 0, ''),
	(1002, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 106, 0, ''),
	(1003, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 163, 1, 'S'),
	(1022, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 50, 0, ''),
	(1023, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 50, 0, ''),
	(1156, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 103, 0, ''),
	(1157, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 103, 0, ''),
	(1158, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 105, 0, ''),
	(1159, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 105, 0, ''),
	(1160, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 106, 0, ''),
	(1161, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 106, 0, ''),
	(1214, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 103, 0, ''),
	(1215, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 103, 0, ''),
	(1216, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 105, 0, ''),
	(1217, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 105, 0, ''),
	(1218, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 106, 0, ''),
	(1219, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 106, 0, ''),
	(1220, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 112, 0, ''),
	(1221, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 112, 0, ''),
	(1222, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 140, 0, ''),
	(1223, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 140, 0, ''),
	(1224, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 146, 0, ''),
	(1225, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 146, 0, ''),
	(1262, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 103, 0, ''),
	(1263, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 103, 0, ''),
	(1264, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 105, 0, ''),
	(1265, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 105, 0, ''),
	(1266, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 106, 0, ''),
	(1267, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 106, 0, ''),
	(1268, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 112, 0, ''),
	(1269, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 112, 0, ''),
	(1270, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 140, 0, ''),
	(1271, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 140, 0, ''),
	(1272, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 146, 0, ''),
	(1273, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 146, 0, ''),
	(1274, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 164, 2, 'S'),
	(1275, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 165, 1, 'S'),
	(1276, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 166, 1, 'S'),
	(1278, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 168, 1, 'S'),
	(1279, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 103, 0, ''),
	(1280, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 105, 0, ''),
	(1281, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 106, 0, ''),
	(1282, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 112, 0, ''),
	(1283, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 140, 0, ''),
	(1284, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 146, 0, ''),
	(1285, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 50, 0, 'S'),
	(1286, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 50, 0, 'S'),
	(1287, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 50, 0, ''),
	(1288, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 103, 0, ''),
	(1289, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 105, 0, ''),
	(1290, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 106, 0, ''),
	(1291, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 112, 0, ''),
	(1292, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 140, 0, ''),
	(1293, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 146, 0, ''),
	(1294, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 103, 0, ''),
	(1295, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 105, 0, ''),
	(1296, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 106, 0, ''),
	(1297, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 112, 0, ''),
	(1298, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 140, 0, ''),
	(1299, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 146, 0, ''),
	(1300, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 103, 0, ''),
	(1301, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 105, 0, ''),
	(1302, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 106, 0, ''),
	(1303, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 112, 0, ''),
	(1304, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 140, 0, ''),
	(1305, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 146, 0, ''),
	(1314, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 171, 0, ''),
	(1315, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 171, 0, ''),
	(1316, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 103, 0, ''),
	(1317, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 103, 0, ''),
	(1318, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 105, 0, ''),
	(1319, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 105, 0, ''),
	(1320, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 106, 0, ''),
	(1321, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 106, 0, ''),
	(1322, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 112, 0, ''),
	(1323, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 112, 0, ''),
	(1324, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 140, 0, ''),
	(1325, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 140, 0, ''),
	(1326, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 146, 0, ''),
	(1327, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 146, 0, ''),
	(1328, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 103, 0, ''),
	(1329, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 103, 0, ''),
	(1330, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 105, 0, ''),
	(1331, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 105, 0, ''),
	(1332, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 106, 0, ''),
	(1333, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 106, 0, ''),
	(1334, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 112, 0, ''),
	(1335, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 112, 0, ''),
	(1336, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 140, 0, ''),
	(1337, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 140, 0, ''),
	(1338, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 146, 0, ''),
	(1339, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 146, 0, ''),
	(1340, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 103, 0, ''),
	(1341, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 103, 0, ''),
	(1342, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 105, 0, ''),
	(1343, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 105, 0, ''),
	(1344, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 106, 0, ''),
	(1345, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 106, 0, ''),
	(1346, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 112, 0, ''),
	(1347, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 112, 0, ''),
	(1348, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 140, 0, ''),
	(1349, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 140, 0, ''),
	(1350, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 146, 0, ''),
	(1351, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 146, 0, ''),
	(1352, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 103, 0, ''),
	(1353, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 103, 0, ''),
	(1354, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 105, 0, ''),
	(1355, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 105, 0, ''),
	(1356, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 106, 0, ''),
	(1357, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 106, 0, ''),
	(1358, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 112, 0, ''),
	(1359, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 112, 0, ''),
	(1360, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 140, 0, ''),
	(1361, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 140, 0, ''),
	(1362, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 146, 0, ''),
	(1363, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 146, 0, ''),
	(1364, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 103, 0, ''),
	(1365, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 103, 0, ''),
	(1366, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 105, 0, ''),
	(1367, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 105, 0, ''),
	(1368, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 106, 0, ''),
	(1369, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 106, 0, ''),
	(1370, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 112, 0, ''),
	(1371, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 112, 0, ''),
	(1372, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 140, 0, ''),
	(1373, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 140, 0, ''),
	(1374, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 146, 0, ''),
	(1375, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 146, 0, ''),
	(1376, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 103, 0, ''),
	(1377, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 105, 0, ''),
	(1378, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 106, 0, ''),
	(1379, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 112, 0, ''),
	(1380, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 140, 0, ''),
	(1381, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 146, 0, ''),
	(1382, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 103, 0, ''),
	(1383, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 105, 0, ''),
	(1384, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 106, 0, ''),
	(1385, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 112, 0, ''),
	(1386, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 140, 0, ''),
	(1387, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 146, 0, ''),
	(1388, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 103, 0, ''),
	(1389, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 105, 0, ''),
	(1390, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 106, 0, ''),
	(1391, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 112, 0, ''),
	(1392, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 140, 0, ''),
	(1393, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 146, 0, ''),
	(1394, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 103, 0, ''),
	(1395, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 105, 0, ''),
	(1396, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 106, 0, ''),
	(1397, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 112, 0, ''),
	(1398, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 140, 0, ''),
	(1399, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 146, 0, ''),
	(1400, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 103, 0, ''),
	(1401, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 105, 0, ''),
	(1402, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 106, 0, ''),
	(1403, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 112, 0, ''),
	(1404, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 140, 0, ''),
	(1405, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 146, 0, ''),
	(1406, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 50, 0, ''),
	(1407, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 103, 0, ''),
	(1408, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 105, 0, ''),
	(1409, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 106, 0, ''),
	(1410, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 112, 0, ''),
	(1411, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 140, 0, ''),
	(1412, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 146, 0, ''),
	(1413, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 103, 0, ''),
	(1414, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 105, 0, ''),
	(1415, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 106, 0, ''),
	(1416, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 112, 0, ''),
	(1417, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 140, 0, ''),
	(1418, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 146, 0, ''),
	(1419, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 103, 0, ''),
	(1420, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 105, 0, ''),
	(1421, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 106, 0, ''),
	(1422, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 112, 0, ''),
	(1423, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 140, 0, ''),
	(1424, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 146, 0, ''),
	(1425, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 50, 0, ''),
	(1426, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 103, 0, ''),
	(1427, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 105, 0, ''),
	(1428, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 106, 0, ''),
	(1429, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 112, 0, ''),
	(1430, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 140, 0, ''),
	(1431, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 146, 0, ''),
	(1432, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 103, 0, ''),
	(1433, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 105, 0, ''),
	(1434, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 106, 0, ''),
	(1435, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 112, 0, ''),
	(1436, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 140, 0, ''),
	(1437, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 146, 0, ''),
	(1438, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 103, 0, ''),
	(1439, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 105, 0, ''),
	(1440, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 106, 0, ''),
	(1441, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 112, 0, ''),
	(1442, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 140, 0, ''),
	(1443, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 146, 0, ''),
	(1444, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 50, 0, ''),
	(1445, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 103, 0, ''),
	(1446, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 105, 0, ''),
	(1447, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 106, 0, ''),
	(1448, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 112, 0, ''),
	(1449, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 140, 0, ''),
	(1450, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 146, 0, ''),
	(1451, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 103, 0, ''),
	(1452, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 105, 0, ''),
	(1453, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 106, 0, ''),
	(1454, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 112, 0, ''),
	(1455, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 140, 0, ''),
	(1456, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 146, 0, ''),
	(1457, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 103, 0, ''),
	(1458, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 105, 0, ''),
	(1459, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 106, 0, ''),
	(1460, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 112, 0, ''),
	(1461, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 140, 0, ''),
	(1462, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 146, 0, ''),
	(1463, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 50, 0, ''),
	(1464, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 103, 0, ''),
	(1465, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 105, 0, ''),
	(1466, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 106, 0, ''),
	(1467, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 112, 0, ''),
	(1468, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 140, 0, ''),
	(1469, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 146, 0, ''),
	(1470, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 50, 0, ''),
	(1471, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 50, 0, 'S'),
	(1480, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 50, 0, 'S'),
	(1482, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 103, 0, ''),
	(1483, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 105, 0, ''),
	(1484, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 106, 0, ''),
	(1485, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 112, 0, ''),
	(1486, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 140, 0, ''),
	(1487, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 146, 0, ''),
	(1488, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 50, 0, 'S'),
	(1495, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 50, 0, 'S'),
	(1496, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 50, 0, 'S'),
	(1497, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 103, 0, ''),
	(1498, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 105, 0, ''),
	(1499, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 106, 0, ''),
	(1500, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 112, 0, ''),
	(1501, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 140, 0, ''),
	(1502, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 146, 0, ''),
	(1503, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 50, 0, 'S'),
	(1504, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 103, 0, ''),
	(1505, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 105, 0, ''),
	(1506, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 106, 0, ''),
	(1507, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 112, 0, ''),
	(1508, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 140, 0, ''),
	(1509, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 146, 0, ''),
	(1510, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 50, 0, 'S'),
	(1511, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 103, 0, ''),
	(1512, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 105, 0, ''),
	(1513, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 106, 0, ''),
	(1514, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 112, 0, ''),
	(1515, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 140, 0, ''),
	(1516, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 146, 0, ''),
	(1517, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 50, 0, 'S'),
	(1518, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 103, 0, ''),
	(1519, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 105, 0, ''),
	(1520, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 106, 0, ''),
	(1521, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 112, 0, ''),
	(1522, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 140, 0, ''),
	(1523, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 146, 0, ''),
	(1524, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 50, 0, ''),
	(1525, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 50, 0, 'S'),
	(1526, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 103, 0, ''),
	(1527, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 105, 0, ''),
	(1528, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 106, 0, ''),
	(1529, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 112, 0, ''),
	(1530, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 140, 0, ''),
	(1531, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 146, 0, ''),
	(1532, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 50, 0, 'S'),
	(1533, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 103, 0, ''),
	(1534, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 105, 0, ''),
	(1535, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 106, 0, ''),
	(1536, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 112, 0, ''),
	(1537, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 140, 0, ''),
	(1538, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 146, 0, ''),
	(1539, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 50, 0, 'S'),
	(1540, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 103, 0, ''),
	(1541, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 105, 0, ''),
	(1542, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 106, 0, ''),
	(1543, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 112, 0, ''),
	(1544, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 140, 0, ''),
	(1545, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 146, 0, ''),
	(1547, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 103, 0, ''),
	(1548, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 105, 0, ''),
	(1549, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 106, 0, ''),
	(1550, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 112, 0, ''),
	(1551, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 140, 0, ''),
	(1552, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 146, 0, ''),
	(1553, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 50, 0, 'S'),
	(1554, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 103, 0, ''),
	(1555, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 105, 0, ''),
	(1556, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 106, 0, ''),
	(1557, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 112, 0, ''),
	(1558, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 140, 0, ''),
	(1559, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 146, 0, ''),
	(1560, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 50, 0, 'S'),
	(1561, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 103, 0, ''),
	(1562, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 105, 0, ''),
	(1563, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 106, 0, ''),
	(1564, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 112, 0, ''),
	(1565, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 140, 0, ''),
	(1566, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 146, 0, ''),
	(1567, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 103, 0, ''),
	(1568, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 105, 0, ''),
	(1569, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 106, 0, ''),
	(1570, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 112, 0, ''),
	(1571, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 140, 0, ''),
	(1572, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 146, 0, ''),
	(1573, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 103, 0, ''),
	(1574, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 105, 0, ''),
	(1575, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 106, 0, ''),
	(1576, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 112, 0, ''),
	(1577, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 140, 0, ''),
	(1578, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 146, 0, ''),
	(1579, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 103, 0, ''),
	(1580, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 105, 0, ''),
	(1581, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 106, 0, ''),
	(1582, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 112, 0, ''),
	(1583, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 140, 0, ''),
	(1584, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 146, 0, ''),
	(1591, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 50, 0, 'S'),
	(1592, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 50, 0, 'S'),
	(1593, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 103, 0, ''),
	(1594, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 105, 0, ''),
	(1595, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 106, 0, ''),
	(1596, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 112, 0, ''),
	(1597, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 140, 0, ''),
	(1598, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 146, 0, ''),
	(1599, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 192, 0, 'P'),
	(1600, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 192, 0, 'P'),
	(1601, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 193, 0, 'P'),
	(1602, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 193, 0, 'P'),
	(1603, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 194, 0, 'S'),
	(1604, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 194, 0, 'S'),
	(1605, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 195, 0, 'S'),
	(1606, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 195, 0, 'S'),
	(1607, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 196, 0, 'S'),
	(1608, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 196, 0, 'S'),
	(1609, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 197, 0, 'S'),
	(1610, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 197, 0, 'S'),
	(1611, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 198, 0, 'S'),
	(1612, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 198, 0, 'S'),
	(1613, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 199, 0, 'S'),
	(1614, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 199, 0, 'S'),
	(1615, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 200, 0, 'S'),
	(1616, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 200, 0, 'S'),
	(1617, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 201, 0, 'S'),
	(1618, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 201, 0, 'S'),
	(1619, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 202, 0, 'S'),
	(1620, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 202, 0, 'S'),
	(1621, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 203, 0, 'S'),
	(1622, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 203, 0, 'S'),
	(1623, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 204, 0, 'S'),
	(1624, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 204, 0, 'S'),
	(1625, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 205, 0, 'S'),
	(1626, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 205, 0, 'S'),
	(1627, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 206, 0, 'S'),
	(1628, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 206, 0, 'S'),
	(1629, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 207, 0, 'S'),
	(1630, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 207, 0, 'S'),
	(1631, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 208, 0, 'S'),
	(1632, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 208, 0, 'S'),
	(1633, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 50, 0, 'S'),
	(1634, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 50, 0, 'S'),
	(1635, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 103, 0, ''),
	(1636, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 105, 0, ''),
	(1637, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 106, 0, ''),
	(1638, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 112, 0, ''),
	(1639, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 140, 0, ''),
	(1640, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 146, 0, ''),
	(1641, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 192, 0, 'P'),
	(1642, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 192, 0, 'P'),
	(1643, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 193, 0, 'P'),
	(1644, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 193, 0, 'P'),
	(1645, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 194, 0, 'S'),
	(1646, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 194, 0, 'S'),
	(1647, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 195, 0, 'S'),
	(1648, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 195, 0, 'S'),
	(1649, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 196, 0, 'S'),
	(1650, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 196, 0, 'S'),
	(1651, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 197, 0, 'S'),
	(1652, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 197, 0, 'S'),
	(1653, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 198, 0, 'S'),
	(1654, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 198, 0, 'S'),
	(1655, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 199, 0, 'S'),
	(1656, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 199, 0, 'S'),
	(1657, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 200, 0, 'S'),
	(1658, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 200, 0, 'S'),
	(1659, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 201, 0, 'S'),
	(1660, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 201, 0, 'S'),
	(1661, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 202, 0, 'S'),
	(1662, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 202, 0, 'S'),
	(1663, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 203, 0, 'S'),
	(1664, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 203, 0, 'S'),
	(1665, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 204, 0, 'S'),
	(1666, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 204, 0, 'S'),
	(1667, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 205, 0, 'S'),
	(1668, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 205, 0, 'S'),
	(1669, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 206, 0, 'S'),
	(1670, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 206, 0, 'S'),
	(1671, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 207, 0, 'S'),
	(1672, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 207, 0, 'S'),
	(1673, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 208, 0, 'S'),
	(1674, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 208, 0, 'S'),
	(1717, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 50, 0, 'S'),
	(1718, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 192, 0, 'P'),
	(1719, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 193, 0, 'P'),
	(1720, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 193, 0, ''),
	(1721, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 193, 0, ''),
	(1722, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 207, 0, 'S'),
	(1723, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 208, 0, 'S'),
	(1724, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 196, 0, 'S'),
	(1725, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 197, 0, 'S'),
	(1726, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 198, 0, 'S'),
	(1727, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 199, 0, 'S'),
	(1728, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 200, 0, 'S'),
	(1729, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 202, 0, 'S'),
	(1730, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 203, 0, 'S'),
	(1731, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 206, 0, 'S'),
	(1732, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 204, 0, 'S'),
	(1762, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 192, 0, 'P'),
	(1763, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 193, 0, 'P'),
	(1764, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 194, 0, 'S'),
	(1765, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 195, 0, 'S'),
	(1766, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 196, 0, 'S'),
	(1767, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 197, 0, 'S'),
	(1768, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 198, 0, 'S'),
	(1769, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 199, 0, 'S'),
	(1770, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 200, 0, 'S'),
	(1771, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 201, 0, 'S'),
	(1772, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 202, 0, 'S'),
	(1773, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 203, 0, 'S'),
	(1774, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 204, 0, 'S'),
	(1775, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 205, 0, 'S'),
	(1776, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 206, 0, 'S'),
	(1777, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 207, 0, 'S'),
	(1778, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 208, 0, 'S'),
	(1779, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 192, 0, 'P'),
	(1780, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 193, 0, 'P'),
	(1781, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 194, 0, 'S'),
	(1782, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 195, 0, 'S'),
	(1783, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 196, 0, 'S'),
	(1784, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 197, 0, 'S'),
	(1785, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 198, 0, 'S'),
	(1786, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 199, 0, 'S'),
	(1787, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 200, 0, 'S'),
	(1788, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 201, 0, 'S'),
	(1789, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 202, 0, 'S'),
	(1790, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 203, 0, 'S'),
	(1791, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 204, 0, 'S'),
	(1792, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 205, 0, 'S'),
	(1793, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 206, 0, 'S'),
	(1794, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 207, 0, 'S'),
	(1795, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 208, 0, 'S'),
	(1796, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 192, 0, 'P'),
	(1797, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 193, 0, 'P'),
	(1798, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 194, 0, 'S'),
	(1799, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 195, 0, 'S'),
	(1800, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 196, 0, 'S'),
	(1801, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 197, 0, 'S'),
	(1802, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 198, 0, 'S'),
	(1803, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 199, 0, 'S'),
	(1804, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 200, 0, 'S'),
	(1805, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 201, 0, 'S'),
	(1806, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 202, 0, 'S'),
	(1807, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 203, 0, 'S'),
	(1808, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 204, 0, 'S'),
	(1809, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 205, 0, 'S'),
	(1810, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 206, 0, 'S'),
	(1811, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 207, 0, 'S'),
	(1812, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 208, 0, 'S'),
	(1813, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 192, 0, 'P'),
	(1814, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 193, 0, 'P'),
	(1815, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 194, 0, 'S'),
	(1816, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 195, 0, 'S'),
	(1817, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 196, 0, 'S'),
	(1818, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 197, 0, 'S'),
	(1819, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 198, 0, 'S'),
	(1820, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 199, 0, 'S'),
	(1821, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 200, 0, 'S'),
	(1822, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 201, 0, 'S'),
	(1823, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 202, 0, 'S'),
	(1824, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 203, 0, 'S'),
	(1825, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 204, 0, 'S'),
	(1826, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 205, 0, 'S'),
	(1827, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 206, 0, 'S'),
	(1828, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 207, 0, 'S'),
	(1829, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 208, 0, 'S'),
	(1830, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 192, 0, 'P'),
	(1831, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 193, 0, 'P'),
	(1832, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 194, 0, 'S'),
	(1833, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 195, 0, 'S'),
	(1834, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 196, 0, 'S'),
	(1835, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 197, 0, 'S'),
	(1836, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 198, 0, 'S'),
	(1837, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 199, 0, 'S'),
	(1838, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 200, 0, 'S'),
	(1839, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 201, 0, 'S'),
	(1840, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 202, 0, 'S'),
	(1841, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 203, 0, 'S'),
	(1842, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 204, 0, 'S'),
	(1843, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 205, 0, 'S'),
	(1844, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 206, 0, 'S'),
	(1845, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 207, 0, 'S'),
	(1846, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 208, 0, 'S'),
	(1847, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 192, 0, 'P'),
	(1848, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 193, 0, 'P'),
	(1849, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 194, 0, 'S'),
	(1850, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 195, 0, 'S'),
	(1851, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 196, 0, 'S'),
	(1852, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 197, 0, 'S'),
	(1853, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 198, 0, 'S'),
	(1854, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 199, 0, 'S'),
	(1855, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 200, 0, 'S'),
	(1856, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 201, 0, 'S'),
	(1857, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 202, 0, 'S'),
	(1858, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 203, 0, 'S'),
	(1859, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 204, 0, 'S'),
	(1860, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 205, 0, 'S'),
	(1861, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 206, 0, 'S'),
	(1862, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 207, 0, 'S'),
	(1863, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 208, 0, 'S'),
	(1864, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 192, 0, 'P'),
	(1865, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 193, 0, 'P'),
	(1866, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 194, 0, 'S'),
	(1867, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 195, 0, 'S'),
	(1868, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 196, 0, 'S'),
	(1869, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 197, 0, 'S'),
	(1870, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 198, 0, 'S'),
	(1871, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 199, 0, 'S'),
	(1872, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 200, 0, 'S'),
	(1873, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 201, 0, 'S'),
	(1874, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 202, 0, 'S'),
	(1875, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 203, 0, 'S'),
	(1876, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 204, 0, 'S'),
	(1877, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 205, 0, 'S'),
	(1878, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 206, 0, 'S'),
	(1879, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 207, 0, 'S'),
	(1880, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 208, 0, 'S'),
	(1881, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 192, 0, 'P'),
	(1882, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 193, 0, 'P'),
	(1883, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 194, 0, 'S'),
	(1884, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 195, 0, 'S'),
	(1885, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 196, 0, 'S'),
	(1886, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 197, 0, 'S'),
	(1887, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 198, 0, 'S'),
	(1888, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 199, 0, 'S'),
	(1889, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 200, 0, 'S'),
	(1890, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 201, 0, 'S'),
	(1891, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 202, 0, 'S'),
	(1892, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 203, 0, 'S'),
	(1893, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 204, 0, 'S'),
	(1894, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 205, 0, 'S'),
	(1895, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 206, 0, 'S'),
	(1896, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 207, 0, 'S'),
	(1897, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 208, 0, 'S'),
	(1898, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 103, 0, ''),
	(1899, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 105, 0, ''),
	(1900, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 106, 0, ''),
	(1901, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 112, 0, ''),
	(1902, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 140, 0, ''),
	(1903, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 146, 0, ''),
	(1904, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 194, 0, ''),
	(1905, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 194, 0, 'S'),
	(1906, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 195, 0, ''),
	(1907, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 195, 0, 'S'),
	(1908, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 201, 0, ''),
	(1909, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 201, 0, 'S'),
	(1910, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 205, 0, ''),
	(1911, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 205, 0, 'S'),
	(1912, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 192, 0, 'P'),
	(1913, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 193, 0, 'P'),
	(1914, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 194, 0, 'S'),
	(1915, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 195, 0, 'S'),
	(1916, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 196, 0, 'S'),
	(1917, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 197, 0, 'S'),
	(1918, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 198, 0, 'S'),
	(1919, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 199, 0, 'S'),
	(1920, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 200, 0, 'S'),
	(1921, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 201, 0, 'S'),
	(1922, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 202, 0, 'S'),
	(1923, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 203, 0, 'S'),
	(1924, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 204, 0, 'S'),
	(1925, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 205, 0, 'S'),
	(1926, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 206, 0, 'S'),
	(1927, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 207, 0, 'S'),
	(1928, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 208, 0, 'S'),
	(1929, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 192, 0, 'P'),
	(1930, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 193, 0, 'P'),
	(1931, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 194, 0, 'S'),
	(1932, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 195, 0, 'S'),
	(1933, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 196, 0, 'S'),
	(1934, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 197, 0, 'S'),
	(1935, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 198, 0, 'S'),
	(1936, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 199, 0, 'S'),
	(1937, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 200, 0, 'S'),
	(1938, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 201, 0, 'S'),
	(1939, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 202, 0, 'S'),
	(1940, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 203, 0, 'S'),
	(1941, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 204, 0, 'S'),
	(1942, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 205, 0, 'S'),
	(1943, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 206, 0, 'S'),
	(1944, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 207, 0, 'S'),
	(1945, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 208, 0, 'S'),
	(1946, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 192, 0, 'P'),
	(1947, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 193, 0, 'P'),
	(1948, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 194, 0, 'S'),
	(1949, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 195, 0, 'S'),
	(1950, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 196, 0, 'S'),
	(1951, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 197, 0, 'S'),
	(1952, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 198, 0, 'S'),
	(1953, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 199, 0, 'S'),
	(1954, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 200, 0, 'S'),
	(1955, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 201, 0, 'S'),
	(1956, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 202, 0, 'S'),
	(1957, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 203, 0, 'S'),
	(1958, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 204, 0, 'S'),
	(1959, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 205, 0, 'S'),
	(1960, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 206, 0, 'S'),
	(1961, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 207, 0, 'S'),
	(1962, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 208, 0, 'S'),
	(1963, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 192, 0, 'P'),
	(1964, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 193, 0, 'P'),
	(1965, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 194, 0, 'S'),
	(1966, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 195, 0, 'S'),
	(1967, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 196, 0, 'S'),
	(1968, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 197, 0, 'S'),
	(1969, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 198, 0, 'S'),
	(1970, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 199, 0, 'S'),
	(1971, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 200, 0, 'S'),
	(1972, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 201, 0, 'S'),
	(1973, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 202, 0, 'S'),
	(1974, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 203, 0, 'S'),
	(1975, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 204, 0, 'S'),
	(1976, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 205, 0, 'S'),
	(1977, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 206, 0, 'S'),
	(1978, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 207, 0, 'S'),
	(1979, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 208, 0, 'S'),
	(1980, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 192, 0, 'P'),
	(1981, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 193, 0, 'P'),
	(1982, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 194, 0, 'P'),
	(1983, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 195, 0, 'S'),
	(1984, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 196, 0, 'S'),
	(1985, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 197, 0, 'S'),
	(1986, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 198, 0, 'S'),
	(1987, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 199, 0, 'S'),
	(1988, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 200, 0, 'S'),
	(1989, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 201, 0, 'S'),
	(1990, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 202, 0, 'S'),
	(1991, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 203, 0, 'S'),
	(1992, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 204, 0, 'S'),
	(1993, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 205, 0, 'S'),
	(1994, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 206, 0, 'S'),
	(1995, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 207, 0, 'S'),
	(1996, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 208, 0, 'S'),
	(1997, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 192, 0, 'P'),
	(1998, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 193, 0, 'P'),
	(1999, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 194, 0, 'S'),
	(2000, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 195, 0, 'S'),
	(2001, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 196, 0, 'S'),
	(2002, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 197, 0, 'S'),
	(2003, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 198, 0, 'S'),
	(2004, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 199, 0, 'S'),
	(2005, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 200, 0, 'S'),
	(2006, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 201, 0, 'S'),
	(2007, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 202, 0, 'S'),
	(2008, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 203, 0, 'S'),
	(2009, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 204, 0, 'S'),
	(2010, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 205, 0, 'S'),
	(2011, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 206, 0, 'S'),
	(2012, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 207, 0, 'S'),
	(2013, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 208, 0, 'S'),
	(2014, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 192, 0, 'P'),
	(2015, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 193, 0, 'P'),
	(2016, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 194, 0, 'S'),
	(2017, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 195, 0, 'S'),
	(2018, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 196, 0, 'S'),
	(2019, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 197, 0, 'S'),
	(2020, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 198, 0, 'S'),
	(2021, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 199, 0, 'S'),
	(2022, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 200, 0, 'S'),
	(2023, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 201, 0, 'S'),
	(2024, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 202, 0, 'S'),
	(2025, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 203, 0, 'S'),
	(2026, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 204, 0, 'S'),
	(2027, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 205, 0, 'S'),
	(2028, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 206, 0, 'S'),
	(2029, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 207, 0, 'S'),
	(2030, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 208, 0, 'S'),
	(2031, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 192, 0, 'P'),
	(2032, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 193, 0, 'P'),
	(2033, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 194, 0, 'S'),
	(2034, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 195, 0, 'S'),
	(2035, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 196, 0, 'S'),
	(2036, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 197, 0, 'S'),
	(2037, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 198, 0, 'S'),
	(2038, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 199, 0, 'S'),
	(2039, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 200, 0, 'S'),
	(2040, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 201, 0, 'S'),
	(2041, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 202, 0, 'S'),
	(2042, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 203, 0, 'S'),
	(2043, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 204, 0, 'S'),
	(2044, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 205, 0, 'S'),
	(2045, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 206, 0, 'S'),
	(2046, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 207, 0, 'S'),
	(2047, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 208, 0, 'S'),
	(2048, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 50, 0, 'S'),
	(2049, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 173, 0, 'P'),
	(2050, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 173, 0, ''),
	(2051, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 174, 0, 'P'),
	(2052, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 175, 0, 'S'),
	(2053, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 176, 0, 'S'),
	(2054, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 177, 0, 'S'),
	(2055, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 178, 0, 'P'),
	(2056, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 178, 0, ''),
	(2057, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 179, 0, 'S'),
	(2058, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 180, 0, 'S'),
	(2059, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 181, 0, 'S'),
	(2060, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 182, 0, 'S'),
	(2061, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 183, 0, 'S'),
	(2062, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 184, 0, 'S'),
	(2063, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 185, 0, 'S'),
	(2064, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 186, 0, 'S'),
	(2065, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 187, 0, 'S'),
	(2066, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 189, 0, 'S'),
	(2067, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 190, 0, 'S'),
	(2068, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 191, 0, 'S'),
	(2088, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 188, 0, ''),
	(2096, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 173, 0, 'P'),
	(2097, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 174, 0, 'P'),
	(2098, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 175, 0, 'S'),
	(2099, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 176, 0, 'S'),
	(2100, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 177, 0, 'S'),
	(2101, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 178, 0, 'P'),
	(2102, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 179, 0, 'S'),
	(2103, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 180, 0, 'S'),
	(2104, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 181, 0, 'S'),
	(2105, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 182, 0, 'S'),
	(2106, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 183, 0, 'S'),
	(2107, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 184, 0, 'S'),
	(2108, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 185, 0, 'S'),
	(2109, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 186, 0, 'S'),
	(2110, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 187, 0, 'S'),
	(2111, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 188, 0, ''),
	(2112, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 189, 0, 'S'),
	(2113, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 190, 0, 'S'),
	(2114, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 191, 0, 'S'),
	(2115, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 173, 0, 'P'),
	(2116, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 174, 0, 'P'),
	(2117, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 175, 0, 'S'),
	(2118, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 176, 0, 'S'),
	(2119, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 177, 0, 'S'),
	(2120, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 178, 0, 'P'),
	(2121, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 179, 0, 'S'),
	(2122, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 180, 0, 'S'),
	(2123, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 181, 0, 'S'),
	(2124, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 182, 0, 'S'),
	(2125, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 183, 0, 'S'),
	(2126, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 184, 0, 'S'),
	(2127, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 185, 0, 'S'),
	(2128, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 186, 0, 'S'),
	(2129, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 187, 0, 'S'),
	(2130, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 188, 0, ''),
	(2131, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 189, 0, 'S'),
	(2132, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 190, 0, 'S'),
	(2133, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 191, 0, 'S'),
	(2134, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 173, 0, 'P'),
	(2135, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 174, 0, 'P'),
	(2136, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 175, 0, 'S'),
	(2137, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 176, 0, 'S'),
	(2138, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 177, 0, 'S'),
	(2139, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 178, 0, 'P'),
	(2140, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 179, 0, 'S'),
	(2141, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 180, 0, 'S'),
	(2142, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 181, 0, 'S'),
	(2143, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 182, 0, 'S'),
	(2144, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 183, 0, 'S'),
	(2145, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 184, 0, 'S'),
	(2146, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 185, 0, 'S'),
	(2147, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 186, 0, 'S'),
	(2148, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 187, 0, 'S'),
	(2149, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 188, 0, ''),
	(2150, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 189, 0, 'S'),
	(2151, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 190, 0, 'S'),
	(2152, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 191, 0, 'S'),
	(2153, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 173, 0, 'P'),
	(2154, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 174, 0, 'P'),
	(2155, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 175, 0, 'S'),
	(2156, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 176, 0, 'S'),
	(2157, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 177, 0, 'S'),
	(2158, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 178, 0, 'P'),
	(2159, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 179, 0, 'S'),
	(2160, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 180, 0, 'S'),
	(2161, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 181, 0, 'S'),
	(2162, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 182, 0, 'S'),
	(2163, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 183, 0, 'S'),
	(2164, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 184, 0, 'S'),
	(2165, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 185, 0, 'S'),
	(2166, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 186, 0, 'S'),
	(2167, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 187, 0, 'S'),
	(2168, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 188, 0, ''),
	(2169, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 189, 0, 'S'),
	(2170, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 190, 0, 'S'),
	(2171, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 191, 0, 'S'),
	(2172, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 173, 0, 'P'),
	(2173, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 174, 0, 'P'),
	(2174, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 175, 0, 'S'),
	(2175, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 176, 0, 'S'),
	(2176, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 177, 0, 'S'),
	(2177, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 178, 0, 'P'),
	(2178, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 179, 0, 'S'),
	(2179, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 180, 0, 'S'),
	(2180, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 181, 0, 'S'),
	(2181, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 182, 0, 'S'),
	(2182, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 183, 0, 'S'),
	(2183, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 184, 0, 'S'),
	(2184, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 185, 0, 'S'),
	(2185, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 186, 0, 'S'),
	(2186, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 187, 0, 'S'),
	(2187, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 188, 0, ''),
	(2188, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 189, 0, 'S'),
	(2189, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 190, 0, 'S'),
	(2190, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 191, 0, 'S'),
	(2191, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 173, 0, 'P'),
	(2192, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 174, 0, 'P'),
	(2193, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 175, 0, 'S'),
	(2194, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 176, 0, 'S'),
	(2195, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 177, 0, 'S'),
	(2196, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 178, 0, 'P'),
	(2197, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 179, 0, 'S'),
	(2198, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 180, 0, 'S'),
	(2199, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 181, 0, 'S'),
	(2200, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 182, 0, 'S'),
	(2201, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 183, 0, 'S'),
	(2202, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 184, 0, 'S'),
	(2203, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 185, 0, 'S'),
	(2204, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 186, 0, 'S'),
	(2205, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 187, 0, 'S'),
	(2206, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 188, 0, ''),
	(2207, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 189, 0, 'S'),
	(2208, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 190, 0, 'S'),
	(2209, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 191, 0, 'S'),
	(2236, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 50, 0, 'S'),
	(2237, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 173, 0, 'P'),
	(2238, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 173, 0, ''),
	(2239, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 174, 0, 'P'),
	(2240, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 175, 0, 'S'),
	(2241, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 176, 0, 'S'),
	(2242, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 177, 0, 'S'),
	(2243, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 178, 0, 'P'),
	(2244, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 178, 0, ''),
	(2245, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 179, 0, 'S'),
	(2246, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 180, 0, 'S'),
	(2247, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 181, 0, 'S'),
	(2248, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 182, 0, 'S'),
	(2249, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 183, 0, 'S'),
	(2250, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 184, 0, 'S'),
	(2251, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 185, 0, 'S'),
	(2252, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 186, 0, 'S'),
	(2253, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 187, 0, 'S'),
	(2254, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 189, 0, 'S'),
	(2255, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 190, 0, 'S'),
	(2256, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 191, 0, 'S'),
	(2276, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 188, 0, ''),
	(2284, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 50, 0, 'S'),
	(2285, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 173, 0, 'P'),
	(2286, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 173, 0, ''),
	(2287, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 174, 0, 'P'),
	(2288, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 175, 0, 'S'),
	(2289, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 176, 0, 'S'),
	(2290, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 177, 0, 'S'),
	(2291, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 178, 0, 'P'),
	(2292, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 178, 0, ''),
	(2293, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 179, 0, 'S'),
	(2294, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 180, 0, 'S'),
	(2295, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 181, 0, 'S'),
	(2296, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 182, 0, 'S'),
	(2297, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 183, 0, 'S'),
	(2298, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 184, 0, 'S'),
	(2299, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 185, 0, 'S'),
	(2300, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 186, 0, 'S'),
	(2301, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 187, 0, 'S'),
	(2302, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 189, 0, 'S'),
	(2303, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 190, 0, 'S'),
	(2304, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 191, 0, 'S'),
	(2324, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 188, 0, ''),
	(2332, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 173, 0, 'P'),
	(2333, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 174, 0, 'P'),
	(2334, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 175, 0, 'S'),
	(2335, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 176, 0, 'S'),
	(2336, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 177, 0, 'S'),
	(2337, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 178, 0, 'P'),
	(2338, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 179, 0, 'S'),
	(2339, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 180, 0, 'S'),
	(2340, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 181, 0, 'S'),
	(2341, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 182, 0, 'S'),
	(2342, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 183, 0, 'S'),
	(2343, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 184, 0, 'S'),
	(2344, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 185, 0, 'S'),
	(2345, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 186, 0, 'S'),
	(2346, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 187, 0, 'S'),
	(2347, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 188, 0, ''),
	(2348, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 189, 0, 'S'),
	(2349, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 190, 0, 'S'),
	(2350, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 191, 0, 'S'),
	(2351, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 173, 0, 'P'),
	(2352, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 174, 0, 'P'),
	(2353, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 175, 0, 'S'),
	(2354, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 176, 0, 'S'),
	(2355, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 177, 0, 'S'),
	(2356, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 178, 0, 'P'),
	(2357, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 179, 0, 'S'),
	(2358, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 180, 0, 'S'),
	(2359, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 181, 0, 'S'),
	(2360, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 182, 0, 'S'),
	(2361, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 183, 0, 'S'),
	(2362, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 184, 0, 'S'),
	(2363, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 185, 0, 'S'),
	(2364, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 186, 0, 'S'),
	(2365, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 187, 0, 'S'),
	(2366, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 188, 0, ''),
	(2367, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 189, 0, 'S'),
	(2368, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 190, 0, 'S'),
	(2369, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 191, 0, 'S'),
	(2370, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 173, 0, 'P'),
	(2371, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 174, 0, 'P'),
	(2372, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 175, 0, 'S'),
	(2373, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 176, 0, 'S'),
	(2374, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 177, 0, 'S'),
	(2375, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 178, 0, 'P'),
	(2376, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 179, 0, 'S'),
	(2377, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 180, 0, 'S'),
	(2378, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 181, 0, 'S'),
	(2379, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 182, 0, 'S'),
	(2380, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 183, 0, 'S'),
	(2381, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 184, 0, 'S'),
	(2382, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 185, 0, 'S'),
	(2383, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 186, 0, 'S'),
	(2384, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 187, 0, 'S'),
	(2385, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 188, 0, ''),
	(2386, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 189, 0, 'S'),
	(2387, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 190, 0, 'S'),
	(2388, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 191, 0, 'S'),
	(2389, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 173, 0, 'P'),
	(2390, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 174, 0, 'P'),
	(2391, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 175, 0, 'S'),
	(2392, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 176, 0, 'S'),
	(2393, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 177, 0, 'S'),
	(2394, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 178, 0, 'P'),
	(2395, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 179, 0, 'S'),
	(2396, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 180, 0, 'S'),
	(2397, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 181, 0, 'S'),
	(2398, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 182, 0, 'S'),
	(2399, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 183, 0, 'S'),
	(2400, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 184, 0, 'S'),
	(2401, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 185, 0, 'S'),
	(2402, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 186, 0, 'S'),
	(2403, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 187, 0, 'S'),
	(2404, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 188, 0, ''),
	(2405, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 189, 0, 'S'),
	(2406, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 190, 0, 'S'),
	(2407, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 191, 0, 'S'),
	(2408, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 173, 0, 'P'),
	(2409, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 174, 0, 'P'),
	(2410, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 175, 0, 'S'),
	(2411, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 176, 0, 'S'),
	(2412, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 177, 0, 'S'),
	(2413, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 178, 0, 'P'),
	(2414, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 179, 0, 'S'),
	(2415, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 180, 0, 'S'),
	(2416, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 181, 0, 'S'),
	(2417, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 182, 0, 'S'),
	(2418, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 183, 0, 'S'),
	(2419, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 184, 0, 'S'),
	(2420, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 185, 0, 'S'),
	(2421, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 186, 0, 'S'),
	(2422, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 187, 0, 'S'),
	(2423, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 188, 0, ''),
	(2424, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 189, 0, 'S'),
	(2425, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 190, 0, 'S'),
	(2426, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 191, 0, 'S'),
	(2427, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 173, 0, 'P'),
	(2428, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 174, 0, 'P'),
	(2429, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 175, 0, 'S'),
	(2430, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 176, 0, 'S'),
	(2431, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 177, 0, 'S'),
	(2432, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 178, 0, 'P'),
	(2433, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 179, 0, 'S'),
	(2434, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 180, 0, 'S'),
	(2435, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 181, 0, 'S'),
	(2436, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 182, 0, 'S'),
	(2437, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 183, 0, 'S'),
	(2438, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 184, 0, 'S'),
	(2439, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 185, 0, 'S'),
	(2440, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 186, 0, 'S'),
	(2441, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 187, 0, 'S'),
	(2442, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 188, 0, ''),
	(2443, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 189, 0, 'S'),
	(2444, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 190, 0, 'S'),
	(2445, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 191, 0, 'S'),
	(2446, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 173, 0, 'P'),
	(2447, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 174, 0, 'P'),
	(2448, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 175, 0, 'S'),
	(2449, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 176, 0, 'S'),
	(2450, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 177, 0, 'S'),
	(2451, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 178, 0, 'P'),
	(2452, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 179, 0, 'S'),
	(2453, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 180, 0, 'S'),
	(2454, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 181, 0, 'S'),
	(2455, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 182, 0, 'S'),
	(2456, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 183, 0, 'S'),
	(2457, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 184, 0, 'S'),
	(2458, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 185, 0, 'S'),
	(2459, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 186, 0, 'S'),
	(2460, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 187, 0, 'S'),
	(2461, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 188, 0, ''),
	(2462, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 189, 0, 'S'),
	(2463, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 190, 0, 'S'),
	(2464, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 191, 0, 'S'),
	(2465, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 173, 0, 'P'),
	(2466, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 174, 0, 'P'),
	(2467, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 175, 0, 'S'),
	(2468, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 176, 0, 'S'),
	(2469, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 177, 0, 'S'),
	(2470, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 178, 0, 'P'),
	(2471, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 179, 0, 'S'),
	(2472, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 180, 0, 'S'),
	(2473, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 181, 0, 'S'),
	(2474, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 182, 0, 'S'),
	(2475, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 183, 0, 'S'),
	(2476, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 184, 0, 'S'),
	(2477, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 185, 0, 'S'),
	(2478, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 186, 0, 'S'),
	(2479, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 187, 0, 'S'),
	(2480, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 188, 0, ''),
	(2481, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 189, 0, 'S'),
	(2482, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 190, 0, 'S'),
	(2483, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 191, 0, 'S'),
	(2484, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 173, 0, 'P'),
	(2485, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 174, 0, 'P'),
	(2486, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 175, 0, 'P'),
	(2487, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 176, 0, 'S'),
	(2488, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 177, 0, 'S'),
	(2489, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 178, 0, 'P'),
	(2490, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 179, 0, 'S'),
	(2491, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 180, 0, 'S'),
	(2492, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 181, 0, 'S'),
	(2493, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 182, 0, 'S'),
	(2494, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 183, 0, 'S'),
	(2495, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 184, 0, 'S'),
	(2496, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 185, 0, 'S'),
	(2497, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 186, 0, 'S'),
	(2498, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 187, 0, 'S'),
	(2499, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 188, 0, ''),
	(2500, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 189, 0, 'S'),
	(2501, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 190, 0, 'S'),
	(2502, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 191, 0, 'S'),
	(2503, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 173, 0, 'P'),
	(2504, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 174, 0, 'P'),
	(2505, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 175, 0, 'S'),
	(2506, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 176, 0, 'S'),
	(2507, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 177, 0, 'S'),
	(2508, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 178, 0, 'P'),
	(2509, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 179, 0, 'S'),
	(2510, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 180, 0, 'S'),
	(2511, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 181, 0, 'S'),
	(2512, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 182, 0, 'S'),
	(2513, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 183, 0, 'S'),
	(2514, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 184, 0, 'S'),
	(2515, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 185, 0, 'S'),
	(2516, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 186, 0, 'S'),
	(2517, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 187, 0, 'S'),
	(2518, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 188, 0, ''),
	(2519, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 189, 0, 'S'),
	(2520, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 190, 0, 'S'),
	(2521, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 191, 0, 'S'),
	(2522, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 103, 0, ''),
	(2523, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 105, 0, ''),
	(2524, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 106, 0, ''),
	(2525, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 112, 0, ''),
	(2526, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 140, 0, ''),
	(2527, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 146, 0, ''),
	(2528, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 103, 0, ''),
	(2529, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 105, 0, ''),
	(2530, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 106, 0, ''),
	(2531, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 112, 0, ''),
	(2532, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 140, 0, ''),
	(2533, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 146, 0, ''),
	(2534, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 103, 0, ''),
	(2535, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 105, 0, ''),
	(2536, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 106, 0, ''),
	(2537, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 112, 0, ''),
	(2538, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 140, 0, ''),
	(2539, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 146, 0, ''),
	(2540, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 209, 1, 'S'),
	(2541, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 210, 1, 'S');


--
-- Attribute checkbox values
--
INSERT INTO
    `%%XC%%_attribute_values_checkbox` (
        `id`, `product_id`, `attribute_id`, `value`, `priceModifier`, `priceModifierType`, `weightModifier`,
        `weightModifierType`, `defaultValue`
    )
VALUES
    (23, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 188, 1, 0, 'p', 0, 'p', 0),
	(37, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 188, 0, 0, 'p', 0, 'p', 0),
	(61, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 188, 1, 0, 'p', 0, 'p', 0);


--
-- Attribute select values
--
INSERT INTO
    `%%XC%%_attribute_values_select` (
        `id`, `product_id`, `attribute_option_id`, `attribute_id`, `position`, `priceModifier`, `priceModifierType`,
        `weightModifier`, `weightModifierType`, `defaultValue`
    )
VALUES
    (1000, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 482, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1272, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 482, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1288, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 485, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1289, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 485, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1290, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 485, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1291, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 485, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1425, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 482, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1495, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 494, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1496, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 494, 50, 10, 0.0000, 'p', 0, 'p', 0),
    (1522, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 497, 158, 10, -5.0000, 'a', 0, 'a', 0),
    (1523, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 498, 158, 20, 15.9500, 'a', 0, 'a', 0),
    (1528, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 503, 161, 10, 0.0000, 'a', 0, 'a', 0),
    (1529, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 504, 161, 20, 0.0000, 'a', 0, 'a', 0),
    (1530, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 505, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1531, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 505, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1532, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 506, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1535, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 507, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1536, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 507, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1537, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 538, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1538, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 531, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1539, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 532, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1540, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 523, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1541, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 532, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1543, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 538, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1544, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 538, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1545, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 509, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1546, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 534, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1547, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 517, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1549, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 508, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1550, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 510, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1551, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 511, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1552, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 516, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1553, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 518, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1554, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 519, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1556, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 521, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1557, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 522, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1558, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 522, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1559, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 522, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1560, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 524, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1561, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 525, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1562, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 528, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1564, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 529, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1565, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 529, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1566, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 529, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1567, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 530, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1568, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 530, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1571, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 533, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1572, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 535, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1573, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 535, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1574, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 535, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1575, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 542, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1576, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 512, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1577, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 515, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1578, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 526, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1580, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 528, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1581, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 536, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1582, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 537, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1584, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 540, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1586, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 543, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1587, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 544, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1588, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 545, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1589, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 546, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1590, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 547, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1594, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 551, 163, 10, 0.0000, 'a', 0, 'a', 0),
    (1595, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 552, 163, 20, 0.0000, 'a', 0, 'a', 0),
    (1596, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 553, 163, 30, 0.0000, 'a', 0, 'a', 0),
    (1597, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 554, 164, 10, 0.0000, 'a', 0, 'a', 0),
    (1598, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 555, 164, 20, 0.0000, 'a', 0, 'a', 0),
    (1599, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 556, 165, 10, 0.0000, 'a', 0, 'a', 0),
    (1600, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 557, 165, 20, 0.0000, 'a', 0, 'a', 0),
    (1601, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 558, 166, 10, 0.0000, 'a', 0, 'a', 1),
    (1602, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 559, 166, 20, 0.0000, 'a', 0, 'a', 0),
    (1605, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 562, 168, 10, 0.0000, 'a', 0, 'a', 0),
    (1606, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 563, 168, 20, 0.0000, 'a', 0, 'a', 0),
    (1607, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 564, 168, 30, 0.0000, 'a', 0, 'a', 0),
    (1608, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 565, 168, 40, 0.0000, 'a', 0, 'a', 0),
    (1609, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 566, 168, 50, 0.0000, 'a', 0, 'a', 0),
    (1610, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 485, 50, 20, 0.0000, 'p', 0, 'p', 0),
    (1611, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 485, 50, 20, 0.0000, 'p', 0, 'p', 0),
    (1616, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 519, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1617, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 519, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1618, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 571, 171, 10, 0.0000, 'a', 0, 'a', 1),
    (1619, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 572, 171, 20, 0.0000, 'a', 0, 'a', 0),
    (1620, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 505, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1621, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 573, 172, 10, 0.0000, 'a', 0, 'a', 0),
    (1622, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 574, 172, 20, 0.0000, 'a', 0, 'a', 0),
    (1634, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 533, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1636, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 583, 50, 10, 0.0000, 'a', 0, 'a', 0),
    (1642, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 575, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1643, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 575, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1644, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 576, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1645, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 576, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1646, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 577, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1648, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 578, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1649, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 579, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1650, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 579, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1653, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 581, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1654, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 582, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1655, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 583, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1656, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 583, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1658, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 585, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1659, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 683, 173, 0, 0.0000, 'a', 0, 'a', 0),
    (1660, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 684, 173, 0, 0.0000, 'a', 0, 'a', 0),
    (1661, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 685, 174, 0, 0.0000, 'a', 0, 'a', 0),
    (1662, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 1677, 175, 0, 0.0000, 'a', 0, 'a', 0),
    (1663, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 1655, 176, 0, 0.0000, 'a', 0, 'a', 0),
    (1664, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 688, 177, 0, 0.0000, 'a', 0, 'a', 0),
    (1665, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 689, 178, 0, 0.0000, 'a', 0, 'a', 0),
    (1666, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 690, 178, 0, 0.0000, 'a', 0, 'a', 0),
    (1667, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 691, 179, 0, 0.0000, 'a', 0, 'a', 0),
    (1668, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 692, 180, 0, 0.0000, 'a', 0, 'a', 0),
    (1669, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 693, 181, 0, 0.0000, 'a', 0, 'a', 0),
    (1670, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 694, 182, 0, 0.0000, 'a', 0, 'a', 0),
    (1671, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 695, 183, 0, 0.0000, 'a', 0, 'a', 0),
    (1672, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 696, 184, 0, 0.0000, 'a', 0, 'a', 0),
    (1673, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 697, 185, 0, 0.0000, 'a', 0, 'a', 0),
    (1674, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 698, 186, 0, 0.0000, 'a', 0, 'a', 0),
    (1675, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 699, 187, 0, 0.0000, 'a', 0, 'a', 0),
    (1676, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 700, 189, 0, 0.0000, 'a', 0, 'a', 0),
    (1677, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 701, 190, 0, 0.0000, 'a', 0, 'a', 0),
    (1678, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 2772, 191, 0, 0.0000, 'a', 0, 'a', 0),
    (1944, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 585, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (1945, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 683, 173, 0, 0.0000, 'a', 0, 'a', 0),
    (1946, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 684, 173, 0, 0.0000, 'a', 0, 'a', 0),
    (1947, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 685, 174, 0, 0.0000, 'a', 0, 'a', 0),
    (1948, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 778, 175, 0, 0.0000, 'a', 0, 'a', 0),
    (1949, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 789, 176, 0, 0.0000, 'a', 0, 'a', 0),
    (1950, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 688, 177, 0, 0.0000, 'a', 0, 'a', 0),
    (1951, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 689, 178, 0, 0.0000, 'a', 0, 'a', 0),
    (1952, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 690, 178, 0, 0.0000, 'a', 0, 'a', 0),
    (1953, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 691, 179, 0, 0.0000, 'a', 0, 'a', 0),
    (1954, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 692, 180, 0, 0.0000, 'a', 0, 'a', 0),
    (1955, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 693, 181, 0, 0.0000, 'a', 0, 'a', 0),
    (1956, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 694, 182, 0, 0.0000, 'a', 0, 'a', 0),
    (1957, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 695, 183, 0, 0.0000, 'a', 0, 'a', 0),
    (1958, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 696, 184, 0, 0.0000, 'a', 0, 'a', 0),
    (1959, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 697, 185, 0, 0.0000, 'a', 0, 'a', 0),
    (1960, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 698, 186, 0, 0.0000, 'a', 0, 'a', 0),
    (1961, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 699, 187, 0, 0.0000, 'a', 0, 'a', 0),
    (1962, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 733, 189, 0, 0.0000, 'a', 0, 'a', 0),
    (1963, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 701, 190, 0, 0.0000, 'a', 0, 'a', 0),
    (1964, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 2774, 191, 0, 0.0000, 'a', 0, 'a', 0),
    (2439, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 585, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (2440, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 683, 173, 0, 0.0000, 'a', 0, 'a', 0),
    (2441, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 684, 173, 0, 0.0000, 'a', 0, 'a', 0),
    (2442, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 685, 174, 0, 0.0000, 'a', 0, 'a', 0),
    (2443, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 1677, 175, 0, 0.0000, 'a', 0, 'a', 0),
    (2444, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 2770, 176, 0, 0.0000, 'a', 0, 'a', 0),
    (2445, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 688, 177, 0, 0.0000, 'a', 0, 'a', 0),
    (2446, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 689, 178, 0, 0.0000, 'a', 0, 'a', 0),
    (2447, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 786, 178, 0, 0.0000, 'a', 0, 'a', 0),
    (2448, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 691, 179, 0, 0.0000, 'a', 0, 'a', 0),
    (2449, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 692, 180, 0, 0.0000, 'a', 0, 'a', 0),
    (2450, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 693, 181, 0, 0.0000, 'a', 0, 'a', 0),
    (2451, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 694, 182, 0, 0.0000, 'a', 0, 'a', 0),
    (2452, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 695, 183, 0, 0.0000, 'a', 0, 'a', 0),
    (2453, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 696, 184, 0, 0.0000, 'a', 0, 'a', 0),
    (2454, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 697, 185, 0, 0.0000, 'a', 0, 'a', 0),
    (2455, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 698, 186, 0, 0.0000, 'a', 0, 'a', 0),
    (2456, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 699, 187, 0, 0.0000, 'a', 0, 'a', 0),
    (2457, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 750, 189, 0, 0.0000, 'a', 0, 'a', 0),
    (2458, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 701, 190, 0, 0.0000, 'a', 0, 'a', 0),
    (2459, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 2777, 191, 0, 0.0000, 'a', 0, 'a', 0),
    (5458, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 529, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (5459, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 844, 192, 0, 0.0000, 'a', 0, 'a', 0),
    (5460, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 845, 193, 0, 0.0000, 'a', 0, 'a', 0),
    (5461, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 846, 193, 0, 0.0000, 'a', 0, 'a', 0),
    (5462, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 959, 194, 0, 0.0000, 'a', 0, 'a', 0),
    (5463, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 939, 195, 0, 0.0000, 'a', 0, 'a', 0),
    (5464, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 940, 196, 0, 0.0000, 'a', 0, 'a', 0),
    (5465, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 850, 197, 0, 0.0000, 'a', 0, 'a', 0),
    (5466, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 851, 198, 0, 0.0000, 'a', 0, 'a', 0),
    (5467, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 852, 199, 0, 0.0000, 'a', 0, 'a', 0),
    (5468, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 853, 200, 0, 0.0000, 'a', 0, 'a', 0),
    (5469, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 854, 201, 0, 0.0000, 'a', 0, 'a', 0),
    (5470, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 855, 202, 0, 0.0000, 'a', 0, 'a', 0),
    (5471, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 856, 203, 0, 0.0000, 'a', 0, 'a', 0),
    (5472, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 1581, 204, 0, 0.0000, 'a', 0, 'a', 0),
    (11402, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 529, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (11403, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 1146, 192, 0, 0.0000, 'a', 0, 'a', 0),
    (11404, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 845, 193, 0, 0.0000, 'a', 0, 'a', 0),
    (11405, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 846, 193, 0, 0.0000, 'a', 0, 'a', 0),
    (11406, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 893, 194, 0, 0.0000, 'a', 0, 'a', 0),
    (11407, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 866, 195, 0, 0.0000, 'a', 0, 'a', 0),
    (11408, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 849, 196, 0, 0.0000, 'a', 0, 'a', 0),
    (11409, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 1454, 197, 0, 0.0000, 'a', 0, 'a', 0),
    (11410, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 1196, 198, 0, 0.0000, 'a', 0, 'a', 0),
    (11411, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 1173, 199, 0, 0.0000, 'a', 0, 'a', 0),
    (11412, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 869, 205, 0, 0.0000, 'a', 0, 'a', 0),
    (11413, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 861, 200, 0, 0.0000, 'a', 0, 'a', 0),
    (11414, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 1133, 201, 0, 0.0000, 'a', 0, 'a', 0),
    (11415, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 1252, 202, 0, 0.0000, 'a', 0, 'a', 0),
    (11416, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 1307, 203, 0, 0.0000, 'a', 0, 'a', 0),
    (11417, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 2757, 204, 0, 0.0000, 'a', 0, 'a', 0),
    (17686, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 635, 50, 0, 0.0000, 'a', 0, 'a', 0),
    (17687, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1146, 192, 0, 0.0000, 'a', 0, 'a', 0),
    (17688, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1147, 193, 0, 0.0000, 'a', 0, 'a', 0),
    (17689, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1895, 193, 0, 0.0000, 'a', 0, 'a', 0),
    (17690, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1896, 193, 0, 0.0000, 'a', 0, 'a', 0),
    (17693, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 849, 196, 0, 0.0000, 'a', 0, 'a', 0),
    (17694, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1899, 197, 0, 0.0000, 'a', 0, 'a', 0),
    (17695, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1900, 198, 0, 0.0000, 'a', 0, 'a', 0),
    (17696, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1901, 199, 0, 0.0000, 'a', 0, 'a', 0),
    (17697, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1902, 200, 0, 0.0000, 'a', 0, 'a', 0),
    (17698, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1903, 202, 0, 0.0000, 'a', 0, 'a', 0),
    (17699, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1177, 203, 0, 0.0000, 'a', 0, 'a', 0),
    (17700, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 1213, 206, 0, 0.0000, 'a', 0, 'a', 0),
    (17701, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 2757, 204, 0, 0.0000, 'a', 0, 'a', 0),
    (26787, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 865, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26788, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 848, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26789, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 875, 196, 10, 0.0000, 'a', 0, 'a', 0),
    (26790, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 2415, 204, 10, 0.0000, 'a', 0, 'a', 0),
    (26791, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 865, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26792, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 939, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26793, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 875, 196, 10, 0.0000, 'a', 0, 'a', 0),
    (26794, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 2414, 204, 10, 0.0000, 'a', 0, 'a', 0),
    (26796, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 1097, 203, 10, 0.0000, 'a', 0, 'a', 0),
    (26797, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 858, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26798, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 939, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26799, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 916, 196, 10, 0.0000, 'a', 0, 'a', 0),
    (26800, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 1097, 203, 10, 0.0000, 'a', 0, 'a', 0),
    (26801, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 2734, 204, 10, 0.0000, 'a', 0, 'a', 0),
    (26802, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 893, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26803, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 960, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26804, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 849, 196, 10, 0.0000, 'a', 0, 'a', 0),
    (26805, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 1402, 204, 10, 0.0000, 'a', 0, 'a', 0),
    (26806, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 893, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26807, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 866, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26808, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 1146, 192, 10, 0.0000, 'a', 0, 'a', 0),
    (26809, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 865, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26810, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 848, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26811, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 849, 196, 10, 0.0000, 'a', 0, 'a', 0),
    (26812, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 2762, 202, 10, 0.0000, 'a', 0, 'a', 0),
    (26813, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 2775, 204, 10, 0.0000, 'a', 0, 'a', 0),
    (26814, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 845, 193, 10, 0.0000, 'a', 0, 'a', 0),
    (26815, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 865, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26816, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 1048, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26817, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 940, 196, 10, 0.0000, 'a', 0, 'a', 0),
    (26818, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 856, 203, 10, 0.0000, 'a', 0, 'a', 0),
    (26819, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 2776, 204, 10, 0.0000, 'a', 0, 'a', 0),
    (26820, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 1146, 192, 10, 0.0000, 'a', 0, 'a', 0),
    (26821, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 1147, 193, 10, 0.0000, 'a', 0, 'a', 0),
    (26823, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 1146, 192, 10, 0.0000, 'a', 0, 'a', 0),
    (26824, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 845, 193, 10, 0.0000, 'a', 0, 'a', 0),
    (26825, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 1146, 192, 10, 0.0000, 'a', 0, 'a', 0),
    (26826, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 1147, 193, 10, 0.0000, 'a', 0, 'a', 0),
    (26827, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 845, 193, 20, 0.0000, 'a', 0, 'a', 0),
    (26828, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 1307, 203, 10, 0.0000, 'a', 0, 'a', 0),
    (26829, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 1146, 192, 10, 0.0000, 'a', 0, 'a', 0),
    (26830, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 845, 193, 10, 0.0000, 'a', 0, 'a', 0),
    (26831, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 1147, 193, 20, 0.0000, 'a', 0, 'a', 0),
    (26832, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 865, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26833, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 939, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26834, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 940, 196, 10, 0.0000, 'a', 0, 'a', 0),
    (26835, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 1097, 203, 10, 0.0000, 'a', 0, 'a', 0),
    (26836, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 1076, 204, 10, 0.0000, 'a', 0, 'a', 0),
    (26840, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 1163, 203, 10, 0.0000, 'a', 0, 'a', 0),
    (26862, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 2767, 175, 10, 0.0000, 'a', 0, 'a', 0),
    (26864, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 1647, 176, 10, 0.0000, 'a', 0, 'a', 0),
    (26865, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 2769, 191, 10, 0.0000, 'a', 0, 'a', 0),
    (26866, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 688, 177, 10, 0.0000, 'a', 0, 'a', 0),
    (26868, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 709, 175, 10, 0.0000, 'a', 0, 'a', 0),
    (26869, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 789, 176, 10, 0.0000, 'a', 0, 'a', 0),
    (26870, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 688, 177, 10, 0.0000, 'a', 0, 'a', 0),
    (26871, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 786, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26872, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 2779, 191, 10, 0.0000, 'a', 0, 'a', 0),
    (26873, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 778, 175, 10, 0.0000, 'a', 0, 'a', 0),
    (26874, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 1647, 176, 10, 0.0000, 'a', 0, 'a', 0),
    (26875, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 688, 177, 10, 0.0000, 'a', 0, 'a', 0),
    (26876, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 786, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26877, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 2780, 191, 10, 0.0000, 'a', 0, 'a', 0),
    (26942, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 2767, 175, 10, 0.0000, 'a', 0, 'a', 0),
    (26943, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 2770, 176, 10, 0.0000, 'a', 0, 'a', 0),
    (26944, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 688, 177, 10, 0.0000, 'a', 0, 'a', 0),
    (26945, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 767, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26946, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 2781, 191, 10, 0.0000, 'a', 0, 'a', 0),
    (26947, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 2767, 175, 10, 0.0000, 'a', 0, 'a', 0),
    (26948, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 1647, 176, 10, 0.0000, 'a', 0, 'a', 0),
    (26949, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 688, 177, 10, 0.0000, 'a', 0, 'a', 0),
    (26950, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 786, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26951, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 2769, 191, 10, 0.0000, 'a', 0, 'a', 0),
    (26952, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 1677, 175, 10, 0.0000, 'a', 0, 'a', 0),
    (26953, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 2770, 176, 10, 0.0000, 'a', 0, 'a', 0),
    (26954, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 688, 177, 10, 0.0000, 'a', 0, 'a', 0),
    (26955, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 786, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26956, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 2771, 191, 10, 0.0000, 'a', 0, 'a', 0),
    (26959, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 688, 177, 10, 0.0000, 'a', 0, 'a', 0),
    (26960, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 767, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26962, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 2773, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26963, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 2773, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26965, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 786, 178, 20, 0.0000, 'a', 0, 'a', 0),
    (26966, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 2769, 191, 20, 0.0000, 'a', 0, 'a', 0),
    (26967, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 2767, 175, 20, 0.0000, 'a', 0, 'a', 0),
    (26968, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 1647, 176, 20, 0.0000, 'a', 0, 'a', 0),
    (26972, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 767, 178, 10, 0.0000, 'a', 0, 'a', 0),
    (26973, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 688, 177, 10, 0.0000, 'a', 0, 'a', 0),
    (26974, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 2782, 164, 30, 0.0000, 'a', 0, 'a', 0),
    (26975, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 2783, 164, 40, 0.0000, 'a', 0, 'a', 0),
    (26979, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 2773, 178, 20, 0.0000, 'a', 0, 'a', 0),
    (26982, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 2785, 164, 50, 0.0000, 'a', 0, 'a', 0),
    (26983, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 786, 178, 30, 0.0000, 'a', 0, 'a', 0),
    (26984, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 2786, 164, 60, 0.0000, 'a', 0, 'a', 0),
    (26990, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 2787, 164, 70, 0.0000, 'a', 0, 'a', 0),
    (26993, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 2790, 168, 60, 0.0000, 'a', 0, 'a', 0),
    (26994, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 959, 194, 10, 0.0000, 'a', 0, 'a', 0),
    (26995, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 939, 195, 10, 0.0000, 'a', 0, 'a', 0),
    (26996, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 940, 196, 10, 0.0000, 'a', 0, 'a', 0),
    (26997, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 1581, 204, 10, 0.0000, 'a', 0, 'a', 0),
    (27009, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 2792, 209, 10, 0.0000, 'a', 0, 'a', 0),
    (27010, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 2793, 210, 10, 0.0000, 'a', 0, 'a', 0);


--
-- Attribute text values
--
INSERT INTO `%%XC%%_attribute_values_text` (`id`, `product_id`, `attribute_id`, `editable`)
VALUES
    (67, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 118, 0),
    (68, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 112, 0),
    (69, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 119, 0),
    (70, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 103, 0),
    (71, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 105, 0),
    (72, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-20-NIS-4' LIMIT 1), 106, 0),
    (1657, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 118, 0),
    (1658, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 103, 0),
    (1659, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 105, 0),
    (1660, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-25-VAU-2' LIMIT 1), 106, 0),
    (1723, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 112, 0),
    (1724, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 103, 0),
    (1725, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 105, 0),
    (1726, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLK-1' LIMIT 1), 106, 0),
    (1727, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 112, 0),
    (1728, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 103, 0),
    (1729, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 105, 0),
    (1730, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002BLU-1' LIMIT 1), 106, 0),
    (1731, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 112, 0),
    (1732, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 103, 0),
    (1733, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 105, 0),
    (1734, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002RED-1' LIMIT 1), 106, 0),
    (1735, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 112, 0),
    (1736, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 103, 0),
    (1737, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 105, 0),
    (1738, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BBK002YEL-1' LIMIT 1), 106, 0),
    (2316, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 118, 0),
    (2317, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 103, 0),
    (2318, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 105, 0),
    (2319, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BL-1-FOR-4-TB' LIMIT 1), 106, 0),
    (2655, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 103, 0),
    (2656, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 105, 0),
    (2657, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-L' LIMIT 1), 106, 0),
    (2658, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 103, 0),
    (2659, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 105, 0),
    (2660, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'BC4101BLK-R' LIMIT 1), 106, 0),
    (5717, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 103, 0),
    (5718, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 105, 0),
    (5719, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 106, 0),
    (5720, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 112, 0),
    (5721, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 140, 0),
    (5722, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940219' LIMIT 1), 146, 0),
    (5729, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 103, 0),
    (5730, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 105, 0),
    (5731, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 106, 0),
    (5732, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 112, 0),
    (5733, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 140, 0),
    (5734, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp184176' LIMIT 1), 146, 0),
    (5735, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 103, 0),
    (5736, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 105, 0),
    (5737, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 106, 0),
    (5738, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 112, 0),
    (5739, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 140, 0),
    (5740, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940119' LIMIT 1), 146, 0),
    (5741, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 103, 0),
    (5742, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 105, 0),
    (5743, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 106, 0),
    (5744, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 112, 0),
    (5745, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 140, 0),
    (5746, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '865860616' LIMIT 1), 146, 0),
    (5747, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 103, 0),
    (5748, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 105, 0),
    (5749, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 106, 0),
    (5750, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 112, 0),
    (5751, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 140, 0),
    (5752, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2947940118' LIMIT 1), 146, 0),
    (5753, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 103, 0),
    (5754, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 105, 0),
    (5755, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 106, 0),
    (5756, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 112, 0),
    (5757, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 140, 0),
    (5758, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp190541' LIMIT 1), 146, 0),
    (5759, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 103, 0),
    (5760, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 105, 0),
    (5761, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 106, 0),
    (5762, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 112, 0),
    (5763, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 140, 0),
    (5764, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4645448461' LIMIT 1), 146, 0),
    (5765, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 103, 0),
    (5766, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 105, 0),
    (5767, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 106, 0),
    (5768, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 112, 0),
    (5769, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 140, 0),
    (5770, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12109' LIMIT 1), 146, 0),
    (5771, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 103, 0),
    (5772, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 105, 0),
    (5773, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 106, 0),
    (5774, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 112, 0),
    (5775, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 140, 0),
    (5776, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp85769' LIMIT 1), 146, 0),
    (5777, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 103, 0),
    (5778, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 105, 0),
    (5779, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 106, 0),
    (5780, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 112, 0),
    (5781, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 140, 0),
    (5782, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp12043' LIMIT 1), 146, 0),
    (5783, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 103, 0),
    (5784, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 105, 0),
    (5785, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 106, 0),
    (5786, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 112, 0),
    (5787, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 140, 0),
    (5788, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1889291213' LIMIT 1), 146, 0),
    (5789, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 103, 0),
    (5790, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 105, 0),
    (5791, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 106, 0),
    (5792, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 112, 0),
    (5793, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 140, 0),
    (5794, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp29051' LIMIT 1), 146, 0),
    (5819, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 103, 0),
    (5820, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 105, 0),
    (5821, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 106, 0),
    (5822, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 112, 0),
    (5823, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 140, 0),
    (5824, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567' LIMIT 1), 146, 0),
    (5825, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 103, 0),
    (5826, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 105, 0),
    (5827, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 106, 0),
    (5828, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 112, 0),
    (5829, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 140, 0),
    (5830, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4670068567-clone-1' LIMIT 1), 146, 0),
    (5837, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 103, 0),
    (5838, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 105, 0),
    (5839, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 106, 0),
    (5840, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 112, 0),
    (5841, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 140, 0),
    (5842, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp147539' LIMIT 1), 146, 0),
    (5879, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 103, 0),
    (5880, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 105, 0),
    (5881, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 106, 0),
    (5882, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 112, 0),
    (5883, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 140, 0),
    (5884, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp108715' LIMIT 1), 146, 0),
    (5885, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 103, 0),
    (5886, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 105, 0),
    (5887, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 106, 0),
    (5888, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 112, 0),
    (5889, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 140, 0),
    (5890, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp178695' LIMIT 1), 146, 0),
    (5891, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 103, 0),
    (5892, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 105, 0),
    (5893, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 106, 0),
    (5894, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 112, 0),
    (5895, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 140, 0),
    (5896, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913' LIMIT 1), 146, 0),
    (5915, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 103, 0),
    (5916, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 105, 0),
    (5917, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 106, 0),
    (5918, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 112, 0),
    (5919, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 140, 0),
    (5920, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4796236558' LIMIT 1), 146, 0),
    (5921, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 103, 0),
    (5922, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 105, 0),
    (5923, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 106, 0),
    (5924, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 112, 0),
    (5925, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 140, 0),
    (5926, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '725638947' LIMIT 1), 146, 0),
    (5927, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 103, 0),
    (5928, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 105, 0),
    (5929, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 106, 0),
    (5930, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 112, 0),
    (5931, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 140, 0),
    (5932, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2226151827' LIMIT 1), 146, 0),
    (5933, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 103, 0),
    (5934, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 105, 0),
    (5935, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 106, 0),
    (5936, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 112, 0),
    (5937, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 140, 0),
    (5938, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3997766134' LIMIT 1), 146, 0),
    (5939, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 103, 0),
    (5940, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 105, 0),
    (5941, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 106, 0),
    (5942, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 112, 0),
    (5943, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 140, 0),
    (5944, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2333742875' LIMIT 1), 146, 0),
    (5945, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 103, 0),
    (5946, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 105, 0),
    (5947, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 106, 0),
    (5948, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 112, 0),
    (5949, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 140, 0),
    (5950, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2253357' LIMIT 1), 146, 0),
    (5951, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 103, 0),
    (5952, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 105, 0),
    (5953, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 106, 0),
    (5954, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 112, 0),
    (5955, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 140, 0),
    (5956, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4784816871' LIMIT 1), 146, 0),
    (5957, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 103, 0),
    (5958, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 105, 0),
    (5959, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 106, 0),
    (5960, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 112, 0),
    (5961, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 140, 0),
    (5962, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2520507136' LIMIT 1), 146, 0),
    (5963, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 103, 0),
    (5964, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 105, 0),
    (5965, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 106, 0),
    (5966, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 112, 0),
    (5967, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 140, 0),
    (5968, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4736024561' LIMIT 1), 146, 0),
    (5969, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 103, 0),
    (5970, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 105, 0),
    (5971, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 106, 0),
    (5972, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 112, 0),
    (5973, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 140, 0),
    (5974, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4634430329' LIMIT 1), 146, 0),
    (5975, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 103, 0),
    (5976, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 105, 0),
    (5977, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 106, 0),
    (5978, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 112, 0),
    (5979, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 140, 0),
    (5980, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4629627773' LIMIT 1), 146, 0),
    (5981, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 103, 0),
    (5982, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 105, 0),
    (5983, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 106, 0),
    (5984, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 112, 0),
    (5985, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 140, 0),
    (5986, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '2355945684' LIMIT 1), 146, 0),
    (5987, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 103, 0),
    (5988, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 105, 0),
    (5989, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 106, 0),
    (5990, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 112, 0),
    (5991, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 140, 0),
    (5992, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4145506070' LIMIT 1), 146, 0),
    (5993, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 103, 0),
    (5994, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 105, 0),
    (5995, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 106, 0),
    (5996, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 112, 0),
    (5997, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 140, 0),
    (5998, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4701094922' LIMIT 1), 146, 0),
    (5999, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 103, 0),
    (6000, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 105, 0),
    (6001, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 106, 0),
    (6002, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 112, 0),
    (6003, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 140, 0),
    (6004, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4693187582' LIMIT 1), 146, 0),
    (6005, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 103, 0),
    (6006, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 105, 0),
    (6007, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 106, 0),
    (6008, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 112, 0),
    (6009, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 140, 0),
    (6010, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4642938301' LIMIT 1), 146, 0),
    (6011, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 103, 0),
    (6012, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 105, 0),
    (6013, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 106, 0),
    (6014, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 112, 0),
    (6015, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 140, 0),
    (6016, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4477224181' LIMIT 1), 146, 0),
    (6023, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 103, 0),
    (6024, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 105, 0),
    (6025, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 106, 0),
    (6026, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 112, 0),
    (6027, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 140, 0),
    (6028, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1654170659' LIMIT 1), 146, 0),
    (6029, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 103, 0),
    (6030, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 105, 0),
    (6031, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 106, 0),
    (6032, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 112, 0),
    (6033, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 140, 0),
    (6034, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066' LIMIT 1), 146, 0),
    (6035, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 103, 0),
    (6036, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 105, 0),
    (6037, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 106, 0),
    (6038, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 112, 0),
    (6039, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 140, 0),
    (6040, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1242279229' LIMIT 1), 146, 0),
    (6041, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 103, 0),
    (6042, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 105, 0),
    (6043, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 106, 0),
    (6044, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 112, 0),
    (6045, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 140, 0),
    (6046, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1656562894' LIMIT 1), 146, 0),
    (6047, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 103, 0),
    (6048, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 105, 0),
    (6049, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 106, 0),
    (6050, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 112, 0),
    (6051, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 140, 0),
    (6052, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414' LIMIT 1), 146, 0),
    (6053, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 103, 0),
    (6054, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 105, 0),
    (6055, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 106, 0),
    (6056, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 112, 0),
    (6057, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 140, 0),
    (6058, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '95627576' LIMIT 1), 146, 0),
    (6059, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 103, 0),
    (6060, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 105, 0),
    (6061, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 106, 0),
    (6062, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 112, 0),
    (6063, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 140, 0),
    (6064, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '10000000905' LIMIT 1), 146, 0),
    (6065, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 103, 0),
    (6066, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 105, 0),
    (6067, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 106, 0),
    (6068, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 112, 0),
    (6069, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 140, 0),
    (6070, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567' LIMIT 1), 146, 0),
    (6071, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 103, 0),
    (6072, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 105, 0),
    (6073, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 106, 0),
    (6074, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 112, 0),
    (6075, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 140, 0),
    (6076, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4652700275' LIMIT 1), 146, 0),
    (6077, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 103, 0),
    (6078, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 105, 0),
    (6079, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 106, 0),
    (6080, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 112, 0),
    (6081, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 140, 0),
    (6082, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134' LIMIT 1), 146, 0),
    (6083, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 103, 0),
    (6084, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 105, 0),
    (6085, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 106, 0),
    (6086, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 112, 0),
    (6087, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 140, 0),
    (6088, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn464544846134-clone-1' LIMIT 1), 146, 0),
    (6089, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 103, 0),
    (6090, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 105, 0),
    (6091, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 106, 0),
    (6092, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 112, 0),
    (6093, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 140, 0),
    (6094, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '8-97329568-0' LIMIT 1), 146, 0),
    (6095, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 103, 0),
    (6096, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 105, 0),
    (6097, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 106, 0),
    (6098, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 112, 0),
    (6099, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 140, 0),
    (6100, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1), 146, 0),
    (6101, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 103, 0),
    (6102, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 105, 0),
    (6103, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 106, 0),
    (6104, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 112, 0),
    (6105, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 140, 0),
    (6106, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1), 146, 0),
    (6107, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 103, 0),
    (6108, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 105, 0),
    (6109, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 106, 0),
    (6110, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 112, 0),
    (6111, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 140, 0),
    (6112, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1), 146, 0),
    (6113, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 103, 0),
    (6114, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 105, 0),
    (6115, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 106, 0),
    (6116, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 112, 0),
    (6117, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 140, 0),
    (6118, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605' LIMIT 1), 146, 0),
    (6119, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 103, 0),
    (6120, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 105, 0),
    (6121, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 106, 0),
    (6122, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 112, 0),
    (6123, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 140, 0),
    (6124, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221080' LIMIT 1), 146, 0),
    (6125, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 103, 0),
    (6126, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 105, 0),
    (6127, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 106, 0),
    (6128, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 112, 0),
    (6129, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 140, 0),
    (6130, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '84221078' LIMIT 1), 146, 0),
    (6137, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 103, 0),
    (6138, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 105, 0),
    (6139, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 106, 0),
    (6140, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 112, 0),
    (6141, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 140, 0),
    (6142, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786' LIMIT 1), 146, 0),
    (6167, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 103, 0),
    (6168, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 105, 0),
    (6169, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 106, 0),
    (6170, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 112, 0),
    (6171, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 140, 0),
    (6172, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4533373412' LIMIT 1), 146, 0),
    (6173, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 103, 0),
    (6174, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 105, 0),
    (6175, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 106, 0),
    (6176, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 112, 0),
    (6177, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 140, 0),
    (6178, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp139404' LIMIT 1), 146, 0),
    (6179, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 103, 0),
    (6180, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 105, 0),
    (6181, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 106, 0),
    (6182, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 112, 0),
    (6183, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 140, 0),
    (6184, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'sp200216' LIMIT 1), 146, 0),
    (6185, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 103, 0),
    (6186, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 105, 0),
    (6187, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 106, 0),
    (6188, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 112, 0),
    (6189, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 140, 0),
    (6190, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn4704437699' LIMIT 1), 146, 0),
    (6191, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 103, 0),
    (6192, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 105, 0),
    (6193, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 106, 0),
    (6194, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 112, 0),
    (6195, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 140, 0),
    (6196, (SELECT product_id FROM `%%XC%%_products` WHERE sku = 'mpn2064787102' LIMIT 1), 146, 0),
    (6197, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 103, 0),
    (6198, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 105, 0),
    (6199, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 106, 0),
    (6200, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 112, 0),
    (6201, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 140, 0),
    (6202, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-clone-1' LIMIT 1), 146, 0),
    (6203, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 103, 0),
    (6204, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 105, 0),
    (6205, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 106, 0),
    (6206, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 112, 0),
    (6207, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 140, 0),
    (6208, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-3' LIMIT 1), 146, 0),
    (6209, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 103, 0),
    (6210, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 105, 0),
    (6211, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 106, 0),
    (6212, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 112, 0),
    (6213, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 140, 0),
    (6214, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-2' LIMIT 1), 146, 0),
    (6215, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 103, 0),
    (6216, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 105, 0),
    (6217, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 106, 0),
    (6218, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 112, 0),
    (6219, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 140, 0),
    (6220, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341434' LIMIT 1), 146, 0),
    (6221, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 103, 0),
    (6222, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 105, 0),
    (6223, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 106, 0),
    (6224, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 112, 0),
    (6225, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 140, 0),
    (6226, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3099712066-23' LIMIT 1), 146, 0),
    (6227, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 103, 0),
    (6228, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 105, 0),
    (6229, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 106, 0),
    (6230, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 112, 0),
    (6231, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 140, 0),
    (6232, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '18798834142' LIMIT 1), 146, 0),
    (6233, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 103, 0),
    (6234, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 105, 0),
    (6235, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 106, 0),
    (6236, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 112, 0),
    (6237, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 140, 0),
    (6238, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422' LIMIT 1), 146, 0),
    (6239, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 103, 0),
    (6240, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 105, 0),
    (6241, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 106, 0),
    (6242, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 112, 0),
    (6243, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 140, 0),
    (6244, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345' LIMIT 1), 146, 0),
    (6245, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 103, 0),
    (6246, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 105, 0),
    (6247, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 106, 0),
    (6248, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 112, 0),
    (6249, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 140, 0),
    (6250, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422344' LIMIT 1), 146, 0),
    (6251, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 103, 0),
    (6252, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 105, 0),
    (6253, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 106, 0),
    (6254, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 112, 0),
    (6255, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 140, 0),
    (6256, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-1' LIMIT 1), 146, 0),
    (6257, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 103, 0),
    (6258, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 105, 0),
    (6259, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 106, 0),
    (6260, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 112, 0),
    (6261, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 140, 0),
    (6262, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-2' LIMIT 1), 146, 0),
    (6263, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 103, 0),
    (6264, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 105, 0),
    (6265, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 106, 0),
    (6266, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 112, 0),
    (6267, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 140, 0),
    (6268, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-3' LIMIT 1), 146, 0),
    (6269, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 103, 0),
    (6270, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 105, 0),
    (6271, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 106, 0),
    (6272, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 112, 0),
    (6273, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 140, 0),
    (6274, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-4' LIMIT 1), 146, 0),
    (6275, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 103, 0),
    (6276, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 105, 0),
    (6277, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 106, 0),
    (6278, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 112, 0),
    (6279, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 140, 0),
    (6280, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-5' LIMIT 1), 146, 0),
    (6281, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-6' LIMIT 1), 103, 0),
    (6282, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-6' LIMIT 1), 105, 0),
    (6283, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-6' LIMIT 1), 106, 0),
    (6284, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-6' LIMIT 1), 112, 0),
    (6285, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-6' LIMIT 1), 140, 0),
    (6286, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '522728567-6' LIMIT 1), 146, 0),
    (6287, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345-clone-1' LIMIT 1), 103, 0),
    (6288, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345-clone-1' LIMIT 1), 105, 0),
    (6289, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345-clone-1' LIMIT 1), 106, 0),
    (6290, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345-clone-1' LIMIT 1), 112, 0),
    (6291, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345-clone-1' LIMIT 1), 140, 0),
    (6292, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '187988341422345-clone-1' LIMIT 1), 146, 0),
    (6293, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 103, 0),
    (6294, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 105, 0),
    (6295, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 106, 0),
    (6296, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 112, 0),
    (6297, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 140, 0),
    (6298, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55' LIMIT 1), 146, 0),
    (6299, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 103, 0),
    (6300, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 105, 0),
    (6301, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 106, 0),
    (6302, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 112, 0),
    (6303, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 140, 0),
    (6304, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-2' LIMIT 1), 146, 0),
    (6305, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-3' LIMIT 1), 103, 0),
    (6306, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-3' LIMIT 1), 105, 0),
    (6307, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-3' LIMIT 1), 106, 0),
    (6308, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-3' LIMIT 1), 112, 0),
    (6309, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-3' LIMIT 1), 140, 0),
    (6310, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-3' LIMIT 1), 146, 0),
    (6311, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 103, 0),
    (6312, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 105, 0),
    (6313, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 106, 0),
    (6314, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 112, 0),
    (6315, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 140, 0),
    (6316, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-5' LIMIT 1), 146, 0),
    (6317, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-6' LIMIT 1), 103, 0),
    (6318, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-6' LIMIT 1), 105, 0),
    (6319, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-6' LIMIT 1), 106, 0),
    (6320, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-6' LIMIT 1), 112, 0),
    (6321, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-6' LIMIT 1), 140, 0),
    (6322, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-55-6' LIMIT 1), 146, 0),
    (6323, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 103, 0),
    (6324, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 105, 0),
    (6325, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 106, 0),
    (6326, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 112, 0),
    (6327, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 140, 0),
    (6328, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-13' LIMIT 1), 146, 0),
    (6329, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 103, 0),
    (6330, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 105, 0),
    (6331, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 106, 0),
    (6332, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 112, 0),
    (6333, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 140, 0),
    (6334, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-14' LIMIT 1), 146, 0),
    (6335, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 103, 0),
    (6336, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 105, 0),
    (6337, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 106, 0),
    (6338, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 112, 0),
    (6339, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 140, 0),
    (6340, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-15' LIMIT 1), 146, 0),
    (6341, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-16' LIMIT 1), 103, 0),
    (6342, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-16' LIMIT 1), 105, 0),
    (6343, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-16' LIMIT 1), 106, 0),
    (6344, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-16' LIMIT 1), 112, 0),
    (6345, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-16' LIMIT 1), 140, 0),
    (6346, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-16' LIMIT 1), 146, 0),
    (6347, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 103, 0),
    (6348, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 105, 0),
    (6349, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 106, 0),
    (6350, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 112, 0),
    (6351, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 140, 0),
    (6352, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-0' LIMIT 1), 146, 0),
    (6353, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 103, 0),
    (6354, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 105, 0),
    (6355, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 106, 0),
    (6356, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 112, 0),
    (6357, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 140, 0),
    (6358, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-34' LIMIT 1), 146, 0),
    (6359, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 103, 0),
    (6360, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 105, 0),
    (6361, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 106, 0),
    (6362, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 112, 0),
    (6363, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 140, 0),
    (6364, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-33' LIMIT 1), 146, 0),
    (6365, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-32' LIMIT 1), 103, 0),
    (6366, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-32' LIMIT 1), 105, 0),
    (6367, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-32' LIMIT 1), 106, 0),
    (6368, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-32' LIMIT 1), 112, 0),
    (6369, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-32' LIMIT 1), 140, 0),
    (6370, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-32' LIMIT 1), 146, 0),
    (6371, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 103, 0),
    (6372, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 105, 0),
    (6373, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 106, 0),
    (6374, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 112, 0),
    (6375, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 140, 0),
    (6376, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-123' LIMIT 1), 146, 0),
    (6377, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-124' LIMIT 1), 103, 0),
    (6378, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-124' LIMIT 1), 105, 0),
    (6379, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-124' LIMIT 1), 106, 0),
    (6380, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-124' LIMIT 1), 112, 0),
    (6381, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-124' LIMIT 1), 140, 0),
    (6382, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-124' LIMIT 1), 146, 0),
    (6383, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-125' LIMIT 1), 103, 0),
    (6384, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-125' LIMIT 1), 105, 0),
    (6385, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-125' LIMIT 1), 106, 0),
    (6386, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-125' LIMIT 1), 112, 0),
    (6387, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-125' LIMIT 1), 140, 0),
    (6388, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-125' LIMIT 1), 146, 0),
    (6389, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-126' LIMIT 1), 103, 0),
    (6390, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-126' LIMIT 1), 105, 0),
    (6391, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-126' LIMIT 1), 106, 0),
    (6392, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-126' LIMIT 1), 112, 0),
    (6393, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-126' LIMIT 1), 140, 0),
    (6394, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '1879883414-126' LIMIT 1), 146, 0),
    (6395, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 103, 0),
    (6396, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 105, 0),
    (6397, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 106, 0),
    (6398, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 112, 0),
    (6399, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 140, 0),
    (6400, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '917435913-13' LIMIT 1), 146, 0),
    (6401, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 103, 0),
    (6402, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 105, 0),
    (6403, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 106, 0),
    (6404, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 112, 0),
    (6405, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 140, 0),
    (6406, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-1' LIMIT 1), 146, 0),
    (6419, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 103, 0),
    (6420, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 105, 0),
    (6421, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 106, 0),
    (6422, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 112, 0),
    (6423, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 140, 0),
    (6424, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1), 146, 0),
    (6431, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 103, 0),
    (6432, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 105, 0),
    (6433, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 106, 0),
    (6434, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 112, 0),
    (6435, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 140, 0),
    (6436, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1), 146, 0),
    (6437, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 103, 0),
    (6438, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 105, 0),
    (6439, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 106, 0),
    (6440, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 112, 0),
    (6441, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 140, 0),
    (6442, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1), 146, 0),
    (6443, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 103, 0),
    (6444, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 105, 0),
    (6445, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 106, 0),
    (6446, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 112, 0),
    (6447, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 140, 0),
    (6448, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-4' LIMIT 1), 146, 0),
    (6449, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 103, 0),
    (6450, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 105, 0),
    (6451, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 106, 0),
    (6452, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 112, 0),
    (6453, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 140, 0),
    (6454, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-5' LIMIT 1), 146, 0),
    (6455, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 103, 0),
    (6456, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 105, 0),
    (6457, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 106, 0),
    (6458, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 112, 0),
    (6459, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 140, 0),
    (6460, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-6' LIMIT 1), 146, 0),
    (6461, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 103, 0),
    (6462, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 105, 0),
    (6463, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 106, 0),
    (6464, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 112, 0),
    (6465, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 140, 0),
    (6466, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3180884605-7' LIMIT 1), 146, 0),
    (6467, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 103, 0),
    (6468, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 105, 0),
    (6469, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 106, 0),
    (6470, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 112, 0),
    (6471, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 140, 0),
    (6472, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-2' LIMIT 1), 146, 0),
    (6473, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 103, 0),
    (6474, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 105, 0),
    (6475, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 106, 0),
    (6476, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 112, 0),
    (6477, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 140, 0),
    (6478, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-3' LIMIT 1), 146, 0),
    (6479, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 103, 0),
    (6480, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 105, 0),
    (6481, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 106, 0),
    (6482, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 112, 0),
    (6483, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 140, 0),
    (6484, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-4' LIMIT 1), 146, 0),
    (6485, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 103, 0),
    (6486, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 105, 0),
    (6487, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 106, 0),
    (6488, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 112, 0),
    (6489, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 140, 0),
    (6490, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4268317786-5' LIMIT 1), 146, 0),
    (6497, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 103, 0),
    (6498, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 105, 0),
    (6499, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 106, 0),
    (6500, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 112, 0),
    (6501, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 140, 0),
    (6502, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1), 146, 0),
    (6503, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 103, 0),
    (6504, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 105, 0),
    (6505, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 106, 0),
    (6506, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 112, 0),
    (6507, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 140, 0),
    (6508, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-8' LIMIT 1), 146, 0),
    (6509, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 103, 0),
    (6510, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 105, 0),
    (6511, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 106, 0),
    (6512, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 112, 0),
    (6513, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 140, 0),
    (6514, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '00813' LIMIT 1), 146, 0),
    (6515, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 103, 0),
    (6516, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 105, 0),
    (6517, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 106, 0),
    (6518, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 112, 0),
    (6519, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 140, 0),
    (6520, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '99915' LIMIT 1), 146, 0),
    (6539, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 103, 0),
    (6540, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 105, 0),
    (6541, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 106, 0),
    (6542, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 112, 0),
    (6543, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 140, 0),
    (6544, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '35125020AMPCA' LIMIT 1), 146, 0),
    (6569, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 103, 0),
    (6570, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 105, 0),
    (6571, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 106, 0),
    (6572, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 112, 0),
    (6573, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 140, 0),
    (6574, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P06-22120-5D55-44BBT' LIMIT 1), 146, 0),
    (6575, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 103, 0),
    (6576, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 105, 0),
    (6577, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 106, 0),
    (6578, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 112, 0),
    (6579, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 140, 0),
    (6580, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P08-22120-5D55-44BBT' LIMIT 1), 146, 0),
    (6581, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 103, 0),
    (6582, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 105, 0),
    (6583, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 106, 0),
    (6584, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 112, 0),
    (6585, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 140, 0),
    (6586, (SELECT product_id FROM `%%XC%%_products` WHERE sku = '4P63-22120-5D55-44BBT' LIMIT 1), 146, 0);


--
-- Attribute text value translations
--
INSERT INTO `%%XC%%_attribute_values_text_translations` (`id`, `value`, `code`)
VALUES
    (67, '4', 'es'),
    (68, 'Reino Unido', 'es'),
    (69, 'Sólo variante de pinza Brembo', 'es'),
    (70, 'Delantero, trasero', 'es'),
    (71, 'HALO Ingeniería de precisión', 'es'),
    (72, 'BL-20-NIS-4', 'es'),
    (1657, '2', 'es'),
    (1658, 'Frente', 'es'),
    (1659, 'HALO Ingeniería de precisión', 'es'),
    (1660, 'BL-25-VAU-2', 'es'),
    (1723, 'Reino Unido', 'es'),
    (1724, 'Delante, detrás', 'es'),
    (1725, 'Frenos EBC', 'es'),
    (1726, 'BBK002BLK-1', 'es'),
    (1727, 'Reino Unido', 'es'),
    (1728, 'Delante, detrás', 'es'),
    (1729, 'Frenos EBC', 'es'),
    (1730, 'BBK002BLU-1', 'es'),
    (1731, 'Reino Unido', 'es'),
    (1732, 'Delante, detrás', 'es'),
    (1733, 'Frenos EBC', 'es'),
    (1734, 'BBK002RED-1', 'es'),
    (1735, 'Reino Unido', 'es'),
    (1736, 'Delante, detrás', 'es'),
    (1737, 'Frenos EBC', 'es'),
    (1738, 'BBK002YEL-1', 'es'),
    (2316, '4', 'es'),
    (2317, 'Delante, detrás', 'es'),
    (2318, 'HALO Ingeniería de precisión', 'es'),
    (2319, 'BL-1-FOR-4-TB', 'es'),
    (2655, 'Frente', 'es'),
    (2656, 'Frenos EBC', 'es'),
    (2657, 'BC4101BLK-L', 'es'),
    (2658, 'Frente', 'es'),
    (2659, 'Frenos EBC', 'es'),
    (2660, 'BC4101BLK-R', 'es'),
    (4329, '321', 'es'),
    (4330, '70', 'es'),
    (4331, '110', 'es'),
    (4332, 'Reino Unido', 'es'),
    (4333, 'Frente', 'es'),
    (4334, 'Superficie estriada', 'es'),
    (4335, 'HALO Ingeniería de precisión', 'es'),
    (4337, '28', 'es'),
    (4338, '26', 'es'),
    (4339, '44', 'es'),
    (4340, '5', 'es'),
    (4341, 'V', 'es'),
    (5717, '', 'es'),
    (5718, 'Lumen', 'es'),
    (5719, '', 'es'),
    (5720, '', 'es'),
    (5721, '', 'es'),
    (5722, '', 'es'),
    (5729, '', 'es'),
    (5730, 'MagnaFlow', 'es'),
    (5731, '', 'es'),
    (5732, '', 'es'),
    (5733, '', 'es'),
    (5734, '', 'es'),
    (5735, '', 'es'),
    (5736, 'Morimoto', 'es'),
    (5737, '', 'es'),
    (5738, '', 'es'),
    (5739, '', 'es'),
    (5740, '', 'es'),
    (5741, '', 'es'),
    (5742, 'MagnaFlow', 'es'),
    (5743, '', 'es'),
    (5744, '', 'es'),
    (5745, '', 'es'),
    (5746, '', 'es'),
    (5747, '', 'es'),
    (5748, 'Morimoto', 'es'),
    (5749, '', 'es'),
    (5750, '', 'es'),
    (5751, '', 'es'),
    (5752, '', 'es'),
    (5753, '', 'es'),
    (5754, 'aFe', 'es'),
    (5755, '', 'es'),
    (5756, '', 'es'),
    (5757, '', 'es'),
    (5758, '', 'es'),
    (5759, '', 'es'),
    (5760, 'APR', 'es'),
    (5761, '', 'es'),
    (5762, '', 'es'),
    (5763, '', 'es'),
    (5764, '', 'es'),
    (5765, '', 'es'),
    (5766, '', 'es'),
    (5767, '', 'es'),
    (5768, '', 'es'),
    (5769, '', 'es'),
    (5770, '', 'es'),
    (5771, '', 'es'),
    (5772, 'Tecnología avanzada de embrague ACT', 'es'),
    (5773, '', 'es'),
    (5774, '', 'es'),
    (5775, '', 'es'),
    (5776, '', 'es'),
    (5777, '', 'es'),
    (5778, 'Centerforce', 'es'),
    (5779, '', 'es'),
    (5780, '', 'es'),
    (5781, '', 'es'),
    (5782, '', 'es'),
    (5783, '', 'es'),
    (5784, 'Spyder', 'es'),
    (5785, '', 'es'),
    (5786, '', 'es'),
    (5787, '', 'es'),
    (5788, '', 'es'),
    (5789, '', 'es'),
    (5790, 'Embragues RAM', 'es'),
    (5791, '', 'es'),
    (5792, '', 'es'),
    (5793, '', 'es'),
    (5794, '', 'es'),
    (5819, '', 'es'),
    (5820, 'Seibon', 'es'),
    (5821, '', 'es'),
    (5822, '', 'es'),
    (5823, '', 'es'),
    (5824, '', 'es'),
    (5825, '', 'es'),
    (5826, 'Dorman', 'es'),
    (5827, '', 'es'),
    (5828, '', 'es'),
    (5829, '', 'es'),
    (5830, '', 'es'),
    (5837, '', 'es'),
    (5838, 'Tyger', 'es'),
    (5839, '', 'es'),
    (5840, '', 'es'),
    (5841, '', 'es'),
    (5842, '', 'es'),
    (5879, '', 'es'),
    (5880, 'OER', 'es'),
    (5881, '', 'es'),
    (5882, '', 'es'),
    (5883, '', 'es'),
    (5884, '', 'es'),
    (5885, '', 'es'),
    (5886, 'Xprite', 'es'),
    (5887, '', 'es'),
    (5888, '', 'es'),
    (5889, '', 'es'),
    (5890, '', 'es'),
    (5891, '', 'es'),
    (5892, 'Xprite', 'es'),
    (5893, '', 'es'),
    (5894, '', 'es'),
    (5895, '', 'es'),
    (5896, '', 'es'),
    (5915, '', 'es'),
    (5916, 'Spyder', 'es'),
    (5917, '', 'es'),
    (5918, '', 'es'),
    (5919, '', 'es'),
    (5920, '', 'es'),
    (5921, '', 'es'),
    (5922, 'Spyder', 'es'),
    (5923, '', 'es'),
    (5924, '', 'es'),
    (5925, '', 'es'),
    (5926, '', 'es'),
    (5927, '', 'es'),
    (5928, 'Iluminación Oracle', 'es'),
    (5929, '', 'es'),
    (5930, '', 'es'),
    (5931, '', 'es'),
    (5932, '', 'es'),
    (5933, '', 'es'),
    (5934, 'Gastokyle', 'es'),
    (5935, '', 'es'),
    (5936, '', 'es'),
    (5937, '', 'es'),
    (5938, '', 'es'),
    (5939, '', 'es'),
    (5940, 'Iluminación Oracle', 'es'),
    (5941, '', 'es'),
    (5942, '', 'es'),
    (5943, '', 'es'),
    (5944, '', 'es'),
    (5945, '', 'es'),
    (5946, 'BOYO', 'es'),
    (5947, '', 'es'),
    (5948, '', 'es'),
    (5949, '', 'es'),
    (5950, '', 'es'),
    (5951, '', 'es'),
    (5952, 'GEKO', 'es'),
    (5953, '', 'es'),
    (5954, '', 'es'),
    (5955, '', 'es'),
    (5956, '', 'es'),
    (5957, '', 'es'),
    (5958, 'Thinkware', 'es'),
    (5959, '', 'es'),
    (5960, '', 'es'),
    (5961, '', 'es'),
    (5962, '', 'es'),
    (5963, '', 'es'),
    (5964, 'Garmin', 'es'),
    (5965, '', 'es'),
    (5966, '', 'es'),
    (5967, '', 'es'),
    (5968, '', 'es'),
    (5969, '', 'es'),
    (5970, 'Garmin', 'es'),
    (5971, '', 'es'),
    (5972, '', 'es'),
    (5973, '', 'es'),
    (5974, '', 'es'),
    (5975, '', 'es'),
    (5976, 'Garmin', 'es'),
    (5977, '', 'es'),
    (5978, '', 'es'),
    (5979, '', 'es'),
    (5980, '', 'es'),
    (5981, '', 'es'),
    (5982, 'Whistler', 'es'),
    (5983, '', 'es'),
    (5984, '', 'es'),
    (5985, '', 'es'),
    (5986, '', 'es'),
    (5987, '', 'es'),
    (5988, 'Uniden', 'es'),
    (5989, '', 'es'),
    (5990, '', 'es'),
    (5991, '', 'es'),
    (5992, '', 'es'),
    (5993, '', 'es'),
    (5994, '', 'es'),
    (5995, '', 'es'),
    (5996, '', 'es'),
    (5997, '', 'es'),
    (5998, '', 'es'),
    (5999, '', 'es'),
    (6000, 'Wagner Tuning', 'es'),
    (6001, '', 'es'),
    (6002, '', 'es'),
    (6003, '', 'es'),
    (6004, '', 'es'),
    (6005, '', 'es'),
    (6006, 'Mishimoto', 'es'),
    (6007, '', 'es'),
    (6008, '', 'es'),
    (6009, '', 'es'),
    (6010, '', 'es'),
    (6011, '', 'es'),
    (6012, 'AMS', 'es'),
    (6013, '', 'es'),
    (6014, '', 'es'),
    (6015, '', 'es'),
    (6016, '', 'es'),
    (6023, '', 'es'),
    (6024, 'CalTrend', 'es'),
    (6025, '', 'es'),
    (6026, '', 'es'),
    (6027, '', 'es'),
    (6028, '', 'es'),
    (6029, '', 'es'),
    (6030, '', 'es'),
    (6031, '', 'es'),
    (6032, '', 'es'),
    (6033, '', 'es'),
    (6034, '', 'es'),
    (6035, '', 'es'),
    (6036, 'Innovate Motorsports', 'es'),
    (6037, '', 'es'),
    (6038, '', 'es'),
    (6039, '', 'es'),
    (6040, '', 'es'),
    (6041, '', 'es'),
    (6042, '', 'es'),
    (6043, '', 'es'),
    (6044, '', 'es'),
    (6045, '', 'es'),
    (6046, '', 'es'),
    (6047, '', 'es'),
    (6048, 'Instrumentos clásicos', 'es'),
    (6049, '', 'es'),
    (6050, '', 'es'),
    (6051, '', 'es'),
    (6052, '', 'es'),
    (6053, '', 'es'),
    (6054, '', 'es'),
    (6055, '', 'es'),
    (6056, '', 'es'),
    (6057, '', 'es'),
    (6058, '', 'es'),
    (6059, '', 'es'),
    (6060, '', 'es'),
    (6061, '', 'es'),
    (6062, '', 'es'),
    (6063, '', 'es'),
    (6064, '', 'es'),
    (6065, '', 'es'),
    (6066, '', 'es'),
    (6067, '', 'es'),
    (6068, '', 'es'),
    (6069, '', 'es'),
    (6070, '', 'es'),
    (6071, '', 'es'),
    (6072, 'Rendimiento del CFR', 'es'),
    (6073, '', 'es'),
    (6074, '', 'es'),
    (6075, '', 'es'),
    (6076, '', 'es'),
    (6077, '', 'es'),
    (6078, 'Spectre', 'es'),
    (6079, '', 'es'),
    (6080, '', 'es'),
    (6081, '', 'es'),
    (6082, '', 'es'),
    (6083, '', 'es'),
    (6084, '', 'es'),
    (6085, '', 'es'),
    (6086, '', 'es'),
    (6087, '', 'es'),
    (6088, '', 'es'),
    (6089, '', 'es'),
    (6090, '', 'es'),
    (6091, '', 'es'),
    (6092, '', 'es'),
    (6093, '', 'es'),
    (6094, '', 'es'),
    (6095, '', 'es'),
    (6096, 'Rotiform', 'es'),
    (6097, '', 'es'),
    (6098, '', 'es'),
    (6099, '', 'es'),
    (6100, '', 'es'),
    (6101, '', 'es'),
    (6102, 'Rotiform', 'es'),
    (6103, '', 'es'),
    (6104, '', 'es'),
    (6105, '', 'es'),
    (6106, '', 'es'),
    (6107, '', 'es'),
    (6108, 'Rotiform', 'es'),
    (6109, '', 'es'),
    (6110, '', 'es'),
    (6111, '', 'es'),
    (6112, '', 'es'),
    (6113, '', 'es'),
    (6114, 'Michelin', 'es'),
    (6115, '', 'es'),
    (6116, '', 'es'),
    (6117, '', 'es'),
    (6118, '', 'es'),
    (6119, '', 'es'),
    (6120, 'Michelin', 'es'),
    (6121, '', 'es'),
    (6122, '', 'es'),
    (6123, '', 'es'),
    (6124, '', 'es'),
    (6125, '', 'es'),
    (6126, 'Michelin', 'es'),
    (6127, '', 'es'),
    (6128, '', 'es'),
    (6129, '', 'es'),
    (6130, '', 'es'),
    (6137, '', 'es'),
    (6138, 'Piloto', 'es'),
    (6139, '', 'es'),
    (6140, '', 'es'),
    (6141, '', 'es'),
    (6142, '', 'es'),
    (6167, '', 'es'),
    (6168, 'Stillen', 'es'),
    (6169, '', 'es'),
    (6170, '', 'es'),
    (6171, '', 'es'),
    (6172, '', 'es'),
    (6173, '', 'es'),
    (6174, 'GrimmSpeed', 'es'),
    (6175, '', 'es'),
    (6176, '', 'es'),
    (6177, '', 'es'),
    (6178, '', 'es'),
    (6179, '', 'es'),
    (6180, 'ACDelco', 'es'),
    (6181, '', 'es'),
    (6182, '', 'es'),
    (6183, '', 'es'),
    (6184, '', 'es'),
    (6185, '', 'es'),
    (6186, 'Zerex', 'es'),
    (6187, '', 'es'),
    (6188, '', 'es'),
    (6189, '', 'es'),
    (6190, '', 'es'),
    (6191, '', 'es'),
    (6192, 'Mishimoto', 'es'),
    (6193, '', 'es'),
    (6194, '', 'es'),
    (6195, '', 'es'),
    (6196, '', 'es'),
    (6197, '', 'es'),
    (6198, '', 'es'),
    (6199, '', 'es'),
    (6200, '', 'es'),
    (6201, '', 'es'),
    (6202, '', 'es'),
    (6203, '', 'es'),
    (6204, '', 'es'),
    (6205, '', 'es'),
    (6206, '', 'es'),
    (6207, '', 'es'),
    (6208, '', 'es'),
    (6209, '', 'es'),
    (6210, 'Instrumentos clásicos', 'es'),
    (6211, '', 'es'),
    (6212, '', 'es'),
    (6213, '', 'es'),
    (6214, '', 'es'),
    (6215, '', 'es'),
    (6216, 'Instrumentos clásicos', 'es'),
    (6217, '', 'es'),
    (6218, '', 'es'),
    (6219, '', 'es'),
    (6220, '', 'es'),
    (6221, '', 'es'),
    (6222, '', 'es'),
    (6223, '', 'es'),
    (6224, '', 'es'),
    (6225, '', 'es'),
    (6226, '', 'es'),
    (6227, '', 'es'),
    (6228, '', 'es'),
    (6229, '', 'es'),
    (6230, '', 'es'),
    (6231, '', 'es'),
    (6232, '', 'es'),
    (6233, '', 'es'),
    (6234, '', 'es'),
    (6235, '', 'es'),
    (6236, '', 'es'),
    (6237, '', 'es'),
    (6238, '', 'es'),
    (6239, '', 'es'),
    (6240, '', 'es'),
    (6241, '', 'es'),
    (6242, '', 'es'),
    (6243, '', 'es'),
    (6244, '', 'es'),
    (6245, '', 'es'),
    (6246, '', 'es'),
    (6247, '', 'es'),
    (6248, '', 'es'),
    (6249, '', 'es'),
    (6250, '', 'es'),
    (6251, '', 'es'),
    (6252, '', 'es'),
    (6253, '', 'es'),
    (6254, '', 'es'),
    (6255, '', 'es'),
    (6256, '', 'es'),
    (6257, '', 'es'),
    (6258, '', 'es'),
    (6259, '', 'es'),
    (6260, '', 'es'),
    (6261, '', 'es'),
    (6262, '', 'es'),
    (6263, '', 'es'),
    (6264, '', 'es'),
    (6265, '', 'es'),
    (6266, '', 'es'),
    (6267, '', 'es'),
    (6268, '', 'es'),
    (6269, '', 'es'),
    (6270, '', 'es'),
    (6271, '', 'es'),
    (6272, '', 'es'),
    (6273, '', 'es'),
    (6274, '', 'es'),
    (6275, '', 'es'),
    (6276, '', 'es'),
    (6277, '', 'es'),
    (6278, '', 'es'),
    (6279, '', 'es'),
    (6280, '', 'es'),
    (6281, '', 'es'),
    (6282, '', 'es'),
    (6283, '', 'es'),
    (6284, '', 'es'),
    (6285, '', 'es'),
    (6286, '', 'es'),
    (6287, '', 'es'),
    (6288, '', 'es'),
    (6289, '', 'es'),
    (6290, '', 'es'),
    (6291, '', 'es'),
    (6292, '', 'es'),
    (6293, '', 'es'),
    (6294, '', 'es'),
    (6295, '', 'es'),
    (6296, '', 'es'),
    (6297, '', 'es'),
    (6298, '', 'es'),
    (6299, '', 'es'),
    (6300, '', 'es'),
    (6301, '', 'es'),
    (6302, '', 'es'),
    (6303, '', 'es'),
    (6304, '', 'es'),
    (6305, '', 'es'),
    (6306, '', 'es'),
    (6307, '', 'es'),
    (6308, '', 'es'),
    (6309, '', 'es'),
    (6310, '', 'es'),
    (6311, '', 'es'),
    (6312, '', 'es'),
    (6313, '', 'es'),
    (6314, '', 'es'),
    (6315, '', 'es'),
    (6316, '', 'es'),
    (6317, '', 'es'),
    (6318, '', 'es'),
    (6319, '', 'es'),
    (6320, '', 'es'),
    (6321, '', 'es'),
    (6322, '', 'es'),
    (6323, '', 'es'),
    (6324, '', 'es'),
    (6325, '', 'es'),
    (6326, '', 'es'),
    (6327, '', 'es'),
    (6328, '', 'es'),
    (6329, '', 'es'),
    (6330, '', 'es'),
    (6331, '', 'es'),
    (6332, '', 'es'),
    (6333, '', 'es'),
    (6334, '', 'es'),
    (6335, '', 'es'),
    (6336, '', 'es'),
    (6337, '', 'es'),
    (6338, '', 'es'),
    (6339, '', 'es'),
    (6340, '', 'es'),
    (6341, '', 'es'),
    (6342, '', 'es'),
    (6343, '', 'es'),
    (6344, '', 'es'),
    (6345, '', 'es'),
    (6346, '', 'es'),
    (6347, '', 'es'),
    (6348, '', 'es'),
    (6349, '', 'es'),
    (6350, '', 'es'),
    (6351, '', 'es'),
    (6352, '', 'es'),
    (6353, '', 'es'),
    (6354, '', 'es'),
    (6355, '', 'es'),
    (6356, '', 'es'),
    (6357, '', 'es'),
    (6358, '', 'es'),
    (6359, '', 'es'),
    (6360, '', 'es'),
    (6361, '', 'es'),
    (6362, '', 'es'),
    (6363, '', 'es'),
    (6364, '', 'es'),
    (6365, '', 'es'),
    (6366, '', 'es'),
    (6367, '', 'es'),
    (6368, '', 'es'),
    (6369, '', 'es'),
    (6370, '', 'es'),
    (6371, '', 'es'),
    (6372, '', 'es'),
    (6373, '', 'es'),
    (6374, '', 'es'),
    (6375, '', 'es'),
    (6376, '', 'es'),
    (6377, '', 'es'),
    (6378, '', 'es'),
    (6379, '', 'es'),
    (6380, '', 'es'),
    (6381, '', 'es'),
    (6382, '', 'es'),
    (6383, '', 'es'),
    (6384, '', 'es'),
    (6385, '', 'es'),
    (6386, '', 'es'),
    (6387, '', 'es'),
    (6388, '', 'es'),
    (6389, '', 'es'),
    (6390, '', 'es'),
    (6391, '', 'es'),
    (6392, '', 'es'),
    (6393, '', 'es'),
    (6394, '', 'es'),
    (6395, '', 'es'),
    (6396, 'Xprite', 'es'),
    (6397, '', 'es'),
    (6398, '', 'es'),
    (6399, '', 'es'),
    (6400, '', 'es'),
    (6401, '', 'es'),
    (6402, 'Vogue Tires', 'es'),
    (6403, '', 'es'),
    (6404, '', 'es'),
    (6405, '', 'es'),
    (6406, '', 'es'),
    (6419, '', 'es'),
    (6420, 'Niche', 'es'),
    (6421, '', 'es'),
    (6422, '', 'es'),
    (6423, '', 'es'),
    (6424, '', 'es'),
    (6431, '', 'es'),
    (6432, 'Niche', 'es'),
    (6433, '', 'es'),
    (6434, '', 'es'),
    (6435, '', 'es'),
    (6436, '', 'es'),
    (6437, '', 'es'),
    (6438, 'Rennen Forged', 'es'),
    (6439, '', 'es'),
    (6440, '', 'es'),
    (6441, '', 'es'),
    (6442, '', 'es'),
    (6443, '', 'es'),
    (6444, 'Laufenn', 'es'),
    (6445, '', 'es'),
    (6446, '', 'es'),
    (6447, '', 'es'),
    (6448, '', 'es'),
    (6449, '', 'es'),
    (6450, 'Landspider', 'es'),
    (6451, '', 'es'),
    (6452, '', 'es'),
    (6453, '', 'es'),
    (6454, '', 'es'),
    (6455, '', 'es'),
    (6456, 'Yokohama', 'es'),
    (6457, '', 'es'),
    (6458, '', 'es'),
    (6459, '', 'es'),
    (6460, '', 'es'),
    (6461, '', 'es'),
    (6462, 'Yokohama', 'es'),
    (6463, '', 'es'),
    (6464, '', 'es'),
    (6465, '', 'es'),
    (6466, '', 'es'),
    (6467, '', 'es'),
    (6468, 'Piloto', 'es'),
    (6469, '', 'es'),
    (6470, '', 'es'),
    (6471, '', 'es'),
    (6472, '', 'es'),
    (6473, '', 'es'),
    (6474, 'CCI', 'es'),
    (6475, '', 'es'),
    (6476, '', 'es'),
    (6477, '', 'es'),
    (6478, '', 'es'),
    (6479, '', 'es'),
    (6480, 'CCI', 'es'),
    (6481, '', 'es'),
    (6482, '', 'es'),
    (6483, '', 'es'),
    (6484, '', 'es'),
    (6485, '', 'es'),
    (6486, 'CCI', 'es'),
    (6487, '', 'es'),
    (6488, '', 'es'),
    (6489, '', 'es'),
    (6490, '', 'es'),
    (6497, '', 'es'),
    (6498, 'Artis Forged', 'es'),
    (6499, '', 'es'),
    (6500, '', 'es'),
    (6501, '', 'es'),
    (6502, '', 'es'),
    (6503, '', 'es'),
    (6504, 'Artis Forged', 'es'),
    (6505, '', 'es'),
    (6506, '', 'es'),
    (6507, '', 'es'),
    (6508, '', 'es'),
    (6509, '', 'es'),
    (6510, '', 'es'),
    (6511, '', 'es'),
    (6512, '', 'es'),
    (6513, '', 'es'),
    (6514, '', 'es'),
    (6515, '', 'es'),
    (6516, '', 'es'),
    (6517, '', 'es'),
    (6518, '', 'es'),
    (6519, '', 'es'),
    (6520, '', 'es'),
    (6539, '', 'es'),
    (6540, '', 'es'),
    (6541, '', 'es'),
    (6542, '', 'es'),
    (6543, '', 'es'),
    (6544, '', 'es'),
    (6569, '', 'es'),
    (6570, '', 'es'),
    (6571, '', 'es'),
    (6572, '', 'es'),
    (6573, '', 'es'),
    (6574, '', 'es'),
    (6575, '', 'es'),
    (6576, '', 'es'),
    (6577, '', 'es'),
    (6578, '', 'es'),
    (6579, '', 'es'),
    (6580, '', 'es'),
    (6581, '', 'es'),
    (6582, '', 'es'),
    (6583, '', 'es'),
    (6584, '', 'es'),
    (6585, '', 'es'),
    (6586, '', 'es'),
    (67, '4', 'en'),
    (68, 'United Kingdom', 'en'),
    (69, 'Brembo Caliper Variant Only', 'en'),
    (70, 'Front, Rear', 'en'),
    (71, 'HALO Precision Engineering', 'en'),
    (72, 'BL-20-NIS-4', 'en'),
    (1657, '2', 'en'),
    (1658, 'Front', 'en'),
    (1659, 'HALO Precision Engineering', 'en'),
    (1660, 'BL-25-VAU-2', 'en'),
    (1723, 'United Kingdom', 'en'),
    (1724, 'Front, Rear', 'en'),
    (1725, 'EBC Brakes', 'en'),
    (1726, 'BBK002BLK-1', 'en'),
    (1727, 'United Kingdom', 'en'),
    (1728, 'Front, Rear', 'en'),
    (1729, 'EBC Brakes', 'en'),
    (1730, 'BBK002BLU-1', 'en'),
    (1731, 'United Kingdom', 'en'),
    (1732, 'Front, Rear', 'en'),
    (1733, 'EBC Brakes', 'en'),
    (1734, 'BBK002RED-1', 'en'),
    (1735, 'United Kingdom', 'en'),
    (1736, 'Front, Rear', 'en'),
    (1737, 'EBC Brakes', 'en'),
    (1738, 'BBK002YEL-1', 'en'),
    (2316, '4', 'en'),
    (2317, 'Front, Rear', 'en'),
    (2318, 'HALO Precision Engineering', 'en'),
    (2319, 'BL-1-FOR-4-TB', 'en'),
    (2655, 'Front', 'en'),
    (2656, 'EBC Brakes', 'en'),
    (2657, 'BC4101BLK-L', 'en'),
    (2658, 'Front', 'en'),
    (2659, 'EBC Brakes', 'en'),
    (2660, 'BC4101BLK-R', 'en'),
    (4329, '321', 'en'),
    (4330, '70', 'en'),
    (4331, '110', 'en'),
    (4332, 'United Kingdom', 'en'),
    (4333, 'Front', 'en'),
    (4334, 'Grooved Surface', 'en'),
    (4335, 'HALO Precision Engineering', 'en'),
    (4337, '28', 'en'),
    (4338, '26', 'en'),
    (4339, '44', 'en'),
    (4340, '5', 'en'),
    (4341, 'V', 'en'),
    (5717, '', 'en'),
    (5718, 'Lumen', 'en'),
    (5719, '', 'en'),
    (5720, '', 'en'),
    (5721, '', 'en'),
    (5722, '', 'en'),
    (5729, '', 'en'),
    (5730, 'MagnaFlow', 'en'),
    (5731, '', 'en'),
    (5732, '', 'en'),
    (5733, '', 'en'),
    (5734, '', 'en'),
    (5735, '', 'en'),
    (5736, 'Morimoto', 'en'),
    (5737, '', 'en'),
    (5738, '', 'en'),
    (5739, '', 'en'),
    (5740, '', 'en'),
    (5741, '', 'en'),
    (5742, 'MagnaFlow', 'en'),
    (5743, '', 'en'),
    (5744, '', 'en'),
    (5745, '', 'en'),
    (5746, '', 'en'),
    (5747, '', 'en'),
    (5748, 'Morimoto', 'en'),
    (5749, '', 'en'),
    (5750, '', 'en'),
    (5751, '', 'en'),
    (5752, '', 'en'),
    (5753, '', 'en'),
    (5754, 'aFe', 'en'),
    (5755, '', 'en'),
    (5756, '', 'en'),
    (5757, '', 'en'),
    (5758, '', 'en'),
    (5759, '', 'en'),
    (5760, 'APR', 'en'),
    (5761, '', 'en'),
    (5762, '', 'en'),
    (5763, '', 'en'),
    (5764, '', 'en'),
    (5765, '', 'en'),
    (5766, '', 'en'),
    (5767, '', 'en'),
    (5768, '', 'en'),
    (5769, '', 'en'),
    (5770, '', 'en'),
    (5771, '', 'en'),
    (5772, 'ACT Advanced Clutch Technology', 'en'),
    (5773, '', 'en'),
    (5774, '', 'en'),
    (5775, '', 'en'),
    (5776, '', 'en'),
    (5777, '', 'en'),
    (5778, 'Centerforce', 'en'),
    (5779, '', 'en'),
    (5780, '', 'en'),
    (5781, '', 'en'),
    (5782, '', 'en'),
    (5783, '', 'en'),
    (5784, 'Spyder', 'en'),
    (5785, '', 'en'),
    (5786, '', 'en'),
    (5787, '', 'en'),
    (5788, '', 'en'),
    (5789, '', 'en'),
    (5790, 'RAM Clutches', 'en'),
    (5791, '', 'en'),
    (5792, '', 'en'),
    (5793, '', 'en'),
    (5794, '', 'en'),
    (5819, '', 'en'),
    (5820, 'Seibon', 'en'),
    (5821, '', 'en'),
    (5822, '', 'en'),
    (5823, '', 'en'),
    (5824, '', 'en'),
    (5825, '', 'en'),
    (5826, 'Dorman', 'en'),
    (5827, '', 'en'),
    (5828, '', 'en'),
    (5829, '', 'en'),
    (5830, '', 'en'),
    (5837, '', 'en'),
    (5838, 'Tyger', 'en'),
    (5839, '', 'en'),
    (5840, '', 'en'),
    (5841, '', 'en'),
    (5842, '', 'en'),
    (5879, '', 'en'),
    (5880, 'OER', 'en'),
    (5881, '', 'en'),
    (5882, '', 'en'),
    (5883, '', 'en'),
    (5884, '', 'en'),
    (5885, '', 'en'),
    (5886, 'Xprite', 'en'),
    (5887, '', 'en'),
    (5888, '', 'en'),
    (5889, '', 'en'),
    (5890, '', 'en'),
    (5891, '', 'en'),
    (5892, 'Xprite', 'en'),
    (5893, '', 'en'),
    (5894, '', 'en'),
    (5895, '', 'en'),
    (5896, '', 'en'),
    (5915, '', 'en'),
    (5916, 'Spyder', 'en'),
    (5917, '', 'en'),
    (5918, '', 'en'),
    (5919, '', 'en'),
    (5920, '', 'en'),
    (5921, '', 'en'),
    (5922, 'Spyder', 'en'),
    (5923, '', 'en'),
    (5924, '', 'en'),
    (5925, '', 'en'),
    (5926, '', 'en'),
    (5927, '', 'en'),
    (5928, 'Oracle Lighting', 'en'),
    (5929, '', 'en'),
    (5930, '', 'en'),
    (5931, '', 'en'),
    (5932, '', 'en'),
    (5933, '', 'en'),
    (5934, 'Gastokyle', 'en'),
    (5935, '', 'en'),
    (5936, '', 'en'),
    (5937, '', 'en'),
    (5938, '', 'en'),
    (5939, '', 'en'),
    (5940, 'Oracle Lighting', 'en'),
    (5941, '', 'en'),
    (5942, '', 'en'),
    (5943, '', 'en'),
    (5944, '', 'en'),
    (5945, '', 'en'),
    (5946, 'BOYO', 'en'),
    (5947, '', 'en'),
    (5948, '', 'en'),
    (5949, '', 'en'),
    (5950, '', 'en'),
    (5951, '', 'en'),
    (5952, 'GEKO', 'en'),
    (5953, '', 'en'),
    (5954, '', 'en'),
    (5955, '', 'en'),
    (5956, '', 'en'),
    (5957, '', 'en'),
    (5958, 'Thinkware', 'en'),
    (5959, '', 'en'),
    (5960, '', 'en'),
    (5961, '', 'en'),
    (5962, '', 'en'),
    (5963, '', 'en'),
    (5964, 'Garmin', 'en'),
    (5965, '', 'en'),
    (5966, '', 'en'),
    (5967, '', 'en'),
    (5968, '', 'en'),
    (5969, '', 'en'),
    (5970, 'Garmin', 'en'),
    (5971, '', 'en'),
    (5972, '', 'en'),
    (5973, '', 'en'),
    (5974, '', 'en'),
    (5975, '', 'en'),
    (5976, 'Garmin', 'en'),
    (5977, '', 'en'),
    (5978, '', 'en'),
    (5979, '', 'en'),
    (5980, '', 'en'),
    (5981, '', 'en'),
    (5982, 'Whistler', 'en'),
    (5983, '', 'en'),
    (5984, '', 'en'),
    (5985, '', 'en'),
    (5986, '', 'en'),
    (5987, '', 'en'),
    (5988, 'Uniden', 'en'),
    (5989, '', 'en'),
    (5990, '', 'en'),
    (5991, '', 'en'),
    (5992, '', 'en'),
    (5993, '', 'en'),
    (5994, '', 'en'),
    (5995, '', 'en'),
    (5996, '', 'en'),
    (5997, '', 'en'),
    (5998, '', 'en'),
    (5999, '', 'en'),
    (6000, 'Wagner Tuning', 'en'),
    (6001, '', 'en'),
    (6002, '', 'en'),
    (6003, '', 'en'),
    (6004, '', 'en'),
    (6005, '', 'en'),
    (6006, 'Mishimoto', 'en'),
    (6007, '', 'en'),
    (6008, '', 'en'),
    (6009, '', 'en'),
    (6010, '', 'en'),
    (6011, '', 'en'),
    (6012, 'AMS', 'en'),
    (6013, '', 'en'),
    (6014, '', 'en'),
    (6015, '', 'en'),
    (6016, '', 'en'),
    (6023, '', 'en'),
    (6024, 'CalTrend', 'en'),
    (6025, '', 'en'),
    (6026, '', 'en'),
    (6027, '', 'en'),
    (6028, '', 'en'),
    (6029, '', 'en'),
    (6030, '', 'en'),
    (6031, '', 'en'),
    (6032, '', 'en'),
    (6033, '', 'en'),
    (6034, '', 'en'),
    (6035, '', 'en'),
    (6036, 'Innovate Motorsports', 'en'),
    (6037, '', 'en'),
    (6038, '', 'en'),
    (6039, '', 'en'),
    (6040, '', 'en'),
    (6041, '', 'en'),
    (6042, '', 'en'),
    (6043, '', 'en'),
    (6044, '', 'en'),
    (6045, '', 'en'),
    (6046, '', 'en'),
    (6047, '', 'en'),
    (6048, 'Classic Instruments', 'en'),
    (6049, '', 'en'),
    (6050, '', 'en'),
    (6051, '', 'en'),
    (6052, '', 'en'),
    (6053, '', 'en'),
    (6054, '', 'en'),
    (6055, '', 'en'),
    (6056, '', 'en'),
    (6057, '', 'en'),
    (6058, '', 'en'),
    (6059, '', 'en'),
    (6060, '', 'en'),
    (6061, '', 'en'),
    (6062, '', 'en'),
    (6063, '', 'en'),
    (6064, '', 'en'),
    (6065, '', 'en'),
    (6066, '', 'en'),
    (6067, '', 'en'),
    (6068, '', 'en'),
    (6069, '', 'en'),
    (6070, '', 'en'),
    (6071, '', 'en'),
    (6072, 'CFR Performance', 'en'),
    (6073, '', 'en'),
    (6074, '', 'en'),
    (6075, '', 'en'),
    (6076, '', 'en'),
    (6077, '', 'en'),
    (6078, 'Spectre', 'en'),
    (6079, '', 'en'),
    (6080, '', 'en'),
    (6081, '', 'en'),
    (6082, '', 'en'),
    (6083, '', 'en'),
    (6084, '', 'en'),
    (6085, '', 'en'),
    (6086, '', 'en'),
    (6087, '', 'en'),
    (6088, '', 'en'),
    (6089, '', 'en'),
    (6090, '', 'en'),
    (6091, '', 'en'),
    (6092, '', 'en'),
    (6093, '', 'en'),
    (6094, '', 'en'),
    (6095, '', 'en'),
    (6096, 'Rotiform', 'en'),
    (6097, '', 'en'),
    (6098, '', 'en'),
    (6099, '', 'en'),
    (6100, '', 'en'),
    (6101, '', 'en'),
    (6102, 'Rotiform', 'en'),
    (6103, '', 'en'),
    (6104, '', 'en'),
    (6105, '', 'en'),
    (6106, '', 'en'),
    (6107, '', 'en'),
    (6108, 'Rotiform', 'en'),
    (6109, '', 'en'),
    (6110, '', 'en'),
    (6111, '', 'en'),
    (6112, '', 'en'),
    (6113, '', 'en'),
    (6114, 'Michelin', 'en'),
    (6115, '', 'en'),
    (6116, '', 'en'),
    (6117, '', 'en'),
    (6118, '', 'en'),
    (6119, '', 'en'),
    (6120, 'Michelin', 'en'),
    (6121, '', 'en'),
    (6122, '', 'en'),
    (6123, '', 'en'),
    (6124, '', 'en'),
    (6125, '', 'en'),
    (6126, 'Michelin', 'en'),
    (6127, '', 'en'),
    (6128, '', 'en'),
    (6129, '', 'en'),
    (6130, '', 'en'),
    (6137, '', 'en'),
    (6138, 'Pilot', 'en'),
    (6139, '', 'en'),
    (6140, '', 'en'),
    (6141, '', 'en'),
    (6142, '', 'en'),
    (6167, '', 'en'),
    (6168, 'Stillen', 'en'),
    (6169, '', 'en'),
    (6170, '', 'en'),
    (6171, '', 'en'),
    (6172, '', 'en'),
    (6173, '', 'en'),
    (6174, 'GrimmSpeed', 'en'),
    (6175, '', 'en'),
    (6176, '', 'en'),
    (6177, '', 'en'),
    (6178, '', 'en'),
    (6179, '', 'en'),
    (6180, 'ACDelco', 'en'),
    (6181, '', 'en'),
    (6182, '', 'en'),
    (6183, '', 'en'),
    (6184, '', 'en'),
    (6185, '', 'en'),
    (6186, 'Zerex', 'en'),
    (6187, '', 'en'),
    (6188, '', 'en'),
    (6189, '', 'en'),
    (6190, '', 'en'),
    (6191, '', 'en'),
    (6192, 'Mishimoto', 'en'),
    (6193, '', 'en'),
    (6194, '', 'en'),
    (6195, '', 'en'),
    (6196, '', 'en'),
    (6197, '', 'en'),
    (6198, '', 'en'),
    (6199, '', 'en'),
    (6200, '', 'en'),
    (6201, '', 'en'),
    (6202, '', 'en'),
    (6203, '', 'en'),
    (6204, '', 'en'),
    (6205, '', 'en'),
    (6206, '', 'en'),
    (6207, '', 'en'),
    (6208, '', 'en'),
    (6209, '', 'en'),
    (6210, 'Classic Instruments', 'en'),
    (6211, '', 'en'),
    (6212, '', 'en'),
    (6213, '', 'en'),
    (6214, '', 'en'),
    (6215, '', 'en'),
    (6216, 'Classic Instruments', 'en'),
    (6217, '', 'en'),
    (6218, '', 'en'),
    (6219, '', 'en'),
    (6220, '', 'en'),
    (6221, '', 'en'),
    (6222, '', 'en'),
    (6223, '', 'en'),
    (6224, '', 'en'),
    (6225, '', 'en'),
    (6226, '', 'en'),
    (6227, '', 'en'),
    (6228, '', 'en'),
    (6229, '', 'en'),
    (6230, '', 'en'),
    (6231, '', 'en'),
    (6232, '', 'en'),
    (6233, '', 'en'),
    (6234, '', 'en'),
    (6235, '', 'en'),
    (6236, '', 'en'),
    (6237, '', 'en'),
    (6238, '', 'en'),
    (6239, '', 'en'),
    (6240, '', 'en'),
    (6241, '', 'en'),
    (6242, '', 'en'),
    (6243, '', 'en'),
    (6244, '', 'en'),
    (6245, '', 'en'),
    (6246, '', 'en'),
    (6247, '', 'en'),
    (6248, '', 'en'),
    (6249, '', 'en'),
    (6250, '', 'en'),
    (6251, '', 'en'),
    (6252, '', 'en'),
    (6253, '', 'en'),
    (6254, '', 'en'),
    (6255, '', 'en'),
    (6256, '', 'en'),
    (6257, '', 'en'),
    (6258, '', 'en'),
    (6259, '', 'en'),
    (6260, '', 'en'),
    (6261, '', 'en'),
    (6262, '', 'en'),
    (6263, '', 'en'),
    (6264, '', 'en'),
    (6265, '', 'en'),
    (6266, '', 'en'),
    (6267, '', 'en'),
    (6268, '', 'en'),
    (6269, '', 'en'),
    (6270, '', 'en'),
    (6271, '', 'en'),
    (6272, '', 'en'),
    (6273, '', 'en'),
    (6274, '', 'en'),
    (6275, '', 'en'),
    (6276, '', 'en'),
    (6277, '', 'en'),
    (6278, '', 'en'),
    (6279, '', 'en'),
    (6280, '', 'en'),
    (6281, '', 'en'),
    (6282, '', 'en'),
    (6283, '', 'en'),
    (6284, '', 'en'),
    (6285, '', 'en'),
    (6286, '', 'en'),
    (6287, '', 'en'),
    (6288, '', 'en'),
    (6289, '', 'en'),
    (6290, '', 'en'),
    (6291, '', 'en'),
    (6292, '', 'en'),
    (6293, '', 'en'),
    (6294, '', 'en'),
    (6295, '', 'en'),
    (6296, '', 'en'),
    (6297, '', 'en'),
    (6298, '', 'en'),
    (6299, '', 'en'),
    (6300, '', 'en'),
    (6301, '', 'en'),
    (6302, '', 'en'),
    (6303, '', 'en'),
    (6304, '', 'en'),
    (6305, '', 'en'),
    (6306, '', 'en'),
    (6307, '', 'en'),
    (6308, '', 'en'),
    (6309, '', 'en'),
    (6310, '', 'en'),
    (6311, '', 'en'),
    (6312, '', 'en'),
    (6313, '', 'en'),
    (6314, '', 'en'),
    (6315, '', 'en'),
    (6316, '', 'en'),
    (6317, '', 'en'),
    (6318, '', 'en'),
    (6319, '', 'en'),
    (6320, '', 'en'),
    (6321, '', 'en'),
    (6322, '', 'en'),
    (6323, '', 'en'),
    (6324, '', 'en'),
    (6325, '', 'en'),
    (6326, '', 'en'),
    (6327, '', 'en'),
    (6328, '', 'en'),
    (6329, '', 'en'),
    (6330, '', 'en'),
    (6331, '', 'en'),
    (6332, '', 'en'),
    (6333, '', 'en'),
    (6334, '', 'en'),
    (6335, '', 'en'),
    (6336, '', 'en'),
    (6337, '', 'en'),
    (6338, '', 'en'),
    (6339, '', 'en'),
    (6340, '', 'en'),
    (6341, '', 'en'),
    (6342, '', 'en'),
    (6343, '', 'en'),
    (6344, '', 'en'),
    (6345, '', 'en'),
    (6346, '', 'en'),
    (6347, '', 'en'),
    (6348, '', 'en'),
    (6349, '', 'en'),
    (6350, '', 'en'),
    (6351, '', 'en'),
    (6352, '', 'en'),
    (6353, '', 'en'),
    (6354, '', 'en'),
    (6355, '', 'en'),
    (6356, '', 'en'),
    (6357, '', 'en'),
    (6358, '', 'en'),
    (6359, '', 'en'),
    (6360, '', 'en'),
    (6361, '', 'en'),
    (6362, '', 'en'),
    (6363, '', 'en'),
    (6364, '', 'en'),
    (6365, '', 'en'),
    (6366, '', 'en'),
    (6367, '', 'en'),
    (6368, '', 'en'),
    (6369, '', 'en'),
    (6370, '', 'en'),
    (6371, '', 'en'),
    (6372, '', 'en'),
    (6373, '', 'en'),
    (6374, '', 'en'),
    (6375, '', 'en'),
    (6376, '', 'en'),
    (6377, '', 'en'),
    (6378, '', 'en'),
    (6379, '', 'en'),
    (6380, '', 'en'),
    (6381, '', 'en'),
    (6382, '', 'en'),
    (6383, '', 'en'),
    (6384, '', 'en'),
    (6385, '', 'en'),
    (6386, '', 'en'),
    (6387, '', 'en'),
    (6388, '', 'en'),
    (6389, '', 'en'),
    (6390, '', 'en'),
    (6391, '', 'en'),
    (6392, '', 'en'),
    (6393, '', 'en'),
    (6394, '', 'en'),
    (6395, '', 'en'),
    (6396, 'Xprite', 'en'),
    (6397, '', 'en'),
    (6398, '', 'en'),
    (6399, '', 'en'),
    (6400, '', 'en'),
    (6401, '', 'en'),
    (6402, 'Vogue Tires', 'en'),
    (6403, '', 'en'),
    (6404, '', 'en'),
    (6405, '', 'en'),
    (6406, '', 'en'),
    (6419, '', 'en'),
    (6420, 'Niche', 'en'),
    (6421, '', 'en'),
    (6422, '', 'en'),
    (6423, '', 'en'),
    (6424, '', 'en'),
    (6431, '', 'en'),
    (6432, 'Niche', 'en'),
    (6433, '', 'en'),
    (6434, '', 'en'),
    (6435, '', 'en'),
    (6436, '', 'en'),
    (6437, '', 'en'),
    (6438, 'Rennen Forged', 'en'),
    (6439, '', 'en'),
    (6440, '', 'en'),
    (6441, '', 'en'),
    (6442, '', 'en'),
    (6443, '', 'en'),
    (6444, 'Laufenn', 'en'),
    (6445, '', 'en'),
    (6446, '', 'en'),
    (6447, '', 'en'),
    (6448, '', 'en'),
    (6449, '', 'en'),
    (6450, 'Landspider', 'en'),
    (6451, '', 'en'),
    (6452, '', 'en'),
    (6453, '', 'en'),
    (6454, '', 'en'),
    (6455, '', 'en'),
    (6456, 'Yokohama', 'en'),
    (6457, '', 'en'),
    (6458, '', 'en'),
    (6459, '', 'en'),
    (6460, '', 'en'),
    (6461, '', 'en'),
    (6462, 'Yokohama', 'en'),
    (6463, '', 'en'),
    (6464, '', 'en'),
    (6465, '', 'en'),
    (6466, '', 'en'),
    (6467, '', 'en'),
    (6468, 'Pilot', 'en'),
    (6469, '', 'en'),
    (6470, '', 'en'),
    (6471, '', 'en'),
    (6472, '', 'en'),
    (6473, '', 'en'),
    (6474, 'CCI', 'en'),
    (6475, '', 'en'),
    (6476, '', 'en'),
    (6477, '', 'en'),
    (6478, '', 'en'),
    (6479, '', 'en'),
    (6480, 'CCI', 'en'),
    (6481, '', 'en'),
    (6482, '', 'en'),
    (6483, '', 'en'),
    (6484, '', 'en'),
    (6485, '', 'en'),
    (6486, 'CCI', 'en'),
    (6487, '', 'en'),
    (6488, '', 'en'),
    (6489, '', 'en'),
    (6490, '', 'en'),
    (6497, '', 'en'),
    (6498, 'Artis Forged', 'en'),
    (6499, '', 'en'),
    (6500, '', 'en'),
    (6501, '', 'en'),
    (6502, '', 'en'),
    (6503, '', 'en'),
    (6504, 'Artis Forged', 'en'),
    (6505, '', 'en'),
    (6506, '', 'en'),
    (6507, '', 'en'),
    (6508, '', 'en'),
    (6509, '', 'en'),
    (6510, '', 'en'),
    (6511, '', 'en'),
    (6512, '', 'en'),
    (6513, '', 'en'),
    (6514, '', 'en'),
    (6515, '', 'en'),
    (6516, '', 'en'),
    (6517, '', 'en'),
    (6518, '', 'en'),
    (6519, '', 'en'),
    (6520, '', 'en'),
    (6539, '', 'en'),
    (6540, '', 'en'),
    (6541, '', 'en'),
    (6542, '', 'en'),
    (6543, '', 'en'),
    (6544, '', 'en'),
    (6569, '', 'en'),
    (6570, '', 'en'),
    (6571, '', 'en'),
    (6572, '', 'en'),
    (6573, '', 'en'),
    (6574, '', 'en'),
    (6575, '', 'en'),
    (6576, '', 'en'),
    (6577, '', 'en'),
    (6578, '', 'en'),
    (6579, '', 'en'),
    (6580, '', 'en'),
    (6581, '', 'en'),
    (6582, '', 'en'),
    (6583, '', 'en'),
    (6584, '', 'en'),
    (6585, '', 'en'),
    (6586, '', 'en');


--
-- Connect products and product classes
--
UPDATE `%%XC%%_products` SET product_class_id = 6 WHERE sku IN ('BL-20-NIS-4', 'BL-25-VAU-2', 'BL-1-FOR-4-TB');
UPDATE `%%XC%%_products` SET product_class_id = 4 WHERE sku IN ('BD8295', 'BD8071', 'BD8175');
UPDATE `%%XC%%_products` SET product_class_id = 13 WHERE sku IN (
    '93213782', '52596051', '3475168729', '52596051-3', '52596051-5', '52596051-6', '52596051-7', '52596051-8',
    '4P06-22120-5D55-44BBT', '4P08-22120-5D55-44BBT', '4P63-22120-5D55-44BBT'
);
UPDATE `%%XC%%_products` SET product_class_id = 14 WHERE sku IN (
    '3180884605', '84221080', '84221078', '3180884605-1', '3180884605-4', '3180884605-5', '3180884605-6',
    '3180884605-7', '00813', '99915', '35125020AMPCA'
);
