SET FOREIGN_KEY_CHECKS=0;


--
-- Fitment types
--
UPDATE `%%XC%%_products` SET fitmentType = 'specific' WHERE sku IN (
    'BD8295', 'BD8071', '52596051', '3475168729',
    '3180884605', '84221080', '3180884605-1', '52596051-3', '52596051-5', '52596051-6',
    '3180884605-4', '3180884605-5', '3180884605-6', '3180884605-7',
    '52596051-7', '52596051-8', '4P06-22120-5D55-44BBT', '4P08-22120-5D55-44BBT',
    '4P63-22120-5D55-44BBT', '00813', '99915', '35125020AMPCA'
);

UPDATE `%%XC%%_products` SET fitmentType = 'universal' WHERE sku IN (
    'BC4101BLK-L', 'BD8175', '2947940219', 'sp184176', '2947940119', '865860616', '2947940118', 'sp190541', 'sp12109',
    'sp85769', 'sp12043', '1889291213', 'sp29051', 'mpn4670068567', 'mpn4670068567-clone-1', 'BBK002BLK-1',
    'sp147539', 'sp13118-2', 'mpn4791051987', 'sp108715', 'mpn4645448461', '4268317786-5', '4268317786-4',
    '4796236558', '725638947', '2226151827', '3997766134', '2333742875', '4634430329', '4629627773', '4693187582',
    '4477224181', '1654170659', '3099712066', '1242279229', '1656562894', '1879883414', '95627576', 'BBK002BLU-1',
    '10000000905', '522728567', '4652700275', '8-97329568-0', '93213782', '84221078', '4268317786-3', 'BC4101BLK-R',
    'mpn4533373412', 'sp139404', 'sp200216', 'mpn4704437699', '3099712066-clone-1', '3099712066-3', '1879883414-2',
    '187988341434', '3099712066-23', '187988341422345', '522728567-1', '522728567-2', '522728567-3', '522728567-4',
    '522728567-5', '522728567-6', '917435913-13', '917435913', 'sp178695', 'BBK002YEL-1', 'BBK002RED-1', '4268317786-2',
    '1879883414-55-6', '1879883414-55-5', '4736024561', 'BL-25-VAU-2', 'BL-1-FOR-4-TB', 'BL-20-NIS-4', '4642938301',
    'mpn2064787102', '4268317786', 'mpn464544846134-clone-1', 'mpn464544846134'
);


--
-- Sale
--
UPDATE `%%XC%%_products` SET participateSale = 1, discountType = 'sale_percent', salePriceValue = 5 WHERE sku = '2355945684';
UPDATE `%%XC%%_products` SET participateSale = 1, discountType = 'sale_percent', salePriceValue = 10 WHERE sku IN (
    '3099712066', 'mpn4704437699', '3099712066-clone-1', '3099712066-3', '3099712066-23'
);
UPDATE `%%XC%%_products` SET participateSale = 1, salePriceValue = 788 WHERE sku = '4642938301';
UPDATE `%%XC%%_products` SET participateSale = 1, salePriceValue = 65 WHERE sku = '95627576';
UPDATE `%%XC%%_products` SET participateSale = 1, salePriceValue = 126 WHERE sku = 'sp139404';
UPDATE `%%XC%%_products` SET participateSale = 1, salePriceValue = 250 WHERE sku = '187988341434';
UPDATE `%%XC%%_products` SET participateSale = 1, salePriceValue = 200 WHERE sku = '187988341422';
UPDATE `%%XC%%_products` SET participateSale = 1, salePriceValue = 180.99 WHERE sku = '187988341422345-clone-1';


--
-- UPC ISBN
--
UPDATE `%%XC%%_products` SET upcIsbn = '9510653', mnfVendor = '4P06-22120-5D55-44BBT' WHERE sku = '4P06-22120-5D55-44BBT';
UPDATE `%%XC%%_products` SET upcIsbn = '9509138', mnfVendor = '4P08-22120-5D55-44BBT' WHERE sku = '4P08-22120-5D55-44BBT';
UPDATE `%%XC%%_products` SET upcIsbn = '9510646', mnfVendor = '4P63-22120-5D55-44BBT' WHERE sku = '4P63-22120-5D55-44BBT';
UPDATE `%%XC%%_products` SET mnfVendor = '00813' WHERE sku = '00813';
UPDATE `%%XC%%_products` SET mnfVendor = '99915' WHERE sku = '99915';
UPDATE `%%XC%%_products` SET mnfVendor = '35125020AMPCA' WHERE sku = '35125020AMPCA';


--
-- Weight & box size
--
UPDATE `%%XC%%_products` SET weight = 47, boxWidth = 24, boxLength = 24, boxHeight = 14 WHERE sku = '4P06-22120-5D55-44BBT';
UPDATE `%%XC%%_products` SET weight = 51.5, boxWidth = 24, boxLength = 24, boxHeight = 14 WHERE sku = '4P08-22120-5D55-44BBT';
UPDATE `%%XC%%_products` SET weight = 48, boxWidth = 24, boxLength = 24, boxHeight = 14 WHERE sku = '4P63-22120-5D55-44BBT';
UPDATE `%%XC%%_products` SET weight = 28.8 WHERE sku = '00813';
UPDATE `%%XC%%_products` SET weight = 30.31 WHERE sku = '99915';
UPDATE `%%XC%%_products` SET weight = 67 WHERE sku = '35125020AMPCA';


--
-- Low limit
--
UPDATE `%%XC%%_products` SET lowLimitEnabled = 1 WHERE sku IN (
    'BL-20-NIS-4', 'BL-25-VAU-2', 'BBK002BLK-1', 'BBK002BLU-1', 'BBK002RED-1', 'BBK002YEL-1', 'BL-1-FOR-4-TB',
    'BC4101BLK-L', 'BC4101BLK-R', '2947940219', 'sp184176', '2947940119', '865860616', '2947940118',
    'sp190541', 'mpn4645448461', 'sp12109', 'sp85769', 'sp12043', '1889291213', 'sp29051', 'mpn4670068567',
    'mpn4670068567-clone-1', 'sp147539', 'sp108715', 'sp178695', '917435913', '4796236558', '725638947', '2226151827',
    '3997766134', '2333742875', '2253357', '4784816871', '2520507136', '4736024561', '4634430329', '4629627773',
    '2355945684', '4145506070', '4701094922', '4693187582', '4642938301', '4477224181', '1654170659', '3099712066',
    '1242279229', '1656562894', '1879883414', '95627576', '10000000905', '522728567', '4652700275', 'mpn464544846134',
    'mpn464544846134-clone-1', '8-97329568-0', '93213782', '52596051', '3475168729', '3180884605', '84221080',
    '84221078', '4268317786', 'mpn4533373412', 'sp139404', 'sp200216', 'mpn4704437699', 'mpn2064787102',
    '3099712066-clone-1', '3099712066-3', '1879883414-2', '187988341434', '3099712066-23', '522728567-1', '522728567-2',
    '522728567-3', '522728567-4', '522728567-5', '522728567-6', '917435913-13', '3180884605-1', '52596051-3',
    '52596051-5', '52596051-6', '3180884605-4', '3180884605-5', '3180884605-6', '3180884605-7', '4268317786-2',
    '4268317786-3', '4268317786-4', '4268317786-5', '52596051-7', '52596051-8'
);


--
-- Arrival date
--
UPDATE `%%XC%%_products` SET arrivalDate = UNIX_TIMESTAMP(CONVERT_TZ(CURDATE(), '+00:00', @@session.time_zone)) - (86400 * 150);

-- Coming soon
UPDATE
    `%%XC%%_products`
SET
    arrivalDate = UNIX_TIMESTAMP(CONVERT_TZ(CURDATE(), '+00:00', @@session.time_zone)) + (86400 * 30)
WHERE
    sku IN ('sp184176', 'BC4101BLK-R', 'BC4101BLK-L', 'BBK002BLK-1');

-- New arrivals
UPDATE
    `%%XC%%_products`
SET
    arrivalDate = UNIX_TIMESTAMP(CONVERT_TZ(CURDATE(), '+00:00', @@session.time_zone)) - (86400 * 7)
WHERE
    sku IN (
        '35125020AMPCA', '99915', '00813', '4P63-22120-5D55-44BBT', '4P08-22120-5D55-44BBT', '4P06-22120-5D55-44BBT',
        '1879883414-126', '1879883414-125', '1879883414-124', '1879883414-123', '1879883414-32', '1879883414-33',
        '1879883414-34', '1879883414-0', '1879883414-16', '1879883414-15', '1879883414-14', '1879883414-13',
        '1879883414-55-6', '1879883414-55-5', '1879883414-55-3', '1879883414-55-2', '1879883414-55',
        '187988341422345-clone-1', '187988341422344', '187988341422345', '187988341422', '18798834142'
    );


--
-- Disable the link to the home page and the catalog menu
--
UPDATE `%%XC%%_menus` SET `enabled` = 0 WHERE `link` = "{home}";
UPDATE `%%XC%%_menus` SET enabled = 0 WHERE id = (SELECT id FROM `%%XC%%_menu_translations` WHERE name = 'Catalog');


--
-- Set brand products
--
INSERT INTO `%%XC%%_brand_products` (`brand_id`, `product_id`, `orderby`) VALUES
    (
        (SELECT brand_id FROM `%%XC%%_brands` WHERE attribute_option_id = 535 LIMIT 1),
        (SELECT product_id FROM `%%XC%%_products` WHERE sku = '93213782' LIMIT 1),
        0
    ),
    (
        (SELECT brand_id FROM `%%XC%%_brands` WHERE attribute_option_id = 535 LIMIT 1),
        (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051' LIMIT 1),
        0
    ),
    (
        (SELECT brand_id FROM `%%XC%%_brands` WHERE attribute_option_id = 535 LIMIT 1),
        (SELECT product_id FROM `%%XC%%_products` WHERE sku = '3475168729' LIMIT 1),
        0
    ),
    (
        (SELECT brand_id FROM `%%XC%%_brands` WHERE attribute_option_id = 535 LIMIT 1),
        (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-3' LIMIT 1),
        0
    ),
    (
        (SELECT brand_id FROM `%%XC%%_brands` WHERE attribute_option_id = 535 LIMIT 1),
        (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-5' LIMIT 1),
        0
    ),
    (
        (SELECT brand_id FROM `%%XC%%_brands` WHERE attribute_option_id = 535 LIMIT 1),
        (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-6' LIMIT 1),
        0
    ),
    (
        (SELECT brand_id FROM `%%XC%%_brands` WHERE attribute_option_id = 535 LIMIT 1),
        (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1),
        0
    ),
    (
        (SELECT brand_id FROM `%%XC%%_brands` WHERE attribute_option_id = 575 LIMIT 1),
        (SELECT product_id FROM `%%XC%%_products` WHERE sku = '52596051-7' LIMIT 1),
        0
    );


--
-- Dumping data for table `%%XC%%_view_lists`
--
INSERT INTO `%%XC%%_view_lists`
    (`parent_id`, `list`, `interface`, `zone`, `child`, `weight`, `tpl`, `version`, `preset`, `list_override`, `weight_override`, `override_mode`, `deleted`)
    VALUES (
            (SELECT list_id FROM (SELECT * FROM `%%XC%%_view_lists` where child="XLite\\View\\Category") v),
            'center','web','customer','XLite\\View\\Category',
            16777215,'',NULL,'one','sidebar.first',-17,1,0
    );

INSERT INTO `%%XC%%_view_lists`
(`parent_id`, `list`, `interface`, `zone`, `child`, `weight`, `tpl`, `version`, `preset`, `list_override`, `weight_override`, `override_mode`, `deleted`)
VALUES (
           (SELECT list_id FROM (SELECT * FROM `%%XC%%_view_lists` where child="XLite\\View\\Subcategories") v),
           'center.bottom','web','customer','XLite\\View\\Subcategories',
           100,'',NULL,'one','center',-7,1,0
       );

INSERT INTO `%%XC%%_view_lists`
(`parent_id`, `list`, `interface`, `zone`, `child`, `weight`, `tpl`, `version`, `preset`, `list_override`, `weight_override`, `override_mode`, `deleted`)
VALUES (
           (SELECT list_id FROM (SELECT * FROM `%%XC%%_view_lists` where child="QSL\\Banner\\View\\Customer\\BannerSectionStandardTop") v),
           'center','web','customer','QSL\\Banner\\View\\Customer\\BannerSectionStandardTop',
           -70,'',NULL,'one','center',3,1,0
       );
