<?php

namespace XCart\Extender\Tests\Domain;

use PHPUnit\Framework\TestCase;
use XCart\Extender\Domain\EnabledModulesMap;

/**
 * @covers \XCart\Extender\Domain\EnabledModulesMap
 */
class EnabledModulesMapTest extends TestCase
{
    /**
     * @param bool  $expected
     * @param array $enabledModules
     * @param array $dependencies
     * @param array $incompatibles
     *
     * @dataProvider getIsResolvedProvider
     */
    public function isResolved(bool $expected, array $enabledModules, array $dependencies, array $incompatibles): void
    {
        $enabledModulesMap = new EnabledModulesMap();
        $enabledModulesMap->setHashMap($enabledModules);

        self::assertEquals($expected, $enabledModulesMap->isResolved($dependencies, $incompatibles));
    }

    public function getIsResolvedProvider(): array
    {
        return [
            [
                true,
                ['a', 'b', 'c'],
                ['a', 'b'],
                ['d']
            ],
            [
                false,
                ['a', 'b', 'c'],
                ['a', 'b'],
                ['c']
            ],
            [
                false,
                ['a', 'b', 'c'],
                ['a', 'f'],
                ['d']
            ],
            [
                true,
                ['a', 'b', 'c'],
                [],
                []
            ],
        ];
    }

    /**
     * @param bool  $expected
     * @param array $enabledModules
     * @param array $modules
     *
     * @dataProvider getTestHasAllProvider
     */
    public function testHasAll(bool $expected, array $enabledModules, array $modules): void
    {
        $enabledModulesMap = new EnabledModulesMap();
        $enabledModulesMap->setHashMap($enabledModules);

        self::assertEquals($expected, $enabledModulesMap->hasAll($modules));
    }

    public function getTestHasAllProvider(): array
    {
        return [
            [
                true,
                ['a', 'b', 'c'],
                ['a', 'b'],
            ],
            [
                false,
                ['a', 'b', 'c'],
                ['a', 'b', 'd'],
            ],
            [
                true,
                ['a', 'b', 'c'],
                [],
            ],
        ];
    }

    /**
     * @param bool  $expected
     * @param array $enabledModules
     * @param array $modules
     *
     * @dataProvider getTestHasNoneProvider
     */
    public function testHasNone(bool $expected, array $enabledModules, array $modules): void
    {
        $enabledModulesMap = new EnabledModulesMap();
        $enabledModulesMap->setHashMap($enabledModules);

        self::assertEquals($expected, $enabledModulesMap->hasNone($modules));
    }

    public function getTestHasNoneProvider(): array
    {
        return [
            [
                true,
                ['a', 'b', 'c'],
                ['d', 'f'],
            ],
            [
                false,
                ['a', 'b', 'c'],
                ['a', 'd', 'f'],
            ],
            [
                true,
                ['a', 'b', 'c'],
                [],
            ],
        ];
    }
}
