<?php

namespace XCart\Extender\Tests\CodeGenerator;

use PHPUnit\Framework\TestCase;
use XCart\Extender\CodeGenerator\ParentMutation;

/**
 * @covers \XCart\Extender\CodeGenerator\ParentMutation
 */
class ParentMutationTest extends TestCase
{
    /**
     * @param bool       $expected
     * @param int|string $token
     * @param string     $content
     *
     * @dataProvider getTestIsApplicableProvider
     */
    public function testIsApplicable(bool $expected, $token, string $content): void
    {
        $mutation = new ParentMutation('');

        self::assertEquals($expected, $mutation->isAnchor($token, $content));
    }

    public function getTestIsApplicableProvider(): array
    {
        return [
            [true, T_EXTENDS, 'extends'],
            [false, T_WHITESPACE, "\n"],
        ];
    }

    /**
     * @param array  $expected
     * @param string $parentFqn
     * @param array  $tokens
     * @param int    $position
     *
     * @dataProvider getTestGetSubstitutionsProvider
     */
    public function testGetSubstitutions(array $expected, string $parentFqn, array $tokens, int $position): void
    {
        $mutation = new ParentMutation($parentFqn);

        self::assertEquals($expected, $mutation->getSubstitutions($tokens, $position));
    }

    public function getTestGetSubstitutionsProvider(): array
    {
        return [
            [
                [25 => '\Some\NewParent'],
                'Some\NewParent',
                token_get_all(file_get_contents(__DIR__ . '/MutationData/Class1.php.test')),
                23,
            ],
            [
                [25 => '\Some\NewParent'],
                'Some\NewParent',
                token_get_all(file_get_contents(__DIR__ . '/MutationData/Class2.php.test')),
                23,
            ],
        ];
    }
}
