<?php

namespace XCart\Extender\Tests\CodeGenerator;

use PHPUnit\Framework\TestCase;
use XCart\Extender\CodeGenerator\NameMutation;

/**
 * @covers \XCart\Extender\CodeGenerator\NameMutation
 */
class NameMutationTest extends TestCase
{
    /**
     * @param bool       $expected
     * @param int|string $token
     * @param string     $content
     *
     * @dataProvider getTestIsApplicableProvider
     */
    public function testIsApplicable(bool $expected, $token, string $content): void
    {
        $mutation = new NameMutation('');

        self::assertEquals($expected, $mutation->isAnchor($token, $content));
    }

    public function getTestIsApplicableProvider(): array
    {
        return [
            [true, T_CLASS, 'class'],
            [true, T_INTERFACE, 'interface'],
            [true, T_TRAIT, 'trait'],
            [false, T_DOC_COMMENT, "/**\n * Some comment\n */"],
            [false, T_WHITESPACE, "\n"],
        ];
    }

    /**
     * @param array  $expected
     * @param string $name
     * @param array  $tokens
     * @param int    $position
     *
     * @dataProvider getTestGetSubstitutionsProvider
     */
    public function testGetSubstitutions(array $expected, string $name, array $tokens, int $position): void
    {
        $mutation = new NameMutation($name);

        self::assertEquals($expected, $mutation->getSubstitutions($tokens, $position));
    }

    public function getTestGetSubstitutionsProvider(): array
    {
        return [
            [
                [21 => 'NewName'],
                'NewName',
                token_get_all(file_get_contents(__DIR__ . '/MutationData/Class1.php.test')),
                19,
            ],
        ];
    }
}
