<?php

namespace XCart\Extender\Tests\CodeGenerator;

use Closure;
use PHPUnit\Framework\TestCase;
use XCart\Extender\CodeGenerator\DocCommentMutation;

/**
 * @covers \XCart\Extender\CodeGenerator\DocCommentMutation
 */
class DocCommentMutationTest extends TestCase
{
    /**
     * @param bool       $expected
     * @param int|string $token
     * @param string     $content
     *
     * @dataProvider getTestIsApplicableProvider
     */
    public function testIsApplicable(bool $expected, $token, string $content): void
    {
        $mutation = new DocCommentMutation(static function () {
        });

        self::assertEquals($expected, $mutation->isAnchor($token, $content));
    }

    public function getTestIsApplicableProvider(): array
    {
        return [
            [true, T_CLASS, 'class'],
            [true, T_INTERFACE, 'interface'],
            [true, T_TRAIT, 'trait'],
            [false, T_DOC_COMMENT, "/**\n * Some comment\n */"],
            [false, T_WHITESPACE, "\n"],
        ];
    }

    /**
     * @param array   $expected
     * @param Closure $replaceFunc
     * @param array   $tokens
     * @param int     $position
     *
     * @dataProvider getTestGetSubstitutionsProvider
     */
    public function testGetSubstitutions(array $expected, Closure $replaceFunc, array $tokens, int $position): void
    {
        $mutation = new DocCommentMutation($replaceFunc);

        self::assertEquals($expected, $mutation->getSubstitutions($tokens, $position));
    }

    public function getTestGetSubstitutionsProvider(): array
    {
        return [
            [
                [17 => "/**\n * SomeNewDocComment\n */\n"],
                function ($content) {
                    return "/**\n * SomeNewDocComment\n */\n";
                },
                token_get_all(file_get_contents(__DIR__ . '/MutationData/Class1.php.test')),
                31,
            ],
            [
                [],
                function ($content) {
                    return "/**\n * SomeNewDocComment\n */\n";
                },
                token_get_all(file_get_contents(__DIR__ . '/MutationData/Class3.php.test')),
                33,
            ],
        ];
    }
}
