<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Model;

use XCart\Extender\CodeGenerator\MutationInterface;

class Entity
{
    /**
     * @var string
     */
    private string $sourcePath;

    /**
     * @var string
     */
    private string $targetPath;

    /**
     * @var string
     */
    private string $targetStream;

    /**
     * @var string
     */
    private string $fqn;

    /**
     * @var string
     */
    private string $ancestorFqn = '';

    /**
     * @var array|MutationInterface[]
     */
    private array $mutations = [];

    /**
     * @param string $fqn
     * @param string $sourcePath
     * @param string $targetPath
     */
    public function __construct(string $fqn, string $sourcePath = '', string $targetPath = '')
    {
        $this->sourcePath   = $sourcePath;
        $this->targetPath   = $targetPath;
        $this->targetStream = $targetPath;
        $this->fqn          = $fqn;
    }

    /**
     * @return string
     */
    public function getSourcePath(): string
    {
        return $this->sourcePath;
    }

    /**
     * @param string $sourcePath
     */
    public function setSourcePath(string $sourcePath): void
    {
        $this->sourcePath = $sourcePath;
    }

    /**
     * @return string
     */
    public function getTargetPath(): string
    {
        return $this->targetPath;
    }

    /**
     * @param string $targetPath
     */
    public function setTargetPath(string $targetPath): void
    {
        $this->targetPath = $targetPath;
    }

    /**
     * @return string
     */
    public function getTargetStream(): string
    {
        return $this->targetStream;
    }

    /**
     * @param string $targetStream
     */
    public function setTargetStream(string $targetStream): void
    {
        $this->targetStream = $targetStream;
    }

    /**
     * @return string
     */
    public function getFqn(): string
    {
        return $this->fqn;
    }

    /**
     * @param string $fqn
     */
    public function setFqn(string $fqn): void
    {
        $this->fqn = $fqn;
    }

    /**
     * @return string
     */
    public function getAncestorFqn(): string
    {
        return $this->ancestorFqn;
    }

    /**
     * @param string $ancestorFqn
     */
    public function setAncestorFqn(string $ancestorFqn): void
    {
        $this->ancestorFqn = $ancestorFqn;
    }

    /**
     * @return array|MutationInterface[]
     */
    public function getMutations(): array
    {
        return $this->mutations;
    }

    /**
     * @param array|MutationInterface[] $mutations
     */
    public function setMutations(array $mutations): void
    {
        $this->mutations = $mutations;
    }

    /**
     * @param MutationInterface $mutation
     */
    public function addMutation(MutationInterface $mutation): void
    {
        $this->mutations[] = $mutation;
    }
}
