<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Model;

use Symfony\Contracts\EventDispatcher\Event;

class CheckMixinEvent extends Event
{
    /**
     * @var Entity
     */
    private Entity $entity;

    /**
     * @var bool|null
     */
    private ?bool $result = null;

    /**
     * @param Entity $entity
     */
    public function __construct(Entity $entity)
    {
        $this->entity = $entity;
    }

    /**
     * @return Entity
     */
    public function getEntity(): Entity
    {
        return $this->entity;
    }

    /**
     * @param Entity $entity
     */
    public function setEntity(Entity $entity): void
    {
        $this->entity = $entity;
    }

    /**
     * @return bool|null
     */
    public function getResult(): ?bool
    {
        return $this->result;
    }

    /**
     * @param bool|null $result
     */
    public function setResult(?bool $result): void
    {
        $this->result = $result;
    }
}
