<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Mapping;

use Doctrine\Common\Annotations\Annotation\NamedArgumentConstructor;

/**
 * @Annotation
 * @NamedArgumentConstructor()
 * @codeCoverageIgnore
 */
class ListChild
{
    private const WEIGHT_MIN = 0;
    private const WEIGHT_MAX = 16777215;

    /**
     * List name
     *
     * @var string|null
     */
    public ?string $list;

    /**
     * Interface: web (default), mail, pdf, ...
     *
     * @var string|null
     */
    public ?string $interface;

    /**
     * Zone: admin, customer, common
     *
     * @var string|null
     */
    public ?string $zone;

    /**
     * Order weight
     *
     * @var int|null
     */
    public ?int $weight;

    /**
     * Used for drag-and-drop functionality
     *
     * @var string|null
     */
    public ?string $preset;

    /**
     * Used for drag-and-drop functionality
     *
     * @var string|null
     */
    public ?string $name;

    public function __construct(
        ?string $list = null,
        ?string $interface = null,
        ?string $zone = null,
        ?string $weight = null,
        ?string $preset = null,
        ?string $name = null
    ) {
        $this->list      = $list ?: '';
        $this->interface = $interface ?: 'web';
        $this->zone      = $zone ?: '';
        $this->weight    = $this->prepareWeightField($weight);
        $this->preset    = $preset ?: '';
        $this->name      = $name ?: '';
    }

    private function prepareWeightField(?string $weight): int
    {
        if ($weight === 'first') {
            return self::WEIGHT_MIN;
        }

        if ($weight === null || $weight === 'last') {
            return self::WEIGHT_MAX;
        }

        return (int) $weight;
    }
}
