<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Mapping\Extender;

use function is_array;

/**
 * @Annotation
 * @codeCoverageIgnore
 */
class Before
{
    /**
     * @var array
     */
    public array $modules = [];

    /**
     * @param array|string $param
     */
    public function __construct($param)
    {
        $this->modules = is_array($param['value']) ? $param['value'] : [$param['value']];
    }
}
