<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Factory;

use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\Entity;
use XCart\Extender\Model\Reflection;

interface ReflectionFactoryInterface
{
    /**
     * @param Entity $entity
     *
     * @return Reflection
     * @throws EntityException
     */
    public function build(Entity $entity): Reflection;
}
