<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Factory;

use XCart\Extender\Action\ParserInterface;
use XCart\Extender\Action\ReaderInterface;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Exception\IOException;
use XCart\Extender\Exception\ParserException;
use XCart\Extender\Model\Entity;
use XCart\Extender\Model\Reflection;

class ReflectionFactory implements ReflectionFactoryInterface
{
    /**
     * @var ReaderInterface
     */
    private ReaderInterface $reader;

    /**
     * @var ParserInterface
     */
    private ParserInterface $parser;

    /**
     * @param ReaderInterface $reader
     * @param ParserInterface $parser
     */
    public function __construct(
        ReaderInterface $reader,
        ParserInterface $parser
    ) {
        $this->reader = $reader;
        $this->parser = $parser;
    }

    /**
     * @param Entity $entity
     *
     * @return Reflection
     * @throws EntityException
     */
    public function build(Entity $entity): Reflection
    {
        try {
            $source = $this->reader->readSource($entity->getSourcePath());
        } catch (IOException $exception) {
            throw EntityException::fromReadSource($entity, $exception);
        }

        if (empty($source)) {
            throw EntityException::fromEmptySource($entity);
        }

        try {
            return $this->parser->parseSource($source);
        } catch (ParserException $exception) {
            throw EntityException::fromParsing($entity, $exception);
        }
    }
}
