<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Exception;

use Exception;

class ParserException extends Exception
{
    /**
     * @param string $part
     *
     * @return static
     */
    public static function fromParsing(string $part): self
    {
        return new self("Parsing error ({$part})");
    }

    /**
     * @param Exception $exception
     *
     * @return static
     */
    public static function fromAnnotationsParsing(Exception $exception): self
    {
        return new self('Annotation parsing error', (int) $exception->getCode(), $exception);
    }
}
