<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Event;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use XCart\Extender\Action\ReflectorInterface;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\CheckMixinEvent;
use XCart\Extender\Model\EntityEvent;

class DependenciesSubscriber implements EventSubscriberInterface
{
    /**
     * @var ReflectorInterface
     */
    private ReflectorInterface $reflector;

    /**
     * @param ReflectorInterface $reflector
     */
    public function __construct(
        ReflectorInterface $reflector
    ) {
        $this->reflector = $reflector;
    }

    /**
     * @return array
     */
    public static function getSubscribedEvents(): array
    {
        return [
            'build-chain'    => ['onBuildChain', 50],
            'read-view-list' => ['onReadViewList', 50],
            'check-mixin'   => 'onCheckMixin',
        ];
    }

    /**
     * @param EntityEvent $event
     *
     * @throws EntityException
     */
    public function onBuildChain(EntityEvent $event): void
    {
        $entity = $event->getEntity();

        if (!$this->reflector->isCompatible($entity)) {
            $event->setResult([]);
            $event->stopPropagation();
        }
    }

    /**
     * @param EntityEvent $event
     *
     * @throws EntityException
     */
    public function onReadViewList(EntityEvent $event): void
    {
        $entity = $event->getEntity();

        if (!$this->reflector->isCompatible($entity)) {
            $event->setResult([]);
            $event->stopPropagation();
        }
    }

    /**
     * @param CheckMixinEvent $event
     *
     * @throws EntityException
     */
    public function onCheckMixin(CheckMixinEvent $event): void
    {
        $entity = $event->getEntity();

        if (!$this->reflector->isCompatible($entity)) {
            $event->setResult(false);
            $event->stopPropagation();
        }
    }
}
