<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Domain;

use function str_replace;

class TargetMap extends HashMapAbstract
{
    /**
     * @var string
     */
    private string $targetRoot;

    /**
     * @param string $targetRoot
     */
    public function __construct(string $targetRoot = '')
    {
        $this->targetRoot = $targetRoot;
    }

    /**
     * @param string $fqn
     *
     * @return string
     */
    public function suggestPathByFqn(string $fqn): string
    {
        if (!isset($this[$fqn])) {
            $this[$fqn] = $this->targetRoot . str_replace('\\', '/', $fqn) . '.php';
        }

        return $this[$fqn];
    }

    /**
     * @return string
     */
    public function getTargetRoot(): string
    {
        return $this->targetRoot;
    }

    /**
     * @param string $targetRoot
     */
    public function setTargetRoot(string $targetRoot): void
    {
        $this->targetRoot = $targetRoot;
    }
}
