<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Domain;

use XCart\Extender\Exception\LogicException;

interface SourceMapInterface
{
    public function suggestFqnByPath(string $filePath): string;

    /**
     * @throws LogicException
     */
    public function suggestPathByFqn(string $fqn): string;

    public function getFiles(): array;

    public function getCoreFiles(): array;

    public function getModuleFiles(): array;

    public function isFqnOfSource(string $fqn): bool;

    public function setHashMap(array $hashMap): void;
}
