<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Domain;

use function array_diff;
use function array_intersect;
use function array_map;
use function str_replace;

class EnabledModulesMap extends HashMapAbstract
{
    /**
     * @param array $hashMap
     */
    public function setHashMap(array $hashMap): void
    {
        parent::setHashMap(array_map(static function ($item) {
            return str_replace('-', '\\', $item);
        }, $hashMap));
    }

    /**
     * @param array $dependencies
     * @param array $incompatibles
     *
     * @return bool
     */
    public function isResolved(array $dependencies, array $incompatibles): bool
    {
        return $this->hasAll($dependencies) && $this->hasNone($incompatibles);
    }

    /**
     * @param array $modules
     *
     * @return bool
     */
    public function hasAll(array $modules): bool
    {
        return !(bool) array_diff($modules, $this->hashMap);
    }

    /**
     * @param array $modules
     *
     * @return bool
     */
    public function hasNone(array $modules): bool
    {
        return !(bool) array_intersect($modules, $this->hashMap);
    }
}
