<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\CodeGenerator;

use function count;
use function in_array;
use function is_array;

use const T_NS_SEPARATOR;
use const T_STRING;

if (!defined('T_NAME_QUALIFIED')) {
    define('T_NAME_QUALIFIED', -1);
}

if (!defined('T_NAME_FULLY_QUALIFIED')) {
    define('T_NAME_FULLY_QUALIFIED', -1);
}

class ParentMutation implements MutationInterface
{
    /**
     * @var string
     */
    private string $parentFqn;

    /**
     * @param string $parentFqn
     */
    public function __construct(string $parentFqn)
    {
        $this->parentFqn = $parentFqn;
    }

    /**
     * @param int|string $token
     * @param string     $content
     *
     * @return bool
     */
    public function isAnchor($token, string $content): bool
    {
        return $token === T_EXTENDS;
    }

    /**
     * @param array $tokens
     * @param int   $anchorPosition
     *
     * @return array
     */
    public function getSubstitutions(array $tokens, int $anchorPosition): array
    {
        $result = [];

        $count = count($tokens);
        while ($anchorPosition < $count) {
            $token = $tokens[$anchorPosition];
            [$token] = is_array($token) ? $token : [$token];

            if (
                in_array(
                    $token,
                    [T_STRING, T_NS_SEPARATOR, T_NAME_QUALIFIED, T_NAME_FULLY_QUALIFIED],
                    true
                )
            ) {
                $result[$anchorPosition] = "\\{$this->parentFqn}";

                $anchorPosition++;
                break;
            }

            $anchorPosition++;
        }

        while ($anchorPosition < $count) {
            $token = $tokens[$anchorPosition];
            [$token] = is_array($token) ? $token : [$token];

            if (
                !in_array(
                    $token,
                    [T_STRING, T_NS_SEPARATOR, T_NAME_QUALIFIED, T_NAME_FULLY_QUALIFIED],
                    true
                )
            ) {
                break;
            }

            $result[$anchorPosition] = '';

            $anchorPosition++;
        }

        return $result;
    }
}
