<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\CodeGenerator;

interface MutationInterface
{
    /**
     * @param string|int $token
     * @param string     $content
     *
     * @return bool
     */
    public function isAnchor($token, string $content): bool;

    /**
     * @param array $tokens
     * @param int   $anchorPosition
     *
     * @return array
     */
    public function getSubstitutions(array $tokens, int $anchorPosition): array;
}
