<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Autoloader;

use function file_exists;
use function ltrim;

class DynamicAutoloader extends Autoloader
{
    public function classExists(string $class): bool
    {
        $file = $this->targetMap->suggestPathByFqn(ltrim($class, '\\'));

        return file_exists($file);
    }

    public function autoload(string $class): bool
    {
        $file = $this->targetMap->suggestPathByFqn(ltrim($class, '\\'));

        if (file_exists($file)) {
            include_once $file;

            return true;
        }

        return false;
    }
}
