<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Autoloader;

interface AutoloaderInterface
{
    public function register(): void;

    public function unregister(): void;

    public function classExists(string $class): bool;

    public function autoload(string $class): bool;

    public function getSourceFilePath(string $class): string;

    public function getTargetFilePath(string $class): string;

    public function suggestFqnByPath(string $path): string;

    public function getTargetStreamPath(string $class): string;
}
