<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use XCart\Extender\Mapping\ListChild;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\Entity;

interface ReflectorInterface
{
    /**
     * @param Entity $entity
     *
     * @return bool
     * @throws EntityException
     */
    public function isFQNEqualToPath(Entity $entity): bool;

    /**
     * @param Entity $entity
     *
     * @return bool
     * @throws EntityException
     */
    public function isClass(Entity $entity): bool;

    /**
     * @param Entity $entity
     *
     * @return bool
     * @throws EntityException
     */
    public function isLocked(Entity $entity): bool;

    /**
     * @param Entity $entity
     *
     * @return string
     * @throws EntityException
     */
    public function getParent(Entity $entity): string;

    /**
     * @param Entity $entity
     *
     * @return bool
     * @throws EntityException
     */
    public function isMixin(Entity $entity): bool;

    /**
     * @param Entity $entity
     * @param string $class
     *
     * @return bool
     * @throws EntityException
     */
    public function hasAnnotationOfClass(Entity $entity, string $class): bool;

    /**
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     */
    public function getDependencies(Entity $entity): array;

    /**
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     */
    public function getIncompatibles(Entity $entity): array;

    /**
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     */
    public function getBeforeModules(Entity $entity): array;

    /**
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     */
    public function getAfterModules(Entity $entity): array;

    /**
     * @param Entity $entity
     *
     * @return ListChild[]
     * @throws EntityException
     */
    public function getViewListAnnotations(Entity $entity): array;

    /**
     * @param Entity $entity
     *
     * @return bool
     * @throws EntityException
     */
    public function isCompatible(Entity $entity): bool;

    /**
     * @param Entity $entity
     *
     * @return string
     * @throws EntityException
     */
    public function getModule(Entity $entity): string;

    /**
     * @param Entity $entity
     *
     * @return bool
     * @throws EntityException
     */
    public function isController(Entity $entity): bool;
}
