<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use XCart\Extender\Exception\ParserException;
use XCart\Extender\Model\Reflection;

interface ParserInterface
{
    /**
     * @param string $sourceCode
     *
     * @return Reflection
     * @throws ParserException
     */
    public function parseSource(string $sourceCode): Reflection;
}
