<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use XCart\Extender\Exception\EntityException;
use XCart\Extender\Exception\LogicException;
use XCart\Extender\Model\Entity;

interface MixinLookupInterface
{
    /**
     * @param Entity $entity
     *
     * @return array|Entity[]
     * @throws EntityException
     * @throws LogicException
     */
    public function getMixins(Entity $entity): array;
}
