<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action;

use function preg_match;

class FQNValidator
{
    private array $cache = [];

    public function validate(string $fqn): bool
    {
        if (!isset($this->cache[$fqn])) {
            $position = mb_strrpos($fqn, '\\');

            if ($position) {
                $this->cache[$fqn] = $this->validateName(mb_substr($fqn, $position + 1, mb_strlen($fqn)))
                    && ($parent = mb_substr($fqn, 0, $position))
                    && $this->validate($parent);
            } else {
                $this->cache[$fqn] = $this->validateName($fqn);
            }
        }

        return $this->cache[$fqn];
    }

    private function validateName(string $name): bool
    {
        if (!isset($this->cache[$name])) {
            // https://www.php.net/manual/en/language.oop5.basic.php
            $this->cache[$name] = (bool) preg_match('/^[a-zA-Z_\x80-\xff][a-zA-Z0-9_\x80-\xff]*$/S', $name);
        }

        return $this->cache[$name];
    }
}
