<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action\DoctrineEntityReader;

use XCart\Extender\Action\ReflectorInterface;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\Entity;

class EntityDoctrineEntityReader
{
    /**
     * @var ReflectorInterface
     */
    private ReflectorInterface $reflector;

    /**
     * @var DoctrineEntityExtractorInterface
     */
    private DoctrineEntityExtractorInterface $doctrineEntityExtractor;

    public function __construct(
        ReflectorInterface $reflector,
        DoctrineEntityExtractorInterface $doctrineEntityExtractor
    ) {
        $this->reflector               = $reflector;
        $this->doctrineEntityExtractor = $doctrineEntityExtractor;
    }

    /**
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     */
    public function readByEntity(Entity $entity): array
    {
        if (!is_readable($entity->getSourcePath())) {
            throw EntityException::fromReadSource($entity);
        }

        if (!$this->reflector->isFQNEqualToPath($entity)) {
            throw EntityException::fromFQNToPathEqualityCheck($entity);
        }

        if (!$this->reflector->isClass($entity)) {
            return [];
        }

        if ($this->reflector->isMixin($entity)) {
            return [];
        }

        return $this->doctrineEntityExtractor->read($entity);
    }
}
