<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action\DoctrineEntityReader;

use XCart\Extender\Domain\SourceMapInterface;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Exception\LogicException;
use XCart\Extender\Factory\EntityFactoryInterface;

class DoctrineEntityReader
{
    /**
     * @var SourceMapInterface
     */
    private SourceMapInterface $sourceMap;

    /**
     * @var EntityFactoryInterface
     */
    private EntityFactoryInterface $entityFactory;

    /**
     * @var EntityDoctrineEntityReader
     */
    private EntityDoctrineEntityReader $entityDoctrineEntityReader;

    public function __construct(
        SourceMapInterface $sourceMap,
        EntityFactoryInterface $entityFactory,
        EntityDoctrineEntityReader $entityDoctrineEntityReader
    ) {
        $this->sourceMap                  = $sourceMap;
        $this->entityFactory              = $entityFactory;
        $this->entityDoctrineEntityReader = $entityDoctrineEntityReader;
    }

    /**
     * @param string $fqn
     * @param string $sourcePath
     *
     * @return array
     * @throws EntityException
     * @throws LogicException
     */
    public function readByFQN(string $fqn, string $sourcePath = ''): array
    {
        $entity = $this->entityFactory->build($fqn, $sourcePath);

        return $this->entityDoctrineEntityReader->readByEntity($entity);
    }

    /**
     * @param string $sourcePath
     *
     * @return array
     * @throws EntityException
     * @throws LogicException
     */
    public function readByPath(string $sourcePath): array
    {
        $fqn = $this->sourceMap->suggestFqnByPath($sourcePath);

        return $fqn ? $this->readByFQN($fqn, $sourcePath) : [];
    }
}
