<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action\DoctrineEntityReader;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use XCart\Extender\Action\ReflectorInterface;
use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\Entity;
use XCart\Extender\Model\EntityEvent;

class DoctrineEntityExtractor implements DoctrineEntityExtractorInterface
{
    /**
     * @var ReflectorInterface
     */
    private ReflectorInterface $reflector;

    /**
     * @var EventDispatcherInterface
     */
    private EventDispatcherInterface $eventDispatcher;

    public function __construct(
        ReflectorInterface $reflector,
        EventDispatcherInterface $eventDispatcher
    ) {
        $this->reflector       = $reflector;
        $this->eventDispatcher = $eventDispatcher;
    }

    /**
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     */
    public function read(Entity $entity): array
    {
        $doctrineEntityEvent = new EntityEvent($entity);
        $this->eventDispatcher->dispatch($doctrineEntityEvent, 'read-doctrine-entity');

        if (($result = $doctrineEntityEvent->getResult()) !== null) {
            return $result;
        }

        $result = [];
        if ($this->reflector->hasAnnotationOfClass($entity, ORM\Entity::class)) {
            $result[] = $entity->getFqn();
        }

        return $result;
    }
}
