<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Extender\Action\ControllerEntityReader;

use XCart\Extender\Exception\EntityException;
use XCart\Extender\Model\Entity;

class ControllerEntityExtractorCached implements ControllerEntityExtractorInterface
{
    /**
     * @var ControllerEntityExtractorInterface
     */
    private ControllerEntityExtractorInterface $controllerEntityExtractor;

    /**
     * @var array
     */
    private array $cache = [];

    public function __construct(
        ControllerEntityExtractorInterface $controllerEntityExtractor
    ) {
        $this->controllerEntityExtractor = $controllerEntityExtractor;
    }

    /**
     * @param Entity $entity
     *
     * @return array
     * @throws EntityException
     */
    public function read(Entity $entity): array
    {
        $fqn = $entity->getFqn();
        if (!isset($this->cache[$fqn])) {
            $this->cache[$fqn] = $this->controllerEntityExtractor->read($entity);
        }

        return $this->cache[$fqn];
    }
}
